/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.ParameterMetaData;
import com.tridium.eas.function.Parameters;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.TransformFunction;
import com.tridium.eas.util.CompoundUnitUtil;
import javax.baja.units.BUnit;

public class NormalizeByPopulation
implements TransformFunction {
    public static final ParameterMetaData PARAMETER_META_DATA = new ParameterMetaData(2, 2, new String[]{"Normal Population", "Population to Normalize"}, 0, 0, null, 0, 0, null);

    public Population getPopulation(Parameters parameters) {
        return NormalizeByPopulation.getNormalizedPopulation(parameters.getPopulation(0), parameters.getPopulation(1));
    }

    public static Population[] getNormalizedPopulations(Population[] populationArray, Population[] populationArray2) {
        Population[] populationArray3 = new Population[populationArray.length];
        for (int i = 0; i < populationArray.length; ++i) {
            populationArray3[i] = NormalizeByPopulation.getNormalizedPopulation(populationArray[i], populationArray2[i]);
        }
        return populationArray3;
    }

    public static Population getNormalizedPopulation(Population population, Population population2) {
        return new NormalizedPopulation(population, population2);
    }

    public ParameterMetaData getParameterMetaData() {
        return PARAMETER_META_DATA;
    }

    private static class NormalizedPopulation
    implements Population {
        private Population normal;
        private Population toNormalize;
        private BUnit unit;

        public NormalizedPopulation(Population population, Population population2) {
            if (population.getSize() != population2.getSize()) {
                throw new IllegalArgumentException("Cannot normalize populations of different sizes " + population.getSize() + " != " + population2.getSize());
            }
            this.normal = population;
            this.toNormalize = population2;
            this.unit = CompoundUnitUtil.make(population2.getUnit(), population.getUnit());
        }

        public int getSize() {
            return this.normal.getSize();
        }

        public double getSample(int n) {
            return this.toNormalize.getSample(n) / this.normal.getSample(n);
        }

        public BUnit getUnit() {
            return this.unit;
        }

        public boolean isValid(int n) {
            return this.normal.isValid(n) && this.toNormalize.isValid(n);
        }
    }
}

