/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.DefaultMutablePopulation;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.PopulationChangedEvent;
import com.tridium.eas.util.BoolArray;
import javax.baja.units.BUnit;

public class ListPopulation
extends DefaultMutablePopulation {
    private double[] samples = null;
    private boolean[] valid = null;
    private int size = 0;
    private int extent = 10;
    private BUnit unit = null;

    public ListPopulation(BUnit bUnit, double[] dArray) {
        this(bUnit, dArray, null);
    }

    public ListPopulation(BUnit bUnit, double[] dArray, BoolArray boolArray) {
        this(bUnit, dArray.length, 10);
        for (int i = 0; i < dArray.length; ++i) {
            this.add(dArray[i], boolArray == null ? true : boolArray.get(i));
        }
    }

    public ListPopulation(BUnit bUnit) {
        this(bUnit, 100, 10);
    }

    public ListPopulation(BUnit bUnit, int n, int n2) {
        this.samples = new double[n];
        this.valid = new boolean[n];
        this.extent = n2;
        this.size = 0;
        this.unit = bUnit;
    }

    public ListPopulation(Population population) {
        this(population.getUnit());
        this.addAll(population);
    }

    public int getSize() {
        return this.size;
    }

    public double getSample(int n) {
        return this.samples[n];
    }

    public boolean isValid(int n) {
        return this.valid[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void ensureCapacity(int n) {
        if (n <= this.samples.length) return;
        double[] dArray = this.samples;
        synchronized (this.samples) {
            double[] dArray2 = this.samples;
            this.samples = new double[n + this.extent];
            System.arraycopy(dArray2, 0, this.samples, 0, dArray2.length);
            boolean[] blArray = this.valid;
            this.valid = new boolean[n + this.extent];
            System.arraycopy(blArray, 0, this.valid, 0, blArray.length);
            for (int i = blArray.length; i < this.valid.length; ++i) {
                this.valid[i] = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setSample(int n, double d, boolean bl) {
        this.ensureCapacity(n + 1);
        this.size = Math.max(n + 1, this.size);
        this.samples[n] = d;
        this.valid[n] = bl;
        this.firePopulationChanged(new PopulationChangedEvent((Population)this, n));
    }

    public void setSample(int n, double d) {
        this.setSample(n, d, true);
    }

    public void setSample(int n, double d, BUnit bUnit) {
        this.setSample(n, d, bUnit, true);
    }

    public void setSample(int n, double d, BUnit bUnit, boolean bl) {
        this.setSample(n, this.getUnit().fromNormal(bUnit.toNormal(d)), bl);
    }

    public void setValid(int n, boolean bl) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.valid[n] = bl;
        this.firePopulationChanged(new PopulationChangedEvent((Population)this, n));
    }

    public BUnit getUnit() {
        return this.unit;
    }

    public void add(int n) {
        this.add(n, true);
    }

    public void add(int n, boolean bl) {
        this.add((double)n, bl);
    }

    public void add(long l) {
        this.add(l, true);
    }

    public void add(long l, boolean bl) {
        this.add((double)l, bl);
    }

    public void add(double d) {
        this.add(d, true);
    }

    public void add(double d, boolean bl) {
        this.setSample(this.size, d, bl);
    }

    public void addAll(Population population) {
        boolean bl = this.holdEvents;
        this.holdEvents = true;
        this.ensureCapacity(this.size + population.getSize());
        int[] nArray = new int[population.getSize()];
        for (int i = 0; i < population.getSize(); ++i) {
            nArray[i] = this.size;
            this.add(population.getSample(i), population.isValid(i));
        }
        this.holdEvents = bl;
        this.firePopulationChanged(new PopulationChangedEvent((Population)this, nArray));
    }
}

