/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.BEasService;
import com.tridium.eas.function.BooleanPopulation;
import com.tridium.eas.function.MutablePopulation;
import com.tridium.eas.function.SimpleBooleanPopulation;
import com.tridium.eas.util.BoolArray;
import javax.baja.units.BUnit;

public class CompactBooleanPopulation
implements BooleanPopulation {
    private BoolArray data;
    private static final BUnit unit = BEasService.MULTISTATE;

    public CompactBooleanPopulation(int n, boolean bl) {
        this.data = new BoolArray(n);
        this.data.setAll(bl);
    }

    public CompactBooleanPopulation(int n) {
        this.data = new BoolArray(n);
    }

    public CompactBooleanPopulation(boolean[] blArray) {
        this.data = new BoolArray(blArray);
    }

    public CompactBooleanPopulation(BoolArray boolArray) {
        this.data = new BoolArray(boolArray);
    }

    public CompactBooleanPopulation(CompactBooleanPopulation compactBooleanPopulation) {
        this.data = compactBooleanPopulation instanceof MutablePopulation ? new BoolArray(compactBooleanPopulation.data) : compactBooleanPopulation.data;
    }

    public CompactBooleanPopulation(BooleanPopulation booleanPopulation) {
        int n = booleanPopulation.getSize();
        this.data = new BoolArray(n);
        this.data.setAll(true);
        int n2 = 0;
        while (n2 < n) {
            if (booleanPopulation.getBoolean(n2)) continue;
            this.data.setf(n2);
        }
    }

    public BUnit getUnit() {
        return unit;
    }

    public boolean isValid(int n) {
        return true;
    }

    public int getSize() {
        return this.data.size();
    }

    public double getSample(int n) {
        return this.getBoolean(n) ? 1.0 : -1.0;
    }

    public boolean getBoolean(int n) {
        return this.data.get(n);
    }

    public SimpleBooleanPopulation getSimpleBooleanPopulation() {
        return new SimpleBooleanPopulation(this.data);
    }

    public BoolArray getBoolArray() {
        return new BoolArray(this.data);
    }
}

