/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.db;

import com.tridium.eas.BEasService;
import com.tridium.eas.EasDatabase;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.GroupExec;
import com.tridium.eas.api.Property;
import com.tridium.eas.util.Dbx;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.user.BUser;

public class GroupExecSrv
implements GroupExec {
    private EasDatabase easDb;
    private EasSession session;

    public GroupExecSrv(EasSession easSession, EasDatabase easDatabase) {
        this.easDb = easDatabase;
        this.session = easSession;
    }

    public Property getProperty(Group group, String string, String string2) {
        return this.getProperty(group == null ? -1 : group.getId(), group, string, string2);
    }

    public Property getProperty(int n, String string, String string2) {
        return this.getProperty(n, null, string, string2);
    }

    private Property getProperty(int n, Group group, String string, String string2) {
        Property property = null;
        if (n != -1) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                String string3 = "select VALUE, VUNIT, NVALUE from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUP_PROP") + " where GROUP_ID=" + n + "and NAME=" + Dbx.str2db(string);
                resultSet = statement.executeQuery(string3);
                if (resultSet.next()) {
                    String string4 = "";
                    property = group == null ? new Property(n, string, resultSet.getString(1), resultSet.getDouble(3), string4, resultSet.getString(2), this.session) : new Property(group, string, resultSet.getString(1), resultSet.getDouble(3), string4, resultSet.getString(2));
                }
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                sQLException.printStackTrace();
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.easDb.freeConnection(connection);
        }
        return property;
    }

    public int remProperty(int n, String string, String string2) {
        int n2 = -2;
        if (n != -1 && string != null && string.length() != 0) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            String string3 = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUP_PROP") + " where GROUP_ID=" + n + " and NAME=" + Dbx.str2db(string);
            BUser bUser = BEasService.getUser(string2);
            BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
            if (!bPermissions.hasAdminWrite()) {
                if (bPermissions.hasOperatorWrite()) {
                    string3 = string3 + " and USERID=" + Dbx.no0str(bUser.getUsername());
                } else {
                    System.out.println("must have at least operator.write priveleges to update a group");
                    this.easDb.freeConnection(connection);
                    return n2;
                }
            }
            try {
                statement = connection.createStatement();
                statement.executeUpdate(string3);
                n2 = 0;
            }
            catch (SQLException sQLException) {
                System.out.println(string3);
                sQLException.printStackTrace();
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.easDb.freeConnection(connection);
        }
        return n2;
    }

    public int setProperty(int n, Property property, String string) {
        int n2 = -2;
        if (n != -1) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            String string2 = property.getUnit();
            String string3 = "update " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUP_PROP") + " set VUNIT=" + Dbx.str2db(string2) + ", ";
            BUser bUser = BEasService.getUser(string);
            BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
            if (!bPermissions.hasAdminWrite()) {
                if (bPermissions.hasOperatorWrite()) {
                    string3 = string3 + " where USERID=" + Dbx.no0str(bUser.getUsername());
                } else {
                    System.out.println("must have at least operator.write priveleges to update a group");
                    this.easDb.freeConnection(connection);
                    return n2;
                }
            }
            try {
                statement = connection.createStatement();
                string3 = string2 == null || string2.equals("null") ? string3 + "VALUE='" + property.getValue() + "', NVALUE=null where GROUP_ID=" + n + " and NAME=" + Dbx.str2db(property.getName()) : string3 + "VALUE=null, NVALUE=" + property.getDouble() + " where GROUP_ID=" + n + " and NAME=" + Dbx.str2db(property.getName());
                int n3 = statement.executeUpdate(string3);
                if (n3 == 1) {
                    n2 = 0;
                } else if (n3 == 0) {
                    n2 = -6;
                } else if (n3 > 1) {
                    n2 = -4;
                }
            }
            catch (SQLException sQLException) {
                System.out.println(string3);
                sQLException.printStackTrace();
                n2 = -1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                n2 = -1;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.easDb.freeConnection(connection);
        }
        return n2;
    }

    public String[] getPropertyNames(int n, String string) {
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        if (n != -1) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                String string2 = "select NAME from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUP_PROP") + " where GROUP_ID=" + n;
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    vector.addElement(new String(string3));
                }
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                sQLException.printStackTrace();
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.easDb.freeConnection(connection);
        }
        stringArray = new String[vector.size()];
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            stringArray[n2] = (String)vector.elementAt(n2);
        }
        return stringArray;
    }

    public int addProperty(int n, Property property, String string) {
        int n2 = -2;
        if (n != -1) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            String string2 = property.getUnit();
            String string3 = string2 == null || string2.equals("null") ? property.getValue() : null;
            String string4 = "insert into " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUP_PROP") + " (GROUP_ID,NAME,VALUE,VUNIT,NVALUE) " + "values (" + n + "," + Dbx.str2db(property.getName()) + "," + Dbx.str2db(string3) + "," + Dbx.str2db(property.getUnit()) + "," + (string2 != null && !string2.equals("null") ? Double.toString(property.getDouble()) : "null") + ")";
            BUser bUser = BEasService.getUser(string);
            BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
            if (!bPermissions.hasAdminWrite()) {
                if (bPermissions.hasOperatorWrite()) {
                    string4 = string4 + " where USERID=" + Dbx.no0str(bUser.getUsername());
                } else {
                    System.out.println("must have at least operator.write priveleges to update a group");
                    this.easDb.freeConnection(connection);
                    return n2;
                }
            }
            try {
                statement = connection.createStatement();
                n2 = statement.executeUpdate(string4) == 1 ? 0 : -4;
            }
            catch (SQLException sQLException) {
                System.out.println(string4);
                sQLException.printStackTrace();
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.easDb.freeConnection(connection);
        }
        return n2;
    }

    public Vector getDataPointGroups(int n, String string) {
        Vector<Group> vector = new Vector<Group>();
        if (n == -1) {
            return vector;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            statement = connection.createStatement();
            string2 = "select g.ID, g.NAME, g.TYPE, g.HIDDEN, g.USERID from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " g, " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_DP_GROUP") + " p where g.ID=p.GROUP_ID and p.DP_ID=" + n;
            BUser bUser = BEasService.getUser(string);
            BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
            if (!bPermissions.hasAdminRead()) {
                if (bPermissions.hasOperatorRead()) {
                    string2 = string2 + " and ( g.USERID is null or g.USERID in (''," + Dbx.no0str(bUser.getUsername()) + "))";
                } else {
                    System.out.println("must have at least operator.read priveleges to access a group");
                    this.easDb.freeConnection(connection);
                    return null;
                }
            }
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                String string3 = resultSet.getString(2);
                char c = Dbx.getChar(resultSet, 3);
                int n3 = resultSet.getInt(4);
                String string4 = resultSet.getString(5);
                vector.addElement(Group.get(n2, string3, string4, c, n3 == 1, true, this.session));
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string2);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return vector;
    }

    public Vector getParents(int n, String string) {
        Vector<Group> vector = new Vector<Group>();
        if (n != -1) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                String string2 = "select P.ID, P.NAME, P.TYPE, p.HIDDEN, P.USERID from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " P, " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_GROUP") + " L " + "where P.ID=L.PARENT_ID and L.CHILD_ID=" + n;
                BUser bUser = BEasService.getUser(string);
                BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
                if (!bPermissions.hasAdminRead()) {
                    if (bPermissions.hasOperatorRead()) {
                        string2 = string2 + " and ( p.USERID is null or p.USERID in (''," + Dbx.no0str(bUser.getUsername()) + "))";
                    } else {
                        System.out.println("must have at least operator.read priveleges to access a group");
                        this.easDb.freeConnection(connection);
                        return null;
                    }
                }
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    int n2 = resultSet.getInt(1);
                    String string3 = resultSet.getString(2);
                    char c = Dbx.getChar(resultSet, 3);
                    int n3 = resultSet.getInt(4);
                    String string4 = resultSet.getString(5);
                    vector.addElement(Group.get(n2, string3, string4, c, n3 == 1, true, this.session));
                }
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                sQLException.printStackTrace();
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.easDb.freeConnection(connection);
        }
        return vector;
    }

    public int create(String string, char c, String string2, String string3) {
        int n;
        Statement statement = null;
        Connection connection = this.easDb.getConnection();
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            this.easDb.freeConnection(connection);
            return -1;
        }
        int n2 = -1;
        boolean bl = true;
        String string4 = null;
        int n3 = 10;
        while (bl && --n3 >= 0) {
            try {
                n2 = this.easDb.getNewId();
                BUser bUser = BEasService.getUser(string3);
                BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
                if (!(bPermissions.hasAdminWrite() || bPermissions.hasOperatorWrite() && string2 != null && string2.length() != 0 && string2.equals(bUser.getUsername()))) {
                    System.out.println("must have at least operator.write priveleges to create a group: " + bPermissions.hasOperatorWrite() + " " + string2 + "' '" + bUser.getUsername() + "'");
                    this.easDb.freeConnection(connection);
                    return -1;
                }
                string4 = "insert into " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " (ID, name, TYPE, USERID) values (" + n2 + ",'_" + n2 + "'," + Dbx.chr2db(c) + "," + Dbx.str2db(string2) + ")";
                n = statement.executeUpdate(string4) == 1 ? 0 : -4;
                bl = n != 0;
            }
            catch (SQLException sQLException) {
                if (n3 != 0) continue;
                System.out.println(string4);
                sQLException.printStackTrace();
            }
        }
        if (bl) {
            this.easDb.freeConnection(connection);
            return -1;
        }
        try {
            if (string == null) {
                string = "_" + Long.toString(n2);
            }
            n = statement.executeUpdate(string4 = "update " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " set NAME=" + Dbx.str2db(string) + " where ID=" + n2) == 1 ? 0 : -4;
        }
        catch (SQLException sQLException) {
            System.out.println(string4);
            sQLException.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            this.easDb.freeConnection(connection);
            return -1;
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.easDb.freeConnection(connection);
        return n2;
    }

    public int remove(int n, String string) {
        int n2 = -2;
        if (n != -1) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            String string2 = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " where ID=" + n;
            BUser bUser = BEasService.getUser(string);
            BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
            if (!bPermissions.hasAdminWrite()) {
                if (bPermissions.hasOperatorWrite()) {
                    string2 = string2 + " and USERID=" + Dbx.no0str(bUser.getUsername());
                } else {
                    System.out.println("must have at least operator.write priveleges to delete a group");
                    this.easDb.freeConnection(connection);
                    return n2;
                }
            }
            try {
                if (BEasService.log.isTraceOn()) {
                    BEasService.log.trace("Delete group " + n);
                }
                statement = connection.createStatement();
                statement.executeUpdate("delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_GROUP") + " where PARENT_ID=" + n);
                statement.executeUpdate("delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUP_PROP") + " where GROUP_ID=" + n);
                statement.executeUpdate("delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_DP_GROUP") + " where GROUP_ID=" + n);
                statement.executeUpdate(string2);
                n2 = 0;
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                sQLException.printStackTrace();
                n2 = -3;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                if (n2 == 0) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.easDb.freeConnection(connection);
        }
        return n2;
    }

    public int addChild(int n, int n2, int n3, String string) {
        int n4 = -2;
        if (n != -1 && n2 != -1) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            try {
                statement = connection.createStatement();
                String string2 = "insert into " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_GROUP") + " (PARENT_ID,CHILD_ID,SEQ_N) values (" + n + "," + n2 + "," + n3 + ")";
                n4 = statement.executeUpdate(string2) == 1 ? 0 : -5;
            }
            catch (SQLException sQLException) {
                n4 = -3;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.easDb.freeConnection(connection);
        }
        return n4;
    }

    public int remChildren(int n, String string) {
        int n2 = -2;
        if (n != -1) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            try {
                statement = connection.createStatement();
                String string2 = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_GROUP") + " where PARENT_ID=" + n;
                n2 = statement.executeUpdate(string2) >= 0 ? 0 : -3;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                n2 = -3;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.easDb.freeConnection(connection);
        }
        return n2;
    }

    public int remChild(int n, int n2, String string) {
        int n3 = -2;
        if (n != -1 && n2 != -1) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            try {
                statement = connection.createStatement();
                String string2 = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_GROUP") + " where PARENT_ID=" + n + " and CHILD_ID=" + n2;
                n3 = statement.executeUpdate(string2) == 1 ? 0 : -4;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                n3 = -3;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.easDb.freeConnection(connection);
        }
        return n3;
    }

    public Vector loadChildren(int n, String string) {
        Vector<Group> vector = new Vector<Group>();
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String string2 = "select C.ID, C.NAME, C.TYPE, C.HIDDEN, L.SEQ_N, C.USERID from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " C, " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_GROUP") + " L " + "where C.ID=L.CHILD_ID and L.PARENT_ID=" + n;
            BUser bUser = BEasService.getUser(string);
            BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
            if (!bPermissions.hasAdminRead()) {
                if (bPermissions.hasOperatorRead()) {
                    string2 = string2 + " and ( C.USERID is null or C.USERID in (''," + Dbx.no0str(bUser.getUsername()) + "))";
                } else {
                    System.out.println("must have at least operator.read priveleges to access a group");
                    this.easDb.freeConnection(connection);
                    return null;
                }
            }
            string2 = string2 + " order by L.SEQ_N";
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                String string3 = resultSet.getString(2);
                char c = Dbx.getChar(resultSet, 3);
                int n3 = resultSet.getInt(4);
                String string4 = resultSet.getString(5);
                vector.addElement(Group.get(n2, string3, string4, c, n3 == 1, true, this.session));
            }
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return vector;
    }

    public int countChildren(int n, String string) {
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        int n2 = 0;
        String string2 = "select count(*) from " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_GROUP") + " L, " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_GROUP") + " C " + "where C.ID=L.CHILD_ID and L.PARENT_ID=" + n;
        try {
            statement = connection.createStatement();
            BUser bUser = BEasService.getUser(string);
            BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
            if (!bPermissions.hasAdminRead()) {
                if (bPermissions.hasOperatorRead()) {
                    string2 = string2 + " and ( C.USERID is null or C.USERID in (''," + Dbx.no0str(bUser.getUsername()) + "))";
                } else {
                    System.out.println("must have at least operator.read priveleges to access a group");
                    this.easDb.freeConnection(connection);
                    return 0;
                }
            }
            if ((resultSet = statement.executeQuery(string2)).next()) {
                n2 = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string2);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return n2;
    }

    public boolean update(int n, String string, String string2, String string3) {
        boolean bl = false;
        BUser bUser = BEasService.getUser(string3);
        BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
        if (!bPermissions.hasOperatorWrite()) {
            return bl;
        }
        if (n != -1 && string != null && string.length() != 0) {
            Connection connection = this.easDb.getConnection();
            Statement statement = null;
            String string4 = "update " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " set NAME=" + Dbx.str2db(string) + ", USERID=" + Dbx.str2db(string2) + " where ID=" + n;
            if (!bPermissions.hasAdminWrite()) {
                if (bPermissions.hasOperatorWrite()) {
                    string4 = string4 + " and USERID=" + Dbx.no0str(bUser.getUsername());
                } else {
                    System.out.println("must have at least operator.write priveleges to update a group");
                    this.easDb.freeConnection(connection);
                    return bl;
                }
            }
            try {
                statement = connection.createStatement();
                bl = statement.executeUpdate(string4) == 1;
            }
            catch (SQLException sQLException) {
                System.out.println(string4);
                sQLException.printStackTrace();
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                bl = false;
            }
            this.easDb.freeConnection(connection);
        }
        return bl;
    }

    public Vector getGroups(char c, String string) {
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<Group> vector = new Vector<Group>();
        String string2 = null;
        try {
            statement = connection.createStatement();
            string2 = "select ID, NAME, TYPE, HIDDEN, USERID from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS");
            BUser bUser = BEasService.getUser(string);
            BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
            if (c != '\u0000') {
                string2 = string2 + " where TYPE='" + c + "'";
                if (!bPermissions.hasAdminRead()) {
                    string2 = string2 + " and ( USERID is null or USERID in (''," + Dbx.no0str(bUser.getUsername()) + ") )";
                }
            } else if (!bPermissions.hasAdminRead()) {
                string2 = string2 + " where ( USERID is null or USERID in (''," + Dbx.no0str(bUser.getUsername()) + ") )";
            }
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string3 = resultSet.getString(2);
                c = Dbx.getChar(resultSet, 3);
                int n2 = resultSet.getInt(4);
                String string4 = resultSet.getString(5);
                vector.addElement(Group.get(n, string3, string4, c, n2 == 1, true, this.session));
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string2);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return vector;
    }

    public Group load(int n, String string) {
        Group group = null;
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = "select NAME, TYPE, HIDDEN, USERID from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " where ID=" + n;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                int n2 = resultSet.getInt(3);
                group = Group.get(n, resultSet.getString(1), resultSet.getString(4), Dbx.getChar(resultSet, 2), n2 == 1, true, this.session);
            }
        }
        catch (Exception exception) {
            System.out.println(string2);
            exception.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return group;
    }

    public Group getByName(String string, String string2) {
        Group group = null;
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = "select ID, TYPE, HIDDEN, USERID from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " where NAME =" + Dbx.str2db(string);
        BUser bUser = BEasService.getUser(string2);
        BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.easDb.getService());
        if (!bPermissions.hasAdminRead()) {
            string3 = string3 + " and ( USERID is null or USERID in (''," + Dbx.no0str(bUser.getUsername()) + ") )";
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                int n = resultSet.getInt(3);
                group = Group.get(resultSet.getInt(1), string, resultSet.getString(4), Dbx.getChar(resultSet, 2), n == 1, true, this.session);
            }
        }
        catch (Exception exception) {
            System.out.println(string3);
            exception.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return group;
    }
}

