/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.db;

import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.DynGroupFld;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.xml.XmlMessage;
import com.tridium.eas.xml.XmlSupport;
import java.util.Vector;
import javax.baja.log.Log;

public class DynGroupDxDispatch {
    private EasSession srv;
    private static final Log log = Log.getLog((String)"eas");

    public DynGroupDxDispatch(EasSession easSession) {
        this.srv = easSession;
    }

    public XmlMessage process(XmlMessage xmlMessage) {
        String string = xmlMessage.getString("command", null);
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("loadFields")) {
            return this.loadFields(xmlMessage);
        }
        if (string.equalsIgnoreCase("getChildren")) {
            return this.getChildren(xmlMessage);
        }
        if (string.equalsIgnoreCase("getSubIDs")) {
            return this.getSubIDs(xmlMessage);
        }
        if (string.equalsIgnoreCase("countLevels")) {
            return this.countLevels(xmlMessage);
        }
        return null;
    }

    public XmlMessage countLevels(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        int n = 0;
        try {
            int n2 = xmlMessage.getInt("groupid");
            n = this.srv.getDynGroupExec().countLevels(n2);
            xmlMessage2 = new XmlMessage("countLevels");
            xmlMessage2.add("count", n);
        }
        catch (Exception exception) {
            log.error("Problem counting levels", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage getChildren(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            if (xmlMessage == null) {
                return null;
            }
            XmlSupport[] xmlSupportArray = xmlMessage.getChildObjects();
            int n = xmlSupportArray != null ? xmlSupportArray.length - 3 : 0;
            Vector<DynGroupFld> vector = new Vector<DynGroupFld>(n);
            for (int i = 0; i < n; ++i) {
                XmlMessage xmlMessage3 = xmlMessage.getMessage("row" + i);
                boolean bl = xmlMessage3.getBoolean("dgfGroupIdx");
                boolean bl2 = xmlMessage3.getBoolean("dgfWhereIdx");
                int n2 = xmlMessage3.getInt("dgfOrderIdx");
                char c = (char)xmlMessage3.getInt("dgfOrigIdx");
                String string = xmlMessage3.getString("dgfNameIdx");
                String string2 = xmlMessage3.getString("dgfValIdx");
                if (string2.length() == 0) {
                    string2 = null;
                }
                double d = xmlMessage3.getDouble("dgfNvalIdx");
                boolean bl3 = xmlMessage3.getBoolean("dgfNumericIdx");
                String string3 = xmlMessage3.getString("dgfCompIdx");
                String string4 = xmlMessage3.getString("dgfOperIdx");
                int n3 = xmlMessage3.getInt("dgfSeqIdx");
                vector.addElement(new DynGroupFld(bl, bl2, n2, c, string, string2, d, bl3, string3, string4, n3));
            }
            Vector vector2 = this.srv.getDynGroupExec().getChildren(vector);
            if (vector2 == null) {
                return null;
            }
            xmlMessage2 = new XmlMessage("getChildren");
            for (int i = 0; i < vector2.size(); ++i) {
                XmlMessage xmlMessage4 = new XmlMessage("row" + i);
                Group group = (Group)vector2.elementAt(i);
                xmlMessage4.add("idIndex", group.getId());
                xmlMessage4.add("nameIndex", group.getName());
                xmlMessage4.add("userIndex", group.getUserId());
                xmlMessage4.add("typeIndex", group.getType());
                xmlMessage4.add("hiddenIndex", group.isHidden());
                xmlMessage2.add("row" + i, xmlMessage4);
            }
        }
        catch (Exception exception) {
            log.error("Problem getting children", (Throwable)exception);
            return null;
        }
        return xmlMessage2;
    }

    /*
     * WARNING - void declaration
     */
    public XmlMessage getSubIDs(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            void var9_15;
            void var9_13;
            Object object;
            int n;
            Object object2;
            if (xmlMessage == null) {
                return null;
            }
            int n3 = xmlMessage.getInt("id");
            XmlSupport[] xmlSupportArray = xmlMessage.getChildObjects();
            int n4 = xmlSupportArray != null ? xmlSupportArray.length - 4 : 0;
            Vector<DynGroupFld> vector = new Vector<DynGroupFld>(n4);
            for (int i = 0; i < n4; ++i) {
                object2 = xmlMessage.getMessage("row" + i);
                boolean n2 = ((XmlMessage)object2).getBoolean("dgfGroupIdx");
                boolean bl = ((XmlMessage)object2).getBoolean("dgfWhereIdx");
                n = ((XmlMessage)object2).getInt("dgfOrderIdx");
                char c = (char)((XmlMessage)object2).getInt("dgfOrigIdx");
                object = ((XmlMessage)object2).getString("dgfNameIdx");
                String string = ((XmlMessage)object2).getString("dgfValIdx");
                if (string.length() == 0) {
                    string = null;
                }
                double d = ((XmlMessage)object2).getDouble("dgfNvalIdx");
                boolean bl2 = ((XmlMessage)object2).getBoolean("dgfNumericIdx");
                String string2 = ((XmlMessage)object2).getString("dgfCompIdx");
                String string3 = ((XmlMessage)object2).getString("dgfOperIdx");
                int n5 = ((XmlMessage)object2).getInt("dgfSeqIdx");
                vector.addElement(new DynGroupFld(n2, bl, n, c, (String)object, string, d, bl2, string2, string3, n5));
            }
            Vector vector2 = this.srv.getDynGroupExec().getSubIDs(n3, vector);
            xmlMessage2 = new XmlMessage("getSubIDs");
            object2 = new Vector();
            boolean bl = false;
            while (var9_13 < vector2.size()) {
                DynGroupFld[] dynGroupFldArray = ((DynGroup)vector2.elementAt((int)var9_13)).getFlds();
                if (dynGroupFldArray != null) {
                    for (n = 0; n < dynGroupFldArray.length; ++n) {
                        DynGroupFld dynGroupFld = dynGroupFldArray[n];
                        object = new XmlMessage("row" + n);
                        ((XmlMessage)object).add("dsfIdIdx", (int)var9_13);
                        ((XmlMessage)object).add("dsfOrigIdx", dynGroupFld.orig);
                        ((XmlMessage)object).add("dsfNameIdx", dynGroupFld.name);
                        ((XmlMessage)object).add("dsfValIdx", dynGroupFld.val);
                        ((XmlMessage)object).add("dsfIsGrpIdx", dynGroupFld.isGroup());
                        ((XmlMessage)object).add("dsfIsWhrIdx", dynGroupFld.isWhere());
                        ((XmlMessage)object).add("dsfSeqIdx", dynGroupFld.seq);
                        ((Vector)object2).addElement(object);
                    }
                }
                ++var9_13;
            }
            boolean bl3 = false;
            while (var9_15 < ((Vector)object2).size()) {
                XmlMessage xmlMessage3 = (XmlMessage)((Vector)object2).elementAt((int)var9_15);
                xmlMessage3.setName("row" + (int)var9_15);
                xmlMessage2.add("row" + (int)var9_15, xmlMessage3);
                ++var9_15;
            }
        }
        catch (Exception exception) {
            log.error("Problem getting subIDs", (Throwable)exception);
            return null;
        }
        return xmlMessage2;
    }

    public XmlMessage loadFields(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("id");
            Vector vector = this.srv.getDynGroupExec().loadFields(n);
            xmlMessage2 = new XmlMessage("loadFields");
            for (int i = 0; i < vector.size(); ++i) {
                XmlMessage xmlMessage3 = new XmlMessage("row" + i);
                DynGroupFld dynGroupFld = (DynGroupFld)vector.elementAt(i);
                xmlMessage3.add("dgfGroupIdx", dynGroupFld.isGroup());
                xmlMessage3.add("dgfWhereIdx", dynGroupFld.isWhere());
                xmlMessage3.add("dgfOrderIdx", dynGroupFld.getOrder());
                xmlMessage3.add("dgfOrigIdx", dynGroupFld.orig);
                xmlMessage3.add("dgfNameIdx", dynGroupFld.name);
                xmlMessage3.add("dgfValIdx", dynGroupFld.val);
                xmlMessage3.add("dgfNvalIdx", dynGroupFld.nval);
                xmlMessage3.add("dgfNumericIdx", dynGroupFld.isNumeric());
                xmlMessage3.add("dgfCompIdx", dynGroupFld.comp);
                xmlMessage3.add("dgfOperIdx", dynGroupFld.oper);
                xmlMessage3.add("dgfSeqIdx", dynGroupFld.seq);
                xmlMessage2.add("row" + i, xmlMessage3);
            }
        }
        catch (Exception exception) {
            log.error("Problem loading fields", (Throwable)exception);
        }
        return xmlMessage2;
    }
}

