/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.db;

import com.tridium.eas.BEasService;
import com.tridium.eas.api.DPNormInfo;
import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DataSample;
import com.tridium.eas.api.DataSummaryElement;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ExceptionSummaryData;
import com.tridium.eas.api.RestorationMethod;
import com.tridium.eas.api.RollupMethod;
import com.tridium.eas.api.SiteSummary;
import com.tridium.eas.api.TSDataFloat;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.xml.XmlMessage;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class DataPointDxDispatch {
    private EasSession srv;
    private BEasService eas;
    private UnitDatabase unitDatabase = null;
    private static final Log log = Log.getLog((String)"eas");

    public DataPointDxDispatch(BEasService bEasService, EasSession easSession) {
        this.eas = bEasService;
        this.srv = easSession;
    }

    public XmlMessage process(XmlMessage xmlMessage) {
        String string = xmlMessage.getString("command", null);
        if (string == null) {
            return null;
        }
        try {
            if (string.equalsIgnoreCase("create")) {
                return this.create(xmlMessage);
            }
            if (string.equalsIgnoreCase("erase")) {
                return this.erase(xmlMessage);
            }
            if (string.equalsIgnoreCase("update")) {
                return this.update(xmlMessage);
            }
            if (string.equalsIgnoreCase("getData")) {
                return this.getData(xmlMessage);
            }
            if (string.equalsIgnoreCase("getExceptionSummary")) {
                return this.getExceptionSummary(xmlMessage);
            }
            if (string.equalsIgnoreCase("getRawData")) {
                return this.getRawData(xmlMessage);
            }
            if (string.equalsIgnoreCase("getTotal")) {
                return this.getTotal(xmlMessage);
            }
            if (string.equalsIgnoreCase("getDataSummary")) {
                return this.getDataSummary(xmlMessage);
            }
            if (string.equalsIgnoreCase("getAggregatedSummary")) {
                return this.getAggregatedSummary(xmlMessage);
            }
            if (string.equalsIgnoreCase("getAggregatedSummaryNorm")) {
                return this.getAggregatedSummaryNorm(xmlMessage);
            }
            if (string.equalsIgnoreCase("getRankedSummaries")) {
                return this.getRankedSummaries(xmlMessage);
            }
            if (string.equalsIgnoreCase("remGroupLink")) {
                return this.remGroupLink(xmlMessage);
            }
            if (string.equalsIgnoreCase("addGroupLink")) {
                return this.addGroupLink(xmlMessage);
            }
            if (string.equalsIgnoreCase("getDataPoints")) {
                return this.getDataPoints(xmlMessage);
            }
            if (string.equalsIgnoreCase("getGroupDataPoints")) {
                return this.getGroupDataPoints(xmlMessage);
            }
            if (string.equalsIgnoreCase("getDataPointsFromList")) {
                return this.getDataPointsFromList(xmlMessage);
            }
            if (string.equalsIgnoreCase("load")) {
                return this.load(xmlMessage);
            }
            if (string.equalsIgnoreCase("getMeterDPs")) {
                return this.getMeterDPs(xmlMessage);
            }
            if (string.equalsIgnoreCase("availableLicensed")) {
                return this.getAvailableLicensedDataPointCount();
            }
            if (string.equalsIgnoreCase("getAllDataPointNames")) {
                return this.getAllDataPointNames();
            }
            if (string.equalsIgnoreCase("isMultistate")) {
                return this.isMultistate(xmlMessage);
            }
        }
        catch (LocalizableRuntimeException localizableRuntimeException) {
            XmlMessage xmlMessage2 = new XmlMessage("error");
            xmlMessage2.add("server exception", localizableRuntimeException.toString(null));
            xmlMessage2.add("lexiconModule", localizableRuntimeException.getLexiconModule());
            xmlMessage2.add("lexiconKey", localizableRuntimeException.getLexiconKey());
            Object[] objectArray = localizableRuntimeException.getLexiconArguments();
            if (objectArray != null && objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    xmlMessage2.add("lexiconArgument", objectArray[i].toString());
                }
            }
            return xmlMessage2;
        }
        catch (Exception exception) {
            log.error("DxDispatch: Server exception in " + string, (Throwable)exception);
            XmlMessage xmlMessage3 = new XmlMessage("error");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(byteArrayOutputStream));
            xmlMessage3.add("server exception", byteArrayOutputStream.toString());
            return xmlMessage3;
        }
        return null;
    }

    public XmlMessage remGroupLink(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("dpid");
            int n2 = xmlMessage.getInt("grpid");
            this.srv.getDataPointExec().remGroupLink(n, n2);
        }
        catch (Exception exception) {
            log.error("Problem removing group link", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage addGroupLink(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("dpid");
            int n2 = xmlMessage.getInt("grpid");
            this.srv.getDataPointExec().addGroupLink(n, n2);
        }
        catch (Exception exception) {
            log.error("Problem adding group link", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage getDataPointsFromList(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            String string = xmlMessage.getString("points");
            Vector vector = this.srv.getDataPointExec().getDataPoints(string);
            xmlMessage2 = new XmlMessage("getDataPointsFromList");
            XmlMessage[] xmlMessageArray = new XmlMessage[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                DataPoint dataPoint = (DataPoint)vector.elementAt(i);
                xmlMessageArray[i] = new XmlMessage("row" + i);
                xmlMessageArray[i].add("dpid", dataPoint.getId());
                xmlMessageArray[i].add("dpName", dataPoint.getName());
                xmlMessageArray[i].add("dpStationName", dataPoint.getStationName());
                xmlMessageArray[i].add("dpDescr", dataPoint.getDescr());
                xmlMessageArray[i].add("dpRcType", dataPoint.getRcType());
                xmlMessageArray[i].add("dpRcSubType", dataPoint.getRcSubType());
                xmlMessageArray[i].add("dpIsMain", dataPoint.isMain());
                xmlMessageArray[i].add("dpVType", dataPoint.getVType());
                xmlMessageArray[i].add("dpVUnit", dataPoint.getVUnit());
                xmlMessageArray[i].add("dpSite", dataPoint.getSite().getId());
                xmlMessageArray[i].add("dpMeter", dataPoint.getMeter() == null ? -1 : dataPoint.getMeter().getId());
                xmlMessageArray[i].add("dpFAVUnit", dataPoint.getFloorAreaVUnit());
                xmlMessageArray[i].add("dpFAValue", dataPoint.getFloorAreaValue());
                xmlMessageArray[i].add("dpTZ", dataPoint.getTimeZoneString());
                xmlMessageArray[i].add("dpFlags", dataPoint.getFlags());
                xmlMessage2.add("row" + i, xmlMessageArray[i]);
            }
        }
        catch (Exception exception) {
            log.error("Problem getting data points from list", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage load(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("dpid");
            DataPoint dataPoint = this.srv.getDataPointExec().load(n);
            if (dataPoint == null) {
                return xmlMessage2;
            }
            xmlMessage2 = new XmlMessage("load");
            XmlMessage xmlMessage3 = new XmlMessage("row0");
            xmlMessage3.add("dpid", dataPoint.getId());
            xmlMessage3.add("dpName", dataPoint.getName());
            xmlMessage3.add("dpStationName", dataPoint.getStationName());
            xmlMessage3.add("dpDescr", dataPoint.getDescr());
            xmlMessage3.add("dpRcType", dataPoint.getRcType());
            xmlMessage3.add("dpRcSubType", dataPoint.getRcSubType());
            xmlMessage3.add("dpIsMain", dataPoint.isMain());
            xmlMessage3.add("dpVType", dataPoint.getVType());
            xmlMessage3.add("dpVUnit", dataPoint.getVUnit());
            xmlMessage3.add("dpSite", dataPoint.getSite().getId());
            xmlMessage3.add("dpMeter", dataPoint.getMeter() == null ? -1 : dataPoint.getMeter().getId());
            xmlMessage3.add("dpFAVUnit", dataPoint.getFloorAreaVUnit());
            xmlMessage3.add("dpFAValue", dataPoint.getFloorAreaValue());
            xmlMessage3.add("dpTZ", dataPoint.getTimeZoneString());
            xmlMessage3.add("dpFlags", dataPoint.getFlags());
            xmlMessage2.add("row0", xmlMessage3);
        }
        catch (Exception exception) {
            log.error("Cannot load data point", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage getGroupDataPoints(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("group");
            Vector vector = this.srv.getDataPointExec().getGroupDataPoints(n);
            xmlMessage2 = new XmlMessage("getGroupDataPoints");
            XmlMessage[] xmlMessageArray = new XmlMessage[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                DataPoint dataPoint = (DataPoint)vector.elementAt(i);
                xmlMessageArray[i] = new XmlMessage("row" + i);
                xmlMessageArray[i].add("dpid", dataPoint.getId());
                xmlMessageArray[i].add("dpName", dataPoint.getName());
                xmlMessageArray[i].add("dpStationName", dataPoint.getStationName());
                xmlMessageArray[i].add("dpDescr", dataPoint.getDescr());
                xmlMessageArray[i].add("dpRcType", dataPoint.getRcType());
                xmlMessageArray[i].add("dpRcSubType", dataPoint.getRcSubType());
                xmlMessageArray[i].add("dpIsMain", dataPoint.isMain());
                xmlMessageArray[i].add("dpVType", dataPoint.getVType());
                xmlMessageArray[i].add("dpVUnit", dataPoint.getVUnit());
                xmlMessageArray[i].add("dpSite", dataPoint.getSite().getId());
                xmlMessageArray[i].add("dpMeter", dataPoint.getMeter() == null ? -1 : dataPoint.getMeter().getId());
                xmlMessageArray[i].add("dpFAVUnit", dataPoint.getFloorAreaVUnit());
                xmlMessageArray[i].add("dpFAValue", dataPoint.getFloorAreaValue());
                xmlMessageArray[i].add("dpTZ", dataPoint.getTimeZoneString());
                xmlMessageArray[i].add("dpFlags", dataPoint.getFlags());
                xmlMessage2.add("row" + i, xmlMessageArray[i]);
            }
        }
        catch (Exception exception) {
            log.error("Can't get group data points", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage getMeterDPs(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("meter");
            Vector vector = this.srv.getDataPointExec().getMeterDPs(n);
            xmlMessage2 = new XmlMessage("getMeterDPs");
            XmlMessage[] xmlMessageArray = new XmlMessage[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                DataPoint dataPoint = (DataPoint)vector.elementAt(i);
                xmlMessageArray[i] = new XmlMessage("row" + i);
                xmlMessageArray[i].add("dpid", dataPoint.getId());
                xmlMessageArray[i].add("dpName", dataPoint.getName());
                xmlMessageArray[i].add("dpStationName", dataPoint.getStationName());
                xmlMessageArray[i].add("dpDescr", dataPoint.getDescr());
                xmlMessageArray[i].add("dpRcType", dataPoint.getRcType());
                xmlMessageArray[i].add("dpRcSubType", dataPoint.getRcSubType());
                xmlMessageArray[i].add("dpIsMain", dataPoint.isMain());
                xmlMessageArray[i].add("dpVType", dataPoint.getVType());
                xmlMessageArray[i].add("dpVUnit", dataPoint.getVUnit());
                xmlMessageArray[i].add("dpSite", dataPoint.getSite().getId());
                xmlMessageArray[i].add("dpMeter", dataPoint.getMeter() == null ? -1 : dataPoint.getMeter().getId());
                xmlMessageArray[i].add("dpFAVUnit", dataPoint.getFloorAreaVUnit());
                xmlMessageArray[i].add("dpFAValue", dataPoint.getFloorAreaValue());
                xmlMessageArray[i].add("dpTZ", dataPoint.getTimeZoneString());
                xmlMessageArray[i].add("dpFlags", dataPoint.getFlags());
                xmlMessage2.add("row" + i, xmlMessageArray[i]);
            }
        }
        catch (Exception exception) {
            log.error("Problem getting meter data points", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage getDataPoints(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("site");
            Vector vector = this.srv.getDataPointExec().getDataPoints(n);
            xmlMessage2 = new XmlMessage("getDataPoints");
            XmlMessage[] xmlMessageArray = new XmlMessage[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                DataPoint dataPoint = (DataPoint)vector.elementAt(i);
                xmlMessageArray[i] = new XmlMessage("row" + i);
                xmlMessageArray[i].add("dpid", dataPoint.getId());
                xmlMessageArray[i].add("dpName", dataPoint.getName());
                xmlMessageArray[i].add("dpStationName", dataPoint.getStationName());
                xmlMessageArray[i].add("dpDescr", dataPoint.getDescr());
                xmlMessageArray[i].add("dpRcType", dataPoint.getRcType());
                xmlMessageArray[i].add("dpRcSubType", dataPoint.getRcSubType());
                xmlMessageArray[i].add("dpIsMain", dataPoint.isMain());
                xmlMessageArray[i].add("dpVType", dataPoint.getVType());
                xmlMessageArray[i].add("dpVUnit", dataPoint.getVUnit());
                xmlMessageArray[i].add("dpSite", dataPoint.getSite().getId());
                xmlMessageArray[i].add("dpMeter", dataPoint.getMeter() == null ? -1 : dataPoint.getMeter().getId());
                xmlMessageArray[i].add("dpFAVUnit", dataPoint.getFloorAreaVUnit());
                xmlMessageArray[i].add("dpFAValue", dataPoint.getFloorAreaValue());
                xmlMessageArray[i].add("dpTZ", dataPoint.getTimeZoneString());
                xmlMessageArray[i].add("dpFlags", dataPoint.getFlags());
                xmlMessage2.add("row" + i, xmlMessageArray[i]);
            }
        }
        catch (Exception exception) {
            log.error("Can't get data points", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage getAllDataPointNames() {
        XmlMessage xmlMessage = null;
        try {
            Vector vector = this.srv.getDataPointExec().getAllDataPointNames();
            xmlMessage = new XmlMessage("getAllDataPointNames");
            for (int i = 0; i < vector.size(); ++i) {
                xmlMessage.add("dpName" + i, vector.elementAt(i).toString());
            }
        }
        catch (Exception exception) {
            log.error("Problem getting all data point names.", (Throwable)exception);
        }
        return xmlMessage;
    }

    public XmlMessage isMultistate(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            String string = xmlMessage.getString("dpName");
            boolean bl = this.srv.getDataPointExec().isMultistate(string);
            xmlMessage2 = new XmlMessage("isMultistate");
            xmlMessage2.add("multistate", bl);
        }
        catch (Exception exception) {
            log.error("Problem with isMultistate.", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage create(XmlMessage xmlMessage) throws EasException {
        if (this.eas.isDemo()) {
            throw new EasException("Cannot create data points in demo mode.");
        }
        XmlMessage xmlMessage2 = null;
        try {
            String string = xmlMessage.getString("name");
            String string2 = xmlMessage.getString("station_name");
            String string3 = xmlMessage.getString("descr");
            int n = xmlMessage.getInt("rc_type");
            int n2 = xmlMessage.getInt("rc_subtype");
            boolean bl = xmlMessage.getBoolean("is_main");
            String string4 = xmlMessage.getString("vtype");
            String string5 = xmlMessage.getString("vunit");
            int n3 = xmlMessage.getInt("site");
            int n4 = xmlMessage.getInt("meter");
            String string6 = xmlMessage.getString("floorarea_vunit");
            double d = xmlMessage.getDouble("floorarea_value");
            String string7 = xmlMessage.getString("time_zone");
            int n5 = xmlMessage.getInt("flags", 1);
            int n6 = this.srv.getDataPointExec().create(string, string2, string3, n5, n, n2, bl, string4, string5, n3, n4, string6, d, string7);
            xmlMessage2 = new XmlMessage("create");
            xmlMessage2.add("dpid", n6);
        }
        catch (Exception exception) {
            log.error("Problem creating data point", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage update(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("dpid");
            String string = xmlMessage.getString("name");
            String string2 = xmlMessage.getString("station_name");
            String string3 = xmlMessage.getString("descr");
            int n2 = xmlMessage.getInt("rc_type");
            int n3 = xmlMessage.getInt("rc_subtype");
            boolean bl = xmlMessage.getBoolean("is_main");
            String string4 = xmlMessage.getString("vtype");
            String string5 = xmlMessage.getString("vunit");
            int n4 = xmlMessage.getInt("site");
            int n5 = xmlMessage.getInt("meter");
            String string6 = xmlMessage.getString("floorarea_vunit");
            double d = xmlMessage.getDouble("floorarea_value");
            String string7 = xmlMessage.getString("time_zone");
            int n6 = xmlMessage.getInt("flags", 1);
            int n7 = this.srv.getDataPointExec().update(n, string, string2, string3, n6, n2, n3, bl, string4, string5, n4, n5, string6, d, string7);
            xmlMessage2 = new XmlMessage("update");
            xmlMessage2.add("status", n7);
        }
        catch (Exception exception) {
            log.error("Problem updating data point", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage erase(XmlMessage xmlMessage) throws EasException {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("dpid");
            String string = xmlMessage.getString("name");
            int n2 = this.srv.getDataPointExec().erase(n, string);
            xmlMessage2 = new XmlMessage("erase");
            xmlMessage2.add("status", n2);
        }
        catch (Exception exception) {
            log.error("Problem erasing data point", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage getData(XmlMessage xmlMessage) throws Exception {
        XmlMessage xmlMessage2 = null;
        String string = xmlMessage.getString("name");
        long l = xmlMessage.getLong("interval");
        int n = xmlMessage.getInt("intl_unit");
        String string2 = xmlMessage.getString("vtype");
        String string3 = xmlMessage.getString("vunit");
        BUnit bUnit = BUnit.getUnit((String)string3);
        RestorationMethod restorationMethod = RestorationMethod.getById(xmlMessage.getInt("accum"));
        EasLocalTime easLocalTime = EasLocalTime.fromSerializedLong(xmlMessage.getLong("first"));
        EasLocalTime easLocalTime2 = EasLocalTime.fromSerializedLong(xmlMessage.getLong("last"));
        BTimeZone bTimeZone = BTimeZone.getTimeZone((String)xmlMessage.getString("tz"));
        boolean bl = xmlMessage.getBoolean("data_cleanse");
        int n2 = xmlMessage.getInt("cleanse_w");
        double d = xmlMessage.getDouble("cleanse_p");
        boolean bl2 = xmlMessage.getBoolean("dpNormalization");
        DataPoint dataPoint = null;
        if (bl2) {
            dataPoint = DataPoint.get(xmlMessage.getInt("normalizer"), this.srv);
        }
        TSDataFloat tSDataFloat = this.srv.getDataPointExec().getData(string, easLocalTime, easLocalTime2, bTimeZone, restorationMethod, bUnit, new TimeInterval(l, n), bl, n2, d, bl2, dataPoint);
        xmlMessage2 = new XmlMessage("getData");
        for (int i = 0; i < tSDataFloat.getSize(); ++i) {
            XmlMessage xmlMessage3 = new XmlMessage("row" + i);
            xmlMessage3.add("value", tSDataFloat.getDouble(i));
            xmlMessage3.add("valid", tSDataFloat.isValid(i));
            xmlMessage2.add("row" + i, xmlMessage3);
        }
        return xmlMessage2;
    }

    public XmlMessage getTotal(XmlMessage xmlMessage) throws Exception {
        XmlMessage xmlMessage2 = null;
        String string = xmlMessage.getString("name");
        EasLocalTime easLocalTime = EasLocalTime.fromSerializedLong(xmlMessage.getLong("first"));
        EasLocalTime easLocalTime2 = EasLocalTime.fromSerializedLong(xmlMessage.getLong("last"));
        BTimeZone bTimeZone = BTimeZone.getTimeZone((String)xmlMessage.getString("tz"));
        double d = this.srv.getDataPointExec().getTotal(string, easLocalTime, easLocalTime2, bTimeZone);
        xmlMessage2 = new XmlMessage("getTotal");
        xmlMessage2.add("total", d);
        return xmlMessage2;
    }

    public XmlMessage getRawData(XmlMessage xmlMessage) throws Exception {
        int n;
        int n2;
        XmlMessage xmlMessage2 = null;
        String string = xmlMessage.getString("name");
        EasLocalTime easLocalTime = EasLocalTime.fromSerializedLong(xmlMessage.getLong("first"));
        EasLocalTime easLocalTime2 = EasLocalTime.fromSerializedLong(xmlMessage.getLong("last"));
        BTimeZone bTimeZone = BTimeZone.getTimeZone((String)xmlMessage.getString("tz"));
        String string2 = xmlMessage.getString("vtype");
        String string3 = xmlMessage.getString("vunit");
        BUnit bUnit = BUnit.getUnit((String)string3);
        DataSample[] dataSampleArray = this.srv.getDataPointExec().getRawData(string, easLocalTime, easLocalTime2, bTimeZone, bUnit);
        int n3 = n2 = dataSampleArray == null ? 0 : dataSampleArray.length;
        int n4 = 0;
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            if (dataSampleArray[n] == null) {
                --n3;
                if (!bl) continue;
                ++n4;
                continue;
            }
            bl = false;
        }
        xmlMessage2 = new XmlMessage("getRawData");
        for (n = 0; n < n3; ++n) {
            DataSample dataSample = dataSampleArray[n + n4];
            if (dataSample == null) continue;
            XmlMessage xmlMessage3 = new XmlMessage("row" + n);
            xmlMessage3.add("timestamp", dataSample.getTime());
            xmlMessage3.add("value", dataSample.getDouble());
            xmlMessage3.add("status", dataSample.getStatus());
            xmlMessage2.add("row" + n, xmlMessage3);
        }
        return xmlMessage2;
    }

    public XmlMessage getAggregatedSummary(XmlMessage xmlMessage) throws Exception {
        TSDataSummary tSDataSummary;
        Object object;
        XmlMessage xmlMessage2 = null;
        BUnit bUnit = null;
        int n = 0;
        boolean bl = xmlMessage.getBoolean("dpNormalization");
        int n2 = bl ? 21 : 20;
        int n3 = xmlMessage.getChildObjects().length - n2;
        String[] stringArray = new String[n3];
        double[] dArray = new double[n3];
        BUnit[] bUnitArray = new BUnit[n3];
        BTimeZone[] bTimeZoneArray = new BTimeZone[n3];
        for (int i = 0; i < n3; ++i) {
            object = xmlMessage.getMessage("row" + i);
            stringArray[i] = ((XmlMessage)object).getString("names");
            dArray[i] = ((XmlMessage)object).getDouble("coeffs");
            String string = ((XmlMessage)object).getString("unit_tag");
            String string2 = ((XmlMessage)object).getString("unit_id");
            bUnitArray[i] = BUnit.getUnit((String)string2);
            bTimeZoneArray[i] = BTimeZone.getTimeZone((String)((XmlMessage)object).getString("tz"));
        }
        n = xmlMessage.getInt("aggregation_method");
        String string = xmlMessage.getString("ounit_tag");
        object = xmlMessage.getString("ounit_id");
        bUnit = BUnit.getUnit((String)object);
        long l = xmlMessage.getLong("interval");
        int n4 = xmlMessage.getInt("intl_unit");
        EasLocalTime easLocalTime = EasLocalTime.fromSerializedLong(xmlMessage.getLong("first"));
        EasLocalTime easLocalTime2 = EasLocalTime.fromSerializedLong(xmlMessage.getLong("last"));
        RestorationMethod restorationMethod = RestorationMethod.getById(xmlMessage.getInt("accum"));
        int n5 = xmlMessage.getInt("incl_wdays");
        int n6 = xmlMessage.getInt("excl_wdays");
        long l2 = xmlMessage.getLong("rollup_intl");
        int n7 = xmlMessage.getInt("rollup_unit");
        int n8 = xmlMessage.getInt("cycle");
        boolean bl2 = xmlMessage.getBoolean("data_cleanse");
        int n9 = xmlMessage.getInt("cleanse_w");
        double d = xmlMessage.getDouble("cleanse_p");
        DataPoint dataPoint = null;
        if (bl) {
            dataPoint = DataPoint.get(xmlMessage.getInt("normalizer"), this.srv);
        }
        int n10 = (tSDataSummary = this.srv.getDataPointExec().getAggregatedSummary(stringArray, easLocalTime, easLocalTime2, bTimeZoneArray, restorationMethod, n5, n6, new TimeInterval(l2, n7), n8, dArray, bUnitArray, bUnit, n, new TimeInterval(l, n4), bl2, n9, d, bl, dataPoint)) == null ? 0 : tSDataSummary.getSize();
        xmlMessage2 = new XmlMessage("getAggregatedSummary");
        for (int i = 0; i < n10; ++i) {
            DataSummaryElement dataSummaryElement = tSDataSummary.getDataSummary(i);
            dataSummaryElement.doFinal();
            XmlMessage xmlMessage3 = new XmlMessage("row" + i);
            xmlMessage3.add("dtSumTotalConsumption", dataSummaryElement.getTotalConsumption(1));
            xmlMessage3.add("dtSumAvgDemand", dataSummaryElement.getAvgDemand());
            xmlMessage3.add("dtSumMinDemand", dataSummaryElement.getMinDemand());
            xmlMessage3.add("dtSumDateOfMinDemand", dataSummaryElement.getDateOfMinDemand().getTime());
            xmlMessage3.add("dtSumPeakDemand", dataSummaryElement.getPeakDemand());
            xmlMessage3.add("dtSumDateOfPeakDemand", dataSummaryElement.getDateOfPeakDemand().getTime());
            xmlMessage3.add("dtSumCount", dataSummaryElement.getCount());
            xmlMessage3.add("dtGoodCount", dataSummaryElement.getGoodCount());
            xmlMessage3.add("dtSumNCycles", dataSummaryElement.getNCycles());
            xmlMessage3.add("dtSiteId", -1);
            xmlMessage2.add("row" + i, xmlMessage3);
        }
        return xmlMessage2;
    }

    public XmlMessage getAggregatedSummaryNorm(XmlMessage xmlMessage) throws Exception {
        TSDataSummary tSDataSummary;
        XmlMessage xmlMessage2 = null;
        boolean bl = xmlMessage.getBoolean("dpNormalization");
        int n = bl ? 26 : 25;
        int n2 = xmlMessage.getChildObjects().length - n;
        DPNormInfo[] dPNormInfoArray = new DPNormInfo[n2];
        for (int i = 0; i < n2; ++i) {
            dPNormInfoArray[i] = DPNormInfo.fromXmlMessage(xmlMessage.getMessage("dps" + i));
        }
        EasLocalTime easLocalTime = EasLocalTime.fromSerializedLong(xmlMessage.getLong("first"));
        EasLocalTime easLocalTime2 = EasLocalTime.fromSerializedLong(xmlMessage.getLong("last"));
        RestorationMethod restorationMethod = RestorationMethod.getById(xmlMessage.getInt("accum"));
        RollupMethod rollupMethod = RollupMethod.getById(xmlMessage.getInt("rollupMethod"));
        int n3 = xmlMessage.getInt("incl_wdays");
        int n4 = xmlMessage.getInt("excl_wdays");
        long l = xmlMessage.getLong("rollup_intl");
        int n5 = xmlMessage.getInt("rollup_unit");
        int n6 = xmlMessage.getInt("cycle");
        BUnit bUnit = BUnit.getUnit((String)xmlMessage.getString("ounit_id"));
        double d = xmlMessage.getDouble("normTemperature");
        BUnit bUnit2 = null;
        boolean bl2 = xmlMessage.getBoolean("doTemperature");
        if (bl2) {
            bUnit2 = BUnit.getUnit((String)xmlMessage.getString("temperatureUnitOutId"));
        }
        BUnit bUnit3 = null;
        boolean bl3 = xmlMessage.getBoolean("normByFloorArea");
        if (bl3) {
            bUnit3 = BUnit.getUnit((String)xmlMessage.getString("floorAreaUnitId"));
        }
        boolean bl4 = xmlMessage.getBoolean("data_cleanse");
        int n7 = xmlMessage.getInt("cleanse_w");
        double d2 = xmlMessage.getDouble("cleanse_p");
        DataPoint dataPoint = null;
        if (bl) {
            dataPoint = DataPoint.get(xmlMessage.getInt("normalizer"), this.srv);
        }
        int n8 = (tSDataSummary = this.srv.getDataPointExec().getAggregatedSummaryNorm(dPNormInfoArray, easLocalTime, easLocalTime2, restorationMethod, rollupMethod, bUnit, bl3, bUnit3, bl2, d, bUnit2, n3, n4, new TimeInterval(l, n5), n6, bl4, n7, d2, bl, dataPoint)) == null ? 0 : tSDataSummary.getSize();
        xmlMessage2 = new XmlMessage("getAggregatedSummaryNorm");
        for (int i = 0; i < n8; ++i) {
            DataSummaryElement dataSummaryElement = tSDataSummary.getDataSummary(i);
            dataSummaryElement.doFinal();
            XmlMessage xmlMessage3 = new XmlMessage("row" + i);
            xmlMessage3.add("dtSumTotalConsumption", dataSummaryElement.getTotalConsumption(1));
            xmlMessage3.add("dtSumAvgDemand", dataSummaryElement.getAvgDemand());
            xmlMessage3.add("dtSumMinDemand", dataSummaryElement.getMinDemand());
            xmlMessage3.add("dtSumDateOfMinDemand", dataSummaryElement.getDateOfMinDemand().getTime());
            xmlMessage3.add("dtSumPeakDemand", dataSummaryElement.getPeakDemand());
            xmlMessage3.add("dtSumDateOfPeakDemand", dataSummaryElement.getDateOfPeakDemand().getTime());
            xmlMessage3.add("dtSumCount", dataSummaryElement.getCount());
            xmlMessage3.add("dtGoodCount", dataSummaryElement.getGoodCount());
            xmlMessage3.add("dtSumNCycles", dataSummaryElement.getNCycles());
            xmlMessage3.add("dtSiteId", -1);
            xmlMessage2.add("row" + i, xmlMessage3);
        }
        return xmlMessage2;
    }

    public XmlMessage getDataSummary(XmlMessage xmlMessage) throws Exception {
        TSDataSummary tSDataSummary;
        int n;
        XmlMessage xmlMessage2 = null;
        String string = xmlMessage.getString("name");
        BTimeZone bTimeZone = BTimeZone.getTimeZone((String)xmlMessage.getString("tz"));
        long l = xmlMessage.getLong("interval");
        int n2 = xmlMessage.getInt("intl_unit");
        EasLocalTime easLocalTime = EasLocalTime.fromSerializedLong(xmlMessage.getLong("first"));
        EasLocalTime easLocalTime2 = EasLocalTime.fromSerializedLong(xmlMessage.getLong("last"));
        RestorationMethod restorationMethod = RestorationMethod.getById(xmlMessage.getInt("accum"));
        int n3 = xmlMessage.getInt("cycle");
        int n4 = xmlMessage.getInt("incl_wdays");
        int n5 = xmlMessage.getInt("excl_wdays");
        long l2 = xmlMessage.getLong("rollup_intl");
        int n6 = xmlMessage.getInt("rollup_unit");
        String string2 = xmlMessage.getString("vtype");
        String string3 = xmlMessage.getString("vunit");
        BUnit bUnit = BUnit.getUnit((String)string3);
        String string4 = xmlMessage.getString("otype");
        String string5 = xmlMessage.getString("ounit");
        BUnit bUnit2 = BUnit.getUnit((String)string5);
        double d = xmlMessage.getDouble("normCoeff");
        BUnit bUnit3 = null;
        if (d != 1.0 && d != 0.0) {
            bUnit3 = BUnit.getUnit((String)xmlMessage.getString("normUnitId"));
        }
        String string6 = null;
        BUnit bUnit4 = null;
        double d2 = 0.0;
        if (xmlMessage.getBoolean("doWeather")) {
            String string7 = xmlMessage.getString("temperatureUnitTag");
            String string8 = xmlMessage.getString("temperatureUnitId");
            bUnit4 = BUnit.getUnit((String)string8);
            d2 = xmlMessage.getDouble("normTemperature");
            string6 = xmlMessage.getString("temperatureLog");
        }
        boolean bl = xmlMessage.getBoolean("data_cleanse");
        int n7 = xmlMessage.getInt("cleanse_w");
        double d3 = xmlMessage.getDouble("cleanse_p");
        boolean bl2 = xmlMessage.getBoolean("dpNormalization");
        DataPoint dataPoint = null;
        if (bl2) {
            dataPoint = DataPoint.get(xmlMessage.getInt("normalizer"), this.srv);
        }
        int n8 = n = (tSDataSummary = this.srv.getDataPointExec().getDataSummary(string, easLocalTime, easLocalTime2, bTimeZone, restorationMethod, n4, n5, bUnit, bUnit2, new TimeInterval(l2, n6), n3, d, bUnit3, string6, bUnit4, d2, new TimeInterval(l, n2), bl, n7, d3, bl2, dataPoint)) == null ? 0 : tSDataSummary.getSize();
        if (n != 0) {
            bUnit2 = tSDataSummary.getValueUnit();
        }
        xmlMessage2 = new XmlMessage("getDataSummary");
        for (int i = 0; i < n; ++i) {
            DataSummaryElement dataSummaryElement = tSDataSummary.getDataSummary(i);
            XmlMessage xmlMessage3 = new XmlMessage("row" + i);
            xmlMessage3.add("dtSumTotalConsumption", dataSummaryElement.getTotalConsumption(1));
            xmlMessage3.add("dtSumAvgDemand", dataSummaryElement.getAvgDemand());
            xmlMessage3.add("dtSumMinDemand", dataSummaryElement.getMinDemand());
            xmlMessage3.add("dtSumDateOfMinDemand", dataSummaryElement.getDateOfMinDemand().getTime());
            xmlMessage3.add("dtSumPeakDemand", dataSummaryElement.getPeakDemand());
            xmlMessage3.add("dtSumDateOfPeakDemand", dataSummaryElement.getDateOfPeakDemand().getTime());
            xmlMessage3.add("dtSumCount", dataSummaryElement.getCount());
            xmlMessage3.add("dtGoodCount", dataSummaryElement.getGoodCount());
            xmlMessage3.add("dtSumNCycles", dataSummaryElement.getNCycles());
            xmlMessage3.add("dtSiteId", -1);
            xmlMessage2.add("row" + i, xmlMessage3);
        }
        return xmlMessage2;
    }

    public XmlMessage getRankedSummaries(XmlMessage xmlMessage) throws Exception {
        Object object;
        Object object2;
        int n;
        XmlMessage xmlMessage2 = null;
        String string = xmlMessage.getString("sites");
        long l = xmlMessage.getLong("interval");
        int n2 = xmlMessage.getInt("intl_unit");
        EasLocalTime easLocalTime = EasLocalTime.fromSerializedLong(xmlMessage.getLong("first"));
        EasLocalTime easLocalTime2 = EasLocalTime.fromSerializedLong(xmlMessage.getLong("last"));
        int n3 = xmlMessage.getInt("incl_wdays");
        int n4 = xmlMessage.getInt("excl_wdays");
        int n5 = xmlMessage.getInt("rc_type");
        int n6 = xmlMessage.getInt("rc_subtype");
        boolean bl = xmlMessage.getBoolean("is_main");
        int n7 = xmlMessage.getInt("maxSites");
        String string2 = xmlMessage.getString("normPropName");
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        boolean bl2 = xmlMessage.getBoolean("weatherNorm");
        double d = xmlMessage.getDouble("normTemperature");
        BUnit bUnit = null;
        if (bl2) {
            bUnit = BUnit.getUnit((String)xmlMessage.getString("temperatureUnitId"));
        }
        boolean bl3 = xmlMessage.getBoolean("data_cleanse");
        int n8 = xmlMessage.getInt("cleanse_w");
        double d2 = xmlMessage.getDouble("cleanse_p");
        int n9 = xmlMessage.getInt("dpNormSize");
        boolean[] blArray = new boolean[n9];
        DataPoint[] dataPointArray = new DataPoint[n9];
        for (int i = 0; i < n9; ++i) {
            blArray[i] = xmlMessage.getBoolean("dpNormalization" + i);
            dataPointArray[i] = null;
            if (!blArray[i]) continue;
            dataPointArray[i] = DataPoint.get(xmlMessage.getInt("normalizer" + i), this.srv);
        }
        int[] nArray = new int[xmlMessage.getInt("nfields")];
        for (int i = 0; i < nArray.length; ++i) {
            XmlMessage xmlMessage3 = xmlMessage.getMessage("row" + i);
            if (xmlMessage3.getBoolean("what")) continue;
            nArray[i] = (int)xmlMessage3.getLong("value");
        }
        SiteSummary[] siteSummaryArray = this.srv.getDataPointExec().getRankedSummaries(string, n5, n6, bl, n7, string2, nArray, easLocalTime, easLocalTime2, n3, n4, bl2, d, bUnit, new TimeInterval(l, n2), bl3, n8, d2, blArray, dataPointArray);
        int n10 = n = siteSummaryArray == null ? 0 : siteSummaryArray.length;
        while (--n10 >= 0) {
            if (siteSummaryArray[n10] != null) continue;
            --n;
        }
        xmlMessage2 = new XmlMessage("getRankedSummaries");
        for (n10 = 0; n10 < n; ++n10) {
            object2 = siteSummaryArray[n10];
            object = new XmlMessage("row" + n10);
            ((XmlMessage)object).add("dtSumTotalConsumption", ((DataSummaryElement)object2).getTotalConsumption(1));
            ((XmlMessage)object).add("dtSumAvgDemand", ((DataSummaryElement)object2).getAvgDemand());
            ((XmlMessage)object).add("dtSumMinDemand", ((DataSummaryElement)object2).getMinDemand());
            ((XmlMessage)object).add("dtSumDateOfMinDemand", ((DataSummaryElement)object2).getDateOfMinDemand().getTime());
            ((XmlMessage)object).add("dtSumPeakDemand", ((DataSummaryElement)object2).getPeakDemand());
            ((XmlMessage)object).add("dtSumDateOfPeakDemand", ((DataSummaryElement)object2).getDateOfPeakDemand().getTime());
            ((XmlMessage)object).add("dtSumCount", ((DataSummaryElement)object2).getCount());
            ((XmlMessage)object).add("dtGoodCount", ((DataSummaryElement)object2).getGoodCount());
            ((XmlMessage)object).add("dtSumNCycles", ((DataSummaryElement)object2).getNCycles());
            ((XmlMessage)object).add("dtSiteId", ((SiteSummary)object2).getSiteId());
            xmlMessage2.add("row" + n10, (XmlMessage)object);
        }
        String string3 = "misc";
        object2 = "misc";
        object = "null";
        String string4 = "null";
        if (n > 0) {
            if (this.unitDatabase == null) {
                this.unitDatabase = UnitDatabase.getDefault();
            }
            String string5 = null;
            string5 = this.unitDatabase.getQuantity(siteSummaryArray[0].getBaseUnit()) != null ? this.unitDatabase.getQuantity(siteSummaryArray[0].getBaseUnit()).getName() : "";
            string3 = string5;
            object = siteSummaryArray[0].getBaseUnit().getUnitName();
            BUnit bUnit2 = siteSummaryArray[0].getNormalizationUnit();
            if (bUnit2 != null) {
                string5 = this.unitDatabase.getQuantity(bUnit2) != null ? this.unitDatabase.getQuantity(bUnit2).getName() : "";
                object2 = string5;
                string4 = bUnit2.getUnitName();
            }
        }
        xmlMessage2.add("unitTag", string3);
        xmlMessage2.add("unitId", (String)object);
        xmlMessage2.add("normUnitTag", (String)object2);
        xmlMessage2.add("normUnitId", string4);
        return xmlMessage2;
    }

    public XmlMessage getExceptionSummary(XmlMessage xmlMessage) throws Exception {
        XmlMessage xmlMessage2 = null;
        String string = xmlMessage.getString("name");
        EasLocalTime easLocalTime = EasLocalTime.fromSerializedLong(xmlMessage.getLong("data_start"));
        EasLocalTime easLocalTime2 = EasLocalTime.fromSerializedLong(xmlMessage.getLong("data_end"));
        BTimeZone bTimeZone = BTimeZone.getTimeZone((String)xmlMessage.getString("tz"));
        int n = xmlMessage.getInt("incl_wdays");
        int n2 = xmlMessage.getInt("excl_wdays");
        int n3 = xmlMessage.getInt("startHr");
        int n4 = xmlMessage.getInt("startMin");
        int n5 = xmlMessage.getInt("endHr");
        int n6 = xmlMessage.getInt("endMin");
        boolean bl = xmlMessage.getBoolean("exclusive");
        long l = xmlMessage.getLong("rollup_n_units");
        int n7 = xmlMessage.getInt("rollup_unit");
        int n8 = xmlMessage.getInt("rollup_method");
        boolean bl2 = xmlMessage.getBoolean("weather_norm");
        String string2 = xmlMessage.getString("temp_log_name");
        EasLocalTime easLocalTime3 = EasLocalTime.fromSerializedLong(xmlMessage.getLong("base_start"));
        int n9 = xmlMessage.getInt("base_len");
        int n10 = xmlMessage.getInt("limit_type");
        double d = xmlMessage.getDouble("upper_limit");
        double d2 = xmlMessage.getDouble("lower_limit");
        int n11 = xmlMessage.getInt("max_ex");
        int n12 = xmlMessage.getInt("rules");
        boolean bl3 = xmlMessage.getBoolean("send_summary");
        RestorationMethod restorationMethod = RestorationMethod.getById(xmlMessage.getInt("accum"));
        long l2 = xmlMessage.getLong("interval");
        int n13 = xmlMessage.getInt("intl_unit");
        String string3 = xmlMessage.getString("vtype");
        String string4 = xmlMessage.getString("vunit");
        BUnit bUnit = BUnit.getUnit((String)string4);
        boolean bl4 = xmlMessage.getBoolean("data_cleanse");
        int n14 = xmlMessage.getInt("cleanse_w");
        double d3 = xmlMessage.getDouble("cleanse_p");
        boolean bl5 = xmlMessage.getBoolean("dpNormalization");
        DataPoint dataPoint = null;
        if (bl5) {
            dataPoint = DataPoint.get(xmlMessage.getInt("normalizer"), this.srv);
        }
        if (bl3) {
            ExceptionSummaryData exceptionSummaryData = null;
            exceptionSummaryData = this.srv.getDataPointExec().getExceptionSummaryData(string, easLocalTime, easLocalTime2, bTimeZone, n, n2, n3, n4, n5, n6, bl, new TimeInterval(l, n7), bUnit, bl2, string2, n8, easLocalTime3, n9, n10, d, d2, n11, n12, restorationMethod, new TimeInterval(l2, n13), bl4, n14, d3, bl5, dataPoint);
            if (exceptionSummaryData == null) {
                return null;
            }
            int n15 = exceptionSummaryData.getViolationsTotal();
            xmlMessage2 = new XmlMessage("getExceptionSummary");
            int[] nArray = exceptionSummaryData.getViolations();
            for (int i = 0; i < n15; ++i) {
                XmlMessage xmlMessage3 = new XmlMessage("row" + i);
                xmlMessage3.add("violation", nArray[i]);
                xmlMessage2.add("row" + i, xmlMessage3);
            }
            xmlMessage2.add("violationsAbove", exceptionSummaryData.getUpperLimitViolations());
            xmlMessage2.add("violationsBelow", exceptionSummaryData.getLowerLimitViolations());
            xmlMessage2.add("total_count", exceptionSummaryData.getTotalCount());
            xmlMessage2.add("total", exceptionSummaryData.getTotal());
            xmlMessage2.add("total_diff", exceptionSummaryData.getTotalDiff());
            xmlMessage2.add("positive_diff", exceptionSummaryData.getPositiveDiff());
            xmlMessage2.add("spc_upper", exceptionSummaryData.getSPC_UpperLimit());
            xmlMessage2.add("spc_lower", exceptionSummaryData.getSPC_LowerLimit());
        } else {
            boolean bl6 = xmlMessage.getBoolean("current");
            TSDataFloat tSDataFloat = null;
            tSDataFloat = this.srv.getDataPointExec().getExceptionSeries(string, bl6, easLocalTime, easLocalTime2, bTimeZone, n, n2, n3, n4, n5, n6, bl, new TimeInterval(l, n7), bUnit, bl2, string2, n8, easLocalTime3, n9, restorationMethod, new TimeInterval(l2, n13), bl4, n14, d3, bl5, dataPoint);
            int n16 = tSDataFloat == null ? 0 : tSDataFloat.getSize();
            xmlMessage2 = new XmlMessage("getExceptionSummary");
            for (int i = 0; i < n16; ++i) {
                XmlMessage xmlMessage4 = new XmlMessage("row" + i);
                xmlMessage4.add("value", tSDataFloat.getDouble(i));
                xmlMessage4.add("valid", tSDataFloat.isValid(i));
                xmlMessage2.add("row" + i, xmlMessage4);
            }
        }
        return xmlMessage2;
    }

    public final XmlMessage getAvailableLicensedDataPointCount() {
        int n = this.srv.getDataPointExec().getAvailableLicensedDataPointCount();
        XmlMessage xmlMessage = new XmlMessage("availableLicensed");
        try {
            xmlMessage.add("count", n);
        }
        catch (Exception exception) {
            log.error("Problem getting available licensed data point count", (Throwable)exception);
        }
        return xmlMessage;
    }
}

