/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.util;

import com.tridium.eas.cost.util.DoubleRecord;
import com.tridium.eas.cost.util.Record;
import com.tridium.eas.cost.util.Result;
import com.tridium.eas.function.Population;
import java.io.IOException;

public class RawCostData {
    private Population population;
    private long startTimestamp;
    private int popInterval;
    private static final byte FAULT_BIT = 2;

    public RawCostData(Population population, long l, int n) {
        this.population = population;
        this.startTimestamp = l;
        this.popInterval = n;
    }

    public synchronized Result get(long l, long l2) throws IOException {
        long l3;
        if (l < this.startTimestamp) {
            throw new IOException("Error in RawCostData: Start times must be equal (" + this.startTimestamp + " != " + l + ").");
        }
        if (l > l2) {
            throw new IOException("Error in RawCostData: Start time is after end time (" + l + " > " + l2 + ").");
        }
        int n = 0;
        int n2 = 0;
        for (l3 = this.startTimestamp; l3 < l; l3 += (long)(60000 * this.popInterval)) {
            ++n;
            ++n2;
        }
        while (l3 < l2) {
            ++n2;
            l3 += (long)(60000 * this.popInterval);
        }
        return new PopulationResult(this.population, this.startTimestamp, this.popInterval, n, n2);
    }

    public Record createRecord() throws IOException {
        return Record.create(1);
    }

    private class PopulationResult
    implements Result {
        private Population pop;
        private long start;
        private int interval;
        private int startIndex;
        private int endIndex;
        private int runningIndex;
        private int zeroBasedIndex;

        public PopulationResult(Population population, long l, int n, int n2, int n3) {
            this.pop = population;
            this.start = l;
            this.interval = n;
            this.startIndex = n2;
            this.endIndex = n3;
            this.runningIndex = n2;
            this.zeroBasedIndex = 0;
        }

        public long getSize() {
            if (this.pop == null) {
                return 0L;
            }
            return this.endIndex - this.startIndex + 1;
        }

        public Record extra(Record record, int n) throws IOException {
            System.out.println("FIXX - need to implement PopulationResult.extra()");
            return null;
        }

        public Record first(Record record) throws IOException {
            this.runningIndex = this.startIndex;
            this.zeroBasedIndex = 0;
            if (this.pop == null || this.getSize() <= 0L || this.runningIndex >= this.pop.getSize()) {
                return null;
            }
            record = new DoubleRecord(this.start + (long)this.runningIndex * 1000L * 60L * (long)this.interval, this.pop.getSample(this.runningIndex), this.pop.isValid(this.runningIndex) ? 0 : 2);
            ++this.runningIndex;
            ++this.zeroBasedIndex;
            return record;
        }

        public Record next(Record record) throws IOException {
            if (this.pop == null || this.getSize() <= 0L || this.zeroBasedIndex >= (int)this.getSize() || this.runningIndex >= this.pop.getSize()) {
                return null;
            }
            record = new DoubleRecord(this.start + (long)this.runningIndex * 1000L * 60L * (long)this.interval, this.pop.getSample(this.runningIndex), this.pop.isValid(this.runningIndex) ? 0 : 2);
            ++this.runningIndex;
            ++this.zeroBasedIndex;
            return record;
        }
    }
}

