/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.util;

import com.tridium.eas.cost.datatypes.TimePeriods;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;

public final class CostTimeUtil {
    public static final int CYCLE_TIME = 0;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY = 3;
    public static final int WEEK = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long MILLIS_IN_WEEK = 604800000L;
    public static final BTimeZone DEFAULT_TZ = BTimeZone.getTimeZone((String)"GMT");

    public static final long getCycleStart(BTimeZone bTimeZone, long l, long l2, TimePeriods timePeriods, int n) {
        if (l < l2) {
            long l3 = l2;
            long l4 = l2;
            while (l < l4) {
                l3 = l4;
                if (l != (l4 = CostTimeUtil.decrementTime(bTimeZone, l4, timePeriods, n))) continue;
                l3 = l4;
            }
            return l3;
        }
        if (l > l2) {
            long l5 = l2;
            while (l > l5) {
                l5 = CostTimeUtil.incrementTime(bTimeZone, l5, timePeriods, n);
            }
            return l5;
        }
        return l;
    }

    public static final long getCycleEnd(BTimeZone bTimeZone, long l, long l2, TimePeriods timePeriods, int n) {
        long l3 = CostTimeUtil.getCycleStart(bTimeZone, l, l2, timePeriods, n);
        if (l3 == l) {
            l3 = CostTimeUtil.incrementTime(bTimeZone, l3, timePeriods, n);
        }
        return l3;
    }

    public static final long incrementTime(BTimeZone bTimeZone, long l, TimePeriods timePeriods, int n) {
        Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
        calendar.setTime(new Date(l));
        switch (n) {
            case 1: {
                calendar.add(12, 1);
                break;
            }
            case 2: {
                calendar.add(10, 1);
                break;
            }
            case 3: {
                calendar.add(5, 1);
                break;
            }
            case 4: {
                calendar.add(5, 7);
                break;
            }
            case 5: {
                calendar.add(2, 1);
                break;
            }
            case 6: {
                calendar.add(1, 1);
                break;
            }
            case 0: {
                return CostTimeUtil.incrementByTimePeriod(bTimeZone, l, timePeriods, timePeriods, false);
            }
        }
        return calendar.getTime().getTime();
    }

    public static final long decrementTime(BTimeZone bTimeZone, long l, TimePeriods timePeriods, int n) {
        Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
        calendar.setTime(new Date(l));
        switch (n) {
            case 1: {
                calendar.add(12, -1);
                break;
            }
            case 2: {
                calendar.add(10, -1);
                break;
            }
            case 3: {
                calendar.add(5, -1);
                break;
            }
            case 4: {
                calendar.add(5, -7);
                break;
            }
            case 5: {
                calendar.add(2, -1);
                break;
            }
            case 6: {
                calendar.add(1, -1);
                break;
            }
            case 0: {
                return CostTimeUtil.decrementByTimePeriod(bTimeZone, l, timePeriods, timePeriods);
            }
        }
        return calendar.getTime().getTime();
    }

    public static final long incrementByTimePeriod(BTimeZone bTimeZone, long l, TimePeriods timePeriods, TimePeriods timePeriods2, boolean bl) {
        if (timePeriods2 == null) {
            return l;
        }
        Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
        calendar.setTime(new Date(l));
        int n = timePeriods2.getNumber();
        if (bl && n > 0) {
            --n;
        }
        block0 : switch (timePeriods2.getTimeUnits()) {
            case 1: {
                calendar.add(12, n);
                break;
            }
            case 2: {
                calendar.add(10, n);
                break;
            }
            case 3: {
                calendar.add(5, n);
                break;
            }
            case 4: {
                calendar.add(5, n * 7);
                break;
            }
            case 5: {
                calendar.add(2, n);
                break;
            }
            case 6: {
                calendar.add(1, n);
                break;
            }
            case 0: {
                switch (timePeriods.getTimeUnits()) {
                    case 1: {
                        calendar.add(12, n * timePeriods.getNumber());
                        break block0;
                    }
                    case 2: {
                        calendar.add(10, n * timePeriods.getNumber());
                        break block0;
                    }
                    case 3: {
                        calendar.add(5, n * timePeriods.getNumber());
                        break block0;
                    }
                    case 4: {
                        calendar.add(5, n * 7 * timePeriods.getNumber());
                        break block0;
                    }
                    case 5: {
                        calendar.add(2, n * timePeriods.getNumber());
                        break block0;
                    }
                    case 6: {
                        calendar.add(1, n * timePeriods.getNumber());
                    }
                }
            }
        }
        return calendar.getTime().getTime();
    }

    public static final long decrementByTimePeriod(BTimeZone bTimeZone, long l, TimePeriods timePeriods, TimePeriods timePeriods2) {
        if (timePeriods2 == null) {
            return l;
        }
        Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
        calendar.setTime(new Date(l));
        block0 : switch (timePeriods2.getTimeUnits()) {
            case 1: {
                calendar.add(12, -1 * timePeriods2.getNumber());
                break;
            }
            case 2: {
                calendar.add(10, -1 * timePeriods2.getNumber());
                break;
            }
            case 3: {
                calendar.add(5, -1 * timePeriods2.getNumber());
                break;
            }
            case 4: {
                calendar.add(5, -1 * timePeriods2.getNumber() * 7);
                break;
            }
            case 5: {
                calendar.add(2, -1 * timePeriods2.getNumber());
                break;
            }
            case 6: {
                calendar.add(1, -1 * timePeriods2.getNumber());
                break;
            }
            case 0: {
                switch (timePeriods.getTimeUnits()) {
                    case 1: {
                        calendar.add(12, -1 * timePeriods2.getNumber() * timePeriods.getNumber());
                        break block0;
                    }
                    case 2: {
                        calendar.add(10, -1 * timePeriods2.getNumber() * timePeriods.getNumber());
                        break block0;
                    }
                    case 3: {
                        calendar.add(5, -1 * timePeriods2.getNumber() * timePeriods.getNumber());
                        break block0;
                    }
                    case 4: {
                        calendar.add(5, -1 * timePeriods2.getNumber() * 7 * timePeriods.getNumber());
                        break block0;
                    }
                    case 5: {
                        calendar.add(2, -1 * timePeriods2.getNumber() * timePeriods.getNumber());
                        break block0;
                    }
                    case 6: {
                        calendar.add(1, -1 * timePeriods2.getNumber() * timePeriods.getNumber());
                    }
                }
            }
        }
        return calendar.getTime().getTime();
    }

    public static final double percentOfIntervalUsed(BTimeZone bTimeZone, long l, long l2, int n) {
        long l3 = l2;
        long l4 = l;
        if (l3 < l4) {
            l4 = l2;
            l3 = l;
        }
        long l5 = l3 - l4;
        double d = 0.0;
        switch (n) {
            case 1: {
                d = (double)l5 / 60000.0;
                break;
            }
            case 2: {
                d = (double)l5 / 3600000.0;
                break;
            }
            case 3: {
                d = (double)l5 / 8.64E7;
                break;
            }
            case 4: {
                d = (double)l5 / 6.048E8;
                break;
            }
            case 5: {
                Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
                calendar.setTime(new Date(l4));
                Calendar calendar2 = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
                calendar2.setTime(new Date(l3));
                int n2 = calendar.get(1);
                int n3 = calendar2.get(1);
                int n4 = n3 - n2;
                int n5 = calendar.get(2);
                int n6 = calendar2.get(2);
                int n7 = calendar.get(5);
                int n8 = calendar2.get(5);
                int n9 = CostTimeUtil.getDaysInMonth(calendar);
                int n10 = CostTimeUtil.getDaysInMonth(calendar2);
                int n11 = n9 - n7;
                if (n4 <= 0) {
                    int n12 = n6 - n5;
                    if (n12 == 0) {
                        d = ((double)n8 - (double)n7) / (double)n9;
                        break;
                    }
                    if (n12 == 1) {
                        d = (double)n11 / (double)n9 + (double)n8 / (double)n10;
                        break;
                    }
                    d = (double)n11 / (double)n9 + (double)n8 / (double)n10 + ((double)n12 - 1.0);
                    break;
                }
                int n13 = 11 - n5 + n6 + (n4 - 1) * 12;
                d = (double)n11 / (double)n9 + (double)n8 / (double)n10 + (double)n13;
                break;
            }
            case 6: {
                Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
                calendar.setTime(new Date(l4));
                Calendar calendar3 = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
                calendar3.setTime(new Date(l3));
                int n14 = calendar.get(1);
                int n15 = calendar3.get(1);
                int n16 = n15 - n14;
                int n17 = calendar.get(6);
                int n18 = calendar3.get(6);
                int n19 = CostTimeUtil.getDaysInYear(calendar);
                int n20 = CostTimeUtil.getDaysInYear(calendar3);
                d = n16 == 0 ? ((double)n18 - (double)n17) / (double)n19 : (n16 == 1 ? ((double)n19 - (double)n17) / (double)n19 + (double)n18 / (double)n20 : ((double)n19 - (double)n17) / (double)n19 + (double)n18 / (double)n20 + ((double)n16 - 1.0));
            }
        }
        return d;
    }

    public static final double percentOfIntervalUsed(long l, long l2, long l3, long l4) {
        double d;
        double d2 = l2 - l;
        if (d2 < 0.0) {
            d2 *= -1.0;
        }
        if ((d = (double)(l4 - l3)) < 0.0) {
            d *= -1.0;
        }
        return d2 / d;
    }

    public static boolean includes(long l, long l2, long l3) {
        return l2 <= l && l3 > l;
    }

    public static int getDaysInMonth(Calendar calendar) {
        int n = calendar.get(2);
        int n2 = calendar.getMaximum(5) + 1;
        int n3 = -1;
        while (n3 != n) {
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.set(5, --n2);
            calendar2.getTime();
            n3 = calendar2.get(2);
        }
        return n2;
    }

    public static int getDaysInYear(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.getMaximum(6) + 1;
        int n3 = -1;
        while (n3 != n) {
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.set(6, --n2);
            calendar2.getTime();
            n3 = calendar2.get(1);
        }
        return n2;
    }

    public static long convertTime(long l, BTimeZone bTimeZone, BTimeZone bTimeZone2) {
        if (bTimeZone.isEquivalent(bTimeZone2)) {
            return l;
        }
        Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
        calendar.setTime(new Date(l));
        Calendar calendar2 = Calendar.getInstance((TimeZone)bTimeZone2.tzSupport());
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        calendar2.set(11, calendar.get(11));
        calendar2.set(12, calendar.get(12));
        calendar2.set(13, calendar.get(13));
        calendar2.set(14, calendar.get(14));
        return calendar2.getTime().getTime();
    }
}

