/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.reconciliation;

import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.rate.components.ChoiceComponent;
import com.tridium.eas.cost.rate.components.ChoiceComponentChild;
import com.tridium.eas.cost.rate.components.CombinationPercentageFee;
import com.tridium.eas.cost.rate.components.CustomRateComponent;
import com.tridium.eas.cost.rate.components.DemandCharge;
import com.tridium.eas.cost.rate.components.FixedFee;
import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.HistoricalRatchet;
import com.tridium.eas.cost.rate.components.Ratchet;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.rate.components.ScheduledDemandCharge;
import com.tridium.eas.cost.rate.components.ScheduledFeePerUnit;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.EasHotLink;
import com.tridium.eas.cost.ui.RateScheduleDetailPanel;
import com.tridium.eas.cost.ui.RateScheduleParentPanel;
import com.tridium.eas.cost.ui.reports.reconciliation.BillReconciliationDetailPanel;
import com.tridium.eas.cost.ui.reports.reconciliation.BillReconciliationSeries;
import com.tridium.eas.cost.ui.reports.reconciliation.BillReconciliationTable;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultPieConfig;
import com.tridium.eas.ui.widgets.CheckList;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ReconciliationComponentDetailPanel
extends JPanel
implements RateScheduleParentPanel {
    private ReconciliationRow currentReconciliationRow = null;
    private RateScheduleDetailPanel rateScheduleDetails = null;
    private BillReconciliationDetailPanel parentPanel = null;
    private Lexicon lex;
    private CardLayout layout = null;
    private JPanel rateComponentPanel;
    private JPanel choiceComponentPanel;
    private JPanel chartPanel;
    private Chart chart = null;
    private BillReconciliationTable table = null;
    private ChartModel model = null;
    private JSplitPane detailSplit;
    private boolean firstLoad = true;
    private JLabel lastSelectedLabel = null;
    public static final int CALCULATED_COST = 0;
    public static final int ACTUAL_COST = 1;
    public static final int DELTA_COST = 2;

    protected ReconciliationComponentDetailPanel(BillReconciliationDetailPanel billReconciliationDetailPanel, Lexicon lexicon) {
        this.lex = lexicon;
        this.parentPanel = billReconciliationDetailPanel;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add("show", new JScrollPane(jPanel));
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        jPanel2.setBorder(BorderFactory.createTitledBorder(lexicon.getText("billDetails")));
        this.add("hide", jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        this.add("chart", jPanel3);
        this.rateComponentPanel = new JPanel(new BorderLayout(), false);
        this.choiceComponentPanel = new JPanel(new BorderLayout(), false);
        JPanel jPanel4 = new JPanel(new BorderLayout(), false);
        jPanel4.add((Component)this.choiceComponentPanel, "North");
        jPanel4.add((Component)this.rateComponentPanel, "Center");
        jPanel.add((Component)jPanel4, "North");
        jPanel.add((Component)this.buildRateSchedulesPanel(), "Center");
        this.chartPanel = new JPanel(new BorderLayout(), false);
        jPanel3.add((Component)this.chartPanel, "Center");
        this.chart = new Chart(lexicon);
        this.chart.setTitle(lexicon.getText("reconcileContribution"));
        this.chart.setDefaultUsesAxes(false);
        this.model = new ChartModel();
        this.chart.setModel(this.model);
        this.model.setTitle(lexicon.getText("reconcileContribution"));
        this.table = new BillReconciliationTable(lexicon);
        this.detailSplit = new JSplitPane(0);
        this.detailSplit.setTopComponent(this.chart);
        this.detailSplit.setBottomComponent(new JScrollPane(this.table));
        this.chartPanel.add((Component)this.detailSplit, "Center");
        this.setReconciliationRowEditorValue(null);
    }

    private void buildRowEditor(ReconciliationRow reconciliationRow) {
        this.rateComponentPanel.removeAll();
        if (reconciliationRow.getShowCostColumns()) {
            this.rateComponentPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("rateComponentDetails")));
        } else {
            this.rateComponentPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("rateDetails")));
        }
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel, gridBagConstraints);
        if (reconciliationRow.getShowCostColumns()) {
            Format format;
            String string = reconciliationRow.getCurrency().toString() + " ";
            RateComponent rateComponent = reconciliationRow.getRateComponent();
            if (rateComponent instanceof ChoiceComponentChild) {
                rateComponent = ((ChoiceComponentChild)rateComponent).getRateComponent();
            }
            jLabel.setText(rateComponent.getName());
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("calculatedCost")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
            jPanel.add((Component)new JLabel(string + decimalFormat.format(reconciliationRow.getCalculatedCost()), 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("actualCost")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)new JLabel(string + decimalFormat.format(reconciliationRow.getActualCost(false, 1.0)), 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("deltaCost")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)new JLabel(string + decimalFormat.format(reconciliationRow.getDeltaCost(false, 1.0)), 4), gridBagConstraints);
            if (rateComponent instanceof FlatFeePerUnit) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 17;
                jPanel.add((Component)new JLabel(this.lex.getText("calculatedUnits")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                format = decimalFormat;
                if (((FlatFeePerUnit)rateComponent).getCalculatedUnits() > 0.0 && ((FlatFeePerUnit)rateComponent).getCalculatedUnits() < 0.01) {
                    format = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
                }
                String string2 = ((NumberFormat)format).format(((FlatFeePerUnit)rateComponent).getCalculatedUnits());
                String string3 = reconciliationRow.getUnits().toString();
                jPanel.add((Component)new JLabel(string2 + " " + string3, 4), gridBagConstraints);
                if (rateComponent instanceof ScheduledFeePerUnit) {
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("preTransitionUnits")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    format = decimalFormat;
                    if (((ScheduledFeePerUnit)rateComponent).getPreTransitionUnits() > 0.0 && ((ScheduledFeePerUnit)rateComponent).getPreTransitionUnits() < 0.01) {
                        format = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
                    }
                    string2 = ((NumberFormat)format).format(((ScheduledFeePerUnit)rateComponent).getPreTransitionUnits());
                    jPanel.add((Component)new JLabel(string2 + " " + string3, 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("postTransitionUnits")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    format = decimalFormat;
                    if (((ScheduledFeePerUnit)rateComponent).getPostTransitionUnits() > 0.0 && ((ScheduledFeePerUnit)rateComponent).getPostTransitionUnits() < 0.01) {
                        format = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
                    }
                    string2 = ((NumberFormat)format).format(((ScheduledFeePerUnit)rateComponent).getPostTransitionUnits());
                    jPanel.add((Component)new JLabel(string2 + " " + string3, 4), gridBagConstraints);
                }
            }
            if (rateComponent instanceof DemandCharge) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 17;
                jPanel.add((Component)new JLabel(this.lex.getText("peakTime")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                format = new SimpleDateFormat(this.lex.getText("peakTimeFormat"), new Locale(this.lex.language, ""));
                ((DateFormat)format).setTimeZone((TimeZone)rateComponent.getTimeZone().tzSupport());
                jPanel.add((Component)new JLabel(((DateFormat)format).format(new Date(((DemandCharge)rateComponent).getPeakTime())), 4), gridBagConstraints);
            }
            if (rateComponent instanceof Ratchet) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 17;
                jPanel.add((Component)new JLabel(this.lex.getText("peakTime")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                format = new SimpleDateFormat(this.lex.getText("peakTimeFormat"), new Locale(this.lex.language, ""));
                ((DateFormat)format).setTimeZone((TimeZone)rateComponent.getTimeZone().tzSupport());
                jPanel.add((Component)new JLabel(((DateFormat)format).format(new Date(((Ratchet)rateComponent).getPeakTime())), 4), gridBagConstraints);
            }
            if (rateComponent instanceof CustomRateComponent) {
                gridBagConstraints.gridy = n++;
                ((CustomRateComponent)((Object)rateComponent)).buildReconciliationDetails(reconciliationRow, jPanel, gridBagConstraints, this.lex);
            }
            n = gridBagConstraints.gridy;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)new JLabel(" "), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            jPanel.add((Component)new JLabel(this.lex.getText("componentConfiguration"), 0), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
            this.buildAdvRateComponentEditor(reconciliationRow, jPanel, gridBagConstraints);
            this.rateComponentPanel.add((Component)jPanel, "North");
        } else {
            Rate rate = null;
            try {
                rate = EasCostClient.retrieveRate(this.parentPanel.getSession(), reconciliationRow.getName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (rate != null) {
                Object object;
                Object object2;
                Object object3;
                RateLink rateLink;
                block32: {
                    jLabel.setText(rate.getName());
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("energyProvider")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rate.getEnergyProvider(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("providerPhone")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rate.getPhoneNumber(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("providerWebsite")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 13;
                    EasHotLink easHotLink = new EasHotLink(rate.getWebsite(), this.parentPanel.getParentApplication().getApplet().getApplet(), false, 35, Color.red, Color.blue);
                    jPanel.add((Component)easHotLink, gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("location")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rate.getLocation(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(this.lex.getText("currency")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(rate.getCurrency().toString(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("consumptionUnits")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rate.getConsumptionUnits().toString(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("demandUnits")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rate.getDemandUnits().toString(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("reactiveEnergyUnits")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rate.getReactiveEnergyUnits().toString(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("apparentEnergyUnits")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rate.getApparentEnergyUnits().toString(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("reactivePowerUnits")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rate.getReactivePowerUnits().toString(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("apparentPowerUnits")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rate.getApparentPowerUnits().toString(), 4), gridBagConstraints);
                    rateLink = null;
                    try {
                        object3 = this.parentPanel.getSelectedMeter();
                        if (object3 == null || (object2 = EasCostClient.retrieveRateHistory(this.parentPanel.getSession(), ((EasObject)object3).getId())) == null || (object = ((RateHistory)object2).getRateLinks()) == null) break block32;
                        for (int i = 0; i < ((RateLink[])object).length; ++i) {
                            if (!object[i].getName().equals(reconciliationRow.getName())) continue;
                            rateLink = object[i];
                            break;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (rateLink != null) {
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(""), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("startTime")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    object3 = new SimpleDateFormat(this.lex.getText("rateTimeFormat"), new Locale(this.lex.language, ""));
                    ((DateFormat)object3).setTimeZone((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                    jPanel.add((Component)new JLabel(((DateFormat)object3).format(new Date(rateLink.getStartTime())), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("endTime")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    if (rateLink.getEndTime() < 0L) {
                        jPanel.add((Component)new JLabel(this.lex.getText("presentTime"), 4), gridBagConstraints);
                    } else {
                        jPanel.add((Component)new JLabel(((DateFormat)object3).format(new Date(rateLink.getEndTime())), 4), gridBagConstraints);
                    }
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("billingCycle")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    object2 = "unknown";
                    switch (rateLink.getBillingCycle().getTimeUnits()) {
                        case 0: {
                            object2 = this.lex.getText("numBillingCycles");
                            break;
                        }
                        case 1: {
                            object2 = this.lex.getText("numMinutes");
                            break;
                        }
                        case 2: {
                            object2 = this.lex.getText("numHours");
                            break;
                        }
                        case 3: {
                            object2 = this.lex.getText("numDays");
                            break;
                        }
                        case 4: {
                            object2 = this.lex.getText("numWeeks");
                            break;
                        }
                        case 5: {
                            object2 = this.lex.getText("numMonths");
                            break;
                        }
                        case 6: {
                            object2 = this.lex.getText("numYears");
                        }
                    }
                    jPanel.add((Component)new JLabel(String.valueOf(rateLink.getBillingCycle().getNumber() + " " + (String)object2), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("billingCycleStart")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(((DateFormat)object3).format(new Date(rateLink.getBillingCycleStart())), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("account")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rateLink.getAccount(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("custServRep")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rateLink.getCustServRep(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("custServRepPhone")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 13;
                    jPanel.add((Component)new JLabel(rateLink.getCustServRepPhone(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("custServRepEmail")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 13;
                    object = new EasHotLink(rateLink.getCustServRepEmail(), this.parentPanel.getParentApplication().getApplet().getApplet(), true, 35, Color.red, Color.blue);
                    jPanel.add((Component)object, gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("salesRep")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rateLink.getSalesRep(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("salesRepPhone")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel.add((Component)new JLabel(rateLink.getSalesRepPhone(), 4), gridBagConstraints);
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(this.lex.getText("salesRepEmail")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 13;
                    EasHotLink easHotLink = new EasHotLink(rateLink.getSalesRepEmail(), this.parentPanel.getParentApplication().getApplet().getApplet(), true, 35, Color.red, Color.blue);
                    jPanel.add((Component)easHotLink, gridBagConstraints);
                }
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
            } else {
                jLabel.setText(this.lex.getText("rateNameError") + " " + reconciliationRow.getName());
            }
            this.rateComponentPanel.add((Component)jPanel, "North");
        }
        this.rateComponentPanel.revalidate();
        this.rateComponentPanel.repaint();
    }

    private void buildAdvRateComponentEditor(ReconciliationRow reconciliationRow, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        Object object;
        Object[] objectArray;
        Object object2;
        RateComponent rateComponent = reconciliationRow.getRateComponent();
        String string = reconciliationRow.getCurrency().toString() + " ";
        String string2 = " " + reconciliationRow.getUnits().toString();
        int n = gridBagConstraints.gridy + 1;
        if (rateComponent instanceof ChoiceComponentChild) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("choicePercentage")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)new JLabel(String.valueOf(((ChoiceComponentChild)rateComponent).getPercentage()), 4), gridBagConstraints);
            rateComponent = ((ChoiceComponentChild)rateComponent).getRateComponent();
        }
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("categoryLabel")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        String string3 = "";
        if (rateComponent.getCategory() == 0) {
            string3 = this.lex.getText("Consumption");
        } else if (rateComponent.getCategory() == 1) {
            string3 = this.lex.getText("Demand");
        } else if (rateComponent.getCategory() == 2) {
            string3 = this.lex.getText("Other");
        } else if (rateComponent.getCategory() == 3) {
            string3 = this.lex.getText("userDefinedComponent1");
        } else if (rateComponent.getCategory() == 4) {
            string3 = this.lex.getText("userDefinedComponent2");
        } else if (rateComponent.getCategory() == 5) {
            string3 = this.lex.getText("userDefinedComponent3");
        } else if (rateComponent.getCategory() == 6) {
            string3 = this.lex.getText("userDefinedComponent4");
        }
        jPanel.add((Component)new JLabel(string3, 4), gridBagConstraints);
        if (rateComponent instanceof FlatFeePerUnit) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("applicableData")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            object2 = "";
            if (rateComponent.getApplicableData() == 0) {
                object2 = this.lex.getText("Consumption");
            } else if (rateComponent.getApplicableData() == 1) {
                object2 = this.lex.getText("Demand");
            } else if (rateComponent.getApplicableData() == 2) {
                object2 = this.lex.getText("ReactiveEnergy");
            } else if (rateComponent.getApplicableData() == 4) {
                object2 = this.lex.getText("ApparentEnergy");
            } else if (rateComponent.getApplicableData() == 3) {
                object2 = this.lex.getText("ReactivePower");
            } else if (rateComponent.getApplicableData() == 5) {
                object2 = this.lex.getText("ApparentPower");
            }
            jPanel.add((Component)new JLabel((String)object2, 4), gridBagConstraints);
        }
        if (rateComponent instanceof Ratchet) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("minContractPeakLevel")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)new JLabel(String.valueOf(((Ratchet)rateComponent).getMinimumContractPeakLevel()) + string2, 4), gridBagConstraints);
        }
        if (rateComponent instanceof FixedFee) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            object2 = this.lex.getText("fee");
            if (rateComponent instanceof ScheduledFeePerUnit || rateComponent instanceof ScheduledDemandCharge) {
                object2 = this.lex.getText("originalFee");
            }
            jPanel.add((Component)new JLabel((String)object2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            objectArray = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
            jPanel.add((Component)new JLabel(string + objectArray.format(((FixedFee)rateComponent).getFee()), 4), gridBagConstraints);
        }
        if (rateComponent instanceof ScheduledFeePerUnit) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("newFee")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            object2 = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
            jPanel.add((Component)new JLabel(string + ((NumberFormat)object2).format(((ScheduledFeePerUnit)rateComponent).getNewFee()), 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("transitionTime")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            objectArray = new SimpleDateFormat(this.lex.getText("rateTimeFormat"), new Locale(this.lex.language, ""));
            objectArray.setTimeZone((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
            jPanel.add((Component)new JLabel(objectArray.format(new Date(((ScheduledFeePerUnit)rateComponent).getTransitionTime())), 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("transitionApproach")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            object = this.lex.getText("proRated");
            if (((ScheduledFeePerUnit)rateComponent).getTransitionMethod() == 1) {
                object = this.lex.getText("absolute");
            }
            jPanel.add((Component)new JLabel((String)object, 4), gridBagConstraints);
        }
        if (rateComponent instanceof ScheduledDemandCharge) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("newFee")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            object2 = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
            jPanel.add((Component)new JLabel(string + ((NumberFormat)object2).format(((ScheduledDemandCharge)rateComponent).getNewFee()), 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("transitionTime")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            objectArray = new SimpleDateFormat(this.lex.getText("rateTimeFormat"), new Locale(this.lex.language, ""));
            objectArray.setTimeZone((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
            jPanel.add((Component)new JLabel(objectArray.format(new Date(((ScheduledDemandCharge)rateComponent).getTransitionTime())), 4), gridBagConstraints);
        }
        if (rateComponent instanceof HistoricalRatchet) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("percentage")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)new JLabel(String.valueOf(((HistoricalRatchet)rateComponent).getPercentage()), 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("ratchetValid")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            object2 = "unknown";
            switch (((HistoricalRatchet)rateComponent).getPeriodsARatchetIsValid().getTimeUnits()) {
                case 0: {
                    object2 = this.lex.getText("numBillingCycles");
                    break;
                }
                case 1: {
                    object2 = this.lex.getText("numMinutes");
                    break;
                }
                case 2: {
                    object2 = this.lex.getText("numHours");
                    break;
                }
                case 3: {
                    object2 = this.lex.getText("numDays");
                    break;
                }
                case 4: {
                    object2 = this.lex.getText("numWeeks");
                    break;
                }
                case 5: {
                    object2 = this.lex.getText("numMonths");
                    break;
                }
                case 6: {
                    object2 = this.lex.getText("numYears");
                }
            }
            jPanel.add((Component)new JLabel(String.valueOf(((HistoricalRatchet)rateComponent).getPeriodsARatchetIsValid().getNumber() + " " + (String)object2), 4), gridBagConstraints);
        }
        if (rateComponent instanceof FlatFeePerUnit) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)new JLabel(this.lex.getText("minApplicableData")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)new JLabel(String.valueOf(((FlatFeePerUnit)rateComponent).getMinDataValue()) + string2, 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)new JLabel(this.lex.getText("maxApplicableData")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            double d = ((FlatFeePerUnit)rateComponent).getMaxDataValue();
            object = String.valueOf(d);
            if (d == Double.MAX_VALUE) {
                object = this.lex.getText("noUpperLimit");
            }
            jPanel.add((Component)new JLabel((String)object + string2, 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)new JLabel(this.lex.getText("dataRangeApproach")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            String string4 = "unknown";
            switch (((FlatFeePerUnit)rateComponent).getDataRangeApproach()) {
                case 0: {
                    string4 = this.lex.getText("cumulativeRangeApproach");
                    break;
                }
                case 1: {
                    string4 = this.lex.getText("overallRangeApproach");
                    break;
                }
                case 2: {
                    string4 = this.lex.getText("individualRangeApproach");
                }
            }
            jPanel.add((Component)new JLabel(string4, 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)new JLabel(this.lex.getText("unitsInFee")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)new JLabel(String.valueOf(((FlatFeePerUnit)rateComponent).getUnitsInFee()) + string2, 4), gridBagConstraints);
        }
        if (rateComponent instanceof CombinationPercentageFee) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("percentage")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)new JLabel(String.valueOf(((CombinationPercentageFee)rateComponent).getPercentage()), 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("includedComponents")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            CheckList checkList = new CheckList();
            checkList.setEnabled(false);
            objectArray = ((CombinationPercentageFee)rateComponent).getRegisteredComponentIds();
            if (objectArray != null) {
                object = new int[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    object[i] = i;
                }
                checkList.setListData(objectArray);
                checkList.setSelectedIndices((int[])object);
            }
            jPanel.add((Component)checkList, gridBagConstraints);
        }
        if (rateComponent instanceof ChoiceComponent) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("choice")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            String string5 = "unknown";
            switch (((ChoiceComponent)rateComponent).getChoice()) {
                case 0: {
                    string5 = this.lex.getText("useHighest");
                    break;
                }
                case 1: {
                    string5 = this.lex.getText("useLowest");
                    break;
                }
                case 2: {
                    string5 = this.lex.getText("useSum");
                    break;
                }
                case 3: {
                    string5 = this.lex.getText("useDifference");
                }
            }
            jPanel.add((Component)new JLabel(string5, 4), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("choiceBasedOn")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            objectArray = "unknown";
            switch (((ChoiceComponent)rateComponent).getComparison()) {
                case 0: {
                    objectArray = this.lex.getText("calculatedCost");
                    break;
                }
                case 1: {
                    objectArray = this.lex.getText("calculatedUnits");
                }
            }
            jPanel.add((Component)new JLabel((String)objectArray, 4), gridBagConstraints);
        }
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
    }

    private JComponent buildRateSchedulesPanel() {
        this.rateScheduleDetails = new RateScheduleDetailPanel(this.parentPanel.getResourceManager(), this, this.lex);
        this.rateScheduleDetails.setRateScheduleEditorValue(null);
        return this.rateScheduleDetails;
    }

    private void buildChoiceRowEditor(RateComponent rateComponent, String string) {
        Object object;
        this.choiceComponentPanel.removeAll();
        if (rateComponent == null || !(rateComponent instanceof ChoiceComponent) && !(rateComponent instanceof ChoiceComponentChild)) {
            this.choiceComponentPanel.setBorder(BorderFactory.createEmptyBorder());
            this.choiceComponentPanel.revalidate();
            this.choiceComponentPanel.repaint();
            return;
        }
        this.choiceComponentPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("choiceDetails")));
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        String string2 = "";
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        RateComponent rateComponent2 = null;
        if (rateComponent instanceof ChoiceComponentChild) {
            rateComponent2 = ((ChoiceComponentChild)rateComponent).getParentRateComponent();
            if (((ChoiceComponent)rateComponent2).getNestedChoice() != null) {
                object = ((ChoiceComponentChild)(rateComponent2 = ((ChoiceComponent)rateComponent2).getNestedChoice())).getParentRateComponent();
                if (((ChoiceComponent)object).getNestedChoice() != null) {
                    object = ((ChoiceComponent)object).getNestedChoice();
                }
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                JLabel jLabel = new JLabel(string2 + ((RateComponent)object).getName());
                jLabel.addMouseListener(new ChoiceMouseAdapter((RateComponent)object, string));
                jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
                jPanel.add((Component)jLabel, gridBagConstraints);
                string2 = string2 + "    ";
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            object = new JLabel(string2 + rateComponent2.getName());
            ((Component)object).addMouseListener(new ChoiceMouseAdapter(rateComponent2, string));
            ((JComponent)object).setBorder(BorderFactory.createRaisedBevelBorder());
            jPanel.add((Component)object, gridBagConstraints);
            string2 = string2 + "    ";
        }
        object = null;
        boolean bl = true;
        if (rateComponent instanceof ChoiceComponent) {
            object = (ChoiceComponent)rateComponent;
        } else if (((ChoiceComponentChild)rateComponent).getRateComponent() instanceof ChoiceComponent) {
            object = (ChoiceComponent)((ChoiceComponentChild)rateComponent).getRateComponent();
        } else if (rateComponent2 instanceof ChoiceComponent) {
            object = (ChoiceComponent)rateComponent2;
            bl = false;
        } else if (rateComponent2 instanceof ChoiceComponentChild && ((ChoiceComponentChild)rateComponent2).getRateComponent() instanceof ChoiceComponent) {
            object = (ChoiceComponent)((ChoiceComponentChild)rateComponent2).getRateComponent();
            bl = false;
        }
        if (object != null) {
            Object object2;
            if (bl) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                object2 = new JLabel(string2 + ((RateComponent)object).getName());
                ((Component)object2).addMouseListener(new ChoiceMouseAdapter((RateComponent)object, string));
                ((JComponent)object2).setBorder(BorderFactory.createBevelBorder(1, Color.red, Color.red));
                this.lastSelectedLabel = object2;
                jPanel.add((Component)object2, gridBagConstraints);
                string2 = string2 + "    ";
            }
            if ((object2 = ((ChoiceComponent)object).getRateComponents()) != null) {
                for (int i = 0; i < ((ChoiceComponentChild[])object2).length; ++i) {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.weightx = 100.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.anchor = 17;
                    JLabel jLabel = new JLabel(string2 + ((ChoiceComponentChild)object2[i]).getName());
                    jLabel.addMouseListener(new ChoiceMouseAdapter((RateComponent)object2[i], string));
                    jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
                    if (!bl && ((ChoiceComponentChild)object2[i]).getName().equals(rateComponent.getName())) {
                        jLabel.setBorder(BorderFactory.createBevelBorder(1, Color.red, Color.red));
                        this.lastSelectedLabel = jLabel;
                    }
                    jPanel.add((Component)jLabel, gridBagConstraints);
                }
            }
        }
        this.choiceComponentPanel.add((Component)jPanel, "North");
        this.choiceComponentPanel.revalidate();
        this.choiceComponentPanel.repaint();
    }

    public void setReconciliationRowEditorValue(ReconciliationRow reconciliationRow) {
        Object object;
        this.currentReconciliationRow = reconciliationRow;
        if (reconciliationRow == null) {
            this.layout.show(this, "hide");
        } else {
            this.layout.show(this, "show");
            object = "";
            object = reconciliationRow.getShowCostColumns() ? reconciliationRow.getName().substring(0, reconciliationRow.getNamePrefixLength()) : reconciliationRow.getName();
            this.buildChoiceRowEditor(reconciliationRow.getRateComponent(), (String)object);
            this.buildRowEditor(reconciliationRow);
        }
        object = null;
        if (reconciliationRow != null && (object = reconciliationRow.getRateComponent()) instanceof ChoiceComponentChild) {
            object = ((ChoiceComponentChild)object).getRateComponent();
        }
        this.rateScheduleDetails.setRateComponentEditorValue((RateComponent)object);
    }

    public void setContributionChartEditorValue(ReconciliationReport reconciliationReport, int n) {
        this.currentReconciliationRow = null;
        if (reconciliationReport == null) {
            this.layout.show(this, "hide");
        } else {
            this.layout.show(this, "chart");
            this.buildChart(reconciliationReport, n);
        }
    }

    private void buildChart(ReconciliationReport reconciliationReport, int n) {
        switch (n) {
            case 0: {
                this.chart.setTitle(this.lex.getText("calculatedCost") + " " + this.lex.getText("contributors"));
                break;
            }
            case 1: {
                this.chart.setTitle(this.lex.getText("actualCost") + " " + this.lex.getText("contributors"));
                break;
            }
            case 2: {
                this.chart.setTitle(this.lex.getText("deltaCost") + " " + this.lex.getText("contributors"));
            }
        }
        BillReconciliationSeries billReconciliationSeries = new BillReconciliationSeries(this.lex, reconciliationReport, n);
        if (billReconciliationSeries.getValueCount() > 0) {
            this.model.setSeries(billReconciliationSeries, new DefaultPieConfig(billReconciliationSeries, Color.black), null, null);
            this.chart.setModel(this.model);
            this.table.setSeries(billReconciliationSeries);
        }
        this.table.resetSorting();
        if (this.firstLoad) {
            this.detailSplit.setDividerLocation(0.4);
            this.firstLoad = false;
        }
    }

    public void handleRateComponentChange(boolean bl) {
    }

    public RateComponent getSelectedRateComponentBase() {
        return this.currentReconciliationRow.getRateComponent();
    }

    public boolean rateSchedulesEditable() {
        return false;
    }

    protected void init(EasSession easSession) {
        this.rateScheduleDetails.init(easSession);
    }

    private class ChoiceMouseAdapter
    extends MouseAdapter {
        private RateComponent rateComponent;
        private String rateName;

        public ChoiceMouseAdapter(RateComponent rateComponent, String string) {
            this.rateComponent = rateComponent;
            this.rateName = string;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == ReconciliationComponentDetailPanel.this.lastSelectedLabel) {
                return;
            }
            ReconciliationRow reconciliationRow = null;
            String string = this.rateName + this.rateComponent.getName();
            if (this.rateComponent instanceof ChoiceComponentChild) {
                int n = this.rateName.length();
                Rate rate = null;
                try {
                    rate = EasCostClient.retrieveRate(ReconciliationComponentDetailPanel.this.parentPanel.getSession(), this.rateName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                BUnit bUnit = null;
                BUnit bUnit2 = null;
                BUnit bUnit3 = null;
                BUnit bUnit4 = null;
                BUnit bUnit5 = null;
                BUnit bUnit6 = null;
                BUnit bUnit7 = null;
                if (rate != null) {
                    bUnit = rate.getCurrency();
                    bUnit2 = rate.getConsumptionUnits();
                    bUnit3 = rate.getDemandUnits();
                    bUnit4 = rate.getReactiveEnergyUnits();
                    bUnit5 = rate.getApparentEnergyUnits();
                    bUnit6 = rate.getReactivePowerUnits();
                    bUnit7 = rate.getApparentPowerUnits();
                }
                BUnit bUnit8 = null;
                switch (this.rateComponent.getApplicableData()) {
                    case 0: {
                        bUnit8 = bUnit2;
                        break;
                    }
                    case 1: {
                        bUnit8 = bUnit3;
                        break;
                    }
                    case 2: {
                        bUnit8 = bUnit4;
                        break;
                    }
                    case 4: {
                        bUnit8 = bUnit5;
                        break;
                    }
                    case 3: {
                        bUnit8 = bUnit6;
                        break;
                    }
                    case 5: {
                        bUnit8 = bUnit7;
                    }
                }
                reconciliationRow = new ReconciliationRow(string, n, (RateComponent)this.rateComponent.newCopy(), 0.0, false, bUnit, bUnit8);
            } else {
                ReconciliationRow[] reconciliationRowArray;
                ReconciliationReport reconciliationReport = ReconciliationComponentDetailPanel.this.parentPanel.getSelectedReconciliation();
                if (reconciliationReport != null && (reconciliationRowArray = reconciliationReport.getReconciliationRows()) != null) {
                    for (int i = 0; i < reconciliationRowArray.length; ++i) {
                        if (!reconciliationRowArray[i].getName().equals(string)) continue;
                        reconciliationRow = reconciliationRowArray[i];
                        break;
                    }
                }
            }
            ReconciliationComponentDetailPanel.this.setReconciliationRowEditorValue(reconciliationRow);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == ReconciliationComponentDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == ReconciliationComponentDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }
}

