/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.reconciliation;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.cost.report.ReconciliationNote;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NoteEditorDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JTextArea noteTextArea = null;
    private String noteText = null;
    private String user = null;
    private ReconciliationNote originalNote = null;
    private Component parent;

    private NoteEditorDialog(String string, ReconciliationNote reconciliationNote, Dialog dialog, Component component, Lexicon lexicon) {
        super(dialog, reconciliationNote == null ? lexicon.getText("addNote") : lexicon.getText("editNote"), true);
        this.parent = component;
        this.user = string;
        this.originalNote = reconciliationNote;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1), false);
        this.okButton = new JButton(lexicon.getText("ok"));
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("ok");
        this.okButton.setEnabled(false);
        jPanel.add(this.okButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancel");
        jPanel.add(this.cancelButton);
        jComponent.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new FlowLayout(0), false);
        this.noteTextArea = reconciliationNote == null ? new JTextArea(15, 50) : new JTextArea(reconciliationNote.getNote(), 15, 50);
        this.noteTextArea.setEditable(true);
        this.noteTextArea.getDocument().addDocumentListener(this);
        jPanel2.add(new JScrollPane(this.noteTextArea));
        jComponent.add((Component)jPanel2, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                NoteEditorDialog.this.noteTextArea.requestFocus();
            }
        });
        this.pack();
    }

    public void show() {
        this.pack();
        Point point = this.parent.getLocationOnScreen();
        Point point2 = new Point(point.x + this.parent.getSize().width / 2, point.y + this.parent.getSize().height / 2);
        int n = this.getPreferredSize().width;
        int n2 = this.getPreferredSize().height;
        int n3 = point2.x - n / 2;
        int n4 = point2.y - n2 / 2;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 + n > toolkit.getScreenSize().width) {
            n3 = toolkit.getScreenSize().width - n;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 + n2 > toolkit.getScreenSize().height) {
            n4 = toolkit.getScreenSize().height - n2;
        }
        this.setLocation(n3, n4);
        super.show();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.noteTextArea.getText().trim().length() > 0 || this.originalNote != null);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.noteTextArea.getText().trim().length() > 0 || this.originalNote != null);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.noteTextArea.getText().trim().length() > 0 || this.originalNote != null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton || actionEvent.getActionCommand().equals("ok") && this.okButton.isEnabled()) {
            this.noteText = this.noteTextArea.getText();
            this.hide();
        } else if (actionEvent.getSource() == this.cancelButton || actionEvent.getActionCommand().equals("cancel")) {
            this.hide();
        }
    }

    private ReconciliationNote getReconciliationNote() {
        if (this.noteText == null) {
            return this.originalNote;
        }
        BTimeZone bTimeZone = BTimeZone.getLocal();
        long l = EasLocalTime.getCurrentTime().getTimestamp(bTimeZone);
        if (this.originalNote != null) {
            this.originalNote.editNote(this.user, l, bTimeZone, this.noteText);
            return this.originalNote;
        }
        return new ReconciliationNote(this.user, l, bTimeZone, this.noteText);
    }

    public static ReconciliationNote getNote(String string, ReconciliationNote reconciliationNote, Dialog dialog, Component component, Lexicon lexicon) {
        NoteEditorDialog noteEditorDialog = new NoteEditorDialog(string, reconciliationNote, dialog, component, lexicon);
        noteEditorDialog.show();
        return noteEditorDialog.getReconciliationNote();
    }
}

