/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.reconciliation;

import com.tridium.eas.cost.ui.reports.reconciliation.BillReconciliationSeries;
import com.tridium.eas.ui.reports.SeriesLabel;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import java.awt.Color;
import java.text.DecimalFormat;
import javax.baja.util.Lexicon;

public class BillReconciliationTableModel
extends AbstractRowMappedTableModel {
    private BillReconciliationSeries series = null;
    public static final int INPUT_COL = 0;
    public static final int VALUE_COL = 1;
    public static final int VALUE_PERCENT_COL = 2;
    private static DecimalFormat percentFormat = new DecimalFormat("#0.0");
    private int[] col_list;
    private Lexicon lex;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$SeriesLabel;
    static /* synthetic */ Class class$java$lang$String;

    public BillReconciliationTableModel(Lexicon lexicon) {
        this.lex = lexicon;
        this.col_list = new int[]{0, 1, 2};
    }

    public void setSeries(BillReconciliationSeries billReconciliationSeries) {
        this.series = billReconciliationSeries;
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        if (this.series == null) {
            return 0;
        }
        return this.series.getValueCount();
    }

    public String getColumnName(int n) {
        switch (this.col_list[n]) {
            case 0: {
                return this.lex.getText("rateComponent");
            }
            case 1: {
                return this.lex.getText("reconcileContribution");
            }
            case 2: {
                return this.lex.getText("%");
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getColumnCount() {
        return this.col_list.length;
    }

    public Class getColumnClass(int n) {
        switch (this.col_list[n]) {
            case 0: {
                return class$com$tridium$eas$ui$reports$SeriesLabel == null ? (class$com$tridium$eas$ui$reports$SeriesLabel = BillReconciliationTableModel.class$("com.tridium.eas.ui.reports.SeriesLabel")) : class$com$tridium$eas$ui$reports$SeriesLabel;
            }
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = BillReconciliationTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 2: {
                return class$java$lang$String == null ? (class$java$lang$String = BillReconciliationTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Object getModelValueAt(int n, int n2) {
        switch (this.col_list[n2]) {
            case 0: {
                return new ColorNameLabel(this.series.getValueName(n), this.series.getValueColor(n));
            }
            case 1: {
                return this.series.getFullValue(n).getValueString();
            }
            case 2: {
                try {
                    return percentFormat.format(this.series.getFullValue(n).getPercent().doubleValue() * 100.0);
                }
                catch (Exception exception) {
                    return new Double(this.series.getFullValue(n).getPercent().doubleValue() * 100.0).toString();
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ColorNameLabel
    implements SeriesLabel {
        private String name;
        private Color color;

        public ColorNameLabel(String string, Color color) {
            this.name = string;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

