/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.reconciliation;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.report.ReconciliationNote;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.ScrollPaneDialog;
import com.tridium.eas.cost.ui.reports.reconciliation.BillReconciliationApplication;
import com.tridium.eas.cost.ui.reports.reconciliation.NotesDialog;
import com.tridium.eas.cost.ui.reports.reconciliation.ReconciliationComponentDetailPanel;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.EasScrollPane;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BillReconciliationDetailPanel
extends JPanel
implements Printable {
    private Font cellFont = null;
    private Font headerFont = null;
    private Font titleFont = null;
    private Font subtitleFont = null;
    private FontMetrics cellFontMetrics;
    private FontMetrics headerFontMetrics;
    private FontMetrics titleFontMetrics;
    private FontMetrics subtitleFontMetrics;
    private EasSession session = null;
    private ResourceManager resourceManager = null;
    private BillReconciliationApplication parentApplication = null;
    private ReconciliationComponentDetailPanel componentDetails = null;
    protected Lexicon lex;
    private CardLayout layout = null;
    private boolean initializingBillValues;
    private ReconciliationReport currentSelectedReconciliation = null;
    private NumberTextField miscCostTextField;
    private NumberTextField totalCalcCostTextField;
    private NumberTextField totalActualCostTextField;
    private NumberTextField totalDeltaCostTextField;
    private JSplitPane defaultPane = null;
    private JSplitPane upperPane = null;
    private JPanel reportPanel = null;
    private ReconciliationRow[] reportRows = null;
    private JLabel lastSelectedLabel = null;
    private ReconciliationRow lastSelectedRow = null;
    private boolean changeOccurred = false;
    private int currentChartType = -1;
    private boolean firstLoad = true;
    private boolean administratorRights;
    private JButton notesButton = null;
    private int currentPage = 0;

    protected BillReconciliationDetailPanel(ResourceManager resourceManager, BillReconciliationApplication billReconciliationApplication, boolean bl, Lexicon lexicon) {
        this.lex = lexicon;
        this.resourceManager = resourceManager;
        this.parentApplication = billReconciliationApplication;
        this.administratorRights = bl;
        this.initializingBillValues = true;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add("show", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.add("hide", jPanel2);
        jPanel2.add((Component)this.buildDefaultView(), "Center");
        this.upperPane = new JSplitPane();
        this.upperPane.setDividerSize(4);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel3.add((Component)this.buildReconciliationReportPanel(), gridBagConstraints);
        EasScrollPane easScrollPane = new EasScrollPane(jPanel3);
        easScrollPane.getViewport().setBackground(Color.white);
        JPanel jPanel4 = new JPanel(new BorderLayout(), false);
        jPanel4.add((Component)easScrollPane, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout(), false);
        JPanel jPanel6 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this.notesButton = new JButton(lexicon.getText("notes"));
        this.notesButton.setEnabled(false);
        this.notesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BillReconciliationDetailPanel.this.viewNotes();
            }
        });
        jPanel6.add((Component)this.notesButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)new JLabel(lexicon.getText("miscCost")), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        DecimalFormat decimalFormat = new DecimalFormat(lexicon.getText("costValueFormat"));
        this.miscCostTextField = new CostTextField(9, false);
        this.miscCostTextField.setHorizontalAlignment(4);
        this.miscCostTextField.setFormatter(decimalFormat);
        this.miscCostTextField.setMaximumFractionDigits(2);
        this.miscCostTextField.setUseLabelAppearanceWhenDisabled(true);
        this.miscCostTextField.setEditable(bl);
        this.miscCostTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (BillReconciliationDetailPanel.this.initializingBillValues) {
                    return;
                }
                try {
                    BillReconciliationDetailPanel.this.getSelectedReconciliation().setMiscCost(BillReconciliationDetailPanel.this.miscCostTextField.getDoubleValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                BillReconciliationDetailPanel.this.changeOccurred = true;
                BillReconciliationDetailPanel.this.handleBillChange();
            }
        });
        this.miscCostTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!BillReconciliationDetailPanel.this.changeOccurred) {
                        return;
                    }
                    BillReconciliationDetailPanel.this.computeTotals(BillReconciliationDetailPanel.this.currentSelectedReconciliation);
                    if (BillReconciliationDetailPanel.this.currentChartType >= 0) {
                        BillReconciliationDetailPanel.this.componentDetails.setContributionChartEditorValue(BillReconciliationDetailPanel.this.currentSelectedReconciliation, BillReconciliationDetailPanel.this.currentChartType);
                    }
                    BillReconciliationDetailPanel.this.changeOccurred = false;
                }
            }
        });
        this.miscCostTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                BillReconciliationDetailPanel.this.selectItLater(BillReconciliationDetailPanel.this.miscCostTextField);
            }

            public void focusLost(FocusEvent focusEvent) {
                if (!BillReconciliationDetailPanel.this.changeOccurred) {
                    return;
                }
                BillReconciliationDetailPanel.this.computeTotals(BillReconciliationDetailPanel.this.currentSelectedReconciliation);
                if (BillReconciliationDetailPanel.this.currentChartType >= 0) {
                    BillReconciliationDetailPanel.this.componentDetails.setContributionChartEditorValue(BillReconciliationDetailPanel.this.currentSelectedReconciliation, BillReconciliationDetailPanel.this.currentChartType);
                }
                BillReconciliationDetailPanel.this.changeOccurred = false;
            }
        });
        jPanel6.add((Component)this.miscCostTextField, gridBagConstraints);
        jPanel5.add((Component)jPanel6, "North");
        JPanel jPanel7 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        jPanel7.add((Component)new JLabel(lexicon.getText("calculatedCost")), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        jPanel7.add((Component)new JLabel(lexicon.getText("actualCost")), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        jPanel7.add((Component)new JLabel(lexicon.getText("deltaCost")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)new JLabel(lexicon.getText("totals")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalCalcCostTextField = new CostTextField(9, false);
        this.totalCalcCostTextField.setHorizontalAlignment(4);
        this.totalCalcCostTextField.setFormatter(decimalFormat);
        this.totalCalcCostTextField.setMaximumFractionDigits(2);
        this.totalCalcCostTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalCalcCostTextField.setEditable(false);
        this.totalCalcCostTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (BillReconciliationDetailPanel.this.initializingBillValues) {
                    return;
                }
                BillReconciliationDetailPanel.this.handleBillChange();
            }
        });
        jPanel7.add((Component)this.totalCalcCostTextField, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalActualCostTextField = new CostTextField(9, false);
        this.totalActualCostTextField.setHorizontalAlignment(4);
        this.totalActualCostTextField.setFormatter(decimalFormat);
        this.totalActualCostTextField.setMaximumFractionDigits(2);
        this.totalActualCostTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalActualCostTextField.setEditable(false);
        this.totalActualCostTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (BillReconciliationDetailPanel.this.initializingBillValues) {
                    return;
                }
                BillReconciliationDetailPanel.this.handleBillChange();
            }
        });
        jPanel7.add((Component)this.totalActualCostTextField, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalDeltaCostTextField = new CostTextField(9, false);
        this.totalDeltaCostTextField.setHorizontalAlignment(4);
        this.totalDeltaCostTextField.setFormatter(decimalFormat);
        this.totalDeltaCostTextField.setMaximumFractionDigits(2);
        this.totalDeltaCostTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalDeltaCostTextField.setEditable(false);
        this.totalDeltaCostTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (BillReconciliationDetailPanel.this.initializingBillValues) {
                    return;
                }
                BillReconciliationDetailPanel.this.handleBillChange();
            }
        });
        jPanel7.add((Component)this.totalDeltaCostTextField, gridBagConstraints);
        jPanel5.add((Component)jPanel7, "South");
        jPanel4.add((Component)jPanel5, "South");
        this.upperPane.setLeftComponent(jPanel4);
        this.upperPane.setRightComponent(this.buildReconciliationRowEditorPanel());
        jPanel.add((Component)this.upperPane, "Center");
        this.setReconciliationEditorValue(null, false);
        this.initializingBillValues = false;
    }

    private JComponent buildDefaultView() {
        this.defaultPane = new JSplitPane();
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)new JLabel(this.lex.getText("selectRateMeter")), gridBagConstraints);
        EasScrollPane easScrollPane = new EasScrollPane(jPanel);
        easScrollPane.getViewport().setBackground(Color.white);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        jPanel2.add((Component)easScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel(this.lex.getText("miscCost")), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        CostTextField costTextField = new CostTextField(9, false);
        costTextField.setHorizontalAlignment(4);
        costTextField.setFormatter(decimalFormat);
        costTextField.setEditable(false);
        costTextField.setMaximumFractionDigits(2);
        costTextField.setText(0.0);
        jPanel4.add((Component)costTextField, gridBagConstraints);
        jPanel3.add((Component)jPanel4, "North");
        JPanel jPanel5 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        jPanel5.add((Component)new JLabel(this.lex.getText("calculatedCost")), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        jPanel5.add((Component)new JLabel(this.lex.getText("actualCost")), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        jPanel5.add((Component)new JLabel(this.lex.getText("deltaCost")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)new JLabel(this.lex.getText("totals")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        CostTextField costTextField2 = new CostTextField(9, false);
        costTextField2.setHorizontalAlignment(4);
        costTextField2.setFormatter(decimalFormat);
        costTextField2.setEditable(false);
        costTextField2.setMaximumFractionDigits(2);
        costTextField2.setText(0.0);
        jPanel5.add((Component)costTextField2, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        CostTextField costTextField3 = new CostTextField(9, false);
        costTextField3.setHorizontalAlignment(4);
        costTextField3.setFormatter(decimalFormat);
        costTextField3.setEditable(false);
        costTextField3.setMaximumFractionDigits(2);
        costTextField3.setText(0.0);
        jPanel5.add((Component)costTextField3, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        CostTextField costTextField4 = new CostTextField(9, false);
        costTextField4.setHorizontalAlignment(4);
        costTextField4.setFormatter(decimalFormat);
        costTextField4.setEditable(false);
        costTextField4.setMaximumFractionDigits(2);
        costTextField4.setText(0.0);
        jPanel5.add((Component)costTextField4, gridBagConstraints);
        jPanel3.add((Component)jPanel5, "South");
        jPanel2.add((Component)jPanel3, "South");
        this.defaultPane.setLeftComponent(jPanel2);
        JPanel jPanel6 = new JPanel(new BorderLayout(), false);
        jPanel6.setBorder(BorderFactory.createTitledBorder(this.lex.getText("billDetails")));
        this.defaultPane.setRightComponent(jPanel6);
        return this.defaultPane;
    }

    private JComponent buildReconciliationReportPanel() {
        this.reportPanel = new JPanel(new GridBagLayout(), false);
        return this.reportPanel;
    }

    private JComponent buildReconciliationRowEditorPanel() {
        this.componentDetails = new ReconciliationComponentDetailPanel(this, this.lex);
        return this.componentDetails;
    }

    private LabelRowPair layoutReconciliationReport(ReconciliationReport reconciliationReport) {
        LabelRowPair labelRowPair = null;
        this.reportPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        if (reconciliationReport == null || reconciliationReport.getReconciliationRows() == null) {
            if (this.notesButton != null) {
                this.notesButton.setEnabled(false);
            }
            this.reportPanel.add((Component)new JLabel(this.lex.getText("noAttachedRates")), gridBagConstraints);
            gridBagConstraints.gridy = 2;
        } else {
            if (this.notesButton != null) {
                this.notesButton.setEnabled(true);
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            this.reportPanel.add((Component)new JLabel(""), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            JLabel jLabel = new JLabel(this.lex.getText("calculatedCost"), 0);
            jLabel.addMouseListener(new ReconciliationHeaderMouseAdapter(0));
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            this.reportPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            JLabel jLabel2 = new JLabel(this.lex.getText("actualCost"), 0);
            jLabel2.addMouseListener(new ReconciliationHeaderMouseAdapter(1));
            jLabel2.setBorder(BorderFactory.createRaisedBevelBorder());
            this.reportPanel.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            JLabel jLabel3 = new JLabel(this.lex.getText("deltaCost"), 0);
            jLabel3.addMouseListener(new ReconciliationHeaderMouseAdapter(2));
            jLabel3.setBorder(BorderFactory.createRaisedBevelBorder());
            this.reportPanel.add((Component)jLabel3, gridBagConstraints);
            this.reportRows = reconciliationReport.getReconciliationRows();
            JComponent jComponent = null;
            CostTextField costTextField = null;
            for (int i = 0; i < this.reportRows.length; ++i) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = i + 2;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                String string = this.reportRows[i].getShowCostColumns() ? this.reportRows[i].getDisplayName(this.lex) : this.lex.getText("rate") + "  " + this.reportRows[i].getDisplayName(this.lex);
                JLabel jLabel4 = new JLabel(string);
                jLabel4.addMouseListener(new ReconciliationMouseAdapter(this.reportRows[i]));
                jLabel4.setBorder(BorderFactory.createRaisedBevelBorder());
                this.reportPanel.add((Component)jLabel4, gridBagConstraints);
                if (labelRowPair == null) {
                    labelRowPair = new LabelRowPair(jLabel4, this.reportRows[i]);
                }
                if (!this.reportRows[i].getShowCostColumns()) continue;
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField2 = new CostTextField(9, false);
                costTextField2.setHorizontalAlignment(4);
                DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
                costTextField2.setFormatter(decimalFormat);
                costTextField2.setMaximumFractionDigits(2);
                costTextField2.setUseLabelAppearanceWhenDisabled(true);
                costTextField2.setEditable(false);
                costTextField2.getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (BillReconciliationDetailPanel.this.initializingBillValues) {
                            return;
                        }
                        BillReconciliationDetailPanel.this.handleBillChange();
                    }
                });
                costTextField2.setText(this.reportRows[i].getCalculatedCost());
                this.reportPanel.add((Component)costTextField2, gridBagConstraints);
                CostTextField costTextField3 = new CostTextField(9, false);
                costTextField3.setHorizontalAlignment(4);
                costTextField3.setFormatter(decimalFormat);
                costTextField3.setMaximumFractionDigits(2);
                costTextField3.setUseLabelAppearanceWhenDisabled(true);
                costTextField3.setEditable(false);
                costTextField3.getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (BillReconciliationDetailPanel.this.initializingBillValues) {
                            return;
                        }
                        BillReconciliationDetailPanel.this.handleBillChange();
                    }
                });
                gridBagConstraints.gridx = 3;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField4 = new CostTextField(9, false);
                costTextField4.setHorizontalAlignment(4);
                costTextField4.setFormatter(decimalFormat);
                costTextField4.setMaximumFractionDigits(2);
                costTextField4.setUseLabelAppearanceWhenDisabled(true);
                costTextField4.setEditable(this.administratorRights);
                costTextField4.getDocument().addDocumentListener(new ActualCostListener(costTextField4, this.reportRows[i]));
                costTextField4.addKeyListener(new ActualCostKeyAdapter(costTextField4, costTextField3, this.reportRows[i]));
                costTextField4.addFocusListener(new ActualCostFocusAdapter(costTextField4, costTextField3, this.reportRows[i]));
                if (!this.reportRows[i].getActualCostSet() && this.reportRows[i].getCalculatedCost() != 0.0) {
                    this.reportRows[i].setActualCost(this.reportRows[i].getCalculatedCost());
                }
                costTextField4.setText(this.reportRows[i].getActualCost(false, 1.0));
                this.reportPanel.add((Component)costTextField4, gridBagConstraints);
                costTextField3.setText(this.reportRows[i].getDeltaCost(false, 1.0));
                gridBagConstraints.gridx = 4;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                this.reportPanel.add((Component)costTextField3, gridBagConstraints);
                if (jComponent != null) {
                    jComponent.setNextFocusableComponent(costTextField4);
                } else {
                    costTextField = costTextField4;
                }
                jComponent = costTextField4;
            }
            if (costTextField != null) {
                jComponent.setNextFocusableComponent(costTextField);
            }
            gridBagConstraints.gridy = this.reportRows.length + 2;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        this.reportPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.reportPanel.revalidate();
        this.reportPanel.repaint();
        return labelRowPair;
    }

    public void setReconciliationEditorValue(ReconciliationReport reconciliationReport, boolean bl) {
        this.initializingBillValues = true;
        this.currentSelectedReconciliation = reconciliationReport;
        this.currentChartType = -1;
        if (reconciliationReport == null && !bl) {
            this.layout.show(this, "hide");
            this.componentDetails.setReconciliationRowEditorValue(null);
            this.lastSelectedRow = null;
        } else {
            this.layout.show(this, "show");
            LabelRowPair labelRowPair = this.layoutReconciliationReport(reconciliationReport);
            if (reconciliationReport != null) {
                this.computeTotals(reconciliationReport);
            }
            if (this.firstLoad) {
                this.upperPane.setDividerLocation(0.57);
                this.defaultPane.setDividerLocation(0.57);
                this.firstLoad = false;
            }
            if (labelRowPair != null) {
                labelRowPair.getLabel().setBorder(BorderFactory.createBevelBorder(1, Color.red, Color.red));
                this.lastSelectedLabel = labelRowPair.getLabel();
                this.currentChartType = -1;
                this.componentDetails.setReconciliationRowEditorValue(labelRowPair.getRow());
                this.lastSelectedRow = labelRowPair.getRow();
            } else {
                this.componentDetails.setReconciliationRowEditorValue(null);
                this.lastSelectedRow = null;
            }
        }
        this.initializingBillValues = false;
    }

    public ReconciliationReport getSelectedReconciliation() {
        return this.currentSelectedReconciliation;
    }

    private void computeTotals(ReconciliationReport reconciliationReport) {
        this.miscCostTextField.setText(reconciliationReport.getMiscCost(false, 1.0));
        this.totalCalcCostTextField.setText(reconciliationReport.getTotalCalculatedCost());
        this.totalActualCostTextField.setText(reconciliationReport.getTotalActualCost(false, 1.0));
        this.totalDeltaCostTextField.setText(reconciliationReport.getTotalDeltaCost(false, 1.0));
    }

    public void handleBillChange() {
        if (this.initializingBillValues) {
            return;
        }
        this.parentApplication.handleBillChange();
    }

    public void doRefresh() {
    }

    protected void init(EasSession easSession) {
        this.session = easSession;
        this.layout.show(this, "hide");
        this.componentDetails.init(easSession);
    }

    protected void initApplication() {
        this.parentApplication.initApplication(true);
    }

    protected EasSession getSession() {
        return this.session;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public Meter getSelectedMeter() {
        if (this.parentApplication != null) {
            return this.parentApplication.getSelectedMeter();
        }
        return null;
    }

    public BillReconciliationApplication getParentApplication() {
        return this.parentApplication;
    }

    private void selectItLater(Component component) {
        if (component instanceof JTextField) {
            final JTextField jTextField = (JTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTextField.selectAll();
                }
            });
        }
    }

    private void viewNotes() {
        if (this.currentSelectedReconciliation != null) {
            String string = this.parentApplication.getBillPeriodString() + " " + this.lex.getText("notesFor") + " " + this.parentApplication.getMeterString();
            ReconciliationNote[] reconciliationNoteArray = null;
            try {
                reconciliationNoteArray = NotesDialog.getNotes(this.currentSelectedReconciliation, string, this.getSession(), this.parentApplication, this.lex);
            }
            catch (EasException easException) {
                return;
            }
            this.parentApplication.setCursor(Cursor.getPredefinedCursor(3));
            boolean bl = false;
            ReconciliationReport reconciliationReport = this.parentApplication.loadCurrentReconciliationReport();
            if (reconciliationReport != null) {
                reconciliationReport.setReconciliationNotes(reconciliationNoteArray);
                bl = this.parentApplication.saveReconciliationReport(reconciliationReport);
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this.parentApplication, this.lex.getText("unrecoverableError"), this.lex.getText("error"), 0);
            }
            this.parentApplication.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void getPopupDetails() {
        if (this.currentSelectedReconciliation == null) {
            return;
        }
        ReconciliationComponentDetailPanel reconciliationComponentDetailPanel = new ReconciliationComponentDetailPanel(this, this.lex);
        reconciliationComponentDetailPanel.init(this.getSession());
        ScrollPaneDialog scrollPaneDialog = new ScrollPaneDialog(reconciliationComponentDetailPanel, this.parentApplication, null, "", false, this.lex);
        scrollPaneDialog.show();
        if (this.currentChartType >= 0) {
            reconciliationComponentDetailPanel.setContributionChartEditorValue(this.currentSelectedReconciliation, this.currentChartType);
        } else {
            reconciliationComponentDetailPanel.setReconciliationRowEditorValue(this.lastSelectedRow);
        }
    }

    private Font getCellFont() {
        if (this.cellFont == null) {
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            hashMap.put(TextAttribute.FAMILY, Theme.widget().getTextFont().getName());
            hashMap.put(TextAttribute.SIZE, new Float(10.0f));
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            this.cellFont = new Font(hashMap);
        }
        return this.cellFont;
    }

    private Font getHeaderFont() {
        if (this.headerFont == null) {
            this.headerFont = this.getCellFont().deriveFont(1);
        }
        return this.headerFont;
    }

    private Font getTitleFont() {
        if (this.titleFont == null) {
            this.titleFont = this.getCellFont().deriveFont(1, 14.0f);
        }
        return this.titleFont;
    }

    private Font getSubtitleFont() {
        if (this.subtitleFont == null) {
            this.subtitleFont = this.getCellFont().deriveFont(12.0f);
        }
        return this.subtitleFont;
    }

    private FontMetrics getCellFontMetrics() {
        if (this.cellFontMetrics == null) {
            this.cellFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getCellFont());
        }
        return this.cellFontMetrics;
    }

    private FontMetrics getHeaderFontMetrics() {
        if (this.headerFontMetrics == null) {
            this.headerFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getHeaderFont());
        }
        return this.headerFontMetrics;
    }

    private FontMetrics getTitleFontMetrics() {
        if (this.titleFontMetrics == null) {
            this.titleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getTitleFont());
        }
        return this.titleFontMetrics;
    }

    private FontMetrics getSubtitleFontMetrics() {
        if (this.subtitleFontMetrics == null) {
            this.subtitleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getSubtitleFont());
        }
        return this.subtitleFontMetrics;
    }

    private double calculatePreferredColumnWidth(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = this.lex.getText("calculatedCost");
                break;
            }
            case 2: {
                string = this.lex.getText("actualCost");
                break;
            }
            case 3: {
                string = this.lex.getText("deltaCost");
            }
        }
        int n2 = this.getHeaderFontMetrics().stringWidth(string);
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        for (int i = 0; i < this.reportRows.length; ++i) {
            String string2 = "";
            switch (n) {
                case 0: {
                    string2 = this.reportRows[i].getShowCostColumns() ? this.reportRows[i].getDisplayName(this.lex) : this.lex.getText("rate") + "  " + this.reportRows[i].getDisplayName(this.lex);
                    break;
                }
                case 1: {
                    if (!this.reportRows[i].getShowCostColumns()) break;
                    string2 = decimalFormat.format(this.reportRows[i].getCalculatedCost());
                    break;
                }
                case 2: {
                    if (!this.reportRows[i].getShowCostColumns()) break;
                    string2 = decimalFormat.format(this.reportRows[i].getActualCost(false, 1.0));
                    break;
                }
                case 3: {
                    if (!this.reportRows[i].getShowCostColumns()) break;
                    string2 = decimalFormat.format(this.reportRows[i].getDeltaCost(false, 1.0));
                }
            }
            n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string2));
        }
        if (n == 0) {
            n2 = Math.max(n2, this.getHeaderFontMetrics().stringWidth(this.lex.getText("miscCost")));
        } else if (n == 2) {
            n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(decimalFormat.format(this.currentSelectedReconciliation.getMiscCost(false, 1.0))));
        }
        if (n == 0) {
            n2 = Math.max(n2, this.getHeaderFontMetrics().stringWidth(this.lex.getText("totals")));
        } else {
            String string3 = "";
            switch (n) {
                case 1: {
                    string3 = decimalFormat.format(this.currentSelectedReconciliation.getTotalCalculatedCost());
                    break;
                }
                case 2: {
                    string3 = decimalFormat.format(this.currentSelectedReconciliation.getTotalActualCost(false, 1.0));
                    break;
                }
                case 3: {
                    string3 = decimalFormat.format(this.currentSelectedReconciliation.getTotalDeltaCost(false, 1.0));
                }
            }
            n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string3));
        }
        return n2 + 7;
    }

    private ArrayList filterLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (!stringTokenizer.hasMoreTokens()) {
            arrayList.add(string);
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private ArrayList getCellLines(String string, FontMetrics fontMetrics, double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = this.filterLines(string);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if ((double)fontMetrics.stringWidth(string2) <= d) {
                arrayList.add(string2);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                StringBuffer stringBuffer2 = new StringBuffer().append(stringBuffer.toString());
                String string4 = stringBuffer.length() == 0 ? "" : " ";
                if ((double)fontMetrics.stringWidth(stringBuffer2.append(string4).append(string3).toString()) > d) {
                    if (stringBuffer.length() == 0) {
                        stringBuffer = new StringBuffer(string3);
                        while ((double)fontMetrics.stringWidth(stringBuffer.toString()) > d) {
                            StringBuffer stringBuffer3 = new StringBuffer();
                            while ((double)fontMetrics.stringWidth(stringBuffer3.toString()) <= d) {
                                stringBuffer3.append(stringBuffer.charAt(0));
                                stringBuffer.deleteCharAt(0);
                            }
                            arrayList.add(stringBuffer3.toString());
                        }
                        continue;
                    }
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string3);
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string3);
            }
            if (stringBuffer.length() <= 0) continue;
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public int getEstimateNumPages() {
        return this.currentPage + 1;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        double d;
        int n12;
        int n13;
        int n14;
        Iterator iterator;
        this.currentPage = 0;
        if (this.currentSelectedReconciliation == null) {
            this.currentPage = -1;
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n15 = 3;
        int n16 = 1;
        int n17 = 0;
        int n18 = (int)pageFormat.getImageableWidth();
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getTitleFont());
        ArrayList arrayList = this.getCellLines(this.lex.getText("billReconcile"), this.getTitleFontMetrics(), n18);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            iterator = (String)object.next();
            int n19 = this.getTitleFontMetrics().stringWidth((String)((Object)iterator));
            n14 = n18 / 2 - n19 / 2;
            n13 = n17 + n15 + this.getTitleFontMetrics().getHeight() - this.getTitleFontMetrics().getDescent();
            if (this.currentPage == n) {
                graphics2D.drawString((String)((Object)iterator), n14, n13);
            }
            n17 += n15 + this.getTitleFontMetrics().getHeight();
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        object = this.getCellLines(this.lex.getText("meter") + ":  " + this.parentApplication.getMeterString(), this.getSubtitleFontMetrics(), n18);
        iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n14 = this.getSubtitleFontMetrics().stringWidth(string);
            n13 = n18 / 2 - n14 / 2;
            n12 = n17 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            if ((double)n12 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n12 = n17 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n13, n12);
            }
            n17 += n15 + this.getSubtitleFontMetrics().getHeight();
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        object = this.getCellLines(this.lex.getText("billPeriod") + ":  " + this.parentApplication.getBillPeriodString(), this.getSubtitleFontMetrics(), n18);
        iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n14 = this.getSubtitleFontMetrics().stringWidth(string);
            n13 = n18 / 2 - n14 / 2;
            n12 = n17 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            if ((double)n12 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n12 = n17 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n13, n12);
            }
            n17 += n15 + this.getSubtitleFontMetrics().getHeight();
        }
        int n20 = n17 += n15 + this.getSubtitleFontMetrics().getHeight();
        graphics2D.setFont(this.getHeaderFont());
        Color color = new Color(153, 153, 153);
        graphics2D.setColor(color);
        double d2 = 0.0;
        double d3 = d = this.calculatePreferredColumnWidth(0);
        d2 += d;
        ArrayList arrayList2 = this.getCellLines(this.lex.getText("calculatedCost"), this.getHeaderFontMetrics(), n18);
        double d4 = d = this.calculatePreferredColumnWidth(1);
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = (String)arrayList2.get(i);
            n11 = this.getHeaderFontMetrics().stringWidth(string);
            int n21 = (int)(d2 + d / 2.0 - (double)(n11 / 2));
            n10 = n17 + n15 + (i + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n10 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n10 = n17 + n15 + (i + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n21, n10);
        }
        d2 += d;
        arrayList2 = this.getCellLines(this.lex.getText("actualCost"), this.getHeaderFontMetrics(), n18);
        double d5 = d = this.calculatePreferredColumnWidth(2);
        for (n11 = 0; n11 < arrayList2.size(); ++n11) {
            String string = (String)arrayList2.get(n11);
            n10 = this.getHeaderFontMetrics().stringWidth(string);
            int n22 = (int)(d2 + d / 2.0 - (double)(n10 / 2));
            n9 = n17 + n15 + (n11 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n9 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n9 = n17 + n15 + (n11 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n22, n9);
        }
        d2 += d;
        arrayList2 = this.getCellLines(this.lex.getText("deltaCost"), this.getHeaderFontMetrics(), n18);
        double d6 = d = this.calculatePreferredColumnWidth(3);
        for (n10 = 0; n10 < arrayList2.size(); ++n10) {
            String string = (String)arrayList2.get(n10);
            n9 = this.getHeaderFontMetrics().stringWidth(string);
            n8 = (int)(d2 + d / 2.0 - (double)(n9 / 2));
            int n23 = n17 + n15 + (n10 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n23 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n23 = n17 + n15 + (n10 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n8, n23);
        }
        n17 += n15 + this.getHeaderFontMetrics().getHeight();
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getCellFont());
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        for (n7 = 0; n7 < this.reportRows.length; ++n7) {
            int n24;
            n9 = 0;
            n8 = (int)(d3 - (double)n15 - (double)n15 - (double)n16);
            d2 = 0.0;
            ArrayList arrayList3 = this.getCellLines(this.reportRows[n7].getShowCostColumns() ? this.reportRows[n7].getDisplayName(this.lex) : this.lex.getText("rate") + "  " + this.reportRows[n7].getDisplayName(this.lex), this.getCellFontMetrics(), n8);
            for (n24 = 0; n24 < arrayList3.size(); ++n24) {
                String string = (String)arrayList3.get(n24);
                int n25 = this.getCellFontMetrics().stringWidth(string);
                n6 = (int)(d2 + (double)n15);
                n5 = n17 + n15 + (n24 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n5 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n17 = 0;
                    n5 = n17 + n15 + (n24 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string, n6, n5);
            }
            n24 = this.getCellFontMetrics().getHeight() * arrayList3.size() + n15 + n15 + n16;
            n9 = Math.max(n24, n9);
            if (this.reportRows[n7].getShowCostColumns()) {
                int n26;
                d2 += d3;
                n8 = (int)(d4 - (double)n15 - (double)n15 - (double)n16);
                arrayList3 = this.getCellLines(decimalFormat.format(this.reportRows[n7].getCalculatedCost()), this.getCellFontMetrics(), n8);
                for (n26 = 0; n26 < arrayList3.size(); ++n26) {
                    String string = (String)arrayList3.get(n26);
                    n6 = this.getCellFontMetrics().stringWidth(string);
                    n5 = (int)(d2 + d4 - (double)n15 - (double)n6);
                    n4 = n17 + n15 + (n26 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    if ((double)n4 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n17 = 0;
                        n4 = n17 + n15 + (n26 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    }
                    if (this.currentPage != n) continue;
                    graphics2D.drawString(string, n5, n4);
                }
                n24 = this.getCellFontMetrics().getHeight() * arrayList3.size() + n15 + n15 + n16;
                n9 = Math.max(n24, n9);
                d2 += d4;
                n8 = (int)(d5 - (double)n15 - (double)n15 - (double)n16);
                arrayList3 = this.getCellLines(decimalFormat.format(this.reportRows[n7].getActualCost(false, 1.0)), this.getCellFontMetrics(), n8);
                for (n26 = 0; n26 < arrayList3.size(); ++n26) {
                    String string = (String)arrayList3.get(n26);
                    n6 = this.getCellFontMetrics().stringWidth(string);
                    n5 = (int)(d2 + d5 - (double)n15 - (double)n6);
                    n4 = n17 + n15 + (n26 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    if ((double)n4 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n17 = 0;
                        n4 = n17 + n15 + (n26 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    }
                    if (this.currentPage != n) continue;
                    graphics2D.drawString(string, n5, n4);
                }
                n24 = this.getCellFontMetrics().getHeight() * arrayList3.size() + n15 + n15 + n16;
                n9 = Math.max(n24, n9);
                d2 += d5;
                n8 = (int)(d6 - (double)n15 - (double)n15 - (double)n16);
                arrayList3 = this.getCellLines(decimalFormat.format(this.reportRows[n7].getDeltaCost(false, 1.0)), this.getCellFontMetrics(), n8);
                for (n26 = 0; n26 < arrayList3.size(); ++n26) {
                    String string = (String)arrayList3.get(n26);
                    n6 = this.getCellFontMetrics().stringWidth(string);
                    n5 = (int)(d2 + d6 - (double)n15 - (double)n6);
                    n4 = n17 + n15 + (n26 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    if ((double)n4 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n17 = 0;
                        n4 = n17 + n15 + (n26 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    }
                    if (this.currentPage != n) continue;
                    graphics2D.drawString(string, n5, n4);
                }
                n24 = this.getCellFontMetrics().getHeight() * arrayList3.size() + n15 + n15 + n16;
                n9 = Math.max(n24, n9);
            }
            n17 += n9;
        }
        graphics2D.setColor(color);
        graphics2D.setFont(this.getHeaderFont());
        n7 = 0;
        n9 = (int)(d3 - (double)n15 - (double)n15 - (double)n16);
        d2 = 0.0;
        ArrayList arrayList4 = this.getCellLines(this.lex.getText("miscCost"), this.getHeaderFontMetrics(), n9);
        for (n3 = 0; n3 < arrayList4.size(); ++n3) {
            String string = (String)arrayList4.get(n3);
            int n27 = this.getHeaderFontMetrics().stringWidth(string);
            int n28 = (int)(d2 + (double)n15);
            n6 = n17 + n15 + (n3 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n6 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n6 = n17 + n15 + (n3 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n28, n6);
        }
        n3 = this.getHeaderFontMetrics().getHeight() * arrayList4.size() + n15 + n15 + n16;
        n7 = Math.max(n3, n7);
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getCellFont());
        d2 += d3 + d4;
        n9 = (int)(d5 - (double)n15 - (double)n15 - (double)n16);
        arrayList4 = this.getCellLines(decimalFormat.format(this.currentSelectedReconciliation.getMiscCost(false, 1.0)), this.getCellFontMetrics(), n9);
        for (n2 = 0; n2 < arrayList4.size(); ++n2) {
            String string = (String)arrayList4.get(n2);
            int n29 = this.getCellFontMetrics().stringWidth(string);
            n6 = (int)(d2 + d5 - (double)n15 - (double)n29);
            n5 = n17 + n15 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n5 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n5 = n17 + n15 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n6, n5);
        }
        n3 = this.getCellFontMetrics().getHeight() * arrayList4.size() + n15 + n15 + n16;
        n7 = Math.max(n3, n7);
        n17 += n7;
        graphics2D.setColor(color);
        graphics2D.setFont(this.getHeaderFont());
        n7 = 0;
        n9 = (int)(d3 - (double)n15 - (double)n15 - (double)n16);
        d2 = 0.0;
        arrayList4 = this.getCellLines(this.lex.getText("totals"), this.getHeaderFontMetrics(), n9);
        for (n2 = 0; n2 < arrayList4.size(); ++n2) {
            String string = (String)arrayList4.get(n2);
            int n30 = this.getHeaderFontMetrics().stringWidth(string);
            n6 = (int)(d2 + (double)n15);
            n5 = n17 + n15 + (n2 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n5 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n5 = n17 + n15 + (n2 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n6, n5);
        }
        n3 = this.getHeaderFontMetrics().getHeight() * arrayList4.size() + n15 + n15 + n16;
        n7 = Math.max(n3, n7);
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getCellFont());
        d2 += d3;
        n9 = (int)(d4 - (double)n15 - (double)n15 - (double)n16);
        arrayList4 = this.getCellLines(decimalFormat.format(this.currentSelectedReconciliation.getTotalCalculatedCost()), this.getCellFontMetrics(), n9);
        for (n2 = 0; n2 < arrayList4.size(); ++n2) {
            String string = (String)arrayList4.get(n2);
            int n31 = this.getCellFontMetrics().stringWidth(string);
            n6 = (int)(d2 + d4 - (double)n15 - (double)n31);
            n5 = n17 + n15 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n5 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n5 = n17 + n15 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n6, n5);
        }
        n3 = this.getCellFontMetrics().getHeight() * arrayList4.size() + n15 + n15 + n16;
        n7 = Math.max(n3, n7);
        d2 += d4;
        n9 = (int)(d5 - (double)n15 - (double)n15 - (double)n16);
        arrayList4 = this.getCellLines(decimalFormat.format(this.currentSelectedReconciliation.getTotalActualCost(false, 1.0)), this.getCellFontMetrics(), n9);
        for (n2 = 0; n2 < arrayList4.size(); ++n2) {
            String string = (String)arrayList4.get(n2);
            int n32 = this.getCellFontMetrics().stringWidth(string);
            n6 = (int)(d2 + d5 - (double)n15 - (double)n32);
            n5 = n17 + n15 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n5 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n5 = n17 + n15 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n6, n5);
        }
        n3 = this.getCellFontMetrics().getHeight() * arrayList4.size() + n15 + n15 + n16;
        n7 = Math.max(n3, n7);
        d2 += d5;
        n9 = (int)(d6 - (double)n15 - (double)n15 - (double)n16);
        arrayList4 = this.getCellLines(decimalFormat.format(this.currentSelectedReconciliation.getTotalDeltaCost(false, 1.0)), this.getCellFontMetrics(), n9);
        for (n2 = 0; n2 < arrayList4.size(); ++n2) {
            String string = (String)arrayList4.get(n2);
            int n33 = this.getCellFontMetrics().stringWidth(string);
            n6 = (int)(d2 + d6 - (double)n15 - (double)n33);
            n5 = n17 + n15 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n5 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n17 = 0;
                n5 = n17 + n15 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n6, n5);
        }
        n3 = this.getCellFontMetrics().getHeight() * arrayList4.size() + n15 + n15 + n16;
        n7 = Math.max(n3, n7);
        n17 += n7;
        n17 += n15 + this.getSubtitleFontMetrics().getHeight();
        ReconciliationNote[] reconciliationNoteArray = this.currentSelectedReconciliation.getReconciliationNotes();
        if (reconciliationNoteArray != null && reconciliationNoteArray.length > 0) {
            graphics2D.setFont(this.getSubtitleFont());
            object = this.getCellLines(this.parentApplication.getBillPeriodString() + " " + this.lex.getText("notesFor") + " " + this.parentApplication.getMeterString(), this.getSubtitleFontMetrics(), n18);
            Iterator iterator2 = ((ArrayList)object).iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                n6 = this.getSubtitleFontMetrics().stringWidth(string);
                n5 = n18 / 2 - n6 / 2;
                n4 = n17 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
                if ((double)n4 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n17 = 0;
                    n4 = n17 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
                }
                if (this.currentPage == n) {
                    graphics2D.drawString(string, n5, n4);
                }
                n17 += n15 + this.getSubtitleFontMetrics().getHeight();
            }
            graphics2D.setFont(this.getCellFont());
            for (int i = 0; i < reconciliationNoteArray.length; ++i) {
                arrayList4 = this.getCellLines(reconciliationNoteArray[i].toDisplayString(this.lex), this.getCellFontMetrics(), n18);
                Iterator iterator3 = arrayList4.iterator();
                while (iterator3.hasNext()) {
                    String string = (String)iterator3.next();
                    n5 = this.getCellFontMetrics().stringWidth(string);
                    n4 = n15;
                    int n34 = n17 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    if ((double)n34 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n17 = 0;
                        n34 = n17 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    }
                    if (this.currentPage == n) {
                        graphics2D.drawString(string, n4, n34);
                    }
                    n17 += n15 + this.getCellFontMetrics().getHeight();
                }
                n17 += n15 + this.getCellFontMetrics().getHeight();
            }
        }
        if (this.currentPage < n) {
            return 1;
        }
        return 0;
    }

    private class LabelRowPair {
        private JLabel label;
        private ReconciliationRow row;

        public LabelRowPair(JLabel jLabel, ReconciliationRow reconciliationRow) {
            this.label = jLabel;
            this.row = reconciliationRow;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public ReconciliationRow getRow() {
            return this.row;
        }
    }

    private class ReconciliationHeaderMouseAdapter
    extends MouseAdapter {
        private int type;

        public ReconciliationHeaderMouseAdapter(int n) {
            this.type = n;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == BillReconciliationDetailPanel.this.lastSelectedLabel) {
                return;
            }
            if (BillReconciliationDetailPanel.this.lastSelectedLabel != null) {
                BillReconciliationDetailPanel.this.lastSelectedLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            jLabel.setBorder(BorderFactory.createBevelBorder(1, Color.red, Color.red));
            BillReconciliationDetailPanel.this.lastSelectedLabel = jLabel;
            BillReconciliationDetailPanel.this.currentChartType = this.type;
            BillReconciliationDetailPanel.this.componentDetails.setContributionChartEditorValue(BillReconciliationDetailPanel.this.currentSelectedReconciliation, this.type);
            BillReconciliationDetailPanel.this.lastSelectedRow = null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == BillReconciliationDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == BillReconciliationDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    private class ReconciliationMouseAdapter
    extends MouseAdapter {
        private ReconciliationRow referenceRow;

        public ReconciliationMouseAdapter(ReconciliationRow reconciliationRow) {
            this.referenceRow = reconciliationRow;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == BillReconciliationDetailPanel.this.lastSelectedLabel) {
                return;
            }
            if (BillReconciliationDetailPanel.this.lastSelectedLabel != null) {
                BillReconciliationDetailPanel.this.lastSelectedLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            jLabel.setBorder(BorderFactory.createBevelBorder(1, Color.red, Color.red));
            BillReconciliationDetailPanel.this.lastSelectedLabel = jLabel;
            BillReconciliationDetailPanel.this.currentChartType = -1;
            BillReconciliationDetailPanel.this.componentDetails.setReconciliationRowEditorValue(this.referenceRow);
            BillReconciliationDetailPanel.this.lastSelectedRow = this.referenceRow;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == BillReconciliationDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == BillReconciliationDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    private class ActualCostFocusAdapter
    extends FocusAdapter {
        private NumberTextField actualTextField;
        private NumberTextField deltaTextField;
        private ReconciliationRow referenceRow;

        public ActualCostFocusAdapter(NumberTextField numberTextField, NumberTextField numberTextField2, ReconciliationRow reconciliationRow) {
            this.referenceRow = reconciliationRow;
            this.deltaTextField = numberTextField2;
            this.actualTextField = numberTextField;
        }

        public void focusGained(FocusEvent focusEvent) {
            BillReconciliationDetailPanel.this.selectItLater(focusEvent.getComponent());
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!BillReconciliationDetailPanel.this.changeOccurred) {
                return;
            }
            this.actualTextField.setText(this.referenceRow.getActualCost(false, 1.0));
            this.deltaTextField.setText(this.referenceRow.getDeltaCost(false, 1.0));
            BillReconciliationDetailPanel.this.computeTotals(BillReconciliationDetailPanel.this.currentSelectedReconciliation);
            if (BillReconciliationDetailPanel.this.lastSelectedRow == this.referenceRow) {
                BillReconciliationDetailPanel.this.componentDetails.setReconciliationRowEditorValue(BillReconciliationDetailPanel.this.lastSelectedRow);
                BillReconciliationDetailPanel.this.currentChartType = -1;
            } else if (BillReconciliationDetailPanel.this.currentChartType >= 0) {
                BillReconciliationDetailPanel.this.componentDetails.setContributionChartEditorValue(BillReconciliationDetailPanel.this.currentSelectedReconciliation, BillReconciliationDetailPanel.this.currentChartType);
            }
            BillReconciliationDetailPanel.this.changeOccurred = false;
        }
    }

    private class ActualCostKeyAdapter
    extends KeyAdapter {
        private NumberTextField actualTextField;
        private NumberTextField deltaTextField;
        private ReconciliationRow referenceRow;

        public ActualCostKeyAdapter(NumberTextField numberTextField, NumberTextField numberTextField2, ReconciliationRow reconciliationRow) {
            this.referenceRow = reconciliationRow;
            this.deltaTextField = numberTextField2;
            this.actualTextField = numberTextField;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                if (!BillReconciliationDetailPanel.this.changeOccurred) {
                    return;
                }
                this.actualTextField.setText(this.referenceRow.getActualCost(false, 1.0));
                this.deltaTextField.setText(this.referenceRow.getDeltaCost(false, 1.0));
                BillReconciliationDetailPanel.this.computeTotals(BillReconciliationDetailPanel.this.currentSelectedReconciliation);
                if (BillReconciliationDetailPanel.this.lastSelectedRow == this.referenceRow) {
                    BillReconciliationDetailPanel.this.componentDetails.setReconciliationRowEditorValue(BillReconciliationDetailPanel.this.lastSelectedRow);
                    BillReconciliationDetailPanel.this.currentChartType = -1;
                } else if (BillReconciliationDetailPanel.this.currentChartType >= 0) {
                    BillReconciliationDetailPanel.this.componentDetails.setContributionChartEditorValue(BillReconciliationDetailPanel.this.currentSelectedReconciliation, BillReconciliationDetailPanel.this.currentChartType);
                }
                BillReconciliationDetailPanel.this.changeOccurred = false;
            }
        }
    }

    private class ActualCostListener
    implements DocumentListener {
        private NumberTextField referenceTextField;
        private ReconciliationRow referenceRow;

        public ActualCostListener(NumberTextField numberTextField, ReconciliationRow reconciliationRow) {
            this.referenceTextField = numberTextField;
            this.referenceRow = reconciliationRow;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (BillReconciliationDetailPanel.this.initializingBillValues) {
                return;
            }
            try {
                this.referenceRow.setActualCost(this.referenceTextField.getDoubleValue());
                this.referenceRow.setActualCostSet(true);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            BillReconciliationDetailPanel.this.changeOccurred = true;
            BillReconciliationDetailPanel.this.handleBillChange();
        }
    }
}

