/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.contribution;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.reports.contribution.CostContributionParameters;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.reports.MeterInputItem;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.util.CompoundUnitUtil;
import java.awt.Color;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.ProgressMonitor;

public class CostContributionSeries
extends Series
implements ValueColors {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final BUnit COST_UNITS = BUnit.make((String)"cost", (String)"cost", (BDimension)BDimension.make((int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)1));
    private CostContributionParameters params;
    private CostRank[] ranking;
    private double[] range;
    private Lexicon lex;
    private boolean useCalc = true;
    private String[] componentList = null;
    private boolean floorAreaNormalized = false;

    public CostContributionSeries(CostContributionParameters costContributionParameters, Lexicon lexicon) {
        this.params = costContributionParameters;
        this.lex = lexicon;
        this.useCalc = costContributionParameters.useCalculated();
    }

    public String getSeriesName() {
        return null;
    }

    public ReportInput getInput(int n) {
        int n2 = n;
        if (this.params.getApplyBaseline()) {
            n2 /= 2;
        }
        if (this.ranking == null || n2 >= this.ranking.length || this.ranking[n2] == null) {
            return null;
        }
        if (this.params.getApplyBaseline() && n % 2 != 0) {
            ReportInput reportInput = this.ranking[n2].getInput().getCopy();
            reportInput.setName(this.lex.getText("baseline") + ": " + reportInput.getName());
            return reportInput;
        }
        return this.ranking[n2].getInput();
    }

    public void load(EasSession easSession, InputList inputList, ProgressMonitor progressMonitor, boolean bl) {
        boolean bl2 = this.params.isNormalizedByFloorArea();
        boolean bl3 = this.params.isNormalizedByTemperature();
        BUnit bUnit = this.params.getNormalTemperatureUnit();
        double d = this.params.getNormalTemperature();
        boolean bl4 = this.params.getApplyBaseline();
        String string = this.params.getBaselineBillingCycle();
        boolean bl5 = this.params.getDataCleanse();
        int n = this.params.getDataCleanseWindow();
        double d2 = this.params.getDataCleansePercentage();
        this.range = null;
        this.componentList = null;
        String string2 = this.params.getBillingCycle();
        int n2 = this.params.getNumBillingCycles();
        ReportInput[] reportInputArray = this.params.getInputs();
        if (reportInputArray != null && reportInputArray.length != 0) {
            int n3;
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < reportInputArray.length; ++n4) {
                n5 += reportInputArray[n4].getInputItemCount() * n2;
            }
            if (bl4) {
                n5 *= 2;
            }
            progressMonitor.setMinimum(1);
            progressMonitor.setMaximum(n5 + 1);
            n4 = 1;
            CostRank[] costRankArray = new CostRank[reportInputArray.length];
            for (n3 = 0; n3 < reportInputArray.length; ++n3) {
                String string3 = string2;
                String string4 = string;
                try {
                    ReconciliationReport[] reconciliationReportArray = new ReconciliationReport[reportInputArray[n3].getInputItemCount() * n2];
                    ReconciliationReport[] reconciliationReportArray2 = new ReconciliationReport[reportInputArray[n3].getInputItemCount() * n2];
                    int n6 = 0;
                    BUnit bUnit2 = null;
                    double d3 = 1.0;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < reportInputArray[n3].getInputItemCount() && !progressMonitor.isCanceled(); ++j) {
                            Meter meter = ((MeterInputItem)reportInputArray[n3].getInputItem(j)).getMeter();
                            if (bUnit2 == null) {
                                bUnit2 = meter.getFloorAreaUnit();
                                d3 = meter.getFloorAreaValue();
                            }
                            String string5 = "meter" + meter.getId();
                            String string6 = string5 + "_" + string3;
                            String string7 = "meter" + meter.getId();
                            progressMonitor.setNote((meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName() + " " + CostContributionSeries.toBillPeriodString(string3, this.lex));
                            progressMonitor.setProgress(n4);
                            boolean bl6 = reportInputArray[n3].hasNormalizingPoint();
                            DataPoint dataPoint = reportInputArray[n3].getNormalizingPoint();
                            reconciliationReportArray[n6] = CostContributionSeries.loadMeterReport(easSession, string5, string6, string3, string7, bl2, bl3, bUnit, d, bl5, n, d2, bl6, dataPoint);
                            ++n4;
                            if (bl4) {
                                if (progressMonitor.isCanceled()) break;
                                string6 = string5 + "_" + string4;
                                progressMonitor.setNote(this.lex.getText("baseline") + ": " + (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName() + " " + CostContributionSeries.toBillPeriodString(string4, this.lex));
                                progressMonitor.setProgress(n4);
                                reconciliationReportArray2[n6] = CostContributionSeries.loadMeterReport(easSession, string5, string6, string4, string7, bl2, bl3, bUnit, d, bl5, n, d2, bl6, dataPoint);
                                ++n4;
                            }
                            ++n6;
                        }
                        if (progressMonitor.isCanceled()) break;
                        string3 = CostContributionSeries.getNextBillPeriod(string3);
                        string4 = CostContributionSeries.getNextBillPeriod(string4);
                    }
                    if (progressMonitor.isCanceled()) break;
                    costRankArray[n3] = new CostRank(reportInputArray[n3].getCopy(), reconciliationReportArray, reconciliationReportArray2, d3, bUnit2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (progressMonitor.isCanceled()) {
                return;
            }
            this.floorAreaNormalized = bl2;
            this.ranking = costRankArray;
            this.useCalc = this.params.useCalculated();
            this.sortRanking(ReconciliationReport.TOTAL_COST, this.useCalc);
            if (bl) {
                inputList.getModel().removeAllInputs();
                if (this.ranking != null) {
                    for (n3 = 0; n3 < this.ranking.length; ++n3) {
                        this.ranking[n3].getInput().setColor(this.getChartColorByIndex(n3));
                        inputList.getModel().addInput(this.ranking[n3].getInput());
                    }
                }
            }
        } else {
            this.ranking = null;
        }
    }

    public void sortRanking(String string, boolean bl) {
        this.range = null;
    }

    private Color getChartColorByIndex(int n) {
        if (n > ChartColors.getColorCount() - 1) {
            return ChartColors.getOverflowColor();
        }
        return ChartColors.getColor(n);
    }

    public void setUseCalculated(boolean bl) {
        this.range = null;
        this.useCalc = bl;
    }

    private static String toBillPeriodString(String string, Lexicon lexicon) {
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        return lexicon.getText(string2) + " " + string3;
    }

    private static ReconciliationReport loadMeterReport(EasSession easSession, String string, String string2, String string3, String string4, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        try {
            ReconciliationReport reconciliationReport = EasCostClient.retrieveReconciliationReport(easSession, string, string2, string3, true, true, string4, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
            if (reconciliationReport == null) {
                reconciliationReport = EasCostClient.retrieveReconciliationReport(easSession, string, string, string3, true, true, string4, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
            }
            return reconciliationReport;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String getNextBillPeriod(String string) {
        int n = -2;
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = string2;
        if (string2.equals("Jan")) {
            string4 = "Feb";
        } else if (string2.equals("Feb")) {
            string4 = "Mar";
        } else if (string2.equals("Mar")) {
            string4 = "Apr";
        } else if (string2.equals("Apr")) {
            string4 = "May";
        } else if (string2.equals("May")) {
            string4 = "Jun";
        } else if (string2.equals("Jun")) {
            string4 = "Jul";
        } else if (string2.equals("Jul")) {
            string4 = "Aug";
        } else if (string2.equals("Aug")) {
            string4 = "Sep";
        } else if (string2.equals("Sep")) {
            string4 = "Oct";
        } else if (string2.equals("Oct")) {
            string4 = "Nov";
        } else if (string2.equals("Nov")) {
            string4 = "Dec";
        } else if (string2.equals("Dec")) {
            string4 = "Jan";
            ++n;
        }
        if (n >= 0) {
            string3 = String.valueOf(n);
        }
        return string4 + string3;
    }

    public int getRowCount() {
        if (this.ranking == null) {
            return 0;
        }
        if (this.params.getApplyBaseline()) {
            return this.ranking.length * 2;
        }
        return this.ranking.length;
    }

    public String getRowName(int n) {
        if (this.ranking == null) {
            return null;
        }
        int n2 = n;
        if (this.params.getApplyBaseline()) {
            n2 /= 2;
        }
        try {
            if (this.ranking[n2] == null) {
                return null;
            }
            return (this.params.getApplyBaseline() && n % 2 != 0 ? this.lex.getText("baseline") + ": " : "") + this.ranking[n2].getInput().getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Error";
        }
    }

    public int getValueCount() {
        return 7;
    }

    public int getValueType() {
        return 0;
    }

    public double getValue(int n, int n2) {
        ReconciliationReport[] reconciliationReportArray;
        int n3 = n;
        if (this.params.getApplyBaseline()) {
            n3 /= 2;
        }
        if (this.ranking == null || n3 >= this.ranking.length || this.ranking[n3] == null) {
            return 0.0;
        }
        ReconciliationReport[] reconciliationReportArray2 = reconciliationReportArray = this.params.getApplyBaseline() && n % 2 != 0 ? this.ranking[n3].getBaselineResult() : this.ranking[n3].getResult();
        if (reconciliationReportArray == null) {
            return 0.0;
        }
        switch (n2) {
            case 0: {
                return CostContributionSeries.getValue(reconciliationReportArray, ReconciliationReport.CATEGORY_CONSUMPTION_COST, this.useCalc, this.getFloorAreaNorm(), this.ranking[n3].getFloorAreaValue());
            }
            case 1: {
                return CostContributionSeries.getValue(reconciliationReportArray, ReconciliationReport.CATEGORY_DEMAND_COST, this.useCalc, this.getFloorAreaNorm(), this.ranking[n3].getFloorAreaValue());
            }
            case 2: {
                return CostContributionSeries.getValue(reconciliationReportArray, ReconciliationReport.CATEGORY_OTHER_COST, this.useCalc, this.getFloorAreaNorm(), this.ranking[n3].getFloorAreaValue());
            }
            case 3: {
                return CostContributionSeries.getValue(reconciliationReportArray, ReconciliationReport.CATEGORY_USER_DEF1_COST, this.useCalc, this.getFloorAreaNorm(), this.ranking[n3].getFloorAreaValue());
            }
            case 4: {
                return CostContributionSeries.getValue(reconciliationReportArray, ReconciliationReport.CATEGORY_USER_DEF2_COST, this.useCalc, this.getFloorAreaNorm(), this.ranking[n3].getFloorAreaValue());
            }
            case 5: {
                return CostContributionSeries.getValue(reconciliationReportArray, ReconciliationReport.CATEGORY_USER_DEF3_COST, this.useCalc, this.getFloorAreaNorm(), this.ranking[n3].getFloorAreaValue());
            }
            case 6: {
                return CostContributionSeries.getValue(reconciliationReportArray, ReconciliationReport.CATEGORY_USER_DEF4_COST, this.useCalc, this.getFloorAreaNorm(), this.ranking[n3].getFloorAreaValue());
            }
        }
        return 0.0;
    }

    public double getValue(int n, int n2, String string) {
        ReconciliationReport[] reconciliationReportArray;
        int n3 = n;
        if (this.params.getApplyBaseline()) {
            n3 /= 2;
        }
        if (this.ranking == null || n3 >= this.ranking.length || this.ranking[n3] == null) {
            return 0.0;
        }
        ReconciliationReport[] reconciliationReportArray2 = reconciliationReportArray = this.params.getApplyBaseline() && n % 2 != 0 ? this.ranking[n3].getBaselineResult() : this.ranking[n3].getResult();
        if (reconciliationReportArray == null) {
            return 0.0;
        }
        return CostContributionSeries.getValue(reconciliationReportArray, string, this.useCalc, this.getFloorAreaNorm(), this.ranking[n3].getFloorAreaValue());
    }

    private static double getValue(ReconciliationReport[] reconciliationReportArray, String string, boolean bl, boolean bl2, double d) {
        double d2 = 0.0;
        if (reconciliationReportArray != null) {
            for (int i = 0; i < reconciliationReportArray.length; ++i) {
                if (reconciliationReportArray[i] == null) continue;
                d2 += reconciliationReportArray[i].getComponentCost(string, bl, bl2, d);
            }
        }
        return d2;
    }

    public Color getValueColor(int n) {
        return this.getChartColorByIndex(n);
    }

    public double getMin(int n) {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[0];
    }

    public double getMax(int n) {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[1];
    }

    private void computeRange() {
        this.range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            double d = this.getValue(i, i, ReconciliationReport.TOTAL_COST);
            this.range[0] = Math.min(this.range[0], d);
            this.range[1] = Math.max(this.range[1], d);
        }
        if (this.range[0] == this.range[1]) {
            this.range[1] = this.range[1] + 100.0;
        }
    }

    public double getMinRowTotal() {
        return this.getMin();
    }

    public double getMaxRowTotal() {
        return this.getMax();
    }

    public BUnit getValueUnits() {
        if (this.ranking == null || this.ranking.length == 0 || this.ranking[0] == null) {
            return COST_UNITS;
        }
        for (int i = 0; i < this.ranking.length; ++i) {
            ReconciliationReport[] reconciliationReportArray = this.ranking[i].getResult();
            if (reconciliationReportArray == null) continue;
            for (int j = 0; j < reconciliationReportArray.length; ++j) {
                ReconciliationRow[] reconciliationRowArray;
                if (reconciliationReportArray[j] == null || (reconciliationRowArray = reconciliationReportArray[j].getReconciliationRows()) == null) continue;
                for (int k = 0; k < reconciliationRowArray.length; ++k) {
                    if (!reconciliationRowArray[k].getShowCostColumns()) continue;
                    BUnit bUnit = reconciliationRowArray[k].getCurrency();
                    try {
                        if (this.ranking[i].getInput().hasNormalizingPoint()) {
                            bUnit = CompoundUnitUtil.make(bUnit, this.ranking[i].getInput().getNormalizingPoint().getUnit());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (this.floorAreaNormalized) {
                        bUnit = CompoundUnitUtil.make(bUnit, this.ranking[i].getFloorAreaUnit());
                    }
                    return bUnit;
                }
            }
        }
        return COST_UNITS;
    }

    public BUnit getValueUnits(int n, int n2) {
        ReconciliationReport[] reconciliationReportArray;
        int n3 = n;
        if (this.params.getApplyBaseline()) {
            n3 /= 2;
        }
        if (this.ranking == null || n3 >= this.ranking.length || this.ranking[n3] == null) {
            return null;
        }
        ReconciliationReport[] reconciliationReportArray2 = reconciliationReportArray = this.params.getApplyBaseline() ? this.ranking[n3].getBaselineResult() : this.ranking[n3].getResult();
        if (reconciliationReportArray == null) {
            return null;
        }
        ReconciliationReport[] reconciliationReportArray3 = reconciliationReportArray;
        if (reconciliationReportArray3 != null) {
            for (int i = 0; i < reconciliationReportArray3.length; ++i) {
                ReconciliationRow[] reconciliationRowArray;
                if (reconciliationReportArray3[i] == null || (reconciliationRowArray = reconciliationReportArray3[i].getReconciliationRows()) == null) continue;
                for (int j = 0; j < reconciliationRowArray.length; ++j) {
                    if (!reconciliationRowArray[j].getShowCostColumns()) continue;
                    BUnit bUnit = reconciliationRowArray[j].getCurrency();
                    try {
                        if (this.ranking[n3].getInput().hasNormalizingPoint()) {
                            bUnit = CompoundUnitUtil.make(bUnit, this.ranking[n3].getInput().getNormalizingPoint().getUnit());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (this.floorAreaNormalized) {
                        bUnit = CompoundUnitUtil.make(bUnit, this.ranking[n3].getFloorAreaUnit());
                    }
                    return bUnit;
                }
            }
        }
        return null;
    }

    public boolean getFloorAreaNorm() {
        return this.floorAreaNormalized;
    }

    public boolean hasNormalizingPoint(int n) {
        int n2 = n;
        if (this.params.getApplyBaseline()) {
            n2 /= 2;
        }
        if (this.ranking == null || n2 >= this.ranking.length || this.ranking[n2] == null) {
            return false;
        }
        return this.ranking[n2].getInput().hasNormalizingPoint();
    }

    private class CostRank {
        private ReportInput input;
        private ReconciliationReport[] result;
        private ReconciliationReport[] baselineResult;
        private double floorAreaValue;
        private BUnit floorAreaUnit;

        public CostRank(ReportInput reportInput, ReconciliationReport[] reconciliationReportArray, ReconciliationReport[] reconciliationReportArray2, double d, BUnit bUnit) {
            this.input = reportInput;
            this.result = reconciliationReportArray;
            this.baselineResult = reconciliationReportArray2;
            this.floorAreaValue = d;
            this.floorAreaUnit = bUnit;
        }

        public ReportInput getInput() {
            return this.input;
        }

        public ReconciliationReport[] getResult() {
            return this.result;
        }

        public ReconciliationReport[] getBaselineResult() {
            return this.baselineResult;
        }

        public double getFloorAreaValue() {
            return this.floorAreaValue;
        }

        public BUnit getFloorAreaUnit() {
            return this.floorAreaUnit;
        }
    }
}

