/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.contribution;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class CostContributionParameters
extends ReportParameters {
    public static final int VERSION = -411;
    private boolean useCalculated = true;
    private int numCycles = 1;
    private String billingCycle;
    private boolean applyBaseline = false;
    private String baselineBillingCycle;

    public CostContributionParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public CostContributionParameters(ReportInput[] reportInputArray, boolean bl, String string, int n, int n2, double d, BUnit bUnit, boolean bl2, String string2, Lexicon lexicon, boolean bl3, int n3, double d2) {
        super(reportInputArray, new ReportPeriod(EasLocalTime.getCurrentTime(), EasLocalTime.getCurrentTime(), 127, null), n2, d, bUnit, false, lexicon, bl3, n3, d2);
        this.useCalculated = bl;
        this.billingCycle = string;
        this.numCycles = n;
        this.applyBaseline = bl2;
        this.baselineBillingCycle = string2;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        this.setPeriod(reportParameters.getPeriod());
        this.setNormalization(reportParameters.getNormalization());
        this.setNormalTemperature(reportParameters.getNormalTemperature());
        this.setNormalTemperatureUnit(reportParameters.getNormalTemperatureUnit());
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public boolean useCalculated() {
        return this.useCalculated;
    }

    public String getBillingCycle() {
        return this.billingCycle;
    }

    public int getNumBillingCycles() {
        return this.numCycles;
    }

    public boolean getApplyBaseline() {
        return this.applyBaseline;
    }

    public String getBaselineBillingCycle() {
        return this.baselineBillingCycle;
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        this.useCalculated = dataInput.readBoolean();
        int n = dataInput.readInt();
        if (n != -411) {
            this.numCycles = n;
            this.billingCycle = dataInput.readUTF();
            this.applyBaseline = false;
            this.baselineBillingCycle = null;
        } else {
            this.numCycles = dataInput.readInt();
            this.billingCycle = dataInput.readUTF();
            this.applyBaseline = dataInput.readBoolean();
            this.baselineBillingCycle = dataInput.readUTF();
        }
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.useCalculated);
        dataOutput.writeInt(-411);
        dataOutput.writeInt(this.numCycles);
        String string = this.billingCycle == null ? "" : this.billingCycle;
        dataOutput.writeUTF(string);
        dataOutput.writeBoolean(this.applyBaseline);
        string = this.baselineBillingCycle == null ? "" : this.baselineBillingCycle;
        dataOutput.writeUTF(string);
    }
}

