/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.budget;

import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.report.Budget;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.linking.RateLinkDbObjectValidator;
import com.tridium.eas.cost.ui.reports.budget.BudgetDetailPanel;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasEditorListener;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.DynamicGroupFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class EnterBudgetPanel
extends JPanel
implements TreeSelectionListener,
ActionListener {
    public static final String BUDGET_PREFIX = "meter";
    private MeterTreePanel meters;
    private Budget[] budgets = null;
    private Budget[] currentBudgets = null;
    private BudgetDetailPanel budgetDetails = null;
    private JButton refreshButton;
    private JPanel mainSplit;
    private Filter currentFilter;
    private FilterTree tree;
    private XpComboBox filterSelection;
    private JToolBar toolbar = null;
    private EasApplication easApplication;
    private boolean lastChange = true;
    private JButton saveButton;
    private JButton saveContinueButton;
    private JButton discardChangesButton;
    private JButton deleteButton;
    private EasTextField billYearTextField;
    private boolean billingPeriodChanged = false;

    public EnterBudgetPanel(EasApplication easApplication) {
        this.easApplication = easApplication;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getApplicationContent(), "Center");
    }

    public final void initApplication(boolean bl) {
        if (bl) {
            Lexicon lexicon = BEasApplet.lex;
            this.initFilters();
            this.updateFilter();
        }
    }

    public JToolBar getToolBar() {
        return this.getApplicationToolBar(new int[]{17});
    }

    private JToolBar getApplicationToolBar(int[] nArray) {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        Lexicon lexicon = BEasApplet.lex;
        for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 17: {
                    this.refreshButton = new EasButton((ResourceManager)this.easApplication, 17, lexicon.getText("refresh"));
                    this.refreshButton.addActionListener(this);
                    this.toolbar.add(this.refreshButton);
                    this.toolbar.addSeparator();
                }
            }
        }
        return this.toolbar;
    }

    private JComponent getApplicationContent() {
        if (this.mainSplit == null) {
            Lexicon lexicon = BEasApplet.lex;
            this.mainSplit = new JPanel(new BorderLayout(), false);
            this.add((Component)this.mainSplit, "Center");
            JPanel jPanel = new JPanel(new BorderLayout(), false);
            jPanel.add((Component)this.buildAvailableMetersContents(lexicon), "Center");
            jPanel.add((Component)this.buildBillDateContents(lexicon), "North");
            this.mainSplit.add((Component)jPanel, "West");
            this.mainSplit.add((Component)this.buildBudgetEditorContent(), "Center");
            JPanel jPanel2 = new JPanel(new FlowLayout(1), false);
            this.saveButton = new JButton(lexicon.getText("saveChanges"));
            this.saveButton.setEnabled(false);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (EnterBudgetPanel.this.saveBudget()) {
                        EnterBudgetPanel.this.setMeterSelectionEnabled(true);
                        EnterBudgetPanel.this.saveButton.setEnabled(false);
                        EnterBudgetPanel.this.saveContinueButton.setEnabled(false);
                        EnterBudgetPanel.this.discardChangesButton.setEnabled(false);
                        EnterBudgetPanel.this.deleteButton.setEnabled(true);
                    }
                }
            });
            jPanel2.add(this.saveButton);
            this.saveContinueButton = new JButton(lexicon.getText("saveContinue"));
            this.saveContinueButton.setEnabled(false);
            this.saveContinueButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (EnterBudgetPanel.this.saveBudget()) {
                        EnterBudgetPanel.this.incrementYear();
                        if (EnterBudgetPanel.this.budgetDetails != null) {
                            EnterBudgetPanel.this.budgetDetails.incrementYear();
                        }
                        EnterBudgetPanel.this.setMeterSelectionEnabled(true);
                        EnterBudgetPanel.this.saveButton.setEnabled(false);
                        EnterBudgetPanel.this.saveContinueButton.setEnabled(false);
                        EnterBudgetPanel.this.discardChangesButton.setEnabled(false);
                    }
                }
            });
            jPanel2.add(this.saveContinueButton);
            this.discardChangesButton = new JButton(lexicon.getText("discardChanges"));
            this.discardChangesButton.setEnabled(false);
            this.discardChangesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (EnterBudgetPanel.this.discardChanges()) {
                        EnterBudgetPanel.this.setMeterSelectionEnabled(true);
                        EnterBudgetPanel.this.saveButton.setEnabled(false);
                        EnterBudgetPanel.this.saveContinueButton.setEnabled(false);
                        EnterBudgetPanel.this.discardChangesButton.setEnabled(false);
                    }
                }
            });
            jPanel2.add(this.discardChangesButton);
            this.deleteButton = new JButton(lexicon.getText("deleteBudget"));
            this.deleteButton.setEnabled(false);
            this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (EnterBudgetPanel.this.deleteBudget()) {
                        EnterBudgetPanel.this.setMeterSelectionEnabled(true);
                        EnterBudgetPanel.this.saveButton.setEnabled(false);
                        EnterBudgetPanel.this.saveContinueButton.setEnabled(false);
                        EnterBudgetPanel.this.discardChangesButton.setEnabled(false);
                        EnterBudgetPanel.this.deleteButton.setEnabled(false);
                    }
                }
            });
            jPanel2.add(this.deleteButton);
            JPanel jPanel3 = new JPanel(new BorderLayout(), false);
            jPanel3.add((Component)jPanel2, "Center");
            this.mainSplit.add((Component)jPanel3, "South");
        }
        return this.mainSplit;
    }

    private JComponent buildAvailableMetersContents(Lexicon lexicon) {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(lexicon.getText("selectMeter")));
        this.meters = new MeterTreePanel();
        jPanel.add((Component)this.meters, "Center");
        return jPanel;
    }

    private JComponent buildBillDateContents(Lexicon lexicon) {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(lexicon.getText("selectBudgetYear")));
        EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
        int n = easLocalTime.getYear();
        this.billYearTextField = new EasTextField(4, 5);
        this.billYearTextField.setUseLabelAppearanceWhenDisabled(true);
        this.billYearTextField.setText(String.valueOf(n));
        this.billYearTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                EnterBudgetPanel.this.billingPeriodChanged = true;
            }
        });
        this.billYearTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && EnterBudgetPanel.this.billingPeriodChanged) {
                    EnterBudgetPanel.this.billingPeriodChanged = false;
                    EnterBudgetPanel.this.loadBudget(false);
                }
            }
        });
        this.billYearTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                EnterBudgetPanel.this.billYearTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                if (EnterBudgetPanel.this.billingPeriodChanged) {
                    EnterBudgetPanel.this.billingPeriodChanged = false;
                    EnterBudgetPanel.this.loadBudget(false);
                }
            }
        });
        jPanel.add((Component)this.billYearTextField, "Center");
        return jPanel;
    }

    private JComponent buildBudgetEditorContent() {
        Lexicon lexicon = BEasApplet.lex;
        this.budgetDetails = new BudgetDetailPanel(this, lexicon);
        return this.budgetDetails;
    }

    public void setMeterSelectionEnabled(boolean bl) {
        if (bl != this.lastChange) {
            EventObject eventObject = new EventObject(this);
            if (bl) {
                ((EasEditorListener)((Object)this.easApplication)).editingStopped(eventObject);
            } else {
                ((EasEditorListener)((Object)this.easApplication)).editingStarted(eventObject);
            }
        }
        this.lastChange = bl;
        this.tree.setEnabled(bl);
        this.filterSelection.setEnabled(bl);
        this.billYearTextField.setEditable(bl);
    }

    public Budget loadBudget(boolean bl, String string) {
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            return null;
        }
        Meter meter = (Meter)object;
        if (meter == null) {
            return null;
        }
        int n = meter.getId();
        String string2 = BUDGET_PREFIX + n;
        String string3 = string2 + "_" + string;
        try {
            if (this.budgets == null) {
                Budget budget = EasCostClient.retrieveBudget(this.easApplication.getSession(), n, string);
                if (budget == null) {
                    budget = new Budget(string3, string);
                    this.deleteButton.setEnabled(false);
                } else {
                    this.budgets = new Budget[1];
                    this.budgets[0] = budget;
                    this.deleteButton.setEnabled(true);
                }
                return budget;
            }
            for (int i = 0; i < this.budgets.length; ++i) {
                if (!this.budgets[i].getName().equals(string3)) continue;
                if (bl) {
                    this.budgets[i] = EasCostClient.retrieveBudget(this.easApplication.getSession(), n, string);
                    if (this.budgets[i] == null) {
                        this.deleteButton.setEnabled(false);
                        Budget[] budgetArray = new Budget[this.budgets.length - 1];
                        int n2 = 0;
                        for (int j = 0; j < this.budgets.length; ++j) {
                            if (i == j) continue;
                            budgetArray[n2] = this.budgets[j];
                            ++n2;
                        }
                        this.budgets = budgetArray;
                        return new Budget(string3, string);
                    }
                }
                this.deleteButton.setEnabled(true);
                return this.budgets[i];
            }
            Budget budget = EasCostClient.retrieveBudget(this.easApplication.getSession(), n, string);
            if (budget == null) {
                budget = new Budget(string3, string);
                this.deleteButton.setEnabled(false);
            } else {
                Budget[] budgetArray = new Budget[this.budgets.length + 1];
                for (int i = 0; i < this.budgets.length; ++i) {
                    budgetArray[i] = this.budgets[i];
                }
                budgetArray[this.budgets.length] = budget;
                this.budgets = budgetArray;
                this.deleteButton.setEnabled(true);
            }
            return budget;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean unsavedChangesExist() {
        if (this.saveButton != null) {
            return this.saveButton.isEnabled();
        }
        return false;
    }

    public boolean saveBudget(Budget budget) {
        if (budget == null) {
            return true;
        }
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            return true;
        }
        Meter meter = (Meter)object;
        boolean bl = true;
        try {
            EasCostClient.storeBudget(this.easApplication.getSession(), meter.getId(), budget);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private boolean deleteBudget(Budget budget) {
        if (budget == null) {
            return true;
        }
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            return false;
        }
        Meter meter = (Meter)object;
        boolean bl = true;
        try {
            EasCostClient.deleteBudget(this.easApplication.getSession(), meter.getId(), budget.getBillingCycle());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public void loadBudget(boolean bl) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.budgetDetails.setBudgetEditorValue(this.getSelectedBudgetArray(bl));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public Meter getSelectedMeter() {
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            return null;
        }
        return (Meter)object;
    }

    private Budget[] getSelectedBudgetArray(boolean bl) {
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            this.deleteButton.setEnabled(false);
            return null;
        }
        if (this.currentBudgets == null) {
            this.currentBudgets = new Budget[12];
        }
        String string = "Jan" + this.billYearTextField.getText();
        for (int i = 0; i < this.currentBudgets.length; ++i) {
            this.currentBudgets[i] = this.loadBudget(bl, string);
            string = EnterBudgetPanel.getNextBillPeriod(string);
        }
        return this.currentBudgets;
    }

    private boolean saveBudget() {
        this.currentBudgets = this.budgetDetails.saveBudget();
        if (this.currentBudgets == null) {
            return true;
        }
        boolean bl = true;
        for (int i = 0; i < this.currentBudgets.length; ++i) {
            boolean bl2 = this.saveBudget(this.currentBudgets[i]);
            if (!bl || bl2) continue;
            bl = bl2;
        }
        return bl;
    }

    private boolean deleteBudget() {
        this.currentBudgets = this.budgetDetails.getSelectedBudget();
        if (this.currentBudgets == null) {
            return false;
        }
        Lexicon lexicon = BEasApplet.lex;
        int n = JOptionPane.showConfirmDialog(this.easApplication, lexicon.getText("confirmDeleteBudget") + " " + this.billYearTextField.getText(), lexicon.getText("confirmDelete"), 0);
        if (n != 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < this.currentBudgets.length; ++i) {
            boolean bl2 = this.deleteBudget(this.currentBudgets[i]);
            if (!bl || bl2) continue;
            bl = bl2;
        }
        this.loadBudget(true);
        return bl;
    }

    private static String toBillPeriodString(String string, Lexicon lexicon) {
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        return lexicon.getText(string2) + " " + string3;
    }

    private static String getNextBillPeriod(String string) {
        int n = -2;
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = string2;
        if (string2.equals("Jan")) {
            string4 = "Feb";
        } else if (string2.equals("Feb")) {
            string4 = "Mar";
        } else if (string2.equals("Mar")) {
            string4 = "Apr";
        } else if (string2.equals("Apr")) {
            string4 = "May";
        } else if (string2.equals("May")) {
            string4 = "Jun";
        } else if (string2.equals("Jun")) {
            string4 = "Jul";
        } else if (string2.equals("Jul")) {
            string4 = "Aug";
        } else if (string2.equals("Aug")) {
            string4 = "Sep";
        } else if (string2.equals("Sep")) {
            string4 = "Oct";
        } else if (string2.equals("Oct")) {
            string4 = "Nov";
        } else if (string2.equals("Nov")) {
            string4 = "Dec";
        } else if (string2.equals("Dec")) {
            string4 = "Jan";
            ++n;
        }
        if (n >= 0) {
            string3 = String.valueOf(n);
        }
        return string4 + string3;
    }

    private void incrementYear() {
        try {
            int n = Integer.parseInt(this.billYearTextField.getText());
            this.billYearTextField.setText(String.valueOf(n + 1));
            this.loadBudget(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean discardChanges() {
        this.loadBudget(false);
        return true;
    }

    private void buttonPressed(JButton jButton) {
        if (jButton == this.refreshButton) {
            this.setMeterSelectionEnabled(true);
            this.loadBudget(true);
            this.initApplication(true);
            ((FilterTreeModel)this.tree.getModel()).reload();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.budgetDetails == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.budgetDetails.setBudgetEditorValue(this.getSelectedBudgetArray(false));
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void handleBillChange() {
        this.setMeterSelectionEnabled(false);
        this.saveButton.setEnabled(true);
        this.saveContinueButton.setEnabled(true);
        this.discardChangesButton.setEnabled(true);
    }

    public EasSession getSession() {
        return this.easApplication.getSession();
    }

    public EasApplication getEasApplication() {
        return this.easApplication;
    }

    public void setBudgetYear(String string) {
        if (string != null) {
            this.billYearTextField.setText(string);
        }
    }

    public void setSelectedMeter(Meter meter) {
        if (meter != null) {
            this.tree.setSelectedUserObject(meter);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.filterSelection) {
            this.updateFilter();
        } else if (object instanceof JButton) {
            this.buttonPressed((JButton)object);
        }
    }

    public void initFilters() {
        EasSession easSession = this.easApplication.getSession();
        Lexicon lexicon = BEasApplet.lex;
        this.filterSelection.addItem(new AllSitesFilter(easSession, lexicon));
        this.filterSelection.addItem(new StaticGroupFilter(easSession, lexicon));
        Group[] groupArray = Group.getGroups('D', easSession);
        if (groupArray == null) {
            return;
        }
        int n = groupArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (groupArray[i].isHidden()) continue;
                this.filterSelection.addItem(new DynamicGroupFilter(easSession, (DynGroup)groupArray[i], lexicon));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.filterSelection.setMaximumRowCount(Math.min(this.filterSelection.getItemCount(), 10));
    }

    public void updateFilter() {
        Filter filter = (Filter)this.filterSelection.getSelectedItem();
        if (filter != this.currentFilter) {
            this.currentFilter = filter;
            FilterTreeModel filterTreeModel = new FilterTreeModel(new FilterRootNode(filter, new RateLinkDbObjectValidator()));
            this.tree.setModel(filterTreeModel);
        }
    }

    public void stopApplication() {
        Lexicon lexicon;
        int n;
        if (this.unsavedChangesExist() && (n = JOptionPane.showConfirmDialog(null, (lexicon = BEasApplet.lex).getText("saveChangesTo") + " " + lexicon.getText("enterBudget") + "?", lexicon.getText("saveChanges") + "?", 1)) == 0) {
            this.saveBudget();
        }
    }

    private class MeterFilterTree
    extends FilterTree {
        public MeterFilterTree(ResourceManager resourceManager) {
            super(resourceManager);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            boolean bl = (mouseEvent.getModifiers() & 4) != 0;
            boolean bl2 = mouseEvent.isControlDown();
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                this.clearSelection();
                return;
            }
            if (bl) {
                if (bl2) {
                    this.addSelectionPath(treePath);
                } else {
                    this.setSelectionPath(treePath);
                }
            }
        }
    }

    private class MeterTreePanel
    extends JComponent {
        public MeterTreePanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(1, 2, 2));
            EnterBudgetPanel.this.filterSelection = new XpComboBox();
            EnterBudgetPanel.this.filterSelection.addActionListener(EnterBudgetPanel.this);
            jPanel.add(EnterBudgetPanel.this.filterSelection);
            this.add((Component)jPanel, "North");
            EnterBudgetPanel.this.tree = new MeterFilterTree(EnterBudgetPanel.this.easApplication);
            EnterBudgetPanel.this.tree.addTreeSelectionListener(EnterBudgetPanel.this);
            this.add((Component)new JScrollPane(EnterBudgetPanel.this.tree), "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            int n = 175;
            if (dimension.width > n) {
                n = dimension.width;
            }
            return new Dimension(n, dimension.height);
        }
    }
}

