/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.budget;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.report.ProjectedCostInfo;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.reports.budget.BudgetReportData;
import com.tridium.eas.ui.widgets.EasScrollPane;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.NumberTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class BudgetReportComponentDetails
extends JPanel {
    private EasSession session = null;
    private Lexicon lex;
    private CardLayout layout = null;
    private JPanel reportPanel = null;
    private static final DecimalFormat percentFormat = new DecimalFormat("#0.0%");

    protected BudgetReportComponentDetails(Lexicon lexicon) {
        this.lex = lexicon;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add("show", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.add("hide", jPanel2);
        jPanel2.add((Component)this.buildDefaultView(lexicon.getText("billCycleDetails")), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        jPanel3.setBorder(BorderFactory.createTitledBorder(lexicon.getText("billCycleDetails")));
        EasScrollPane easScrollPane = new EasScrollPane(this.buildBillCycleDetailPanel());
        easScrollPane.getViewport().setBackground(Color.white);
        jPanel3.add((Component)easScrollPane, "Center");
        jPanel.add((Component)jPanel3, "Center");
        this.setBudgetData(null, false, false);
    }

    private JComponent buildDefaultView(String string) {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        return jPanel;
    }

    private JComponent buildBillCycleDetailPanel() {
        this.reportPanel = new JPanel(new GridBagLayout(), false);
        return this.reportPanel;
    }

    private String decodeMeterName(String string) {
        String string2 = "";
        try {
            int n = string.length();
            int n2 = string.lastIndexOf(95);
            if (n2 >= 0) {
                n = n2;
            }
            int n3 = Integer.parseInt(string.substring("meter".length(), n));
            Meter meter = Meter.get(n3, this.getSession());
            string2 = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private void layoutReconciliationReport(ReconciliationReport[] reconciliationReportArray, String string, boolean bl, boolean bl2, double d) {
        int n;
        GridBagConstraints gridBagConstraints;
        block42: {
            Object object;
            Object object2;
            JComponent jComponent;
            Object object3;
            Object object4;
            this.reportPanel.removeAll();
            gridBagConstraints = new GridBagConstraints();
            n = 0;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 12;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            double d17 = 0.0;
            boolean bl3 = false;
            double d18 = 0.0;
            if (reconciliationReportArray == null || reconciliationReportArray.length < 1) break block42;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            this.reportPanel.add((Component)new JLabel(string, 0), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            this.reportPanel.add((Component)new JLabel(this.lex.getText("actualCost"), 0), gridBagConstraints);
            if (bl2) {
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                this.reportPanel.add((Component)new JLabel(this.lex.getText("projectedCost"), 0), gridBagConstraints);
            }
            boolean bl4 = false;
            String string2 = "";
            for (int i = 0; i < reconciliationReportArray.length; ++i) {
                double d19;
                block44: {
                    block43: {
                        Serializable serializable;
                        Serializable serializable2;
                        Serializable serializable3;
                        Object object5;
                        object4 = reconciliationReportArray[i];
                        if (object4 == null || ((ReconciliationReport)object4).getReconciliationRows() == null) continue;
                        object3 = "";
                        string2 = "";
                        bl4 = true;
                        object3 = this.decodeMeterName(((ReconciliationReport)object4).getName());
                        gridBagConstraints.gridy = n++;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.weightx = 100.0;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.gridwidth = 3;
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.anchor = 17;
                        jComponent = new JLabel((String)object3, 2);
                        jComponent.setForeground(Color.blue);
                        this.reportPanel.add((Component)jComponent, gridBagConstraints);
                        string2 = "    ";
                        object2 = ((ReconciliationReport)object4).getReconciliationRows();
                        if (!bl) break block43;
                        d19 = 0.0;
                        double d20 = 0.0;
                        boolean bl5 = false;
                        object = "";
                        for (int j = 0; j < ((ReconciliationRow[])object2).length; ++j) {
                            if (j != 0 && !object2[j].getShowCostColumns()) {
                                gridBagConstraints.gridy = n++;
                                gridBagConstraints.gridx = 0;
                                gridBagConstraints.weightx = 100.0;
                                gridBagConstraints.weighty = 0.0;
                                gridBagConstraints.gridwidth = 1;
                                gridBagConstraints.fill = 1;
                                gridBagConstraints.anchor = 17;
                                object5 = new JLabel((String)object + " " + this.lex.getText("subtotal"), 4);
                                ((JComponent)object5).setForeground(Color.magenta);
                                this.reportPanel.add((Component)object5, gridBagConstraints);
                                gridBagConstraints.gridx = 1;
                                gridBagConstraints.weightx = 0.0;
                                gridBagConstraints.fill = 0;
                                gridBagConstraints.gridwidth = 1;
                                gridBagConstraints.weighty = 0.0;
                                gridBagConstraints.anchor = 10;
                                serializable3 = new CostTextField(9, false);
                                ((JTextField)serializable3).setHorizontalAlignment(4);
                                serializable2 = new DecimalFormat(this.lex.getText("costValueFormat"));
                                ((NumberTextField)serializable3).setFormatter((DecimalFormat)serializable2);
                                ((NumberTextField)serializable3).setMaximumFractionDigits(2);
                                ((EasTextField)serializable3).setUseLabelAppearanceWhenDisabled(true);
                                ((NumberTextField)serializable3).setText(d19);
                                ((JTextComponent)serializable3).setEditable(false);
                                this.reportPanel.add((Component)serializable3, gridBagConstraints);
                                if (bl2) {
                                    gridBagConstraints.gridx = 2;
                                    gridBagConstraints.weightx = 0.0;
                                    gridBagConstraints.fill = 0;
                                    gridBagConstraints.gridwidth = 1;
                                    gridBagConstraints.weighty = 0.0;
                                    gridBagConstraints.anchor = 10;
                                    serializable = new CostTextField(9, false);
                                    ((JTextField)serializable).setHorizontalAlignment(4);
                                    ((NumberTextField)serializable).setFormatter((DecimalFormat)serializable2);
                                    ((NumberTextField)serializable).setMaximumFractionDigits(2);
                                    ((EasTextField)serializable).setUseLabelAppearanceWhenDisabled(true);
                                    ((JComponent)serializable).setBackground(Color.yellow);
                                    ((NumberTextField)serializable).setText(d20);
                                    ((JTextComponent)serializable).setEditable(false);
                                    this.reportPanel.add((Component)serializable, gridBagConstraints);
                                }
                                d19 = 0.0;
                                d20 = 0.0;
                                bl5 = true;
                                object = "";
                            }
                            gridBagConstraints.gridx = 0;
                            gridBagConstraints.gridy = n++;
                            gridBagConstraints.weightx = 100.0;
                            gridBagConstraints.weighty = 0.0;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.fill = 1;
                            gridBagConstraints.anchor = 17;
                            object5 = object2[j].getShowCostColumns() ? object2[j].getDisplayName(this.lex) : this.lex.getText("rate") + "  " + object2[j].getDisplayName(this.lex);
                            object5 = string2 + (String)object5;
                            serializable3 = new JLabel((String)object5);
                            this.reportPanel.add((Component)serializable3, gridBagConstraints);
                            if (object2[j].getShowCostColumns()) {
                                gridBagConstraints.gridx = 1;
                                gridBagConstraints.weightx = 0.0;
                                gridBagConstraints.fill = 0;
                                gridBagConstraints.gridwidth = 1;
                                gridBagConstraints.weighty = 0.0;
                                gridBagConstraints.anchor = 10;
                                serializable2 = new CostTextField(9, false);
                                ((JTextField)serializable2).setHorizontalAlignment(4);
                                serializable = new DecimalFormat(this.lex.getText("costValueFormat"));
                                ((NumberTextField)serializable2).setFormatter((DecimalFormat)serializable);
                                ((NumberTextField)serializable2).setMaximumFractionDigits(2);
                                ((EasTextField)serializable2).setUseLabelAppearanceWhenDisabled(true);
                                ((JTextComponent)serializable2).setEditable(false);
                                double d21 = object2[j].getActualCostSet() ? object2[j].getActualCost(false, 1.0) : object2[j].getCalculatedCost();
                                ((NumberTextField)serializable2).setText(d21);
                                this.reportPanel.add((Component)serializable2, gridBagConstraints);
                                if (bl2) {
                                    gridBagConstraints.gridx = 2;
                                    gridBagConstraints.weightx = 0.0;
                                    gridBagConstraints.fill = 0;
                                    gridBagConstraints.gridwidth = 1;
                                    gridBagConstraints.weighty = 0.0;
                                    gridBagConstraints.anchor = 10;
                                    CostTextField costTextField = new CostTextField(9, false);
                                    costTextField.setHorizontalAlignment(4);
                                    costTextField.setFormatter((DecimalFormat)serializable);
                                    costTextField.setMaximumFractionDigits(2);
                                    costTextField.setUseLabelAppearanceWhenDisabled(true);
                                    costTextField.setEditable(false);
                                    costTextField.setBackground(Color.yellow);
                                    costTextField.setText(((ReconciliationRow)object2[j]).getProjectedCost());
                                    this.reportPanel.add((Component)costTextField, gridBagConstraints);
                                }
                                d19 += d21;
                                d20 += object2[j].getProjectedCost();
                                switch (object2[j].getRateComponent().getCategory()) {
                                    case 0: {
                                        d4 += d21;
                                        d5 += ((ReconciliationRow)object2[j]).getProjectedCost();
                                        break;
                                    }
                                    case 1: {
                                        d6 += d21;
                                        d7 += ((ReconciliationRow)object2[j]).getProjectedCost();
                                        break;
                                    }
                                    case 2: {
                                        d8 += d21;
                                        d9 += ((ReconciliationRow)object2[j]).getProjectedCost();
                                        break;
                                    }
                                    case 3: {
                                        d10 += d21;
                                        d11 += ((ReconciliationRow)object2[j]).getProjectedCost();
                                        break;
                                    }
                                    case 4: {
                                        d12 += d21;
                                        d13 += ((ReconciliationRow)object2[j]).getProjectedCost();
                                        break;
                                    }
                                    case 5: {
                                        d14 += d21;
                                        d15 += ((ReconciliationRow)object2[j]).getProjectedCost();
                                        break;
                                    }
                                    case 6: {
                                        d16 += d21;
                                        d17 += ((ReconciliationRow)object2[j]).getProjectedCost();
                                    }
                                }
                                continue;
                            }
                            object = object2[j].getDisplayName(this.lex);
                        }
                        if (bl5) {
                            gridBagConstraints.gridy = n++;
                            gridBagConstraints.gridx = 0;
                            gridBagConstraints.weightx = 100.0;
                            gridBagConstraints.weighty = 0.0;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.fill = 1;
                            gridBagConstraints.anchor = 17;
                            JLabel jLabel = new JLabel((String)object + " " + this.lex.getText("subtotal"), 4);
                            jLabel.setForeground(Color.magenta);
                            this.reportPanel.add((Component)jLabel, gridBagConstraints);
                            gridBagConstraints.gridx = 1;
                            gridBagConstraints.weightx = 0.0;
                            gridBagConstraints.fill = 0;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.weighty = 0.0;
                            gridBagConstraints.anchor = 10;
                            object5 = new CostTextField(9, false);
                            ((JTextField)object5).setHorizontalAlignment(4);
                            serializable3 = new DecimalFormat(this.lex.getText("costValueFormat"));
                            ((NumberTextField)object5).setFormatter((DecimalFormat)serializable3);
                            ((NumberTextField)object5).setMaximumFractionDigits(2);
                            ((EasTextField)object5).setUseLabelAppearanceWhenDisabled(true);
                            ((NumberTextField)object5).setText(d19);
                            ((JTextComponent)object5).setEditable(false);
                            this.reportPanel.add((Component)object5, gridBagConstraints);
                            d19 = 0.0;
                            if (bl2) {
                                gridBagConstraints.gridx = 2;
                                gridBagConstraints.weightx = 0.0;
                                gridBagConstraints.fill = 0;
                                gridBagConstraints.gridwidth = 1;
                                gridBagConstraints.weighty = 0.0;
                                gridBagConstraints.anchor = 10;
                                serializable2 = new CostTextField(9, false);
                                ((JTextField)serializable2).setHorizontalAlignment(4);
                                ((NumberTextField)serializable2).setFormatter((DecimalFormat)serializable3);
                                ((NumberTextField)serializable2).setMaximumFractionDigits(2);
                                ((EasTextField)serializable2).setUseLabelAppearanceWhenDisabled(true);
                                ((JComponent)serializable2).setBackground(Color.yellow);
                                ((NumberTextField)serializable2).setText(d20);
                                ((JTextComponent)serializable2).setEditable(false);
                                this.reportPanel.add((Component)serializable2, gridBagConstraints);
                            }
                            d20 = 0.0;
                        }
                        if (reconciliationReportArray.length <= 1) break block44;
                        double d22 = ((ReconciliationReport)object4).getMiscCost(false, 1.0);
                        if (d22 != 0.0) {
                            gridBagConstraints.gridy = n++;
                            gridBagConstraints.gridx = 0;
                            gridBagConstraints.weightx = 100.0;
                            gridBagConstraints.weighty = 0.0;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.fill = 1;
                            gridBagConstraints.anchor = 17;
                            this.reportPanel.add((Component)new JLabel((String)object3 + " " + this.lex.getText("miscCost"), 4), gridBagConstraints);
                            gridBagConstraints.gridx = 1;
                            gridBagConstraints.weightx = 0.0;
                            gridBagConstraints.fill = 0;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.weighty = 0.0;
                            gridBagConstraints.anchor = 10;
                            serializable3 = new CostTextField(9, false);
                            ((JTextField)serializable3).setHorizontalAlignment(4);
                            serializable2 = new DecimalFormat(this.lex.getText("costValueFormat"));
                            ((NumberTextField)serializable3).setFormatter((DecimalFormat)serializable2);
                            ((NumberTextField)serializable3).setMaximumFractionDigits(2);
                            ((EasTextField)serializable3).setUseLabelAppearanceWhenDisabled(true);
                            ((NumberTextField)serializable3).setText(d22);
                            ((JTextComponent)serializable3).setEditable(false);
                            this.reportPanel.add((Component)serializable3, gridBagConstraints);
                        }
                        gridBagConstraints.gridy = n++;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.weightx = 100.0;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.anchor = 17;
                        serializable3 = new JLabel((String)object3 + " " + this.lex.getText("total"), 4);
                        ((JComponent)serializable3).setForeground(Color.red);
                        this.reportPanel.add((Component)serializable3, gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.anchor = 10;
                        serializable2 = new CostTextField(9, false);
                        ((JTextField)serializable2).setHorizontalAlignment(4);
                        serializable = new DecimalFormat(this.lex.getText("costValueFormat"));
                        ((NumberTextField)serializable2).setFormatter((DecimalFormat)serializable);
                        ((NumberTextField)serializable2).setMaximumFractionDigits(2);
                        ((EasTextField)serializable2).setUseLabelAppearanceWhenDisabled(true);
                        ((NumberTextField)serializable2).setText(((ReconciliationReport)object4).getTotalActualCost(false, 1.0));
                        ((JTextComponent)serializable2).setEditable(false);
                        this.reportPanel.add((Component)serializable2, gridBagConstraints);
                        if (!bl2) break block44;
                        gridBagConstraints.gridx = 2;
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.anchor = 10;
                        CostTextField costTextField = new CostTextField(9, false);
                        costTextField.setHorizontalAlignment(4);
                        costTextField.setFormatter((DecimalFormat)serializable);
                        costTextField.setMaximumFractionDigits(2);
                        costTextField.setUseLabelAppearanceWhenDisabled(true);
                        costTextField.setBackground(Color.yellow);
                        costTextField.setText(((ReconciliationReport)object4).getTotalProjectedCost());
                        costTextField.setEditable(false);
                        this.reportPanel.add((Component)costTextField, gridBagConstraints);
                        break block44;
                    }
                    for (int j = 0; j < ((ReconciliationRow[])object2).length; ++j) {
                        if (object2[j].getShowCostColumns()) {
                            double d23 = object2[j].getActualCostSet() ? object2[j].getActualCost(false, 1.0) : object2[j].getCalculatedCost();
                            switch (object2[j].getRateComponent().getCategory()) {
                                case 0: {
                                    d4 += d23;
                                    d5 += object2[j].getProjectedCost();
                                    break;
                                }
                                case 1: {
                                    d6 += d23;
                                    d7 += object2[j].getProjectedCost();
                                    break;
                                }
                                case 2: {
                                    d8 += d23;
                                    d9 += object2[j].getProjectedCost();
                                    break;
                                }
                                case 3: {
                                    d10 += d23;
                                    d11 += object2[j].getProjectedCost();
                                    break;
                                }
                                case 4: {
                                    d12 += d23;
                                    d13 += object2[j].getProjectedCost();
                                    break;
                                }
                                case 5: {
                                    d14 += d23;
                                    d15 += object2[j].getProjectedCost();
                                    break;
                                }
                                case 6: {
                                    d16 += d23;
                                    d17 += object2[j].getProjectedCost();
                                }
                            }
                            continue;
                        }
                        bl4 = true;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = n++;
                        gridBagConstraints.weightx = 100.0;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.gridwidth = 3;
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.anchor = 17;
                        String string3 = this.lex.getText("rate") + "  " + object2[j].getDisplayName(this.lex);
                        string3 = string2 + string3;
                        JLabel jLabel = new JLabel(string3);
                        this.reportPanel.add((Component)jLabel, gridBagConstraints);
                    }
                }
                d2 += ((ReconciliationReport)object4).getTotalActualCost(false, 1.0);
                d3 += ((ReconciliationReport)object4).getTotalProjectedCost();
                d19 = ((ReconciliationReport)object4).getMiscCost(false, 1.0);
                if (d19 == 0.0) continue;
                bl3 = true;
                d18 += d19;
            }
            if (!bl) {
                JComponent jComponent2;
                if (!bl4) {
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 100.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.anchor = 17;
                    this.reportPanel.add((Component)new JLabel(" "), gridBagConstraints);
                }
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.reportPanel.add((Component)new JLabel(string2 + "    " + this.lex.getText("Consumption")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField = new CostTextField(9, false);
                costTextField.setHorizontalAlignment(4);
                object4 = new DecimalFormat(this.lex.getText("costValueFormat"));
                costTextField.setFormatter((DecimalFormat)object4);
                costTextField.setMaximumFractionDigits(2);
                costTextField.setUseLabelAppearanceWhenDisabled(true);
                costTextField.setText(d4);
                costTextField.setEditable(false);
                this.reportPanel.add((Component)costTextField, gridBagConstraints);
                if (bl2) {
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    costTextField = new CostTextField(9, false);
                    costTextField.setHorizontalAlignment(4);
                    costTextField.setFormatter((DecimalFormat)object4);
                    costTextField.setMaximumFractionDigits(2);
                    costTextField.setUseLabelAppearanceWhenDisabled(true);
                    costTextField.setBackground(Color.yellow);
                    costTextField.setText(d5);
                    costTextField.setEditable(false);
                    this.reportPanel.add((Component)costTextField, gridBagConstraints);
                }
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.reportPanel.add((Component)new JLabel(string2 + "    " + this.lex.getText("Demand")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                costTextField = new CostTextField(9, false);
                costTextField.setHorizontalAlignment(4);
                costTextField.setFormatter((DecimalFormat)object4);
                costTextField.setMaximumFractionDigits(2);
                costTextField.setUseLabelAppearanceWhenDisabled(true);
                costTextField.setText(d6);
                costTextField.setEditable(false);
                this.reportPanel.add((Component)costTextField, gridBagConstraints);
                if (bl2) {
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    costTextField = new CostTextField(9, false);
                    costTextField.setHorizontalAlignment(4);
                    costTextField.setFormatter((DecimalFormat)object4);
                    costTextField.setMaximumFractionDigits(2);
                    costTextField.setUseLabelAppearanceWhenDisabled(true);
                    costTextField.setBackground(Color.yellow);
                    costTextField.setText(d7);
                    costTextField.setEditable(false);
                    this.reportPanel.add((Component)costTextField, gridBagConstraints);
                }
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.reportPanel.add((Component)new JLabel(string2 + "    " + this.lex.getText("Other")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                costTextField = new CostTextField(9, false);
                costTextField.setHorizontalAlignment(4);
                costTextField.setFormatter((DecimalFormat)object4);
                costTextField.setMaximumFractionDigits(2);
                costTextField.setUseLabelAppearanceWhenDisabled(true);
                costTextField.setText(d8);
                costTextField.setEditable(false);
                this.reportPanel.add((Component)costTextField, gridBagConstraints);
                if (bl2) {
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    costTextField = new CostTextField(9, false);
                    costTextField.setHorizontalAlignment(4);
                    costTextField.setFormatter((DecimalFormat)object4);
                    costTextField.setMaximumFractionDigits(2);
                    costTextField.setUseLabelAppearanceWhenDisabled(true);
                    costTextField.setBackground(Color.yellow);
                    costTextField.setText(d9);
                    costTextField.setEditable(false);
                    this.reportPanel.add((Component)costTextField, gridBagConstraints);
                }
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                object3 = new JLabel(string2 + "    " + this.lex.getText("userDefinedComponent1"));
                ((JComponent)object3).setVisible(bl2 && d11 != 0.0 || d10 != 0.0);
                this.reportPanel.add((Component)object3, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                jComponent = new CostTextField(9, false);
                jComponent.setVisible(bl2 && d11 != 0.0 || d10 != 0.0);
                ((JTextField)jComponent).setHorizontalAlignment(4);
                ((NumberTextField)jComponent).setFormatter((DecimalFormat)object4);
                ((NumberTextField)jComponent).setMaximumFractionDigits(2);
                ((EasTextField)jComponent).setUseLabelAppearanceWhenDisabled(true);
                ((NumberTextField)jComponent).setText(d10);
                ((JTextComponent)jComponent).setEditable(false);
                this.reportPanel.add((Component)jComponent, gridBagConstraints);
                if (bl2) {
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    object2 = new CostTextField(9, false);
                    ((JComponent)object2).setVisible(bl2 && d11 != 0.0 || d10 != 0.0);
                    ((JTextField)object2).setHorizontalAlignment(4);
                    ((NumberTextField)object2).setFormatter((DecimalFormat)object4);
                    ((NumberTextField)object2).setMaximumFractionDigits(2);
                    ((EasTextField)object2).setUseLabelAppearanceWhenDisabled(true);
                    ((JComponent)object2).setBackground(Color.yellow);
                    ((NumberTextField)object2).setText(d11);
                    ((JTextComponent)object2).setEditable(false);
                    this.reportPanel.add((Component)object2, gridBagConstraints);
                }
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                object2 = new JLabel(string2 + "    " + this.lex.getText("userDefinedComponent2"));
                ((JComponent)object2).setVisible(bl2 && d13 != 0.0 || d12 != 0.0);
                this.reportPanel.add((Component)object2, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField2 = new CostTextField(9, false);
                costTextField2.setVisible(bl2 && d13 != 0.0 || d12 != 0.0);
                costTextField2.setHorizontalAlignment(4);
                costTextField2.setFormatter((DecimalFormat)object4);
                costTextField2.setMaximumFractionDigits(2);
                costTextField2.setUseLabelAppearanceWhenDisabled(true);
                costTextField2.setText(d12);
                costTextField2.setEditable(false);
                this.reportPanel.add((Component)costTextField2, gridBagConstraints);
                if (bl2) {
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    CostTextField costTextField3 = new CostTextField(9, false);
                    costTextField3.setVisible(bl2 && d13 != 0.0 || d12 != 0.0);
                    costTextField3.setHorizontalAlignment(4);
                    costTextField3.setFormatter((DecimalFormat)object4);
                    costTextField3.setMaximumFractionDigits(2);
                    costTextField3.setUseLabelAppearanceWhenDisabled(true);
                    costTextField3.setBackground(Color.yellow);
                    costTextField3.setText(d13);
                    costTextField3.setEditable(false);
                    this.reportPanel.add((Component)costTextField3, gridBagConstraints);
                }
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                JLabel jLabel = new JLabel(string2 + "    " + this.lex.getText("userDefinedComponent3"));
                jLabel.setVisible(bl2 && d15 != 0.0 || d14 != 0.0);
                this.reportPanel.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField4 = new CostTextField(9, false);
                costTextField4.setVisible(bl2 && d15 != 0.0 || d14 != 0.0);
                costTextField4.setHorizontalAlignment(4);
                costTextField4.setFormatter((DecimalFormat)object4);
                costTextField4.setMaximumFractionDigits(2);
                costTextField4.setUseLabelAppearanceWhenDisabled(true);
                costTextField4.setText(d14);
                costTextField4.setEditable(false);
                this.reportPanel.add((Component)costTextField4, gridBagConstraints);
                if (bl2) {
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    jComponent2 = new CostTextField(9, false);
                    jComponent2.setVisible(bl2 && d15 != 0.0 || d14 != 0.0);
                    ((JTextField)jComponent2).setHorizontalAlignment(4);
                    ((NumberTextField)jComponent2).setFormatter((DecimalFormat)object4);
                    ((NumberTextField)jComponent2).setMaximumFractionDigits(2);
                    ((EasTextField)jComponent2).setUseLabelAppearanceWhenDisabled(true);
                    jComponent2.setBackground(Color.yellow);
                    ((NumberTextField)jComponent2).setText(d15);
                    ((JTextComponent)jComponent2).setEditable(false);
                    this.reportPanel.add((Component)jComponent2, gridBagConstraints);
                }
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                jComponent2 = new JLabel(string2 + "    " + this.lex.getText("userDefinedComponent4"));
                jComponent2.setVisible(bl2 && d17 != 0.0 || d16 != 0.0);
                this.reportPanel.add((Component)jComponent2, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField5 = new CostTextField(9, false);
                costTextField5.setVisible(bl2 && d17 != 0.0 || d16 != 0.0);
                costTextField5.setHorizontalAlignment(4);
                costTextField5.setFormatter((DecimalFormat)object4);
                costTextField5.setMaximumFractionDigits(2);
                costTextField5.setUseLabelAppearanceWhenDisabled(true);
                costTextField5.setText(d16);
                costTextField5.setEditable(false);
                this.reportPanel.add((Component)costTextField5, gridBagConstraints);
                if (bl2) {
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    object = new CostTextField(9, false);
                    ((JComponent)object).setVisible(bl2 && d17 != 0.0 || d16 != 0.0);
                    ((JTextField)object).setHorizontalAlignment(4);
                    ((NumberTextField)object).setFormatter((DecimalFormat)object4);
                    ((NumberTextField)object).setMaximumFractionDigits(2);
                    ((EasTextField)object).setUseLabelAppearanceWhenDisabled(true);
                    ((JComponent)object).setBackground(Color.yellow);
                    ((NumberTextField)object).setText(d17);
                    ((JTextComponent)object).setEditable(false);
                    this.reportPanel.add((Component)object, gridBagConstraints);
                }
            }
            if (bl3) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.reportPanel.add((Component)new JLabel(this.lex.getText("total") + " " + this.lex.getText("miscCost") + "   ", 4), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField = new CostTextField(9, false);
                costTextField.setHorizontalAlignment(4);
                object4 = new DecimalFormat(this.lex.getText("costValueFormat"));
                costTextField.setFormatter((DecimalFormat)object4);
                costTextField.setMaximumFractionDigits(2);
                costTextField.setUseLabelAppearanceWhenDisabled(true);
                costTextField.setText(d18);
                costTextField.setEditable(false);
                this.reportPanel.add((Component)costTextField, gridBagConstraints);
            }
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            JLabel jLabel = new JLabel(this.lex.getText("total") + "   ", 4);
            jLabel.setBackground(Color.darkGray);
            jLabel.setForeground(Color.green);
            jLabel.setOpaque(true);
            this.reportPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            object4 = new CostTextField(9, false);
            ((JTextField)object4).setHorizontalAlignment(4);
            object3 = new DecimalFormat(this.lex.getText("costValueFormat"));
            ((NumberTextField)object4).setFormatter((DecimalFormat)object3);
            ((NumberTextField)object4).setMaximumFractionDigits(2);
            ((EasTextField)object4).setUseLabelAppearanceWhenDisabled(true);
            ((NumberTextField)object4).setText(d2);
            ((JTextComponent)object4).setEditable(false);
            this.reportPanel.add((Component)object4, gridBagConstraints);
            if (bl2) {
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                jComponent = new CostTextField(9, false);
                ((JTextField)jComponent).setHorizontalAlignment(4);
                ((NumberTextField)jComponent).setFormatter((DecimalFormat)object3);
                ((NumberTextField)jComponent).setMaximumFractionDigits(2);
                ((EasTextField)jComponent).setUseLabelAppearanceWhenDisabled(true);
                jComponent.setBackground(Color.yellow);
                ((NumberTextField)jComponent).setText(d3);
                ((JTextComponent)jComponent).setEditable(false);
                this.reportPanel.add((Component)jComponent, gridBagConstraints);
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.reportPanel.add((Component)new JLabel(this.lex.getText("confidenceFactor"), 4), gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                object2 = new EasTextField(9);
                ((JTextField)object2).setHorizontalAlignment(4);
                ((EasTextField)object2).setUseLabelAppearanceWhenDisabled(true);
                ((JComponent)object2).setBackground(Color.yellow);
                if (d > 0.999 && d < 1.0) {
                    d = 0.999;
                }
                ((JTextComponent)object2).setText(percentFormat.format(d));
                ((JTextComponent)object2).setEditable(false);
                this.reportPanel.add((Component)object2, gridBagConstraints);
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 3, 0, 3);
                this.reportPanel.add((Component)new JLabel(this.lex.getText("projectionNote1"), 2), gridBagConstraints);
                gridBagConstraints.gridy = n++;
                this.reportPanel.add((Component)new JLabel(this.lex.getText("projectionNote2"), 2), gridBagConstraints);
                gridBagConstraints.gridy = n++;
                this.reportPanel.add((Component)new JLabel(this.lex.getText("projectionNote3"), 2), gridBagConstraints);
                gridBagConstraints.gridy = n++;
                this.reportPanel.add((Component)new JLabel(this.lex.getText("projectionNote4"), 2), gridBagConstraints);
            }
        }
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        this.reportPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.reportPanel.revalidate();
        this.reportPanel.repaint();
    }

    public void setBudgetData(BudgetReportData budgetReportData, boolean bl, boolean bl2) {
        if (budgetReportData == null || budgetReportData.getReconciliations() == null || budgetReportData.getReconciliations().length < 1) {
            this.layout.show(this, "hide");
        } else {
            this.layout.show(this, "show");
            double d = 0.0;
            ProjectedCostInfo projectedCostInfo = budgetReportData.getProjectedCosts();
            if (projectedCostInfo != null) {
                d = projectedCostInfo.getConfidenceFactor();
            }
            this.layoutReconciliationReport(budgetReportData.getReconciliations(), budgetReportData.getBillingCycle(this.lex), bl2, bl, d);
        }
    }

    protected void init(EasSession easSession) {
        this.session = easSession;
        this.layout.show(this, "hide");
    }

    protected EasSession getSession() {
        return this.session;
    }
}

