/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.budget;

import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.cost.report.Budget;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.linking.RateLinkDbObjectValidator;
import com.tridium.eas.cost.ui.reports.budget.BudgetReportData;
import com.tridium.eas.cost.ui.reports.budget.BudgetReportDetailPanel;
import com.tridium.eas.cost.ui.reports.budget.EnterBudgetDialog;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasEditorListener;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.DynamicGroupFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.EasToggleButton;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.util.EventObject;
import java.util.Vector;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.tree.TreePath;

public class BudgetReportApplication
extends EasApplication
implements ResourceManager,
EasEditorListener {
    private static final String DEFAULT_RECONCILIATION_PREFIX = "meter";
    private static final String DEFAULT_BUDGET_PREFIX = "meter";
    private MeterTreePanel meters;
    private ReconciliationReport[] reconciliations = null;
    private Budget[] budgets = null;
    private BudgetReportDetailPanel budgetDetails = null;
    private JButton refreshButton;
    private JButton printButton;
    private JPanel meterDateSplit;
    private JPanel mainSplit;
    private Filter currentFilter;
    private FilterTree tree;
    private XpComboBox filterSelection;
    private EasComboBox billMonthComboBox;
    private EasTextField billYearTextField;
    private NumberTextField numCyclesField;
    private JCheckBox projectCostsCheckBox;
    private JToggleButton expandView;
    private JToggleButton showDetails;
    private JButton runButton;
    private JButton enterBudgetButton;
    private boolean administratorRights;
    private boolean reportRunning = false;

    public String getName() {
        Lexicon lexicon = BEasApplet.lex;
        return lexicon.getText("budgetReport");
    }

    public String getId() {
        return "budgetReport";
    }

    public final void initApplication(boolean bl) {
        if (bl) {
            Lexicon lexicon = BEasApplet.lex;
            this.initFilters();
            this.updateFilter();
            this.budgetDetails.init(this.getSession());
        }
    }

    protected JComponent getApplicationToolBar() {
        return this.getApplicationToolBar(new int[]{17, 28, 19, 22});
    }

    protected JComponent getApplicationToolBar(int[] nArray) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        Lexicon lexicon = BEasApplet.lex;
        block6: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 17: {
                    this.refreshButton = new EasButton((ResourceManager)this, 17, lexicon.getText("refresh"));
                    this.refreshButton.addActionListener(this);
                    jToolBar.add(this.refreshButton);
                    continue block6;
                }
                case 28: {
                    this.printButton = new EasButton((ResourceManager)this, 28, lexicon.getText("print"));
                    this.printButton.addActionListener(this);
                    jToolBar.add(this.printButton);
                    continue block6;
                }
                case 19: {
                    this.expandView = new EasToggleButton(this, 19, lexicon.getText("toggleTree"));
                    this.expandView.addActionListener(this);
                    jToolBar.add(this.expandView);
                    continue block6;
                }
                case 22: {
                    this.showDetails = new EasToggleButton(this, 22, lexicon.getText("showDetails"));
                    this.showDetails.addActionListener(this);
                    this.showDetails.setEnabled(false);
                    jToolBar.add(this.showDetails);
                }
            }
        }
        return jToolBar;
    }

    protected JComponent getApplicationContent() {
        if (this.mainSplit == null) {
            Lexicon lexicon = BEasApplet.lex;
            this.administratorRights = this.getSession().hasAdminWrite();
            this.mainSplit = new JPanel(new BorderLayout(), false);
            this.add((Component)this.mainSplit, "Center");
            this.meterDateSplit = new JPanel(new BorderLayout(), false);
            this.meterDateSplit.add((Component)this.buildAvailableMetersContents(lexicon), "Center");
            this.meterDateSplit.add((Component)this.buildBillDateContents(lexicon), "South");
            this.mainSplit.add((Component)this.meterDateSplit, "West");
            this.mainSplit.add((Component)this.buildBudgetContent(), "Center");
            JPanel jPanel = new JPanel(new FlowLayout(1), false);
            this.runButton = new JButton(lexicon.getText("runReport"));
            this.runButton.setEnabled(true);
            this.runButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!BudgetReportApplication.this.reportRunning) {
                        RunReportThread runReportThread = new RunReportThread();
                        runReportThread.start();
                    }
                }
            });
            jPanel.add(this.runButton);
            this.enterBudgetButton = new JButton(lexicon.getText("enterBudget"));
            if (this.administratorRights) {
                this.enterBudgetButton.setEnabled(true);
                this.enterBudgetButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BudgetReportApplication.this.enterBudgetPopup();
                    }
                });
                jPanel.add(this.enterBudgetButton);
            }
            JPanel jPanel2 = new JPanel(new BorderLayout(), false);
            jPanel2.add((Component)jPanel, "Center");
            this.mainSplit.add((Component)jPanel2, "South");
        }
        return this.mainSplit;
    }

    private JComponent buildBillDateContents(Lexicon lexicon) {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("billPeriod")), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
        int n2 = easLocalTime.getMonth();
        int n3 = easLocalTime.getYear();
        if (n2 == 0) {
            n2 = 11;
            --n3;
        } else {
            --n2;
        }
        this.billMonthComboBox = new EasComboBox(new String[]{lexicon.getText("january.short"), lexicon.getText("february.short"), lexicon.getText("march.short"), lexicon.getText("april.short"), lexicon.getText("may.short"), lexicon.getText("june.short"), lexicon.getText("july.short"), lexicon.getText("august.short"), lexicon.getText("september.short"), lexicon.getText("october.short"), lexicon.getText("november.short"), lexicon.getText("december.short")});
        this.billMonthComboBox.setSelectedIndex(0);
        jPanel.add((Component)this.billMonthComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.billYearTextField = new EasTextField(4, 5);
        this.billYearTextField.setUseLabelAppearanceWhenDisabled(true);
        this.billYearTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                BudgetReportApplication.this.billYearTextField.selectAll();
            }
        });
        this.billYearTextField.setText(String.valueOf(n3));
        jPanel.add((Component)this.billYearTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("consecutiveBillingCycles")), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.numCyclesField = new NumberTextField(3, true);
        this.numCyclesField.setAllowNegative(false);
        this.numCyclesField.setUseLabelAppearanceWhenDisabled(true);
        this.numCyclesField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                BudgetReportApplication.this.numCyclesField.selectAll();
            }
        });
        this.numCyclesField.setText(String.valueOf(n2 + 2));
        jPanel.add((Component)this.numCyclesField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.projectCostsCheckBox = new JCheckBox(lexicon.getText("projectCosts"));
        this.projectCostsCheckBox.setSelected(true);
        jPanel.add((Component)this.projectCostsCheckBox, gridBagConstraints);
        return jPanel;
    }

    private JComponent buildAvailableMetersContents(Lexicon lexicon) {
        this.meters = new MeterTreePanel();
        return this.meters;
    }

    private JComponent buildBudgetContent() {
        Lexicon lexicon = BEasApplet.lex;
        this.budgetDetails = new BudgetReportDetailPanel(this, this, lexicon);
        return this.budgetDetails;
    }

    public void runReportEnabled(boolean bl) {
        this.runButton.setEnabled(bl);
    }

    private static String toBillPeriodString(String string, Lexicon lexicon) {
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        return lexicon.getText(string2) + " " + string3;
    }

    private static String getNextBillPeriod(String string) {
        int n = -2;
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = string2;
        if (string2.equals("Jan")) {
            string4 = "Feb";
        } else if (string2.equals("Feb")) {
            string4 = "Mar";
        } else if (string2.equals("Mar")) {
            string4 = "Apr";
        } else if (string2.equals("Apr")) {
            string4 = "May";
        } else if (string2.equals("May")) {
            string4 = "Jun";
        } else if (string2.equals("Jun")) {
            string4 = "Jul";
        } else if (string2.equals("Jul")) {
            string4 = "Aug";
        } else if (string2.equals("Aug")) {
            string4 = "Sep";
        } else if (string2.equals("Sep")) {
            string4 = "Oct";
        } else if (string2.equals("Oct")) {
            string4 = "Nov";
        } else if (string2.equals("Nov")) {
            string4 = "Dec";
        } else if (string2.equals("Dec")) {
            string4 = "Jan";
            ++n;
        }
        if (n >= 0) {
            string3 = String.valueOf(n);
        }
        return string4 + string3;
    }

    private void loadBudgetReportData(boolean bl) {
        int n;
        if (this.budgetDetails == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int n2 = this.numCyclesField.getIntValue();
        if (n2 <= 0) {
            n2 = 1;
        }
        String string = "Jan" + this.billYearTextField.getText();
        switch (this.billMonthComboBox.getSelectedIndex()) {
            case 0: {
                string = "Jan" + this.billYearTextField.getText();
                break;
            }
            case 1: {
                string = "Feb" + this.billYearTextField.getText();
                break;
            }
            case 2: {
                string = "Mar" + this.billYearTextField.getText();
                break;
            }
            case 3: {
                string = "Apr" + this.billYearTextField.getText();
                break;
            }
            case 4: {
                string = "May" + this.billYearTextField.getText();
                break;
            }
            case 5: {
                string = "Jun" + this.billYearTextField.getText();
                break;
            }
            case 6: {
                string = "Jul" + this.billYearTextField.getText();
                break;
            }
            case 7: {
                string = "Aug" + this.billYearTextField.getText();
                break;
            }
            case 8: {
                string = "Sep" + this.billYearTextField.getText();
                break;
            }
            case 9: {
                string = "Oct" + this.billYearTextField.getText();
                break;
            }
            case 10: {
                string = "Nov" + this.billYearTextField.getText();
                break;
            }
            case 11: {
                string = "Dec" + this.billYearTextField.getText();
            }
        }
        Object[] objectArray = this.tree.getSelectedUserObjects();
        Vector<BudgetReportData> vector = new Vector<BudgetReportData>();
        Lexicon lexicon = BEasApplet.lex;
        ProgressMonitor progressMonitor = new ProgressMonitor(this, lexicon.getText("costComputationProgress"), "", 1, 100);
        progressMonitor.setProgress(1);
        progressMonitor.setMillisToDecideToPopup(500);
        if (objectArray != null) {
            Object object;
            Object object2;
            int n3 = 0;
            for (n = 0; n < objectArray.length; ++n) {
                Object object3 = objectArray[n];
                if (object3 != null && object3 instanceof Meter) {
                    object2 = (Meter)object3;
                    if (object2 == null) continue;
                    ++n3;
                    continue;
                }
                if (object3 == null || !(object3 instanceof Site)) continue;
                object2 = (Site)object3;
                object = null;
                try {
                    object = ((Site)object2).getMeters();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (object == null) continue;
                n3 += ((Meter[])object).length;
            }
            progressMonitor.setMinimum(1);
            progressMonitor.setMaximum(n3 * n2 + 1);
            n = 1;
            for (int i = 0; i < n2 && !progressMonitor.isCanceled(); ++i) {
                Budget[] budgetArray;
                object2 = new Vector();
                object = new Vector();
                for (int j = 0; j < objectArray.length && !progressMonitor.isCanceled(); ++j) {
                    String string2;
                    Object object4;
                    EasObject easObject;
                    budgetArray = objectArray[j];
                    if (budgetArray != null && budgetArray instanceof Meter) {
                        easObject = (Meter)budgetArray;
                        if (easObject == null) continue;
                        int n4 = easObject.getId();
                        String string3 = "meter" + n4;
                        object4 = string3 + "_" + string;
                        String string4 = "meter" + n4;
                        string2 = string4 + "_" + string;
                        try {
                            progressMonitor.setNote((((Meter)easObject).getSite() != null ? ((Meter)easObject).getSite().getName() + ": " : "") + ((Meter)easObject).getName() + " " + BudgetReportApplication.toBillPeriodString(string, lexicon));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        progressMonitor.setProgress(n);
                        ((Vector)object2).addElement(this.loadMeterReport(string3, (String)object4, string, bl));
                        ((Vector)object).addElement(this.loadBudget(n4, string2, string, bl));
                        ++n;
                        continue;
                    }
                    if (budgetArray == null || !(budgetArray instanceof Site)) continue;
                    easObject = (Site)budgetArray;
                    Meter[] meterArray = null;
                    try {
                        meterArray = ((Site)easObject).getMeters();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (meterArray == null) continue;
                    for (int k = 0; k < meterArray.length && !progressMonitor.isCanceled(); ++k) {
                        object4 = meterArray[k];
                        if (object4 == null) continue;
                        int n5 = ((EasObject)object4).getId();
                        string2 = "meter" + n5;
                        String string5 = string2 + "_" + string;
                        String string6 = "meter" + n5;
                        String string7 = string6 + "_" + string;
                        try {
                            progressMonitor.setNote((((Meter)object4).getSite() != null ? ((Meter)object4).getSite().getName() + ": " : "") + ((Meter)object4).getName() + " " + BudgetReportApplication.toBillPeriodString(string, lexicon));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        progressMonitor.setProgress(n);
                        ((Vector)object2).addElement(this.loadMeterReport(string2, string5, string, bl));
                        ((Vector)object).addElement(this.loadBudget(n5, string7, string, bl));
                        ++n;
                    }
                }
                if (progressMonitor.isCanceled()) break;
                ReconciliationReport[] reconciliationReportArray = null;
                if (object2 != null && ((Vector)object2).size() > 0) {
                    reconciliationReportArray = new ReconciliationReport[((Vector)object2).size()];
                    for (int j = 0; j < ((Vector)object2).size(); ++j) {
                        reconciliationReportArray[j] = (ReconciliationReport)((Vector)object2).elementAt(j);
                    }
                }
                budgetArray = null;
                if (object != null && ((Vector)object).size() > 0) {
                    budgetArray = new Budget[((Vector)object).size()];
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        budgetArray[j] = (Budget)((Vector)object).elementAt(j);
                    }
                }
                vector.addElement(new BudgetReportData(string, reconciliationReportArray, budgetArray));
                string = BudgetReportApplication.getNextBillPeriod(string);
            }
        }
        if (!progressMonitor.isCanceled()) {
            BudgetReportData[] budgetReportDataArray = null;
            if (vector != null && vector.size() > 0) {
                budgetReportDataArray = new BudgetReportData[vector.size()];
                for (n = 0; n < vector.size(); ++n) {
                    budgetReportDataArray[n] = (BudgetReportData)vector.elementAt(n);
                }
            }
            this.budgetDetails.setBudgetData(budgetReportDataArray);
            this.showDetails.setEnabled(budgetReportDataArray != null && budgetReportDataArray.length > 0);
            this.mainSplit.revalidate();
            this.mainSplit.repaint();
        }
        progressMonitor.close();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean runReport() {
        this.loadBudgetReportData(false);
        return true;
    }

    private ReconciliationReport loadMeterReport(String string, String string2, String string3, boolean bl) {
        try {
            ReconciliationReport reconciliationReport;
            if (this.reconciliations == null) {
                ReconciliationReport reconciliationReport2 = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, true, !this.projectCosts(), string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                if (reconciliationReport2 == null) {
                    reconciliationReport2 = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, true, !this.projectCosts(), string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                }
                if (reconciliationReport2 != null) {
                    reconciliationReport2.setName(string2);
                    if (!reconciliationReport2.isPartialReport()) {
                        this.reconciliations = new ReconciliationReport[1];
                        this.reconciliations[0] = reconciliationReport2;
                    }
                }
                return reconciliationReport2;
            }
            if (string2 != null) {
                for (int i = 0; i < this.reconciliations.length; ++i) {
                    if (!this.reconciliations[i].getName().equals(string2)) continue;
                    if (bl) {
                        this.reconciliations[i] = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, true, !this.projectCosts(), string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                        if (this.reconciliations[i] == null) {
                            this.reconciliations[i] = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, true, !this.projectCosts(), string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                        }
                        if (this.reconciliations[i] != null) {
                            this.reconciliations[i].setName(string2);
                        }
                    }
                    return this.reconciliations[i];
                }
            }
            if ((reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, true, !this.projectCosts(), string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null)) == null) {
                reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, true, !this.projectCosts(), string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
            }
            if (reconciliationReport != null) {
                reconciliationReport.setName(string2);
                if (!reconciliationReport.isPartialReport()) {
                    ReconciliationReport[] reconciliationReportArray = new ReconciliationReport[this.reconciliations.length + 1];
                    for (int i = 0; i < this.reconciliations.length; ++i) {
                        reconciliationReportArray[i] = this.reconciliations[i];
                    }
                    reconciliationReportArray[this.reconciliations.length] = reconciliationReport;
                    this.reconciliations = reconciliationReportArray;
                }
            }
            return reconciliationReport;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Budget loadBudget(int n, String string, String string2, boolean bl) {
        try {
            if (this.budgets == null) {
                Budget budget = EasCostClient.retrieveBudget(this.getSession(), n, string2);
                if (budget == null) {
                    budget = new Budget(string, string2);
                }
                this.budgets = new Budget[1];
                this.budgets[0] = budget;
                return budget;
            }
            for (int i = 0; i < this.budgets.length; ++i) {
                if (!this.budgets[i].getName().equals(string)) continue;
                if (bl) {
                    this.budgets[i] = EasCostClient.retrieveBudget(this.getSession(), n, string2);
                    if (this.budgets[i] == null) {
                        this.budgets[i] = new Budget(string, string2);
                    }
                }
                return this.budgets[i];
            }
            Budget budget = EasCostClient.retrieveBudget(this.getSession(), n, string2);
            if (budget == null) {
                budget = new Budget(string, string2);
            }
            Budget[] budgetArray = new Budget[this.budgets.length + 1];
            for (int i = 0; i < this.budgets.length; ++i) {
                budgetArray[i] = this.budgets[i];
            }
            budgetArray[this.budgets.length] = budget;
            this.budgets = budgetArray;
            return budget;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.refreshButton) {
            this.budgets = null;
            this.reconciliations = null;
            if (this.showDetails != null) {
                this.showDetails.setEnabled(false);
            }
            if (this.budgetDetails != null) {
                this.budgetDetails.setBudgetData(null);
            }
            this.initApplication(true);
            ((FilterTreeModel)this.tree.getModel()).reload();
            this.expandView.setSelected(false);
            this.setExpandedView(true);
        } else if (jButton == this.printButton) {
            try {
                this.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            super.buttonPressed(jButton);
        }
    }

    private void enterBudgetPopup() {
        Object object;
        this.budgets = null;
        Lexicon lexicon = BEasApplet.lex;
        Meter meter = null;
        if (this.tree != null && (object = this.tree.getSelectedUserObject()) != null && object instanceof Meter) {
            meter = (Meter)object;
        }
        object = null;
        if (this.billYearTextField != null) {
            object = this.billYearTextField.getText();
        }
        EnterBudgetDialog.getBudgetDialog(this, this, lexicon, meter, (String)object);
    }

    public boolean projectCosts() {
        return this.projectCostsCheckBox.isSelected();
    }

    public boolean doShowDetails() {
        if (this.showDetails != null) {
            return this.showDetails.isSelected();
        }
        return false;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        pageFormat.setOrientation(1);
        Pageable pageable = this.getPageable(pageFormat);
        if (pageable == null || pageable.getNumberOfPages() == 0) {
            printerJob.cancel();
            return;
        }
        try {
            if (printerJob.printDialog()) {
                printerJob.setPageable(pageable);
                printerJob.print();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = null;
        if (this.budgetDetails != null) {
            this.budgetDetails.print(this.createImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight()).getGraphics(), pageFormat, 0);
            int n = this.budgetDetails.getEstimateNumPages();
            book = new Book();
            book.append(this.budgetDetails, pageFormat, n);
        }
        return book;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.filterSelection) {
            this.updateFilter();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.expandView) {
            this.setExpandedView(!bl);
        } else if (jToggleButton == this.showDetails) {
            this.setShowDetails(!bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    private void setExpandedView(boolean bl) {
        if (this.meterDateSplit != null) {
            this.meterDateSplit.setVisible(bl);
            this.runReportEnabled(bl);
        }
        if (this.mainSplit != null) {
            this.mainSplit.revalidate();
            this.mainSplit.repaint();
        }
    }

    private void setShowDetails(boolean bl) {
        this.budgetDetails.setShowDetails(bl);
        if (this.mainSplit != null) {
            this.mainSplit.revalidate();
            this.mainSplit.repaint();
        }
    }

    public String[] getMeterStrings() {
        String[] stringArray = null;
        Object[] objectArray = this.tree.getSelectedUserObjects();
        if (objectArray == null || objectArray.length < 1) {
            return stringArray;
        }
        stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                Meter meter = (Meter)objectArray[i];
                stringArray[i] = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringArray;
    }

    public String getBillPeriodString() {
        return this.billMonthComboBox.getSelectedItemString() + " " + this.billYearTextField.getText();
    }

    public String getNumConsecutiveCyclesString() {
        return this.numCyclesField.getText();
    }

    public void initFilters() {
        EasSession easSession = this.getSession();
        Lexicon lexicon = BEasApplet.lex;
        this.filterSelection.addItem(new AllSitesFilter(easSession, lexicon));
        this.filterSelection.addItem(new StaticGroupFilter(easSession, lexicon));
        Group[] groupArray = Group.getGroups('D', easSession);
        if (groupArray == null) {
            return;
        }
        int n = groupArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (groupArray[i].isHidden()) continue;
                this.filterSelection.addItem(new DynamicGroupFilter(easSession, (DynGroup)groupArray[i], lexicon));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.filterSelection.setMaximumRowCount(Math.min(this.filterSelection.getItemCount(), 10));
    }

    public void updateFilter() {
        Filter filter = (Filter)this.filterSelection.getSelectedItem();
        if (filter != this.currentFilter) {
            this.currentFilter = filter;
            FilterTreeModel filterTreeModel = new FilterTreeModel(new FilterRootNode(filter, new RateLinkDbObjectValidator()));
            this.tree.setModel(filterTreeModel);
        }
    }

    public BEasApplet getApplet() {
        return this.easApplet;
    }

    public void editingCancelled(EventObject eventObject) {
    }

    public void editingStopped(EventObject eventObject) {
    }

    public void editingStarted(EventObject eventObject) {
    }

    public void editingDeleted(EventObject eventObject) {
    }

    public void dataCleansingChanged() {
        this.budgets = null;
        this.reconciliations = null;
    }

    private class MeterFilterTree
    extends FilterTree {
        public MeterFilterTree(ResourceManager resourceManager) {
            super(resourceManager);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            boolean bl = (mouseEvent.getModifiers() & 4) != 0;
            boolean bl2 = mouseEvent.isControlDown();
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                this.clearSelection();
                return;
            }
            if (bl) {
                if (bl2) {
                    this.addSelectionPath(treePath);
                } else {
                    this.setSelectionPath(treePath);
                }
            }
        }
    }

    private class MeterTreePanel
    extends JComponent {
        public MeterTreePanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(1, 2, 2));
            BudgetReportApplication.this.filterSelection = new XpComboBox();
            BudgetReportApplication.this.filterSelection.addActionListener(BudgetReportApplication.this);
            jPanel.add(BudgetReportApplication.this.filterSelection);
            this.add((Component)jPanel, "North");
            BudgetReportApplication.this.tree = new MeterFilterTree(BudgetReportApplication.this.getResourceManager());
            BudgetReportApplication.this.tree.getSelectionModel().setSelectionMode(4);
            this.add((Component)new JScrollPane(BudgetReportApplication.this.tree), "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            float f = (float)(dimension.width + 30) * 1.2f;
            return new Dimension((int)f, dimension.height);
        }
    }

    private class RunReportThread
    extends Thread {
        public RunReportThread() {
            super("RunBudgetReport");
        }

        public void run() {
            BudgetReportApplication.this.reportRunning = true;
            if (BudgetReportApplication.this.runReport()) {
                // empty if block
            }
            BudgetReportApplication.this.reportRunning = false;
        }
    }
}

