/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.budget;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.report.Budget;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.reports.budget.EnterBudgetPanel;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasScrollPane;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.TemperatureEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BudgetDetailPanel
extends JPanel
implements ActionListener,
FocusListener {
    private EnterBudgetPanel parentPanel = null;
    protected Lexicon lex;
    private Budget[] currentBudgets = null;
    private boolean changeOccurred = false;
    private boolean initializingBillValues = false;
    private boolean findingHistoricalValues = false;
    private NumberTextField janBudgetTextField;
    private NumberTextField febBudgetTextField;
    private NumberTextField marBudgetTextField;
    private NumberTextField aprBudgetTextField;
    private NumberTextField mayBudgetTextField;
    private NumberTextField junBudgetTextField;
    private NumberTextField julBudgetTextField;
    private NumberTextField augBudgetTextField;
    private NumberTextField sepBudgetTextField;
    private NumberTextField octBudgetTextField;
    private NumberTextField novBudgetTextField;
    private NumberTextField decBudgetTextField;
    private JLabel janLabel;
    private JLabel febLabel;
    private JLabel marLabel;
    private JLabel aprLabel;
    private JLabel mayLabel;
    private JLabel junLabel;
    private JLabel julLabel;
    private JLabel augLabel;
    private JLabel sepLabel;
    private JLabel octLabel;
    private JLabel novLabel;
    private JLabel decLabel;
    private JButton applyHistoricalButton;
    private EasTextField historicalBillYearTextField;
    private EasComboBox historicalCostsComboBox;
    private JCheckBox normWeatherCheckBox = null;
    private TemperatureEditor normTempEditor = null;
    private JCheckBox dataCleansingCheckBox = null;
    private NumberTextField dataCleanseWindowEditor = null;
    private NumberTextField dataCleansePercentageEditor = null;

    protected BudgetDetailPanel(EnterBudgetPanel enterBudgetPanel, Lexicon lexicon) {
        this.lex = lexicon;
        this.parentPanel = enterBudgetPanel;
        this.initializingBillValues = true;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel3.add((Component)this.buildBudgetPanel(), gridBagConstraints);
        EasScrollPane easScrollPane = new EasScrollPane(jPanel3);
        easScrollPane.getViewport().setBackground(Color.white);
        JPanel jPanel4 = new JPanel(new BorderLayout(), false);
        jPanel4.setBorder(BorderFactory.createTitledBorder(lexicon.getText("budget")));
        jPanel4.add((Component)easScrollPane, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout(), false);
        JPanel jPanel6 = new JPanel(new FlowLayout(1), false);
        this.applyHistoricalButton = new JButton(lexicon.getText("useHistoricalBudget"));
        this.applyHistoricalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BudgetDetailPanel.this.applyHistoricalValues();
            }
        });
        jPanel6.add(this.applyHistoricalButton);
        jPanel5.add((Component)jPanel6, "North");
        JPanel jPanel7 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)new JLabel(lexicon.getText("historical") + " " + lexicon.getText("year")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this.historicalBillYearTextField = new EasTextField(4, 5);
        this.historicalBillYearTextField.setUseLabelAppearanceWhenDisabled(true);
        this.historicalBillYearTextField.addFocusListener(this);
        EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
        int n = easLocalTime.getYear();
        this.historicalBillYearTextField.setText(String.valueOf(n - 1));
        jPanel7.add((Component)this.historicalBillYearTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)new JLabel(lexicon.getText("useHistorical")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this.historicalCostsComboBox = new EasComboBox(new String[]{lexicon.getText("actualCost"), lexicon.getText("budgetCost"), lexicon.getText("calculatedCost")});
        this.historicalCostsComboBox.setSelectedIndex(0);
        jPanel7.add((Component)this.historicalCostsComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)new JLabel(""), gridBagConstraints);
        JPanel jPanel8 = new JPanel(false);
        jPanel8.setLayout(new FlowLayout(0, 3, 3));
        jPanel8.add(new JLabel(lexicon.getText("normalization")));
        this.normWeatherCheckBox = new JCheckBox(lexicon.getText("degreeDay"));
        this.normWeatherCheckBox.addActionListener(this);
        jPanel8.add(this.normWeatherCheckBox);
        this.normTempEditor = new TemperatureEditor(65, BUnit.getUnit((String)"fahrenheit"), lexicon);
        jPanel8.add(this.normTempEditor);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel(false);
        jPanel9.setLayout(new FlowLayout(1, 10, 3));
        this.dataCleansingCheckBox = new JCheckBox(lexicon.getText("dataCleanse"));
        this.dataCleansingCheckBox.setSelected(enterBudgetPanel.getEasApplication().getDataCleanse());
        this.dataCleansingCheckBox.addActionListener(this);
        jPanel9.add(this.dataCleansingCheckBox);
        this.dataCleanseWindowEditor = new NumberTextField(3, true);
        this.dataCleanseWindowEditor.setAllowNegative(false);
        this.dataCleanseWindowEditor.setUseLabelAppearanceWhenDisabled(true);
        this.dataCleanseWindowEditor.addFocusListener(this);
        this.dataCleanseWindowEditor.setText(enterBudgetPanel.getEasApplication().getDataCleanseWindow());
        this.dataCleanseWindowEditor.setEditable(enterBudgetPanel.getEasApplication().getDataCleanse());
        JPanel jPanel10 = new JPanel(false);
        jPanel10.setLayout(new FlowLayout(1, 3, 0));
        jPanel10.add(this.dataCleanseWindowEditor);
        jPanel10.add(new JLabel(lexicon.getText("dataCleanseWindow")));
        jPanel9.add(jPanel10);
        this.dataCleansePercentageEditor = new NumberTextField(5, false);
        this.dataCleansePercentageEditor.setAllowNegative(false);
        this.dataCleansePercentageEditor.setUseLabelAppearanceWhenDisabled(true);
        this.dataCleansePercentageEditor.addFocusListener(this);
        this.dataCleansePercentageEditor.setText(enterBudgetPanel.getEasApplication().getDataCleansePercentage());
        this.dataCleansePercentageEditor.setEditable(enterBudgetPanel.getEasApplication().getDataCleanse());
        JPanel jPanel11 = new JPanel(false);
        jPanel11.setLayout(new FlowLayout(1, 3, 0));
        jPanel11.add(this.dataCleansePercentageEditor);
        jPanel11.add(new JLabel(lexicon.getText("dataCleansePercentage")));
        jPanel9.add(jPanel11);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)jPanel9, gridBagConstraints);
        jPanel5.add((Component)jPanel7, "South");
        jPanel4.add((Component)jPanel5, "South");
        jPanel2.add((Component)jPanel4, "West");
        jPanel2.add((Component)this.buildMeterDetailPanel(), "Center");
        jPanel.add((Component)jPanel2, "Center");
        this.setBudgetEditorValue(null);
        this.initializingBillValues = false;
    }

    private JComponent buildBudgetPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        int n = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)new JLabel(this.lex.getText("budgetCost"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)new JSeparator(0), gridBagConstraints);
        EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
        String string = " " + String.valueOf(easLocalTime.getYear());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.janLabel = new JLabel(this.lex.getText("january.short") + string, 0);
        jPanel.add((Component)this.janLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.janBudgetTextField = new CostTextField(9, false);
        this.janBudgetTextField.setHorizontalAlignment(4);
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        this.janBudgetTextField.setFormatter(decimalFormat);
        this.janBudgetTextField.setMaximumFractionDigits(2);
        this.janBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.janBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.janBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.janBudgetTextField));
        this.janBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.janBudgetTextField));
        this.janBudgetTextField.setText(0.0);
        jPanel.add((Component)this.janBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.febLabel = new JLabel(this.lex.getText("february.short") + string, 0);
        jPanel.add((Component)this.febLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.febBudgetTextField = new CostTextField(9, false);
        this.febBudgetTextField.setHorizontalAlignment(4);
        this.febBudgetTextField.setFormatter(decimalFormat);
        this.febBudgetTextField.setMaximumFractionDigits(2);
        this.febBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.febBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.febBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.febBudgetTextField));
        this.febBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.febBudgetTextField));
        this.febBudgetTextField.setText(0.0);
        jPanel.add((Component)this.febBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.marLabel = new JLabel(this.lex.getText("march.short") + string, 0);
        jPanel.add((Component)this.marLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.marBudgetTextField = new CostTextField(9, false);
        this.marBudgetTextField.setHorizontalAlignment(4);
        this.marBudgetTextField.setFormatter(decimalFormat);
        this.marBudgetTextField.setMaximumFractionDigits(2);
        this.marBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.marBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.marBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.marBudgetTextField));
        this.marBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.marBudgetTextField));
        this.marBudgetTextField.setText(0.0);
        jPanel.add((Component)this.marBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.aprLabel = new JLabel(this.lex.getText("april.short") + string, 0);
        jPanel.add((Component)this.aprLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.aprBudgetTextField = new CostTextField(9, false);
        this.aprBudgetTextField.setHorizontalAlignment(4);
        this.aprBudgetTextField.setFormatter(decimalFormat);
        this.aprBudgetTextField.setMaximumFractionDigits(2);
        this.aprBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.aprBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.aprBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.aprBudgetTextField));
        this.aprBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.aprBudgetTextField));
        this.aprBudgetTextField.setText(0.0);
        jPanel.add((Component)this.aprBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.mayLabel = new JLabel(this.lex.getText("may.short") + string, 0);
        jPanel.add((Component)this.mayLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.mayBudgetTextField = new CostTextField(9, false);
        this.mayBudgetTextField.setHorizontalAlignment(4);
        this.mayBudgetTextField.setFormatter(decimalFormat);
        this.mayBudgetTextField.setMaximumFractionDigits(2);
        this.mayBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.mayBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.mayBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.mayBudgetTextField));
        this.mayBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.mayBudgetTextField));
        this.mayBudgetTextField.setText(0.0);
        jPanel.add((Component)this.mayBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.junLabel = new JLabel(this.lex.getText("june.short") + string, 0);
        jPanel.add((Component)this.junLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.junBudgetTextField = new CostTextField(9, false);
        this.junBudgetTextField.setHorizontalAlignment(4);
        this.junBudgetTextField.setFormatter(decimalFormat);
        this.junBudgetTextField.setMaximumFractionDigits(2);
        this.junBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.junBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.junBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.junBudgetTextField));
        this.junBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.junBudgetTextField));
        this.junBudgetTextField.setText(0.0);
        jPanel.add((Component)this.junBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.julLabel = new JLabel(this.lex.getText("july.short") + string, 0);
        jPanel.add((Component)this.julLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.julBudgetTextField = new CostTextField(9, false);
        this.julBudgetTextField.setHorizontalAlignment(4);
        this.julBudgetTextField.setFormatter(decimalFormat);
        this.julBudgetTextField.setMaximumFractionDigits(2);
        this.julBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.julBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.julBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.julBudgetTextField));
        this.julBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.julBudgetTextField));
        this.julBudgetTextField.setText(0.0);
        jPanel.add((Component)this.julBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.augLabel = new JLabel(this.lex.getText("august.short") + string, 0);
        jPanel.add((Component)this.augLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.augBudgetTextField = new CostTextField(9, false);
        this.augBudgetTextField.setHorizontalAlignment(4);
        this.augBudgetTextField.setFormatter(decimalFormat);
        this.augBudgetTextField.setMaximumFractionDigits(2);
        this.augBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.augBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.augBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.augBudgetTextField));
        this.augBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.augBudgetTextField));
        this.augBudgetTextField.setText(0.0);
        jPanel.add((Component)this.augBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.sepLabel = new JLabel(this.lex.getText("september.short") + string, 0);
        jPanel.add((Component)this.sepLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.sepBudgetTextField = new CostTextField(9, false);
        this.sepBudgetTextField.setHorizontalAlignment(4);
        this.sepBudgetTextField.setFormatter(decimalFormat);
        this.sepBudgetTextField.setMaximumFractionDigits(2);
        this.sepBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.sepBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.sepBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.sepBudgetTextField));
        this.sepBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.sepBudgetTextField));
        this.sepBudgetTextField.setText(0.0);
        jPanel.add((Component)this.sepBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.octLabel = new JLabel(this.lex.getText("october.short") + string, 0);
        jPanel.add((Component)this.octLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.octBudgetTextField = new CostTextField(9, false);
        this.octBudgetTextField.setHorizontalAlignment(4);
        this.octBudgetTextField.setFormatter(decimalFormat);
        this.octBudgetTextField.setMaximumFractionDigits(2);
        this.octBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.octBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.octBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.octBudgetTextField));
        this.octBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.octBudgetTextField));
        this.octBudgetTextField.setText(0.0);
        jPanel.add((Component)this.octBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.novLabel = new JLabel(this.lex.getText("november.short") + string, 0);
        jPanel.add((Component)this.novLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.novBudgetTextField = new CostTextField(9, false);
        this.novBudgetTextField.setHorizontalAlignment(4);
        this.novBudgetTextField.setFormatter(decimalFormat);
        this.novBudgetTextField.setMaximumFractionDigits(2);
        this.novBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.novBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.novBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.novBudgetTextField));
        this.novBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.novBudgetTextField));
        this.novBudgetTextField.setText(0.0);
        jPanel.add((Component)this.novBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.decLabel = new JLabel(this.lex.getText("december.short") + string, 0);
        jPanel.add((Component)this.decLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.decBudgetTextField = new CostTextField(9, false);
        this.decBudgetTextField.setHorizontalAlignment(4);
        this.decBudgetTextField.setFormatter(decimalFormat);
        this.decBudgetTextField.setMaximumFractionDigits(2);
        this.decBudgetTextField.setUseLabelAppearanceWhenDisabled(true);
        this.decBudgetTextField.getDocument().addDocumentListener(new BudgetListener());
        this.decBudgetTextField.addKeyListener(new BudgetKeyAdapter(this.decBudgetTextField));
        this.decBudgetTextField.addFocusListener(new BudgetFocusAdapter(this.decBudgetTextField));
        this.decBudgetTextField.setText(0.0);
        jPanel.add((Component)this.decBudgetTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.janBudgetTextField.setNextFocusableComponent(this.febBudgetTextField);
        this.febBudgetTextField.setNextFocusableComponent(this.marBudgetTextField);
        this.marBudgetTextField.setNextFocusableComponent(this.aprBudgetTextField);
        this.aprBudgetTextField.setNextFocusableComponent(this.mayBudgetTextField);
        this.mayBudgetTextField.setNextFocusableComponent(this.junBudgetTextField);
        this.junBudgetTextField.setNextFocusableComponent(this.julBudgetTextField);
        this.julBudgetTextField.setNextFocusableComponent(this.augBudgetTextField);
        this.augBudgetTextField.setNextFocusableComponent(this.sepBudgetTextField);
        this.sepBudgetTextField.setNextFocusableComponent(this.octBudgetTextField);
        this.octBudgetTextField.setNextFocusableComponent(this.novBudgetTextField);
        this.novBudgetTextField.setNextFocusableComponent(this.decBudgetTextField);
        this.decBudgetTextField.setNextFocusableComponent(this.janBudgetTextField);
        return jPanel;
    }

    private JComponent buildMeterDetailPanel() {
        return new JLabel("");
    }

    private static String toBillPeriodString(String string, Lexicon lexicon) {
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        return lexicon.getText(string2) + " " + string3;
    }

    private void layoutBudgetCosts(Budget[] budgetArray) {
        this.currentBudgets = budgetArray;
        boolean bl = budgetArray != null;
        this.janBudgetTextField.setEditable(bl);
        this.febBudgetTextField.setEditable(bl);
        this.marBudgetTextField.setEditable(bl);
        this.aprBudgetTextField.setEditable(bl);
        this.mayBudgetTextField.setEditable(bl);
        this.junBudgetTextField.setEditable(bl);
        this.julBudgetTextField.setEditable(bl);
        this.augBudgetTextField.setEditable(bl);
        this.sepBudgetTextField.setEditable(bl);
        this.octBudgetTextField.setEditable(bl);
        this.novBudgetTextField.setEditable(bl);
        this.decBudgetTextField.setEditable(bl);
        this.historicalBillYearTextField.setEditable(bl);
        this.applyHistoricalButton.setEnabled(bl);
        this.historicalCostsComboBox.setEnabled(bl);
        this.normWeatherCheckBox.setEnabled(bl);
        this.normTempEditor.setEditable(bl && this.normWeatherCheckBox.isSelected());
        this.dataCleansingCheckBox.setEnabled(bl);
        this.dataCleanseWindowEditor.setEditable(bl && this.dataCleansingCheckBox.isSelected());
        this.dataCleansePercentageEditor.setEditable(bl && this.dataCleansingCheckBox.isSelected());
        if (!bl) {
            this.janBudgetTextField.setText(0.0);
            this.febBudgetTextField.setText(0.0);
            this.marBudgetTextField.setText(0.0);
            this.aprBudgetTextField.setText(0.0);
            this.mayBudgetTextField.setText(0.0);
            this.junBudgetTextField.setText(0.0);
            this.julBudgetTextField.setText(0.0);
            this.augBudgetTextField.setText(0.0);
            this.sepBudgetTextField.setText(0.0);
            this.octBudgetTextField.setText(0.0);
            this.novBudgetTextField.setText(0.0);
            this.decBudgetTextField.setText(0.0);
            return;
        }
        if (budgetArray.length != 12) {
            System.out.println("ERROR: Wrong number of reported budget costs.  " + budgetArray.length + " != 12.");
            return;
        }
        Budget budget = budgetArray[0];
        if (budget != null) {
            this.janLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.janBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[1]) != null) {
            this.febLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.febBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[2]) != null) {
            this.marLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.marBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[3]) != null) {
            this.aprLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.aprBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[4]) != null) {
            this.mayLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.mayBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[5]) != null) {
            this.junLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.junBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[6]) != null) {
            this.julLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.julBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[7]) != null) {
            this.augLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.augBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[8]) != null) {
            this.sepLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.sepBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[9]) != null) {
            this.octLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.octBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[10]) != null) {
            this.novLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.novBudgetTextField.setText(budget.getBudgetCost());
        }
        if ((budget = budgetArray[11]) != null) {
            this.decLabel.setText(BudgetDetailPanel.toBillPeriodString(budget.getBillingCycle(), this.lex));
            this.decBudgetTextField.setText(budget.getBudgetCost());
        }
    }

    public void setBudgetEditorValue(Budget[] budgetArray) {
        this.initializingBillValues = true;
        this.layoutBudgetCosts(budgetArray);
        this.initializingBillValues = false;
    }

    public Budget[] saveBudget() {
        if (this.currentBudgets == null) {
            return null;
        }
        if (this.currentBudgets.length != 12) {
            System.out.println("ERROR: Wrong number of current budget costs.  " + this.currentBudgets.length + " != 12.");
            return null;
        }
        Budget budget = this.currentBudgets[0];
        if (budget != null) {
            budget.setBudgetCost(this.janBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[1]) != null) {
            budget.setBudgetCost(this.febBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[2]) != null) {
            budget.setBudgetCost(this.marBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[3]) != null) {
            budget.setBudgetCost(this.aprBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[4]) != null) {
            budget.setBudgetCost(this.mayBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[5]) != null) {
            budget.setBudgetCost(this.junBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[6]) != null) {
            budget.setBudgetCost(this.julBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[7]) != null) {
            budget.setBudgetCost(this.augBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[8]) != null) {
            budget.setBudgetCost(this.sepBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[9]) != null) {
            budget.setBudgetCost(this.octBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[10]) != null) {
            budget.setBudgetCost(this.novBudgetTextField.getDoubleValue());
        }
        if ((budget = this.currentBudgets[11]) != null) {
            budget.setBudgetCost(this.decBudgetTextField.getDoubleValue());
        }
        return this.currentBudgets;
    }

    public Budget[] getSelectedBudget() {
        return this.currentBudgets;
    }

    private void applyHistoricalValues() {
        if (!this.findingHistoricalValues) {
            FindHistoricalThread findHistoricalThread = new FindHistoricalThread();
            findHistoricalThread.start();
        }
    }

    private void loadHistoricalValues() {
        Meter meter = this.parentPanel.getSelectedMeter();
        if (meter == null) {
            return;
        }
        int n = -1;
        String string = "";
        try {
            n = meter.getId();
            string = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName() + " ";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        String string2 = this.historicalBillYearTextField.getText();
        String string3 = "Jan" + string2;
        if (this.historicalCostsComboBox.getSelectedIndex() != 1) {
            int n2 = 0;
            ProgressMonitor progressMonitor = new ProgressMonitor(this.parentPanel, this.lex.getText("costComputationProgress"), "", 1, 100);
            progressMonitor.setMillisToDecideToPopup(500);
            progressMonitor.setMinimum(1);
            progressMonitor.setMaximum(13);
            String string4 = "meter" + n;
            String string5 = string4 + "_" + string3;
            String string6 = "meter" + n;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            ReconciliationReport reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Feb" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d2 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d2 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Mar" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d3 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d3 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Apr" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d4 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d4 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "May" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d5 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d5 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Jun" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d6 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d6 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Jul" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d7 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d7 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Aug" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d8 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d8 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Sep" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d9 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d9 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Oct" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d10 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d10 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Nov" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d11 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d11 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            string3 = "Dec" + string2;
            string5 = string4 + "_" + string3;
            progressMonitor.setNote(string + BudgetDetailPanel.toBillPeriodString(string3, this.lex));
            progressMonitor.setProgress(++n2);
            reconciliationReport = this.loadMeterReport(this.parentPanel.getSession(), string4, string5, string3, string6);
            if (reconciliationReport != null) {
                if (this.historicalCostsComboBox.getSelectedIndex() == 0) {
                    d12 = reconciliationReport.getTotalActualCost(false, 1.0);
                } else if (this.historicalCostsComboBox.getSelectedIndex() == 2) {
                    d12 = reconciliationReport.getTotalCalculatedCost();
                }
            }
            progressMonitor.close();
        } else {
            Budget budget = this.parentPanel.loadBudget(false, string3);
            if (budget != null) {
                d = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Feb" + string2)) != null) {
                d2 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Mar" + string2)) != null) {
                d3 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Apr" + string2)) != null) {
                d4 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "May" + string2)) != null) {
                d5 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Jun" + string2)) != null) {
                d6 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Jul" + string2)) != null) {
                d7 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Aug" + string2)) != null) {
                d8 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Sep" + string2)) != null) {
                d9 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Oct" + string2)) != null) {
                d10 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Nov" + string2)) != null) {
                d11 = budget.getBudgetCost();
            }
            if ((budget = this.parentPanel.loadBudget(false, string3 = "Dec" + string2)) != null) {
                d12 = budget.getBudgetCost();
            }
        }
        this.initializingBillValues = true;
        this.janBudgetTextField.setText(d);
        this.febBudgetTextField.setText(d2);
        this.marBudgetTextField.setText(d3);
        this.aprBudgetTextField.setText(d4);
        this.mayBudgetTextField.setText(d5);
        this.junBudgetTextField.setText(d6);
        this.julBudgetTextField.setText(d7);
        this.augBudgetTextField.setText(d8);
        this.sepBudgetTextField.setText(d9);
        this.octBudgetTextField.setText(d10);
        this.novBudgetTextField.setText(d11);
        this.decBudgetTextField.setText(d12);
        this.initializingBillValues = false;
        this.handleBillChange();
    }

    private ReconciliationReport loadMeterReport(EasSession easSession, String string, String string2, String string3, String string4) {
        try {
            ReconciliationReport reconciliationReport = EasCostClient.retrieveReconciliationReport(easSession, string, string2, string3, true, true, string4, false, this.getNormWeather(), this.getNormalTemperatureUnit(), this.getNormalTemperature(), this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
            if (reconciliationReport == null) {
                reconciliationReport = EasCostClient.retrieveReconciliationReport(easSession, string, string, string3, true, true, string4, false, this.getNormWeather(), this.getNormalTemperatureUnit(), this.getNormalTemperature(), this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
            }
            return reconciliationReport;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void incrementYear() {
        try {
            int n = Integer.parseInt(this.historicalBillYearTextField.getText());
            this.historicalBillYearTextField.setText(String.valueOf(n + 1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleBillChange() {
        if (this.initializingBillValues) {
            return;
        }
        this.parentPanel.handleBillChange();
    }

    public EnterBudgetPanel getParentPanel() {
        return this.parentPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.dataCleansingCheckBox) {
            boolean bl = this.dataCleansingCheckBox.isSelected();
            this.dataCleanseWindowEditor.setEditable(bl);
            this.dataCleansePercentageEditor.setEditable(bl);
        } else if (object == this.normWeatherCheckBox) {
            boolean bl = this.normWeatherCheckBox.isSelected();
            this.normTempEditor.setEditable(bl);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof JTextField && ((JTextField)component).isEditable()) {
            BudgetDetailPanel.selectItLater(component);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private static void selectItLater(Component component) {
        if (component instanceof JTextField) {
            final JTextField jTextField = (JTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTextField.selectAll();
                }
            });
        }
    }

    public boolean getNormWeather() {
        if (this.normWeatherCheckBox != null) {
            return this.normWeatherCheckBox.isSelected();
        }
        return false;
    }

    public double getNormalTemperature() {
        if (!this.getNormWeather() || this.normTempEditor == null) {
            return 65.0;
        }
        return this.normTempEditor.getValue();
    }

    public BUnit getNormalTemperatureUnit() {
        if (!this.getNormWeather() || this.normTempEditor == null) {
            return BUnit.getUnit((String)"fahrenheit");
        }
        return this.normTempEditor.getUnit();
    }

    public boolean getDataCleanse() {
        if (this.dataCleansingCheckBox != null) {
            return this.dataCleansingCheckBox.isSelected();
        }
        return false;
    }

    public void setDataCleanse(boolean bl) {
        if (this.dataCleansingCheckBox != null) {
            this.dataCleansingCheckBox.setSelected(bl);
            this.dataCleanseWindowEditor.setEditable(bl);
            this.dataCleansePercentageEditor.setEditable(bl);
        }
    }

    public int getDataCleanseWindow() {
        if (this.dataCleanseWindowEditor != null) {
            return this.dataCleanseWindowEditor.getIntValue();
        }
        return 4;
    }

    public void setDataCleanseWindow(int n) {
        if (this.dataCleanseWindowEditor != null) {
            this.dataCleanseWindowEditor.setText(n);
        }
    }

    public double getDataCleansePercentage() {
        if (this.dataCleansePercentageEditor != null) {
            return this.dataCleansePercentageEditor.getFloatValue();
        }
        return 100.0;
    }

    public void setDataCleansePercentage(double d) {
        if (this.dataCleansePercentageEditor != null) {
            this.dataCleansePercentageEditor.setText(d);
        }
    }

    private class FindHistoricalThread
    extends Thread {
        public FindHistoricalThread() {
            super("FindHistorical");
        }

        public void run() {
            BudgetDetailPanel.this.findingHistoricalValues = true;
            BudgetDetailPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            BudgetDetailPanel.this.loadHistoricalValues();
            BudgetDetailPanel.this.setCursor(Cursor.getDefaultCursor());
            BudgetDetailPanel.this.findingHistoricalValues = false;
        }
    }

    private class BudgetFocusAdapter
    extends FocusAdapter {
        private NumberTextField budgetTextField;

        public BudgetFocusAdapter(NumberTextField numberTextField) {
            this.budgetTextField = numberTextField;
        }

        public void focusGained(FocusEvent focusEvent) {
            BudgetDetailPanel.selectItLater(focusEvent.getComponent());
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!BudgetDetailPanel.this.changeOccurred) {
                return;
            }
            this.budgetTextField.setText(this.budgetTextField.getDoubleValue());
            BudgetDetailPanel.this.changeOccurred = false;
        }
    }

    private class BudgetKeyAdapter
    extends KeyAdapter {
        private NumberTextField budgetTextField;

        public BudgetKeyAdapter(NumberTextField numberTextField) {
            this.budgetTextField = numberTextField;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                if (!BudgetDetailPanel.this.changeOccurred) {
                    return;
                }
                this.budgetTextField.setText(this.budgetTextField.getDoubleValue());
                BudgetDetailPanel.this.changeOccurred = false;
            }
        }
    }

    private class BudgetListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (BudgetDetailPanel.this.initializingBillValues) {
                return;
            }
            BudgetDetailPanel.this.changeOccurred = true;
            BudgetDetailPanel.this.handleBillChange();
        }
    }
}

