/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.analyzer;

import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.cost.report.AnalyzerReport;
import com.tridium.eas.cost.report.BillCycleResult;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.linking.RateLinkDbObjectValidator;
import com.tridium.eas.cost.ui.reports.analyzer.AnalyzerDetailPanel;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.reports.SaveReportDialog;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.DynamicGroupFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.EasToggleButton;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.tree.TreePath;

public class WhatIfAnalyzerApplication
extends EasApplication
implements ResourceManager {
    public static final String DEFAULT_RECONCILIATION_PREFIX = "meter";
    private MeterTreePanel meters;
    private AnalyzerReport currentAnalyzerReport;
    private ReconciliationReport[] reconciliations = null;
    private AnalyzerDetailPanel analyzerDetails = null;
    private JButton refreshButton;
    private JButton printButton;
    private JPanel meterDateSplit;
    private JPanel mainSplit;
    private Filter currentFilter;
    private FilterTree tree;
    private XpComboBox filterSelection;
    private EasComboBox billMonthComboBox;
    private EasTextField billYearTextField;
    private NumberTextField numCyclesField;
    private JToggleButton expandView;
    private JButton runButton;
    private JButton saveButton;
    private boolean reportRunning = false;
    private boolean pub = false;
    private String saveName = null;

    public String getName() {
        Lexicon lexicon = BEasApplet.lex;
        return lexicon.getText("whatIfAnalyzer");
    }

    public String getId() {
        return "whatIfAnalyzer";
    }

    public final void initApplication(boolean bl) {
        if (bl) {
            Lexicon lexicon = BEasApplet.lex;
            this.initFilters();
            this.updateFilter();
            this.analyzerDetails.init(this.getSession());
            this.saveName = this.getParameter("reportName", null);
            if (this.saveName != null) {
                try {
                    String string = "public";
                    String string2 = this.getSession().getUserName();
                    if (string2 != null) {
                        string = string2;
                    }
                    this.currentAnalyzerReport = EasCostClient.retrieveAnalyzerReport(this.getSession(), string, this.saveName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void startApplication() {
        super.startApplication();
        this.saveButton.setEnabled(this.getSession().hasOperatorWrite());
        boolean bl = this.getBooleanParameter("tree", true);
        if (this.expandView != null) {
            this.expandView.setSelected(!bl);
        }
        this.setExpandedView(bl);
        if (this.currentAnalyzerReport != null) {
            this.setDataCleanse(this.currentAnalyzerReport.getDataCleanse());
            this.setDataCleanseWindow(this.currentAnalyzerReport.getDataCleanseWindow());
            this.setDataCleansePercentage(this.currentAnalyzerReport.getDataCleansePercentage());
            String string = this.currentAnalyzerReport.getStartingBillingCycle();
            String string2 = string.substring(0, 3);
            String string3 = string.substring(3);
            int n = 0;
            if (string2.equals("Jan")) {
                n = 0;
            } else if (string2.equals("Feb")) {
                n = 1;
            } else if (string2.equals("Mar")) {
                n = 2;
            } else if (string2.equals("Apr")) {
                n = 3;
            } else if (string2.equals("May")) {
                n = 4;
            } else if (string2.equals("Jun")) {
                n = 5;
            } else if (string2.equals("Jul")) {
                n = 6;
            } else if (string2.equals("Aug")) {
                n = 7;
            } else if (string2.equals("Sep")) {
                n = 8;
            } else if (string2.equals("Oct")) {
                n = 9;
            } else if (string2.equals("Nov")) {
                n = 10;
            } else if (string2.equals("Dec")) {
                n = 11;
            }
            this.billMonthComboBox.setSelectedIndex(n);
            this.billYearTextField.setText(string3);
            this.numCyclesField.setText(String.valueOf(this.currentAnalyzerReport.getNumCycles()));
            Meter[] meterArray = null;
            int[] nArray = this.currentAnalyzerReport.getMeterIds();
            if (nArray != null && nArray.length > 0) {
                meterArray = new Meter[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    try {
                        meterArray[i] = Meter.get(nArray[i], this.getSession());
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            this.tree.setSelectedUserObjects(meterArray);
            this.analyzerDetails.setAnalyzerEditorValue(this.currentAnalyzerReport, true);
            this.mainSplit.revalidate();
            this.mainSplit.repaint();
        } else if (globalConsecutiveBillCycles > -1) {
            this.numCyclesField.setText(String.valueOf(globalConsecutiveBillCycles));
            if (globalBillPeriodMonth > -1) {
                this.billMonthComboBox.setSelectedIndex(globalBillPeriodMonth);
            }
            if (globalBillPeriodYear != null) {
                this.billYearTextField.setText(globalBillPeriodYear);
            }
        }
    }

    protected void stopApplication() {
        super.stopApplication();
        globalBillPeriodMonth = this.billMonthComboBox.getSelectedIndex();
        globalBillPeriodYear = this.billYearTextField.getText();
        globalConsecutiveBillCycles = this.numCyclesField.getIntValue();
    }

    protected JComponent getApplicationToolBar() {
        return this.getApplicationToolBar(new int[]{17, 28, 18, 19});
    }

    protected JComponent getApplicationToolBar(int[] nArray) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        Lexicon lexicon = BEasApplet.lex;
        block6: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 17: {
                    this.refreshButton = new EasButton((ResourceManager)this, 17, lexicon.getText("refresh"));
                    this.refreshButton.addActionListener(this);
                    jToolBar.add(this.refreshButton);
                    continue block6;
                }
                case 28: {
                    this.printButton = new EasButton((ResourceManager)this, 28, lexicon.getText("print"));
                    this.printButton.addActionListener(this);
                    jToolBar.add(this.printButton);
                    continue block6;
                }
                case 18: {
                    this.saveButton = new EasButton((ResourceManager)this, 18, lexicon.getText("saveReport"));
                    this.saveButton.addActionListener(this);
                    jToolBar.add(this.saveButton);
                    continue block6;
                }
                case 19: {
                    this.expandView = new EasToggleButton(this, 19, lexicon.getText("toggleTree"));
                    this.expandView.addActionListener(this);
                    jToolBar.add(this.expandView);
                }
            }
        }
        return jToolBar;
    }

    protected JComponent getApplicationContent() {
        if (this.mainSplit == null) {
            Lexicon lexicon = BEasApplet.lex;
            this.mainSplit = new JPanel(new BorderLayout(), false);
            this.add((Component)this.mainSplit, "Center");
            this.meterDateSplit = new JPanel(new BorderLayout(), false);
            this.meterDateSplit.add((Component)this.buildAvailableMetersContents(lexicon), "Center");
            this.meterDateSplit.add((Component)this.buildBillDateContents(lexicon), "South");
            this.mainSplit.add((Component)this.meterDateSplit, "West");
            this.mainSplit.add((Component)this.buildAnalyzerContent(), "Center");
            JPanel jPanel = new JPanel(new FlowLayout(1), false);
            this.runButton = new JButton(lexicon.getText("runReport"));
            this.runButton.setEnabled(true);
            this.runButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!WhatIfAnalyzerApplication.this.reportRunning) {
                        RunReportThread runReportThread = new RunReportThread();
                        runReportThread.start();
                    }
                }
            });
            jPanel.add(this.runButton);
            JPanel jPanel2 = new JPanel(new BorderLayout(), false);
            jPanel2.add((Component)jPanel, "Center");
            this.mainSplit.add((Component)jPanel2, "South");
        }
        return this.mainSplit;
    }

    private JComponent buildBillDateContents(Lexicon lexicon) {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("billPeriod")), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
        int n2 = easLocalTime.getMonth();
        int n3 = easLocalTime.getYear();
        if (n2 == 0) {
            n2 = 11;
            --n3;
        } else {
            --n2;
        }
        this.billMonthComboBox = new EasComboBox(new String[]{lexicon.getText("january.short"), lexicon.getText("february.short"), lexicon.getText("march.short"), lexicon.getText("april.short"), lexicon.getText("may.short"), lexicon.getText("june.short"), lexicon.getText("july.short"), lexicon.getText("august.short"), lexicon.getText("september.short"), lexicon.getText("october.short"), lexicon.getText("november.short"), lexicon.getText("december.short")});
        this.billMonthComboBox.setSelectedIndex(0);
        jPanel.add((Component)this.billMonthComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.billYearTextField = new EasTextField(4, 5);
        this.billYearTextField.setUseLabelAppearanceWhenDisabled(true);
        this.billYearTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WhatIfAnalyzerApplication.this.billYearTextField.selectAll();
            }
        });
        this.billYearTextField.setText(String.valueOf(n3));
        jPanel.add((Component)this.billYearTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("consecutiveBillingCycles")), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.numCyclesField = new NumberTextField(3, true);
        this.numCyclesField.setAllowNegative(false);
        this.numCyclesField.setUseLabelAppearanceWhenDisabled(true);
        this.numCyclesField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WhatIfAnalyzerApplication.this.numCyclesField.selectAll();
            }
        });
        this.numCyclesField.setText(String.valueOf(n2 + 1));
        jPanel.add((Component)this.numCyclesField, gridBagConstraints);
        return jPanel;
    }

    private JComponent buildAvailableMetersContents(Lexicon lexicon) {
        this.meters = new MeterTreePanel();
        return this.meters;
    }

    private JComponent buildAnalyzerContent() {
        Lexicon lexicon = BEasApplet.lex;
        this.analyzerDetails = new AnalyzerDetailPanel(this, this, lexicon);
        return this.analyzerDetails;
    }

    public void runReportEnabled(boolean bl) {
        this.runButton.setEnabled(bl);
    }

    private static String toBillPeriodString(String string, Lexicon lexicon) {
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        return lexicon.getText(string2) + " " + string3;
    }

    private static String getNextBillPeriod(String string) {
        int n = -2;
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = string2;
        if (string2.equals("Jan")) {
            string4 = "Feb";
        } else if (string2.equals("Feb")) {
            string4 = "Mar";
        } else if (string2.equals("Mar")) {
            string4 = "Apr";
        } else if (string2.equals("Apr")) {
            string4 = "May";
        } else if (string2.equals("May")) {
            string4 = "Jun";
        } else if (string2.equals("Jun")) {
            string4 = "Jul";
        } else if (string2.equals("Jul")) {
            string4 = "Aug";
        } else if (string2.equals("Aug")) {
            string4 = "Sep";
        } else if (string2.equals("Sep")) {
            string4 = "Oct";
        } else if (string2.equals("Oct")) {
            string4 = "Nov";
        } else if (string2.equals("Nov")) {
            string4 = "Dec";
        } else if (string2.equals("Dec")) {
            string4 = "Jan";
            ++n;
        }
        if (n >= 0) {
            string3 = String.valueOf(n);
        }
        return string4 + string3;
    }

    private void loadReconciliationReports(boolean bl) {
        if (this.analyzerDetails == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int n = this.numCyclesField.getIntValue();
        if (n <= 0) {
            n = 1;
        }
        String string = "Jan" + this.billYearTextField.getText();
        switch (this.billMonthComboBox.getSelectedIndex()) {
            case 0: {
                string = "Jan" + this.billYearTextField.getText();
                break;
            }
            case 1: {
                string = "Feb" + this.billYearTextField.getText();
                break;
            }
            case 2: {
                string = "Mar" + this.billYearTextField.getText();
                break;
            }
            case 3: {
                string = "Apr" + this.billYearTextField.getText();
                break;
            }
            case 4: {
                string = "May" + this.billYearTextField.getText();
                break;
            }
            case 5: {
                string = "Jun" + this.billYearTextField.getText();
                break;
            }
            case 6: {
                string = "Jul" + this.billYearTextField.getText();
                break;
            }
            case 7: {
                string = "Aug" + this.billYearTextField.getText();
                break;
            }
            case 8: {
                string = "Sep" + this.billYearTextField.getText();
                break;
            }
            case 9: {
                string = "Oct" + this.billYearTextField.getText();
                break;
            }
            case 10: {
                string = "Nov" + this.billYearTextField.getText();
                break;
            }
            case 11: {
                string = "Dec" + this.billYearTextField.getText();
            }
        }
        Object[] objectArray = this.tree.getSelectedUserObjects();
        AnalyzerReport analyzerReport = null;
        String string2 = "AnalyzerReport";
        String string3 = string;
        Lexicon lexicon = BEasApplet.lex;
        ProgressMonitor progressMonitor = new ProgressMonitor(this, lexicon.getText("analyzerProgress"), "", 1, 100);
        progressMonitor.setProgress(1);
        progressMonitor.setMillisToDecideToPopup(500);
        if (objectArray != null) {
            Object object;
            Vector<EasObject> vector = new Vector<EasObject>();
            for (int i = 0; i < objectArray.length; ++i) {
                EasObject easObject;
                Object object2 = objectArray[i];
                if (object2 != null && object2 instanceof Meter) {
                    easObject = (Meter)object2;
                    if (easObject == null) continue;
                    vector.addElement(easObject);
                    try {
                        string2 = ((Meter)easObject).getName() + " " + string3;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (object2 == null || !(object2 instanceof Site)) continue;
                easObject = (Site)object2;
                object = null;
                try {
                    object = ((Site)easObject).getMeters();
                    string2 = ((Group)easObject).getName() + " " + string3;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (object == null) continue;
                for (int j = 0; j < ((Meter[])object).length; ++j) {
                    Meter meter = object[j];
                    if (meter == null) continue;
                    vector.addElement(meter);
                }
            }
            int[] nArray = null;
            if (vector != null && vector.size() > 0) {
                nArray = new int[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    nArray[i] = ((Meter)vector.elementAt(i)).getId();
                }
            }
            progressMonitor.setMinimum(1);
            if (nArray != null) {
                progressMonitor.setMaximum(nArray.length * n + 1);
            } else {
                progressMonitor.setMaximum(2);
            }
            int n2 = 1;
            for (int i = 0; i < n && !progressMonitor.isCanceled(); ++i) {
                object = new Vector();
                for (int j = 0; j < objectArray.length && !progressMonitor.isCanceled(); ++j) {
                    Object object3;
                    EasObject easObject;
                    Object object4 = objectArray[j];
                    if (object4 != null && object4 instanceof Meter) {
                        easObject = (Meter)object4;
                        if (easObject == null) continue;
                        object3 = DEFAULT_RECONCILIATION_PREFIX + easObject.getId();
                        String string4 = (String)object3 + "_" + string;
                        try {
                            progressMonitor.setNote((((Meter)easObject).getSite() != null ? ((Meter)easObject).getSite().getName() + ": " : "") + ((Meter)easObject).getName() + " " + WhatIfAnalyzerApplication.toBillPeriodString(string, lexicon));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        progressMonitor.setProgress(n2);
                        ((Vector)object).addElement(this.loadMeterReport((String)object3, string4, string, bl));
                        ++n2;
                        continue;
                    }
                    if (object4 == null || !(object4 instanceof Site)) continue;
                    easObject = (Site)object4;
                    object3 = null;
                    try {
                        object3 = ((Site)easObject).getMeters();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (object3 == null) continue;
                    for (int k = 0; k < ((Meter[])object3).length && !progressMonitor.isCanceled(); ++k) {
                        Meter meter = object3[k];
                        if (meter == null) continue;
                        String string5 = DEFAULT_RECONCILIATION_PREFIX + meter.getId();
                        String string6 = string5 + "_" + string;
                        try {
                            progressMonitor.setNote((meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName() + " " + WhatIfAnalyzerApplication.toBillPeriodString(string, lexicon));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        progressMonitor.setProgress(n2);
                        ((Vector)object).addElement(this.loadMeterReport(string5, string6, string, bl));
                        ++n2;
                    }
                }
                if (progressMonitor.isCanceled()) break;
                ReconciliationReport[] reconciliationReportArray = null;
                if (object != null && ((Vector)object).size() > 0) {
                    reconciliationReportArray = new ReconciliationReport[((Vector)object).size()];
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        reconciliationReportArray[j] = (ReconciliationReport)((Vector)object).elementAt(j);
                    }
                }
                if (analyzerReport == null) {
                    analyzerReport = new AnalyzerReport(string2, string3, n, nArray, null, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
                }
                if (reconciliationReportArray != null) {
                    analyzerReport.addCycleResult(new BillCycleResult(string, string, reconciliationReportArray));
                }
                string = WhatIfAnalyzerApplication.getNextBillPeriod(string);
            }
        }
        if (!progressMonitor.isCanceled()) {
            this.currentAnalyzerReport = analyzerReport;
            this.analyzerDetails.setAnalyzerEditorValue(this.currentAnalyzerReport, true);
            this.mainSplit.revalidate();
            this.mainSplit.repaint();
        }
        progressMonitor.close();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean saveAnalyzerReport() {
        if (this.currentAnalyzerReport == null) {
            return false;
        }
        String string = this.getSession().getUserName();
        Lexicon lexicon = BEasApplet.lex;
        SaveReportDialog saveReportDialog = new SaveReportDialog(this, this.saveName, this.pub, false, this.getSession().hasAdminWrite(), false, lexicon);
        this.restrictInputToComponent(saveReportDialog);
        saveReportDialog.open();
        this.setInputEnabled(true);
        if (saveReportDialog.isCancelled()) {
            return false;
        }
        this.saveName = saveReportDialog.getReportName().replace(' ', '_');
        this.pub = saveReportDialog.isPublic();
        String string2 = this.pub ? "public" : string;
        this.currentAnalyzerReport.setName(this.saveName);
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = true;
        try {
            if (this.currentAnalyzerReport != null) {
                EasCostClient.storeAnalyzerReport(this.getSession(), this.currentAnalyzerReport, string2);
            }
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
        return bl;
    }

    private boolean runReport() {
        this.loadReconciliationReports(true);
        return true;
    }

    private ReconciliationReport loadMeterReport(String string, String string2, String string3, boolean bl) {
        try {
            ReconciliationReport reconciliationReport;
            if (this.reconciliations == null) {
                ReconciliationReport reconciliationReport2 = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, true, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                if (reconciliationReport2 == null) {
                    reconciliationReport2 = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, true, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                }
                if (reconciliationReport2 == null) {
                    reconciliationReport2 = new ReconciliationReport(string2 == null ? "temp" : string2);
                } else {
                    reconciliationReport2.setName(string2);
                }
                this.reconciliations = new ReconciliationReport[1];
                this.reconciliations[0] = reconciliationReport2;
                return reconciliationReport2;
            }
            if (string2 != null) {
                for (int i = 0; i < this.reconciliations.length; ++i) {
                    if (!this.reconciliations[i].getName().equals(string2)) continue;
                    if (bl) {
                        this.reconciliations[i] = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, true, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                        if (this.reconciliations[i] == null) {
                            this.reconciliations[i] = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, true, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                        }
                        if (this.reconciliations[i] == null) {
                            this.reconciliations[i] = new ReconciliationReport(string2);
                        } else {
                            this.reconciliations[i].setName(string2);
                        }
                    }
                    return this.reconciliations[i];
                }
            }
            if ((reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, true, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null)) == null) {
                reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, true, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
            }
            if (reconciliationReport == null) {
                reconciliationReport = new ReconciliationReport(string2 == null ? "temp" : string2);
            } else {
                reconciliationReport.setName(string2);
            }
            ReconciliationReport[] reconciliationReportArray = new ReconciliationReport[this.reconciliations.length + 1];
            for (int i = 0; i < this.reconciliations.length; ++i) {
                reconciliationReportArray[i] = this.reconciliations[i];
            }
            reconciliationReportArray[this.reconciliations.length] = reconciliationReport;
            this.reconciliations = reconciliationReportArray;
            return reconciliationReport;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.refreshButton) {
            this.initApplication(true);
            ((FilterTreeModel)this.tree.getModel()).reload();
            this.expandView.setSelected(false);
            this.setExpandedView(true);
        } else if (jButton == this.printButton) {
            try {
                this.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (jButton == this.saveButton) {
            this.saveAnalyzerReport();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        pageFormat.setOrientation(0);
        Pageable pageable = this.getPageable(pageFormat);
        if (pageable == null || pageable.getNumberOfPages() == 0) {
            printerJob.cancel();
            return;
        }
        try {
            if (printerJob.printDialog()) {
                printerJob.setPageable(pageable);
                printerJob.print();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = null;
        if (this.analyzerDetails != null) {
            this.analyzerDetails.print(this.createImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight()).getGraphics(), pageFormat, 0);
            int n = this.analyzerDetails.getEstimateNumPages();
            book = new Book();
            book.append(this.analyzerDetails, pageFormat, n);
        }
        return book;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.filterSelection) {
            this.updateFilter();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.expandView) {
            this.setExpandedView(!bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    private void setExpandedView(boolean bl) {
        if (this.meterDateSplit != null) {
            this.meterDateSplit.setVisible(bl);
            this.runReportEnabled(bl);
        }
        if (this.mainSplit != null) {
            this.mainSplit.revalidate();
            this.mainSplit.repaint();
        }
    }

    public void initFilters() {
        EasSession easSession = this.getSession();
        Lexicon lexicon = BEasApplet.lex;
        this.filterSelection.addItem(new AllSitesFilter(easSession, lexicon));
        this.filterSelection.addItem(new StaticGroupFilter(easSession, lexicon));
        Group[] groupArray = Group.getGroups('D', easSession);
        if (groupArray == null) {
            return;
        }
        int n = groupArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (groupArray[i].isHidden()) continue;
                this.filterSelection.addItem(new DynamicGroupFilter(easSession, (DynGroup)groupArray[i], lexicon));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.filterSelection.setMaximumRowCount(Math.min(this.filterSelection.getItemCount(), 10));
    }

    public void updateFilter() {
        Filter filter = (Filter)this.filterSelection.getSelectedItem();
        if (filter != this.currentFilter) {
            this.currentFilter = filter;
            FilterTreeModel filterTreeModel = new FilterTreeModel(new FilterRootNode(filter, new RateLinkDbObjectValidator()));
            this.tree.setModel(filterTreeModel);
        }
    }

    public BEasApplet getApplet() {
        return this.easApplet;
    }

    public String[] getMeterStrings() {
        String[] stringArray = null;
        Object[] objectArray = this.tree.getSelectedUserObjects();
        if (objectArray == null || objectArray.length < 1) {
            return stringArray;
        }
        stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                Meter meter = (Meter)objectArray[i];
                stringArray[i] = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringArray;
    }

    public String getBillPeriodString() {
        return this.billMonthComboBox.getSelectedItemString() + " " + this.billYearTextField.getText();
    }

    public String getNumConsecutiveCyclesString() {
        return this.numCyclesField.getText();
    }

    public void dataCleansingChanged() {
        this.reconciliations = null;
    }

    private class MeterFilterTree
    extends FilterTree {
        public MeterFilterTree(ResourceManager resourceManager) {
            super(resourceManager);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            boolean bl = (mouseEvent.getModifiers() & 4) != 0;
            boolean bl2 = mouseEvent.isControlDown();
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                this.clearSelection();
                return;
            }
            if (bl) {
                if (bl2) {
                    this.addSelectionPath(treePath);
                } else {
                    this.setSelectionPath(treePath);
                }
            }
        }
    }

    private class MeterTreePanel
    extends JComponent {
        public MeterTreePanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(1, 2, 2));
            WhatIfAnalyzerApplication.this.filterSelection = new XpComboBox();
            WhatIfAnalyzerApplication.this.filterSelection.addActionListener(WhatIfAnalyzerApplication.this);
            jPanel.add(WhatIfAnalyzerApplication.this.filterSelection);
            this.add((Component)jPanel, "North");
            WhatIfAnalyzerApplication.this.tree = new MeterFilterTree(WhatIfAnalyzerApplication.this.getResourceManager());
            WhatIfAnalyzerApplication.this.tree.getSelectionModel().setSelectionMode(4);
            this.add((Component)new JScrollPane(WhatIfAnalyzerApplication.this.tree), "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            float f = (float)(dimension.width + 30) * 1.2f;
            return new Dimension((int)f, dimension.height);
        }
    }

    private class RunReportThread
    extends Thread {
        public RunReportThread() {
            super("RunWhatIfAnalyzer");
        }

        public void run() {
            WhatIfAnalyzerApplication.this.reportRunning = true;
            if (WhatIfAnalyzerApplication.this.runReport()) {
                // empty if block
            }
            WhatIfAnalyzerApplication.this.reportRunning = false;
        }
    }
}

