/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.analyzer;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.rate.components.FixedFee;
import com.tridium.eas.cost.report.AnalyzerAdjustment;
import com.tridium.eas.cost.report.BillCycleResult;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.reports.analyzer.AnalyzerDetailPanel;
import com.tridium.eas.ui.widgets.EasScrollPane;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.NumberTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class AnalyzerComponentDetailPanel
extends JPanel {
    private EasSession session = null;
    private AnalyzerDetailPanel parentPanel = null;
    private Lexicon lex;
    private CardLayout layout = null;
    private BillCycleResult currentSelectedReport = null;
    private JPanel reportPanel = null;
    private boolean changeOccurred = false;
    private boolean initializingBillValues = false;
    private CostTextField totalCalcCostTextField;
    private CostTextField totalAdjCostTextField;
    private CostTextField savingsTextField;
    private static final int CALC_UNITS = 0;
    private static final int FEE_PER_UNIT = 1;

    protected AnalyzerComponentDetailPanel(AnalyzerDetailPanel analyzerDetailPanel, Lexicon lexicon) {
        this.lex = lexicon;
        this.parentPanel = analyzerDetailPanel;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add("show", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.add("hide", jPanel2);
        jPanel2.add((Component)this.buildDefaultView(), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        jPanel3.setBorder(BorderFactory.createTitledBorder(lexicon.getText("billCycleDetails")));
        jPanel3.add((Component)this.buildBillCycleResultPanel(), "Center");
        jPanel.add((Component)jPanel3, "Center");
        this.setAnalyzerRowEditorValue(null);
    }

    private JComponent buildDefaultView() {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("billCycleDetails")));
        return jPanel;
    }

    private JComponent buildBillCycleResultPanel() {
        this.reportPanel = new JPanel(new BorderLayout(), false);
        return this.reportPanel;
    }

    public String decodeMeterRateName(AnalyzerAdjustment analyzerAdjustment) {
        String string = "";
        try {
            String string2 = analyzerAdjustment.getName();
            int n = string2.indexOf(95);
            if (n >= 0) {
                int n2 = Integer.parseInt(string2.substring("meter".length(), n));
                Meter meter = Meter.get(n2, this.getSession());
                string = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName() + ", " + this.lex.getText("rate") + " ";
            }
            string = string + analyzerAdjustment.getReconciliationRow().getFullName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private void layoutBillCycleResult(BillCycleResult billCycleResult) {
        this.reportPanel.removeAll();
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        EasScrollPane easScrollPane = new EasScrollPane(jPanel);
        easScrollPane.getViewport().setBackground(Color.white);
        this.reportPanel.add((Component)easScrollPane, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        if (billCycleResult != null && billCycleResult.getAdjustments() != null && billCycleResult.getAdjustments().length > 0) {
            DecimalFormat decimalFormat;
            JComponent jComponent;
            AnalyzerAdjustment[] analyzerAdjustmentArray = billCycleResult.getAdjustments();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            String string = billCycleResult.getBillingCycle(this.lex);
            JLabel jLabel = new JLabel(string, 0);
            jLabel.setForeground(Color.red);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)new JLabel(this.lex.getText("calculatedUnits"), 0), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)new JLabel(this.lex.getText("costPerUnit"), 0), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)new JLabel(this.lex.getText("calculatedCost"), 0), gridBagConstraints);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)new JLabel(this.lex.getText("adjustedCost"), 0), gridBagConstraints);
            JComponent jComponent2 = null;
            JComponent jComponent3 = null;
            for (int i = 0; i < analyzerAdjustmentArray.length; ++i) {
                JComponent jComponent4;
                ReconciliationRow reconciliationRow;
                if (analyzerAdjustmentArray[i] == null || (reconciliationRow = analyzerAdjustmentArray[i].getReconciliationRow()) == null) continue;
                if (reconciliationRow.getShowCostColumns()) {
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 100.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel.add((Component)new JLabel(reconciliationRow.getDisplayName(this.lex, analyzerAdjustmentArray[i].getUnitsExist()), 2), gridBagConstraints);
                    gridBagConstraints.gridx = 3;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    jComponent4 = new CostTextField(9, false);
                    ((JTextField)jComponent4).setHorizontalAlignment(4);
                    DecimalFormat decimalFormat2 = new DecimalFormat(this.lex.getText("costValueFormat"));
                    ((NumberTextField)jComponent4).setFormatter(decimalFormat2);
                    ((NumberTextField)jComponent4).setMaximumFractionDigits(2);
                    ((EasTextField)jComponent4).setUseLabelAppearanceWhenDisabled(true);
                    ((NumberTextField)jComponent4).setText(analyzerAdjustmentArray[i].getCalculatedCost());
                    ((JTextComponent)jComponent4).setEditable(false);
                    jPanel.add((Component)jComponent4, gridBagConstraints);
                    gridBagConstraints.gridx = 4;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    CostTextField costTextField = new CostTextField(9, false);
                    costTextField.setHorizontalAlignment(4);
                    costTextField.setFormatter(decimalFormat2);
                    costTextField.setMaximumFractionDigits(2);
                    costTextField.setUseLabelAppearanceWhenDisabled(true);
                    costTextField.setText(analyzerAdjustmentArray[i].getAdjustedCost());
                    costTextField.setEditable(false);
                    jPanel.add((Component)costTextField, gridBagConstraints);
                    if (analyzerAdjustmentArray[i].getUnitsExist()) {
                        gridBagConstraints.gridx = 1;
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.anchor = 10;
                        jComponent = new CostTextField(9, false);
                        ((JTextField)jComponent).setHorizontalAlignment(4);
                        ((NumberTextField)jComponent).setFormatter(decimalFormat2);
                        ((NumberTextField)jComponent).setMaximumFractionDigits(2);
                        ((EasTextField)jComponent).setUseLabelAppearanceWhenDisabled(true);
                        ((JTextComponent)jComponent).getDocument().addDocumentListener(new AnalyzerAdjustmentListener((NumberTextField)jComponent, analyzerAdjustmentArray[i], 0));
                        jComponent.addKeyListener(new AnalyzerAdjustmentKeyAdapter((NumberTextField)jComponent, costTextField, analyzerAdjustmentArray[i]));
                        jComponent.addFocusListener(new AnalyzerAdjustmentFocusAdapter((NumberTextField)jComponent, costTextField, analyzerAdjustmentArray[i]));
                        ((NumberTextField)jComponent).setText(analyzerAdjustmentArray[i].getCalcUnits());
                        ((JTextComponent)jComponent).setEditable(true);
                        jPanel.add((Component)jComponent, gridBagConstraints);
                        if (jComponent2 != null) {
                            jComponent2.setNextFocusableComponent(jComponent);
                        } else {
                            jComponent3 = jComponent;
                        }
                        jComponent2 = jComponent;
                    } else {
                        gridBagConstraints.gridx = 1;
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.anchor = 10;
                        jPanel.add((Component)new JLabel(this.lex.getText("notApplicable"), 0), gridBagConstraints);
                    }
                    if (analyzerAdjustmentArray[i].getFeeExists()) {
                        gridBagConstraints.gridx = 2;
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.anchor = 10;
                        jComponent = new CostTextField(9, false);
                        ((JTextField)jComponent).setHorizontalAlignment(4);
                        decimalFormat = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
                        ((NumberTextField)jComponent).setFormatter(decimalFormat);
                        if (reconciliationRow.getRateComponent() != null && reconciliationRow.getRateComponent() instanceof FixedFee) {
                            ((NumberTextField)jComponent).setMaximumFractionDigits(10);
                        } else {
                            ((NumberTextField)jComponent).setMaximumFractionDigits(2);
                        }
                        ((EasTextField)jComponent).setUseLabelAppearanceWhenDisabled(true);
                        ((JTextComponent)jComponent).getDocument().addDocumentListener(new AnalyzerAdjustmentListener((NumberTextField)jComponent, analyzerAdjustmentArray[i], 1));
                        jComponent.addKeyListener(new AnalyzerAdjustmentKeyAdapter((NumberTextField)jComponent, costTextField, analyzerAdjustmentArray[i]));
                        jComponent.addFocusListener(new AnalyzerAdjustmentFocusAdapter((NumberTextField)jComponent, costTextField, analyzerAdjustmentArray[i]));
                        ((NumberTextField)jComponent).setText(analyzerAdjustmentArray[i].getFeePerUnit());
                        ((JTextComponent)jComponent).setEditable(true);
                        jPanel.add((Component)jComponent, gridBagConstraints);
                        if (jComponent2 != null) {
                            jComponent2.setNextFocusableComponent(jComponent);
                        } else {
                            jComponent3 = jComponent;
                        }
                        jComponent2 = jComponent;
                        continue;
                    }
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 10;
                    jPanel.add((Component)new JLabel(this.lex.getText("notApplicable"), 0), gridBagConstraints);
                    continue;
                }
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 5;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                jPanel.add((Component)new JSeparator(0), gridBagConstraints);
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 5;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                jComponent4 = new JLabel(this.decodeMeterRateName(analyzerAdjustmentArray[i]), 2);
                jComponent4.setForeground(Color.blue);
                jPanel.add((Component)jComponent4, gridBagConstraints);
            }
            if (jComponent3 != null) {
                jComponent2.setNextFocusableComponent(jComponent3);
            }
            JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
            double d = billCycleResult.getCalculatedCost();
            double d2 = billCycleResult.getAdjustedCost();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            jComponent = new JLabel(string + " " + this.lex.getText("total") + "   ", 4);
            jComponent.setBackground(Color.darkGray);
            jComponent.setForeground(Color.green);
            jComponent.setOpaque(true);
            jPanel2.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            this.totalCalcCostTextField = new CostTextField(9, false);
            this.totalCalcCostTextField.setHorizontalAlignment(4);
            decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
            this.totalCalcCostTextField.setFormatter(decimalFormat);
            this.totalCalcCostTextField.setMaximumFractionDigits(2);
            this.totalCalcCostTextField.setUseLabelAppearanceWhenDisabled(true);
            this.totalCalcCostTextField.setText(d);
            this.totalCalcCostTextField.setEditable(false);
            jPanel2.add((Component)this.totalCalcCostTextField, gridBagConstraints);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            this.totalAdjCostTextField = new CostTextField(9, false);
            this.totalAdjCostTextField.setHorizontalAlignment(4);
            this.totalAdjCostTextField.setFormatter(decimalFormat);
            this.totalAdjCostTextField.setMaximumFractionDigits(2);
            this.totalAdjCostTextField.setUseLabelAppearanceWhenDisabled(true);
            this.totalAdjCostTextField.setText(d2);
            this.totalAdjCostTextField.setEditable(false);
            jPanel2.add((Component)this.totalAdjCostTextField, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            JLabel jLabel2 = new JLabel(string + " " + this.lex.getText("savings") + "   ", 4);
            jLabel2.setBackground(Color.darkGray);
            jLabel2.setForeground(Color.green);
            jLabel2.setOpaque(true);
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            this.savingsTextField = new CostTextField(9, false);
            this.savingsTextField.setHorizontalAlignment(4);
            this.savingsTextField.setFormatter(decimalFormat);
            this.savingsTextField.setMaximumFractionDigits(2);
            this.savingsTextField.setUseLabelAppearanceWhenDisabled(true);
            this.savingsTextField.setText(d - d2);
            this.savingsTextField.setEditable(false);
            jPanel2.add((Component)this.savingsTextField, gridBagConstraints);
            JPanel jPanel3 = new JPanel(new FlowLayout(1), false);
            JButton jButton = new JButton(this.lex.getText("reset") + " " + string);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AnalyzerComponentDetailPanel.this.resetBillCycle();
                }
            });
            jPanel3.add(jButton);
            JPanel jPanel4 = new JPanel(new BorderLayout(), false);
            jPanel4.add((Component)jPanel3, "South");
            jPanel4.add((Component)jPanel2, "North");
            this.reportPanel.add((Component)jPanel4, "South");
        }
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.reportPanel.revalidate();
        this.reportPanel.repaint();
    }

    public void setAnalyzerRowEditorValue(BillCycleResult billCycleResult) {
        this.initializingBillValues = true;
        this.currentSelectedReport = billCycleResult;
        if (billCycleResult == null) {
            this.layout.show(this, "hide");
        } else {
            this.layout.show(this, "show");
            this.layoutBillCycleResult(billCycleResult);
        }
        this.initializingBillValues = false;
    }

    private void computeTotals(BillCycleResult billCycleResult) {
        double d = billCycleResult.getCalculatedCost();
        double d2 = billCycleResult.getAdjustedCost();
        this.totalCalcCostTextField.setText(d);
        this.totalAdjCostTextField.setText(d2);
        this.savingsTextField.setText(d - d2);
        this.parentPanel.computeTotals(billCycleResult);
    }

    private void resetBillCycle() {
        if (this.currentSelectedReport == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.parentPanel.getParentApplication(), this.lex.getText("confirmResetCycle") + " " + this.currentSelectedReport.getBillingCycle(this.lex), this.lex.getText("confirmReset"), 0);
        if (n != 0) {
            return;
        }
        this.currentSelectedReport.resetComponents();
        this.setAnalyzerRowEditorValue(this.currentSelectedReport);
        this.computeTotals(this.currentSelectedReport);
    }

    protected void init(EasSession easSession) {
        this.session = easSession;
        this.layout.show(this, "hide");
    }

    protected void initApplication() {
        this.parentPanel.initApplication();
    }

    protected EasSession getSession() {
        return this.session;
    }

    public AnalyzerDetailPanel getParentPanel() {
        return this.parentPanel;
    }

    private class AnalyzerAdjustmentFocusAdapter
    extends FocusAdapter {
        private NumberTextField referenceTextField;
        private NumberTextField adjustedTextField;
        private AnalyzerAdjustment adjustment;

        public AnalyzerAdjustmentFocusAdapter(NumberTextField numberTextField, NumberTextField numberTextField2, AnalyzerAdjustment analyzerAdjustment) {
            this.referenceTextField = numberTextField;
            this.adjustedTextField = numberTextField2;
            this.adjustment = analyzerAdjustment;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.selectItLater(focusEvent.getComponent());
        }

        private void selectItLater(Component component) {
            if (component instanceof JTextField) {
                final JTextField jTextField = (JTextField)component;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jTextField.selectAll();
                    }
                });
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!AnalyzerComponentDetailPanel.this.changeOccurred) {
                return;
            }
            this.referenceTextField.setText(this.referenceTextField.getDoubleValue());
            this.adjustedTextField.setText(this.adjustment.getAdjustedCost());
            AnalyzerComponentDetailPanel.this.computeTotals(AnalyzerComponentDetailPanel.this.currentSelectedReport);
            AnalyzerComponentDetailPanel.this.changeOccurred = false;
        }
    }

    private class AnalyzerAdjustmentKeyAdapter
    extends KeyAdapter {
        private NumberTextField referenceTextField;
        private NumberTextField adjustedTextField;
        private AnalyzerAdjustment adjustment;

        public AnalyzerAdjustmentKeyAdapter(NumberTextField numberTextField, NumberTextField numberTextField2, AnalyzerAdjustment analyzerAdjustment) {
            this.referenceTextField = numberTextField;
            this.adjustedTextField = numberTextField2;
            this.adjustment = analyzerAdjustment;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                if (!AnalyzerComponentDetailPanel.this.changeOccurred) {
                    return;
                }
                this.referenceTextField.setText(this.referenceTextField.getDoubleValue());
                this.adjustedTextField.setText(this.adjustment.getAdjustedCost());
                AnalyzerComponentDetailPanel.this.computeTotals(AnalyzerComponentDetailPanel.this.currentSelectedReport);
                AnalyzerComponentDetailPanel.this.changeOccurred = false;
            }
        }
    }

    private class AnalyzerAdjustmentListener
    implements DocumentListener {
        private NumberTextField referenceTextField;
        private AnalyzerAdjustment adjustment;
        private int attribute;

        public AnalyzerAdjustmentListener(NumberTextField numberTextField, AnalyzerAdjustment analyzerAdjustment, int n) {
            this.referenceTextField = numberTextField;
            this.adjustment = analyzerAdjustment;
            this.attribute = n;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (AnalyzerComponentDetailPanel.this.initializingBillValues) {
                return;
            }
            try {
                switch (this.attribute) {
                    case 0: {
                        this.adjustment.setCalcUnits(this.referenceTextField.getDoubleValue());
                        break;
                    }
                    case 1: {
                        this.adjustment.setFeePerUnit(this.referenceTextField.getDoubleValue());
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            AnalyzerComponentDetailPanel.this.changeOccurred = true;
        }
    }
}

