/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.linking;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.ui.RateListCellRenderer;
import com.tridium.eas.cost.ui.linking.RateLinkDetailPanel;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasList;
import java.awt.Cursor;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RateLinkList
extends EasList
implements ListSelectionListener {
    private RateHistory rateHistory = null;
    private RateLinkDetailPanel rateLinkDetails = null;
    private EasSession session = null;

    public RateLinkList(ResourceManager resourceManager) {
        this.setModel(new DefaultListModel());
        this.setCellRenderer(new RateListCellRenderer(resourceManager));
        this.addListSelectionListener(this);
    }

    public void setRateLinkEditor(RateLinkDetailPanel rateLinkDetailPanel) {
        this.rateLinkDetails = rateLinkDetailPanel;
    }

    public void setRateHistory(RateHistory rateHistory) {
        this.rateHistory = rateHistory;
    }

    public void init(EasSession easSession) {
        this.session = easSession;
        this.refreshData();
    }

    public EasSession getSession() {
        return this.session;
    }

    public void refreshData() {
        RateLink[] rateLinkArray;
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.removeAllElements();
        if (this.rateHistory != null && (rateLinkArray = this.rateHistory.getRateLinks()) != null) {
            for (int i = 0; i < rateLinkArray.length; ++i) {
                defaultListModel.addElement(rateLinkArray[i]);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.rateLinkDetails == null) {
            return;
        }
        RateLink rateLink = (RateLink)this.getSelectedValue();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.rateLinkDetails.setRateLinkEditorValue(rateLink);
        this.setCursor(Cursor.getDefaultCursor());
    }
}

