/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.linking;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.ui.linking.RateHistoryDetailPanel;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.ui.widgets.DateEditor;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.EasTimeEditor;
import com.tridium.eas.ui.widgets.NumberTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RateLinkDetailPanel
extends JPanel
implements FocusListener {
    private RateHistoryDetailPanel parentPanel = null;
    protected Lexicon lex;
    private CardLayout layout = null;
    private JLabel nameLabel;
    private boolean initializingRateLinkValues;
    private RateLink currentSelectedRateLink = null;
    private DateEditor startEditor = null;
    private EasTimeEditor startTimeEditor = null;
    private DateEditor endEditor = null;
    private EasTimeEditor endTimeEditor = null;
    private JCheckBox presentTimeCheckBox = null;
    private DateEditor billingStartEditor = null;
    private EasTimeEditor billingStartTimeEditor = null;
    private NumberTextField billingCycleTextField = null;
    private EasComboBox billingCycleComboBox = null;
    private EasTextField accountTextField = null;
    private EasTextField custServRepTextField = null;
    private EasTextField custServRepPhoneTextField = null;
    private EasTextField custServRepEmailTextField = null;
    private EasTextField salesRepTextField = null;
    private EasTextField salesRepPhoneTextField = null;
    private EasTextField salesRepEmailTextField = null;

    protected RateLinkDetailPanel(RateHistoryDetailPanel rateHistoryDetailPanel, Lexicon lexicon) {
        this.lex = lexicon;
        this.parentPanel = rateHistoryDetailPanel;
        this.initializingRateLinkValues = true;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add("show", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.add("hide", jPanel2);
        jPanel.add((Component)this.buildRateLinkEditor(), "Center");
        this.setRateLinkEditorValue(null);
        this.initializingRateLinkValues = false;
    }

    protected JComponent buildRateLinkEditor() {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("rateLinkDetails")));
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        this.nameLabel = new JLabel("-");
        jPanel2.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("startTime")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        this.startEditor = new DateEditor(this.lex);
        this.startEditor.setValue(EasLocalTime.getCurrentTime());
        this.startEditor.setAllowFuture(true);
        this.startEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(RateLinkDetailPanel.this.startEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                calendar.set(11, RateLinkDetailPanel.this.startTimeEditor.getHour());
                calendar.set(12, RateLinkDetailPanel.this.startTimeEditor.getMinute());
                calendar.set(13, RateLinkDetailPanel.this.startTimeEditor.getSecond());
                calendar.set(14, RateLinkDetailPanel.this.startTimeEditor.getMillisecond());
                RateLinkDetailPanel.this.getSelectedRateLink().setStartTime(calendar.getTime().getTime());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        jPanel2.add((Component)this.startEditor, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.startTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.parentPanel.getResourceManager().getIconImage(312)), new ImageIcon(this.parentPanel.getResourceManager().getIconImage(313)));
        this.startTimeEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(RateLinkDetailPanel.this.startEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                calendar.set(11, RateLinkDetailPanel.this.startTimeEditor.getHour());
                calendar.set(12, RateLinkDetailPanel.this.startTimeEditor.getMinute());
                calendar.set(13, RateLinkDetailPanel.this.startTimeEditor.getSecond());
                calendar.set(14, RateLinkDetailPanel.this.startTimeEditor.getMillisecond());
                RateLinkDetailPanel.this.getSelectedRateLink().setStartTime(calendar.getTime().getTime());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        jPanel2.add((Component)this.startTimeEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("endTime")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.presentTimeCheckBox = new JCheckBox(this.lex.getText("presentTime"));
        this.presentTimeCheckBox.setSelected(true);
        this.presentTimeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                if (RateLinkDetailPanel.this.presentTimeCheckBox.isSelected()) {
                    RateLinkDetailPanel.this.getSelectedRateLink().setEndTime(-1L);
                    RateLinkDetailPanel.this.endEditor.setEditable(false);
                    RateLinkDetailPanel.this.endEditor.setVisible(false);
                    RateLinkDetailPanel.this.endTimeEditor.setVisible(false);
                    RateLinkDetailPanel.this.endTimeEditor.setEditable(false);
                } else {
                    Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                    calendar.setTime(new Date(RateLinkDetailPanel.this.endEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                    calendar.set(11, RateLinkDetailPanel.this.endTimeEditor.getHour());
                    calendar.set(12, RateLinkDetailPanel.this.endTimeEditor.getMinute());
                    calendar.set(13, RateLinkDetailPanel.this.endTimeEditor.getSecond());
                    calendar.set(14, RateLinkDetailPanel.this.endTimeEditor.getMillisecond());
                    RateLinkDetailPanel.this.getSelectedRateLink().setEndTime(calendar.getTime().getTime());
                    RateLinkDetailPanel.this.endEditor.setEditable(true);
                    RateLinkDetailPanel.this.endEditor.setVisible(true);
                    RateLinkDetailPanel.this.endTimeEditor.setVisible(true);
                    RateLinkDetailPanel.this.endTimeEditor.setEditable(true);
                }
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        jPanel2.add((Component)this.presentTimeCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        this.endEditor = new DateEditor(this.lex);
        this.endEditor.setValue(EasLocalTime.getCurrentTime());
        this.endEditor.setEditable(false);
        this.endEditor.setVisible(false);
        this.endEditor.setAllowFuture(true);
        this.endEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(RateLinkDetailPanel.this.endEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                calendar.set(11, RateLinkDetailPanel.this.endTimeEditor.getHour());
                calendar.set(12, RateLinkDetailPanel.this.endTimeEditor.getMinute());
                calendar.set(13, RateLinkDetailPanel.this.endTimeEditor.getSecond());
                calendar.set(14, RateLinkDetailPanel.this.endTimeEditor.getMillisecond());
                RateLinkDetailPanel.this.getSelectedRateLink().setEndTime(calendar.getTime().getTime());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        jPanel2.add((Component)this.endEditor, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.endTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.parentPanel.getResourceManager().getIconImage(312)), new ImageIcon(this.parentPanel.getResourceManager().getIconImage(313)));
        this.endTimeEditor.setVisible(false);
        this.endTimeEditor.setEditable(false);
        this.endTimeEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(RateLinkDetailPanel.this.endEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                calendar.set(11, RateLinkDetailPanel.this.endTimeEditor.getHour());
                calendar.set(12, RateLinkDetailPanel.this.endTimeEditor.getMinute());
                calendar.set(13, RateLinkDetailPanel.this.endTimeEditor.getSecond());
                calendar.set(14, RateLinkDetailPanel.this.endTimeEditor.getMillisecond());
                RateLinkDetailPanel.this.getSelectedRateLink().setEndTime(calendar.getTime().getTime());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        jPanel2.add((Component)this.endTimeEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("billingCycle")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.billingCycleTextField = new NumberTextField(3, true);
        this.billingCycleTextField.setAllowNegative(false);
        this.billingCycleTextField.setUseLabelAppearanceWhenDisabled(true);
        this.billingCycleTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                RateLinkDetailPanel.this.getSelectedRateLink().getBillingCycle().setNumber(RateLinkDetailPanel.this.billingCycleTextField.getIntValue());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        this.billingCycleTextField.addFocusListener(this);
        jPanel2.add((Component)this.billingCycleTextField, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.billingCycleComboBox = new EasComboBox(new String[]{this.lex.getText("numMinutes"), this.lex.getText("numHours"), this.lex.getText("numDays"), this.lex.getText("numWeeks"), this.lex.getText("numMonths"), this.lex.getText("numYears")});
        this.billingCycleComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                RateLinkDetailPanel.this.getSelectedRateLink().getBillingCycle().setTimeUnits(RateLinkDetailPanel.this.billingCycleComboBox.getSelectedIndex() + 1);
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        jPanel2.add((Component)this.billingCycleComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("billingCycleStart")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        this.billingStartEditor = new DateEditor(this.lex);
        this.billingStartEditor.setValue(EasLocalTime.getCurrentTime());
        this.billingStartEditor.setAllowFuture(true);
        this.billingStartEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(RateLinkDetailPanel.this.billingStartEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                calendar.set(11, RateLinkDetailPanel.this.billingStartTimeEditor.getHour());
                calendar.set(12, RateLinkDetailPanel.this.billingStartTimeEditor.getMinute());
                calendar.set(13, RateLinkDetailPanel.this.billingStartTimeEditor.getSecond());
                calendar.set(14, RateLinkDetailPanel.this.billingStartTimeEditor.getMillisecond());
                RateLinkDetailPanel.this.getSelectedRateLink().setBillingCycleStart(calendar.getTime().getTime());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        jPanel2.add((Component)this.billingStartEditor, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.billingStartTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.parentPanel.getResourceManager().getIconImage(312)), new ImageIcon(this.parentPanel.getResourceManager().getIconImage(313)));
        this.billingStartTimeEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(RateLinkDetailPanel.this.billingStartEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                calendar.set(11, RateLinkDetailPanel.this.billingStartTimeEditor.getHour());
                calendar.set(12, RateLinkDetailPanel.this.billingStartTimeEditor.getMinute());
                calendar.set(13, RateLinkDetailPanel.this.billingStartTimeEditor.getSecond());
                calendar.set(14, RateLinkDetailPanel.this.billingStartTimeEditor.getMillisecond());
                RateLinkDetailPanel.this.getSelectedRateLink().setBillingCycleStart(calendar.getTime().getTime());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        jPanel2.add((Component)this.billingStartTimeEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("account")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.accountTextField = new EasTextField(20, 50);
        this.accountTextField.setUseLabelAppearanceWhenDisabled(true);
        this.accountTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                RateLinkDetailPanel.this.getSelectedRateLink().setAccount(RateLinkDetailPanel.this.accountTextField.getText());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        this.accountTextField.addFocusListener(this);
        jPanel2.add((Component)this.accountTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("custServRep")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.custServRepTextField = new EasTextField(20, 50);
        this.custServRepTextField.setUseLabelAppearanceWhenDisabled(true);
        this.custServRepTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                RateLinkDetailPanel.this.getSelectedRateLink().setCustServRep(RateLinkDetailPanel.this.custServRepTextField.getText());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        this.custServRepTextField.addFocusListener(this);
        jPanel2.add((Component)this.custServRepTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("custServRepPhone")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.custServRepPhoneTextField = new EasTextField(20, 50);
        this.custServRepPhoneTextField.setUseLabelAppearanceWhenDisabled(true);
        this.custServRepPhoneTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                RateLinkDetailPanel.this.getSelectedRateLink().setCustServRepPhone(RateLinkDetailPanel.this.custServRepPhoneTextField.getText());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        this.custServRepPhoneTextField.addFocusListener(this);
        jPanel2.add((Component)this.custServRepPhoneTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("custServRepEmail")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.custServRepEmailTextField = new EasTextField(20, 250);
        this.custServRepEmailTextField.setUseLabelAppearanceWhenDisabled(true);
        this.custServRepEmailTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                RateLinkDetailPanel.this.getSelectedRateLink().setCustServRepEmail(RateLinkDetailPanel.this.custServRepEmailTextField.getText());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        this.custServRepEmailTextField.addFocusListener(this);
        jPanel2.add((Component)this.custServRepEmailTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("salesRep")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.salesRepTextField = new EasTextField(20, 50);
        this.salesRepTextField.setUseLabelAppearanceWhenDisabled(true);
        this.salesRepTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                RateLinkDetailPanel.this.getSelectedRateLink().setSalesRep(RateLinkDetailPanel.this.salesRepTextField.getText());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        this.salesRepTextField.addFocusListener(this);
        jPanel2.add((Component)this.salesRepTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("salesRepPhone")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.salesRepPhoneTextField = new EasTextField(20, 50);
        this.salesRepPhoneTextField.setUseLabelAppearanceWhenDisabled(true);
        this.salesRepPhoneTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                RateLinkDetailPanel.this.getSelectedRateLink().setSalesRepPhone(RateLinkDetailPanel.this.salesRepPhoneTextField.getText());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        this.salesRepPhoneTextField.addFocusListener(this);
        jPanel2.add((Component)this.salesRepPhoneTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("salesRepEmail")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.salesRepEmailTextField = new EasTextField(20, 250);
        this.salesRepEmailTextField.setUseLabelAppearanceWhenDisabled(true);
        this.salesRepEmailTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateLinkDetailPanel.this.initializingRateLinkValues) {
                    return;
                }
                RateLinkDetailPanel.this.getSelectedRateLink().setSalesRepEmail(RateLinkDetailPanel.this.salesRepEmailTextField.getText());
                RateLinkDetailPanel.this.handleRateLinkChange();
            }
        });
        this.salesRepEmailTextField.addFocusListener(this);
        jPanel2.add((Component)this.salesRepEmailTextField, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        this.accountTextField.setNextFocusableComponent(this.custServRepTextField);
        this.custServRepTextField.setNextFocusableComponent(this.custServRepPhoneTextField);
        this.custServRepPhoneTextField.setNextFocusableComponent(this.custServRepEmailTextField);
        this.custServRepEmailTextField.setNextFocusableComponent(this.salesRepTextField);
        this.salesRepTextField.setNextFocusableComponent(this.salesRepPhoneTextField);
        this.salesRepPhoneTextField.setNextFocusableComponent(this.salesRepEmailTextField);
        this.salesRepEmailTextField.setNextFocusableComponent(this.accountTextField);
        return jPanel;
    }

    public void setRateLinkEditorValue(RateLink rateLink) {
        this.currentSelectedRateLink = rateLink;
        if (rateLink == null) {
            this.layout.show(this, "hide");
        } else {
            this.layout.show(this, "show");
            this.initializingRateLinkValues = true;
            this.nameLabel.setText(rateLink.getName());
            this.startEditor.setValue(new EasLocalTime(rateLink.getStartTime(), CostTimeUtil.DEFAULT_TZ));
            Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
            calendar.setTime(new Date(rateLink.getStartTime()));
            this.startTimeEditor.setValues(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
            if (rateLink.getEndTime() < 0L) {
                this.presentTimeCheckBox.setSelected(true);
                this.endEditor.setEditable(false);
                this.endEditor.setVisible(false);
                this.endTimeEditor.setVisible(false);
                this.endTimeEditor.setEditable(false);
                this.endEditor.setValue(EasLocalTime.getCurrentTime());
                this.endTimeEditor.setValues(0, 0, 0, 0);
            } else {
                this.presentTimeCheckBox.setSelected(false);
                this.endEditor.setEditable(true);
                this.endEditor.setVisible(true);
                this.endEditor.setValue(new EasLocalTime(rateLink.getEndTime(), CostTimeUtil.DEFAULT_TZ));
                this.endTimeEditor.setVisible(true);
                this.endTimeEditor.setEditable(true);
                calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(rateLink.getEndTime()));
                this.endTimeEditor.setValues(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
            }
            this.billingStartEditor.setValue(new EasLocalTime(rateLink.getBillingCycleStart(), CostTimeUtil.DEFAULT_TZ));
            calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
            calendar.setTime(new Date(rateLink.getBillingCycleStart()));
            this.billingStartTimeEditor.setValues(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
            this.billingCycleTextField.setText(rateLink.getBillingCycle().getNumber());
            this.billingCycleComboBox.setSelectedIndex(rateLink.getBillingCycle().getTimeUnits() - 1);
            this.accountTextField.setText(rateLink.getAccount());
            this.custServRepTextField.setText(rateLink.getCustServRep());
            this.custServRepPhoneTextField.setText(rateLink.getCustServRepPhone());
            this.custServRepEmailTextField.setText(rateLink.getCustServRepEmail());
            this.salesRepTextField.setText(rateLink.getSalesRep());
            this.salesRepPhoneTextField.setText(rateLink.getSalesRepPhone());
            this.salesRepEmailTextField.setText(rateLink.getSalesRepEmail());
            this.initializingRateLinkValues = false;
        }
    }

    public void handleRateLinkChange() {
        this.parentPanel.handleRateChange();
    }

    public RateLink getSelectedRateLink() {
        return this.currentSelectedRateLink;
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof JTextField && ((JTextField)component).isEditable()) {
            this.selectItLater(component);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private void selectItLater(Component component) {
        if (component instanceof JTextField) {
            final JTextField jTextField = (JTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTextField.selectAll();
                }
            });
        }
    }
}

