/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.linking;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.ui.linking.AttachARateApplication;
import com.tridium.eas.cost.ui.linking.RateLinkDetailPanel;
import com.tridium.eas.cost.ui.linking.RateLinkList;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.ListPopupHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class RateHistoryDetailPanel
extends JPanel {
    private EasSession session = null;
    private ResourceManager resourceManager = null;
    private AttachARateApplication parentApplication = null;
    protected Lexicon lex;
    private JButton attachButton = null;
    private JButton detachButton = null;
    private JButton applyButton = null;
    private JButton discardChangesButton = null;
    private RateLinkList rateLinks = null;
    private RateLinkDetailPanel rateLinkDetails = null;
    private boolean initializingRateValues;
    private RateHistory currentSelectedRateHistory = null;
    private RateLinkPopup rateLinkPopup = null;
    private JSplitPane upperPane = null;

    protected RateHistoryDetailPanel(ResourceManager resourceManager, AttachARateApplication attachARateApplication, Lexicon lexicon) {
        this.lex = lexicon;
        this.resourceManager = resourceManager;
        this.parentApplication = attachARateApplication;
        this.initializingRateValues = true;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add((Component)jPanel, "Center");
        this.upperPane = new JSplitPane(0);
        this.upperPane.setDividerSize(4);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 4;
        jPanel2.add((Component)this.buildRateLinksPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 50.0;
        jPanel2.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        this.attachButton = new JButton("<< " + lexicon.getText("attachRate"));
        this.attachButton.setEnabled(false);
        this.attachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RateHistoryDetailPanel.this.addRateLink();
            }
        });
        jPanel2.add((Component)this.attachButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.detachButton = new JButton(lexicon.getText("detachRate") + " >>");
        this.detachButton.setEnabled(false);
        this.detachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RateHistoryDetailPanel.this.deleteRateLink();
            }
        });
        jPanel2.add((Component)this.detachButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 50.0;
        jPanel2.add((Component)new JLabel(""), gridBagConstraints);
        this.upperPane.setTopComponent(jPanel2);
        this.upperPane.setBottomComponent(this.buildRateLinkEditorPanel());
        jPanel.add((Component)new JScrollPane(this.upperPane), "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1), false);
        this.applyButton = new JButton(lexicon.getText("applyChanges"));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateHistoryDetailPanel.this.applyChanges()) {
                    RateHistoryDetailPanel.this.discardChangesButton.setEnabled(false);
                    RateHistoryDetailPanel.this.applyButton.setEnabled(false);
                }
            }
        });
        jPanel3.add(this.applyButton);
        this.discardChangesButton = new JButton(lexicon.getText("discardChanges"));
        this.discardChangesButton.setEnabled(false);
        this.discardChangesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RateHistoryDetailPanel.this.applyButton.setEnabled(false);
                RateHistoryDetailPanel.this.discardChangesButton.setEnabled(false);
                RateHistoryDetailPanel.this.discardChanges();
            }
        });
        jPanel3.add(this.discardChangesButton);
        jPanel.add((Component)jPanel3, "South");
        this.initializingRateValues = false;
    }

    protected JComponent buildRateLinksPanel() {
        this.rateLinks = new RateLinkList(this.getResourceManager());
        this.rateLinks.getSelectionModel().setSelectionMode(0);
        this.rateLinks.setPopupHandler(new ListPopupHandler(){

            public void openPopup(Object object, int n, int n2, int n3) {
                if (RateHistoryDetailPanel.this.rateLinks.isEnabled()) {
                    if (RateHistoryDetailPanel.this.rateLinkPopup == null) {
                        RateHistoryDetailPanel.this.rateLinkPopup = new RateLinkPopup(RateHistoryDetailPanel.this.lex);
                    }
                    RateHistoryDetailPanel.this.rateLinkPopup.show(RateHistoryDetailPanel.this.rateLinks, n >= 0, n2, n3);
                }
            }
        });
        this.rateLinks.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    RateHistoryDetailPanel.this.deleteRateLink();
                } else if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown() && AttachARateApplication.clipboard != null && AttachARateApplication.clipboard instanceof Rate) {
                    RateHistoryDetailPanel.this.pasteRateLink();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("rateHistory")));
        jPanel.add((Component)new JScrollPane(this.rateLinks), "Center");
        return jPanel;
    }

    protected JComponent buildRateLinkEditorPanel() {
        this.rateLinkDetails = new RateLinkDetailPanel(this, this.lex);
        this.rateLinks.setRateLinkEditor(this.rateLinkDetails);
        return this.rateLinkDetails;
    }

    public void setRateHistoryEditorValue(RateHistory rateHistory) {
        if (rateHistory == null) {
            this.attachButton.setEnabled(false);
            this.detachButton.setEnabled(false);
        } else {
            this.attachButton.setEnabled(true);
            this.detachButton.setEnabled(true);
        }
        this.initializingRateValues = true;
        this.currentSelectedRateHistory = rateHistory;
        this.rateLinks.setRateHistory(rateHistory);
        this.rateLinks.refreshData();
        this.initializingRateValues = false;
    }

    private RateHistory getSelectedRateHistory() {
        return this.currentSelectedRateHistory;
    }

    public void handleRateChange() {
        if (this.initializingRateValues) {
            return;
        }
        this.parentApplication.setMeterSelectionEnabled(false);
        this.discardChangesButton.setEnabled(true);
        this.applyButton.setEnabled(true);
    }

    public void doRefresh() {
        this.discardChangesButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.attachButton.setEnabled(false);
        this.detachButton.setEnabled(false);
    }

    public boolean unsavedChangesExist() {
        if (this.applyButton != null) {
            return this.applyButton.isEnabled();
        }
        return false;
    }

    public boolean applyChanges() {
        RateHistory rateHistory = this.getSelectedRateHistory();
        boolean bl = this.parentApplication.saveRateHistory(rateHistory);
        if (bl) {
            this.parentApplication.setMeterSelectionEnabled(true);
        }
        return bl;
    }

    private void discardChanges() {
        this.parentApplication.setMeterSelectionEnabled(true);
        this.parentApplication.reloadRateHistory();
    }

    private void addRateLink() {
        this.parentApplication.addRate();
    }

    private void deleteRateLink() {
        RateHistory rateHistory = this.getSelectedRateHistory();
        if (rateHistory != null && this.rateLinks != null && this.rateLinks.getSelectedValue() != null) {
            rateHistory.removeRateLink((RateLink)this.rateLinks.getSelectedValue());
            this.setRateHistoryEditorValue(rateHistory);
            this.handleRateChange();
        }
    }

    private void pasteRateLink() {
        Rate rate = (Rate)AttachARateApplication.clipboard;
        if (rate != null) {
            this.parentApplication.addRate(rate);
        }
    }

    public void setSelectedRateLink(RateLink rateLink) {
        if (this.rateLinks != null) {
            this.rateLinks.setSelectedValue(rateLink, true);
        }
    }

    protected void init(EasSession easSession) {
        this.session = easSession;
        this.rateLinks.init(easSession);
        this.rateLinks.setEnabled(true);
    }

    protected void initApplication() {
        this.parentApplication.initApplication(true);
    }

    protected EasSession getSession() {
        return this.session;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    private class RateLinkPopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem pasteItem = null;
        private boolean pasteItemShowing = false;
        private Lexicon lex;

        public RateLinkPopup(Lexicon lexicon) {
            this.lex = lexicon;
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("detachRate"), 0, null);
            this.pasteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Paste"), 1, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    RateHistoryDetailPanel.this.deleteRateLink();
                    break;
                }
                case 1: {
                    RateHistoryDetailPanel.this.pasteRateLink();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            boolean bl2;
            boolean bl3 = bl;
            boolean bl4 = bl2 = AttachARateApplication.clipboard != null && AttachARateApplication.clipboard instanceof Rate;
            if (bl3 && !this.deleteItemShowing) {
                this.deleteItem.addActionListener(this);
                this.insert(this.deleteItem, 0);
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl3) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            if (bl2 && !this.pasteItemShowing) {
                this.add(this.pasteItem);
                this.revalidate();
                this.pasteItemShowing = true;
            } else if (this.pasteItemShowing && !bl2) {
                this.remove(this.pasteItem);
                this.revalidate();
                this.pasteItemShowing = false;
            }
            if (this.deleteItemShowing || this.pasteItemShowing) {
                super.show(component, n, n2);
            }
        }
    }
}

