/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.datatypes.BillPeriodLengthRateSchedule;
import com.tridium.eas.cost.datatypes.CompositeRateSchedule;
import com.tridium.eas.cost.datatypes.DailyRateSchedule;
import com.tridium.eas.cost.datatypes.DayOfWeekRateSchedule;
import com.tridium.eas.cost.datatypes.IntersectionCompositeRateSchedule;
import com.tridium.eas.cost.datatypes.MonthOfYearRateSchedule;
import com.tridium.eas.cost.datatypes.RateSchedule;
import com.tridium.eas.cost.datatypes.TimeRangeRateSchedule;
import com.tridium.eas.cost.datatypes.UnionCompositeRateSchedule;
import com.tridium.eas.cost.rate.components.CustomRateComponent;
import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.ui.AllRateSchedulesFilter;
import com.tridium.eas.cost.ui.CreateARateApplication;
import com.tridium.eas.cost.ui.NewRateScheduleDialog;
import com.tridium.eas.cost.ui.RateFilterRootNode;
import com.tridium.eas.cost.ui.RateScheduleParentPanel;
import com.tridium.eas.cost.ui.RateScheduleTree;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.CheckList;
import com.tridium.eas.ui.widgets.DateEditor;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.EasTimeEditor;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import com.tridium.eas.ui.widgets.FilterTreePopupHandler;
import com.tridium.eas.ui.widgets.NumberTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RateScheduleDetailPanel
extends JPanel
implements FocusListener {
    private EasSession session = null;
    private ResourceManager resourceManager = null;
    private RateScheduleParentPanel parentPanel = null;
    protected Lexicon lex;
    private CardLayout layout = null;
    private AllRateSchedulesFilter rateSchedulesFilter = null;
    private RateScheduleTree rateSchedules = null;
    private boolean initializingRateValues;
    private RateSchedule originalRateSchedule = null;
    private RateSchedule currentSelectedRateSchedule = null;
    private RateSchedulePopup rateSchedulePopup = null;
    private CardLayout rateScheduleLayout;
    private JPanel rateSchedulePanel;
    private Hashtable nameTextFields = new Hashtable(7);
    private Hashtable exclusiveCheckBoxes = new Hashtable(7);
    private DateEditor startEditor;
    private EasTimeEditor startRangeTimeEditor;
    private DateEditor endEditor;
    private EasTimeEditor endRangeTimeEditor;
    private CheckList includedDaysEditor;
    private CheckList includedMonthsEditor;
    private DocumentListener nameDocumentListener = null;
    private ActionListener exclusiveActionListener = null;
    private EasTimeEditor startTimeEditor = null;
    private EasTimeEditor endTimeEditor = null;
    private NumberTextField minPeriodTextField = null;
    private EasComboBox minPeriodComboBox = null;
    private NumberTextField maxPeriodTextField = null;
    private EasComboBox maxPeriodComboBox = null;
    private JCheckBox maxPeriodCheckBox = null;
    static /* synthetic */ Class class$com$tridium$eas$cost$datatypes$RateSchedule;

    public RateScheduleDetailPanel(ResourceManager resourceManager, RateScheduleParentPanel rateScheduleParentPanel, Lexicon lexicon) {
        this.lex = lexicon;
        this.resourceManager = resourceManager;
        this.parentPanel = rateScheduleParentPanel;
        this.initializingRateValues = true;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(lexicon.getText("rateSchedule")));
        this.add("show", jPanel);
        JSplitPane jSplitPane = new JSplitPane(0);
        jPanel.add((Component)jSplitPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.add("hide", jPanel2);
        jSplitPane.setTopComponent(this.buildRateScheduleContents());
        this.rateScheduleLayout = new CardLayout();
        this.rateSchedulePanel = new JPanel(this.rateScheduleLayout, false);
        this.rateSchedulePanel.add((Component)new JPanel(), "hide");
        this.rateSchedulePanel.add((Component)this.buildRateScheduleEditor(new DailyRateSchedule(lexicon.getText("dailyRateSchedule"))), DailyRateSchedule.TYPE);
        this.rateSchedulePanel.add((Component)this.buildRateScheduleEditor(new DayOfWeekRateSchedule(lexicon.getText("dayOfWeekRateSchedule"))), DayOfWeekRateSchedule.TYPE);
        this.rateSchedulePanel.add((Component)this.buildRateScheduleEditor(new MonthOfYearRateSchedule(lexicon.getText("monthOfYearRateSchedule"))), MonthOfYearRateSchedule.TYPE);
        this.rateSchedulePanel.add((Component)this.buildRateScheduleEditor(new TimeRangeRateSchedule(lexicon.getText("timeRangeRateSchedule"))), TimeRangeRateSchedule.TYPE);
        this.rateSchedulePanel.add((Component)this.buildRateScheduleEditor(new IntersectionCompositeRateSchedule(lexicon.getText("intersectionRateSchedule"))), IntersectionCompositeRateSchedule.TYPE);
        this.rateSchedulePanel.add((Component)this.buildRateScheduleEditor(new UnionCompositeRateSchedule(lexicon.getText("unionRateSchedule"))), UnionCompositeRateSchedule.TYPE);
        this.rateSchedulePanel.add((Component)this.buildRateScheduleEditor(new BillPeriodLengthRateSchedule(lexicon.getText("billPeriodRateSchedule"))), BillPeriodLengthRateSchedule.TYPE);
        this.rateScheduleLayout.show(this.rateSchedulePanel, "hide");
        jSplitPane.setBottomComponent(this.rateSchedulePanel);
        this.setRateScheduleEditorValue(null);
        this.initializingRateValues = false;
    }

    protected JComponent buildRateScheduleContents() {
        this.rateSchedules = new RateScheduleTree(this.getResourceManager());
        this.rateSchedules.setRateScheduleEditor(this);
        this.rateSchedules.setVisibleRowCount(5);
        this.rateSchedules.setShowsRootHandles(false);
        this.rateSchedules.getSelectionModel().setSelectionMode(1);
        if (this.parentPanel.rateSchedulesEditable()) {
            this.rateSchedules.setPopupHandler(new FilterTreePopupHandler(){

                public void openPopup(FilterTree filterTree, FilterTreeNode filterTreeNode, int n, int n2) {
                    if (filterTree.isEnabled()) {
                        if (RateScheduleDetailPanel.this.rateSchedulePopup == null) {
                            RateScheduleDetailPanel.this.rateSchedulePopup = new RateSchedulePopup(RateScheduleDetailPanel.this.lex);
                        }
                        RateScheduleDetailPanel.this.rateSchedulePopup.show(filterTree, filterTreeNode != null, n, n2);
                    }
                }
            });
            this.rateSchedules.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 155) {
                        RateScheduleDetailPanel.this.createRateSchedule();
                    } else if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                        RateScheduleDetailPanel.this.deleteRateSchedule();
                    } else if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                        RateScheduleDetailPanel.this.copyRateSchedule();
                    } else if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown() && CreateARateApplication.clipboard != null && CreateARateApplication.clipboard instanceof RateSchedule && RateScheduleDetailPanel.this.canAddSchedule()) {
                        RateScheduleDetailPanel.this.pasteRateSchedule();
                    }
                }
            });
        }
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.add((Component)new JScrollPane(this.rateSchedules), "Center");
        return jPanel;
    }

    protected JComponent buildRateScheduleEditor(RateSchedule rateSchedule) {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("type")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(rateSchedule.getName()), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        EasTextField easTextField = new EasTextField(20, 50);
        easTextField.setUseLabelAppearanceWhenDisabled(true);
        if (this.parentPanel.rateSchedulesEditable()) {
            if (this.nameDocumentListener == null) {
                this.nameDocumentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        RateScheduleDetailPanel.this.getSelectedRateSchedule().setName(((EasTextField)RateScheduleDetailPanel.this.nameTextFields.get(RateScheduleDetailPanel.this.getSelectedRateSchedule().getType())).getText());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(true);
                    }
                };
            }
            easTextField.getDocument().addDocumentListener(this.nameDocumentListener);
            easTextField.addFocusListener(this);
        } else {
            easTextField.setEditable(false);
        }
        jPanel.add((Component)easTextField, gridBagConstraints);
        this.nameTextFields.put(rateSchedule.getType(), easTextField);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("exclusive")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        JCheckBox jCheckBox = new JCheckBox("");
        if (this.parentPanel.rateSchedulesEditable()) {
            if (this.exclusiveActionListener == null) {
                this.exclusiveActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        RateScheduleDetailPanel.this.getSelectedRateSchedule().setExclusive(((JCheckBox)RateScheduleDetailPanel.this.exclusiveCheckBoxes.get(RateScheduleDetailPanel.this.getSelectedRateSchedule().getType())).isSelected());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(true);
                    }
                };
            }
            jCheckBox.addActionListener(this.exclusiveActionListener);
            jCheckBox.addFocusListener(this);
        } else {
            jCheckBox.setEnabled(false);
        }
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        this.exclusiveCheckBoxes.put(rateSchedule.getType(), jCheckBox);
        if (rateSchedule instanceof DailyRateSchedule) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("startTime")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.startTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.getResourceManager().getIconImage(312)), new ImageIcon(this.getResourceManager().getIconImage(313)));
            if (this.parentPanel.rateSchedulesEditable()) {
                this.startTimeEditor.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        ((DailyRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setStartHour(RateScheduleDetailPanel.this.startTimeEditor.getHour());
                        ((DailyRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setStartMinute(RateScheduleDetailPanel.this.startTimeEditor.getMinute());
                        ((DailyRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setStartSecond(RateScheduleDetailPanel.this.startTimeEditor.getSecond());
                        ((DailyRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setStartMillisecond(RateScheduleDetailPanel.this.startTimeEditor.getMillisecond());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.startTimeEditor.setEditable(false);
            }
            jPanel.add((Component)this.startTimeEditor, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("endTime")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.endTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.getResourceManager().getIconImage(312)), new ImageIcon(this.getResourceManager().getIconImage(313)));
            if (this.parentPanel.rateSchedulesEditable()) {
                this.endTimeEditor.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        ((DailyRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setEndHour(RateScheduleDetailPanel.this.endTimeEditor.getHour());
                        ((DailyRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setEndMinute(RateScheduleDetailPanel.this.endTimeEditor.getMinute());
                        ((DailyRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setEndSecond(RateScheduleDetailPanel.this.endTimeEditor.getSecond());
                        ((DailyRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setEndMillisecond(RateScheduleDetailPanel.this.endTimeEditor.getMillisecond());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.endTimeEditor.setEditable(false);
            }
            jPanel.add((Component)this.endTimeEditor, gridBagConstraints);
        }
        if (rateSchedule instanceof DayOfWeekRateSchedule) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("includedDays")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.includedDaysEditor = new CheckList(new String[]{this.lex.getText("sunday"), this.lex.getText("monday"), this.lex.getText("tuesday"), this.lex.getText("wednesday"), this.lex.getText("thursday"), this.lex.getText("friday"), this.lex.getText("saturday")});
            if (this.parentPanel.rateSchedulesEditable()) {
                this.includedDaysEditor.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        int[] nArray = RateScheduleDetailPanel.this.includedDaysEditor.getSelectedIndices();
                        if (nArray != null) {
                            ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidSunday(false);
                            ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidMonday(false);
                            ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidTuesday(false);
                            ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidWednesday(false);
                            ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidThursday(false);
                            ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidFriday(false);
                            ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidSaturday(false);
                            block9: for (int i = 0; i < nArray.length; ++i) {
                                switch (nArray[i]) {
                                    case 0: {
                                        ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidSunday(true);
                                        continue block9;
                                    }
                                    case 1: {
                                        ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidMonday(true);
                                        continue block9;
                                    }
                                    case 2: {
                                        ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidTuesday(true);
                                        continue block9;
                                    }
                                    case 3: {
                                        ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidWednesday(true);
                                        continue block9;
                                    }
                                    case 4: {
                                        ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidThursday(true);
                                        continue block9;
                                    }
                                    case 5: {
                                        ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidFriday(true);
                                        continue block9;
                                    }
                                    case 6: {
                                        ((DayOfWeekRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setValidSaturday(true);
                                    }
                                }
                            }
                        }
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.includedDaysEditor.setEnabled(false);
            }
            jPanel.add((Component)this.includedDaysEditor, gridBagConstraints);
        }
        if (rateSchedule instanceof MonthOfYearRateSchedule) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("includedMonths")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.includedMonthsEditor = new CheckList(new String[]{this.lex.getText("january"), this.lex.getText("february"), this.lex.getText("march"), this.lex.getText("april"), this.lex.getText("may.short"), this.lex.getText("june"), this.lex.getText("july"), this.lex.getText("august"), this.lex.getText("september"), this.lex.getText("october"), this.lex.getText("november"), this.lex.getText("december")});
            if (this.parentPanel.rateSchedulesEditable()) {
                this.includedMonthsEditor.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        int[] nArray = RateScheduleDetailPanel.this.includedMonthsEditor.getSelectedIndices();
                        if (nArray != null) {
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setJanuary(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setFebruary(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setMarch(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setApril(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setMay(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setJune(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setJuly(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setAugust(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setSeptember(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setOctober(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setNovember(false);
                            ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setDecember(false);
                            block14: for (int i = 0; i < nArray.length; ++i) {
                                switch (nArray[i]) {
                                    case 0: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setJanuary(true);
                                        continue block14;
                                    }
                                    case 1: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setFebruary(true);
                                        continue block14;
                                    }
                                    case 2: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setMarch(true);
                                        continue block14;
                                    }
                                    case 3: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setApril(true);
                                        continue block14;
                                    }
                                    case 4: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setMay(true);
                                        continue block14;
                                    }
                                    case 5: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setJune(true);
                                        continue block14;
                                    }
                                    case 6: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setJuly(true);
                                        continue block14;
                                    }
                                    case 7: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setAugust(true);
                                        continue block14;
                                    }
                                    case 8: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setSeptember(true);
                                        continue block14;
                                    }
                                    case 9: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setOctober(true);
                                        continue block14;
                                    }
                                    case 10: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setNovember(true);
                                        continue block14;
                                    }
                                    case 11: {
                                        ((MonthOfYearRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setDecember(true);
                                    }
                                }
                            }
                        }
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.includedMonthsEditor.setEnabled(false);
            }
            jPanel.add((Component)this.includedMonthsEditor, gridBagConstraints);
        }
        if (rateSchedule instanceof TimeRangeRateSchedule) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("start")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            this.startEditor = new DateEditor(this.lex);
            this.startEditor.setValue(EasLocalTime.getCurrentTime());
            this.startEditor.setAllowFuture(true);
            if (this.parentPanel.rateSchedulesEditable()) {
                this.startEditor.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                        calendar.setTime(new Date(RateScheduleDetailPanel.this.startEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                        calendar.set(11, RateScheduleDetailPanel.this.startRangeTimeEditor.getHour());
                        calendar.set(12, RateScheduleDetailPanel.this.startRangeTimeEditor.getMinute());
                        calendar.set(13, RateScheduleDetailPanel.this.startRangeTimeEditor.getSecond());
                        calendar.set(14, RateScheduleDetailPanel.this.startRangeTimeEditor.getMillisecond());
                        ((TimeRangeRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setStartTime(calendar.getTime().getTime());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.startEditor.setEditable(false);
            }
            jPanel2.add((Component)this.startEditor, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.startRangeTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.getResourceManager().getIconImage(312)), new ImageIcon(this.getResourceManager().getIconImage(313)));
            if (this.parentPanel.rateSchedulesEditable()) {
                this.startRangeTimeEditor.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                        calendar.setTime(new Date(RateScheduleDetailPanel.this.startEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                        calendar.set(11, RateScheduleDetailPanel.this.startRangeTimeEditor.getHour());
                        calendar.set(12, RateScheduleDetailPanel.this.startRangeTimeEditor.getMinute());
                        calendar.set(13, RateScheduleDetailPanel.this.startRangeTimeEditor.getSecond());
                        calendar.set(14, RateScheduleDetailPanel.this.startRangeTimeEditor.getMillisecond());
                        ((TimeRangeRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setStartTime(calendar.getTime().getTime());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.startRangeTimeEditor.setEditable(false);
            }
            jPanel2.add((Component)this.startRangeTimeEditor, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("end")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2 = new JPanel(new GridBagLayout(), false);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            this.endEditor = new DateEditor(this.lex);
            this.endEditor.setValue(EasLocalTime.getCurrentTime());
            this.endEditor.setAllowFuture(true);
            if (this.parentPanel.rateSchedulesEditable()) {
                this.endEditor.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                        calendar.setTime(new Date(RateScheduleDetailPanel.this.endEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                        calendar.set(11, RateScheduleDetailPanel.this.endRangeTimeEditor.getHour());
                        calendar.set(12, RateScheduleDetailPanel.this.endRangeTimeEditor.getMinute());
                        calendar.set(13, RateScheduleDetailPanel.this.endRangeTimeEditor.getSecond());
                        calendar.set(14, RateScheduleDetailPanel.this.endRangeTimeEditor.getMillisecond());
                        ((TimeRangeRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setEndTime(calendar.getTime().getTime());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.endEditor.setEditable(false);
            }
            jPanel2.add((Component)this.endEditor, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.endRangeTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.getResourceManager().getIconImage(312)), new ImageIcon(this.getResourceManager().getIconImage(313)));
            if (this.parentPanel.rateSchedulesEditable()) {
                this.endRangeTimeEditor.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                        calendar.setTime(new Date(RateScheduleDetailPanel.this.endEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                        calendar.set(11, RateScheduleDetailPanel.this.endRangeTimeEditor.getHour());
                        calendar.set(12, RateScheduleDetailPanel.this.endRangeTimeEditor.getMinute());
                        calendar.set(13, RateScheduleDetailPanel.this.endRangeTimeEditor.getSecond());
                        calendar.set(14, RateScheduleDetailPanel.this.endRangeTimeEditor.getMillisecond());
                        ((TimeRangeRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setEndTime(calendar.getTime().getTime());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.endRangeTimeEditor.setEditable(false);
            }
            jPanel2.add((Component)this.endRangeTimeEditor, gridBagConstraints);
        }
        if (rateSchedule instanceof BillPeriodLengthRateSchedule) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("minBillPeriod")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.minPeriodTextField = new NumberTextField(3, true);
            this.minPeriodTextField.setAllowNegative(false);
            this.minPeriodTextField.setUseLabelAppearanceWhenDisabled(true);
            if (this.parentPanel.rateSchedulesEditable()) {
                this.minPeriodTextField.getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        ((BillPeriodLengthRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).getMinLength().setNumber(RateScheduleDetailPanel.this.minPeriodTextField.getIntValue());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
                this.minPeriodTextField.addFocusListener(this);
            } else {
                this.minPeriodTextField.setEditable(false);
            }
            jPanel.add((Component)this.minPeriodTextField, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.minPeriodComboBox = new EasComboBox(new String[]{this.lex.getText("numMinutes"), this.lex.getText("numHours"), this.lex.getText("numDays"), this.lex.getText("numWeeks")});
            if (this.parentPanel.rateSchedulesEditable()) {
                this.minPeriodComboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        ((BillPeriodLengthRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).getMinLength().setTimeUnits(RateScheduleDetailPanel.this.minPeriodComboBox.getSelectedIndex() + 1);
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.minPeriodComboBox.setEnabled(false);
            }
            jPanel.add((Component)this.minPeriodComboBox, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(this.lex.getText("maxBillPeriod")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.maxPeriodCheckBox = new JCheckBox(this.lex.getText("noUpperLimit"));
            if (this.parentPanel.rateSchedulesEditable()) {
                this.maxPeriodCheckBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = RateScheduleDetailPanel.this.maxPeriodCheckBox.isSelected();
                        RateScheduleDetailPanel.this.maxPeriodTextField.setVisible(!bl);
                        RateScheduleDetailPanel.this.maxPeriodComboBox.setVisible(!bl);
                        RateScheduleDetailPanel.this.revalidate();
                        RateScheduleDetailPanel.this.repaint();
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        ((BillPeriodLengthRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).setNoUpperLimit(bl);
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.maxPeriodCheckBox.setEnabled(false);
            }
            jPanel.add((Component)this.maxPeriodCheckBox, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.maxPeriodTextField = new NumberTextField(3, true);
            this.maxPeriodTextField.setAllowNegative(false);
            this.maxPeriodTextField.setUseLabelAppearanceWhenDisabled(true);
            if (this.parentPanel.rateSchedulesEditable()) {
                this.maxPeriodTextField.getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        ((BillPeriodLengthRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).getMaxLength().setNumber(RateScheduleDetailPanel.this.maxPeriodTextField.getIntValue());
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
                this.maxPeriodTextField.addFocusListener(this);
            } else {
                this.maxPeriodTextField.setEditable(false);
            }
            jPanel.add((Component)this.maxPeriodTextField, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.maxPeriodComboBox = new EasComboBox(new String[]{this.lex.getText("numMinutes"), this.lex.getText("numHours"), this.lex.getText("numDays"), this.lex.getText("numWeeks")});
            if (this.parentPanel.rateSchedulesEditable()) {
                this.maxPeriodComboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateScheduleDetailPanel.this.initializingRateValues) {
                            return;
                        }
                        ((BillPeriodLengthRateSchedule)RateScheduleDetailPanel.this.getSelectedRateSchedule()).getMaxLength().setTimeUnits(RateScheduleDetailPanel.this.maxPeriodComboBox.getSelectedIndex() + 1);
                        RateScheduleDetailPanel.this.handleRateScheduleChange(false);
                    }
                });
            } else {
                this.maxPeriodComboBox.setEnabled(false);
            }
            jPanel.add((Component)this.maxPeriodComboBox, gridBagConstraints);
        }
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        return jPanel;
    }

    public void setRateComponentEditorValue(RateComponent rateComponent) {
        if (rateComponent == null || !(rateComponent instanceof FlatFeePerUnit) || rateComponent instanceof CustomRateComponent && !((CustomRateComponent)((Object)rateComponent)).supportsRateSchedule()) {
            this.layout.show(this, "hide");
        } else {
            this.layout.show(this, "show");
            this.rateSchedulesFilter.setRateComponent(rateComponent);
            this.rateSchedules.refresh();
            this.originalRateSchedule = rateComponent instanceof FlatFeePerUnit ? ((FlatFeePerUnit)rateComponent).getRateSchedule() : ((CustomRateComponent)((Object)rateComponent)).getRateSchedule();
            this.setSelectedRateSchedule(this.originalRateSchedule);
        }
    }

    public void setRateScheduleEditorValue(RateSchedule rateSchedule) {
        this.currentSelectedRateSchedule = rateSchedule;
        if (this.originalRateSchedule == null) {
            this.originalRateSchedule = rateSchedule;
        }
        if (rateSchedule == null) {
            this.rateScheduleLayout.show(this.rateSchedulePanel, "hide");
        } else {
            int n;
            Object object;
            this.initializingRateValues = true;
            this.rateScheduleLayout.show(this.rateSchedulePanel, rateSchedule.getType());
            ((EasTextField)this.nameTextFields.get(rateSchedule.getType())).setText(rateSchedule.getName());
            ((JCheckBox)this.exclusiveCheckBoxes.get(rateSchedule.getType())).setSelected(rateSchedule.getExclusive());
            if (rateSchedule instanceof DailyRateSchedule) {
                this.startTimeEditor.setValues(((DailyRateSchedule)rateSchedule).getStartHour(), ((DailyRateSchedule)rateSchedule).getStartMinute(), ((DailyRateSchedule)rateSchedule).getStartSecond(), ((DailyRateSchedule)rateSchedule).getStartMillisecond());
                this.endTimeEditor.setValues(((DailyRateSchedule)rateSchedule).getEndHour(), ((DailyRateSchedule)rateSchedule).getEndMinute(), ((DailyRateSchedule)rateSchedule).getEndSecond(), ((DailyRateSchedule)rateSchedule).getEndMillisecond());
            }
            if (rateSchedule instanceof DayOfWeekRateSchedule) {
                object = new int[7];
                n = 0;
                block23: for (int i = 0; i < 7; ++i) {
                    switch (i) {
                        case 0: {
                            if (!((DayOfWeekRateSchedule)rateSchedule).getValidSunday()) continue block23;
                            object[n] = i;
                            ++n;
                            continue block23;
                        }
                        case 1: {
                            if (!((DayOfWeekRateSchedule)rateSchedule).getValidMonday()) continue block23;
                            object[n] = i;
                            ++n;
                            continue block23;
                        }
                        case 2: {
                            if (!((DayOfWeekRateSchedule)rateSchedule).getValidTuesday()) continue block23;
                            object[n] = i;
                            ++n;
                            continue block23;
                        }
                        case 3: {
                            if (!((DayOfWeekRateSchedule)rateSchedule).getValidWednesday()) continue block23;
                            object[n] = i;
                            ++n;
                            continue block23;
                        }
                        case 4: {
                            if (!((DayOfWeekRateSchedule)rateSchedule).getValidThursday()) continue block23;
                            object[n] = i;
                            ++n;
                            continue block23;
                        }
                        case 5: {
                            if (!((DayOfWeekRateSchedule)rateSchedule).getValidFriday()) continue block23;
                            object[n] = i;
                            ++n;
                            continue block23;
                        }
                        case 6: {
                            if (!((DayOfWeekRateSchedule)rateSchedule).getValidSaturday()) continue block23;
                            object[n] = i;
                            ++n;
                        }
                    }
                }
                int[] nArray = new int[n];
                System.arraycopy(object, 0, nArray, 0, n);
                this.includedDaysEditor.setSelectedIndices(nArray);
            }
            if (rateSchedule instanceof MonthOfYearRateSchedule) {
                object = new int[12];
                n = 0;
                block24: for (int i = 0; i < 12; ++i) {
                    switch (i) {
                        case 0: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getJanuary()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 1: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getFebruary()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 2: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getMarch()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 3: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getApril()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 4: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getMay()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 5: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getJune()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 6: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getJuly()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 7: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getAugust()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 8: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getSeptember()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 9: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getOctober()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 10: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getNovember()) continue block24;
                            object[n] = i;
                            ++n;
                            continue block24;
                        }
                        case 11: {
                            if (!((MonthOfYearRateSchedule)rateSchedule).getDecember()) continue block24;
                            object[n] = i;
                            ++n;
                        }
                    }
                }
                int[] nArray = new int[n];
                System.arraycopy(object, 0, nArray, 0, n);
                this.includedMonthsEditor.setSelectedIndices(nArray);
            }
            if (rateSchedule instanceof TimeRangeRateSchedule) {
                this.startEditor.setValue(new EasLocalTime(((TimeRangeRateSchedule)rateSchedule).getStartTime(), CostTimeUtil.DEFAULT_TZ));
                object = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                ((Calendar)object).setTime(new Date(((TimeRangeRateSchedule)rateSchedule).getStartTime()));
                this.startRangeTimeEditor.setValues(((Calendar)object).get(11), ((Calendar)object).get(12), ((Calendar)object).get(13), ((Calendar)object).get(14));
                this.endEditor.setValue(new EasLocalTime(((TimeRangeRateSchedule)rateSchedule).getEndTime(), CostTimeUtil.DEFAULT_TZ));
                object = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                ((Calendar)object).setTime(new Date(((TimeRangeRateSchedule)rateSchedule).getEndTime()));
                this.endRangeTimeEditor.setValues(((Calendar)object).get(11), ((Calendar)object).get(12), ((Calendar)object).get(13), ((Calendar)object).get(14));
            }
            if (rateSchedule instanceof BillPeriodLengthRateSchedule) {
                this.minPeriodTextField.setText(((BillPeriodLengthRateSchedule)rateSchedule).getMinLength().getNumber());
                this.minPeriodComboBox.setSelectedIndex(((BillPeriodLengthRateSchedule)rateSchedule).getMinLength().getTimeUnits() - 1);
                this.maxPeriodTextField.setText(((BillPeriodLengthRateSchedule)rateSchedule).getMaxLength().getNumber());
                this.maxPeriodComboBox.setSelectedIndex(((BillPeriodLengthRateSchedule)rateSchedule).getMaxLength().getTimeUnits() - 1);
                boolean bl = ((BillPeriodLengthRateSchedule)rateSchedule).getNoUpperLimit();
                this.maxPeriodCheckBox.setSelected(bl);
                this.maxPeriodTextField.setVisible(!bl);
                this.maxPeriodComboBox.setVisible(!bl);
                this.revalidate();
                this.repaint();
            }
            this.initializingRateValues = false;
        }
    }

    private RateSchedule getSelectedRateSchedule() {
        return this.currentSelectedRateSchedule;
    }

    private RateComponent getSelectedRateComponent() {
        return this.parentPanel.getSelectedRateComponentBase();
    }

    public void handleRateScheduleChange(boolean bl) {
        if (this.initializingRateValues) {
            return;
        }
        this.parentPanel.handleRateComponentChange(false);
        if (bl) {
            this.rateSchedules.refreshUserObject(this.rateSchedules.getSelectedUserObject());
        }
    }

    private void createRateSchedule() {
        RateSchedule rateSchedule = NewRateScheduleDialog.getNewRateSchedule(this.getSession(), this, false, this.lex);
        if (rateSchedule != null) {
            boolean bl = false;
            if (this.currentSelectedRateSchedule != null && this.currentSelectedRateSchedule instanceof CompositeRateSchedule) {
                ((CompositeRateSchedule)this.currentSelectedRateSchedule).addRateSchedule(rateSchedule);
                bl = true;
            } else if (this.getSelectedRateComponent() instanceof FlatFeePerUnit) {
                ((FlatFeePerUnit)this.getSelectedRateComponent()).setRateSchedule(rateSchedule);
                this.originalRateSchedule = rateSchedule;
                bl = true;
            } else if (this.getSelectedRateComponent() instanceof CustomRateComponent && ((CustomRateComponent)((Object)this.getSelectedRateComponent())).supportsRateSchedule()) {
                ((CustomRateComponent)((Object)this.getSelectedRateComponent())).setRateSchedule(rateSchedule);
                this.originalRateSchedule = rateSchedule;
                bl = true;
            }
            if (bl) {
                this.handleRateScheduleChange(false);
                this.rateSchedules.refresh();
                this.setSelectedRateSchedule(rateSchedule);
            }
        }
    }

    private void deleteRateSchedule() {
        RateSchedule rateSchedule = this.getSelectedRateSchedule();
        RateComponent rateComponent = this.getSelectedRateComponent();
        if (rateSchedule != null && rateComponent != null && (rateComponent instanceof FlatFeePerUnit || rateComponent instanceof CustomRateComponent && ((CustomRateComponent)((Object)rateComponent)).supportsRateSchedule())) {
            String string = this.lex.getText("deleteWarning") + "\n\"" + rateSchedule.getName() + "\"?";
            int n = JOptionPane.showConfirmDialog(this, string, this.lex.getText("confirmDelete"), 0);
            if (n != 0) {
                return;
            }
            RateSchedule rateSchedule2 = rateComponent instanceof FlatFeePerUnit ? ((FlatFeePerUnit)rateComponent).getRateSchedule() : ((CustomRateComponent)((Object)rateComponent)).getRateSchedule();
            if (rateSchedule2 == rateSchedule) {
                if (rateComponent instanceof FlatFeePerUnit) {
                    ((FlatFeePerUnit)rateComponent).setRateSchedule(null);
                } else {
                    ((CustomRateComponent)((Object)rateComponent)).setRateSchedule(null);
                }
                this.originalRateSchedule = null;
                this.rateSchedules.removeSelectedNode();
            } else {
                RateSchedule rateSchedule3 = rateSchedule2;
                if (rateSchedule3 instanceof CompositeRateSchedule) {
                    ((CompositeRateSchedule)rateSchedule3).removeRateSchedule(rateSchedule);
                    this.rateSchedules.removeSelectedNode();
                }
            }
            this.handleRateScheduleChange(false);
        }
    }

    private void pasteRateSchedule() {
        RateSchedule rateSchedule = (RateSchedule)CreateARateApplication.clipboard.newCopy();
        if (rateSchedule != null) {
            boolean bl = false;
            if (this.currentSelectedRateSchedule != null && this.currentSelectedRateSchedule instanceof CompositeRateSchedule) {
                ((CompositeRateSchedule)this.currentSelectedRateSchedule).addRateSchedule(rateSchedule);
                bl = true;
            } else if (this.getSelectedRateComponent() instanceof FlatFeePerUnit) {
                ((FlatFeePerUnit)this.getSelectedRateComponent()).setRateSchedule(rateSchedule);
                this.originalRateSchedule = rateSchedule;
                bl = true;
            } else if (this.getSelectedRateComponent() instanceof CustomRateComponent && ((CustomRateComponent)((Object)this.getSelectedRateComponent())).supportsRateSchedule()) {
                ((CustomRateComponent)((Object)this.getSelectedRateComponent())).setRateSchedule(rateSchedule);
                this.originalRateSchedule = rateSchedule;
                bl = true;
            }
            if (bl) {
                this.handleRateScheduleChange(false);
                this.rateSchedules.refresh();
                this.setSelectedRateSchedule(rateSchedule);
            }
        }
    }

    private void copyRateSchedule() {
        RateSchedule rateSchedule = this.getSelectedRateSchedule();
        if (rateSchedule != null) {
            CreateARateApplication.clipboard = (RateSchedule)rateSchedule.newCopy();
        }
    }

    private void insertParentRateSchedule() {
        CompositeRateSchedule compositeRateSchedule = (CompositeRateSchedule)NewRateScheduleDialog.getNewRateSchedule(this.getSession(), this, true, this.lex);
        if (compositeRateSchedule != null) {
            if (this.currentSelectedRateSchedule == null || this.originalRateSchedule == null) {
                return;
            }
            boolean bl = false;
            RateSchedule rateSchedule = this.getParentSchedule(this.originalRateSchedule, this.currentSelectedRateSchedule);
            compositeRateSchedule.addRateSchedule(this.currentSelectedRateSchedule);
            if (rateSchedule == null) {
                if (this.getSelectedRateComponent() instanceof FlatFeePerUnit) {
                    ((FlatFeePerUnit)this.getSelectedRateComponent()).setRateSchedule(compositeRateSchedule);
                    this.originalRateSchedule = compositeRateSchedule;
                    bl = true;
                } else if (this.getSelectedRateComponent() instanceof CustomRateComponent && ((CustomRateComponent)((Object)this.getSelectedRateComponent())).supportsRateSchedule()) {
                    ((CustomRateComponent)((Object)this.getSelectedRateComponent())).setRateSchedule(compositeRateSchedule);
                    this.originalRateSchedule = compositeRateSchedule;
                    bl = true;
                }
            } else if (rateSchedule instanceof CompositeRateSchedule) {
                ((CompositeRateSchedule)rateSchedule).replaceRateSchedule(this.currentSelectedRateSchedule, compositeRateSchedule);
                bl = true;
            }
            if (bl) {
                this.handleRateScheduleChange(false);
                this.rateSchedules.refresh();
                this.setSelectedRateSchedule(compositeRateSchedule);
            }
        }
    }

    private RateSchedule getParentSchedule(RateSchedule rateSchedule, RateSchedule rateSchedule2) {
        if (rateSchedule == rateSchedule2) {
            return null;
        }
        if (rateSchedule instanceof CompositeRateSchedule) {
            RateSchedule[] rateScheduleArray = ((CompositeRateSchedule)rateSchedule).getRateSchedules();
            if (rateScheduleArray == null) {
                return null;
            }
            for (int i = 0; i < rateScheduleArray.length; ++i) {
                RateSchedule rateSchedule3;
                if (rateScheduleArray[i] == rateSchedule2) {
                    return rateSchedule;
                }
                if (!(rateScheduleArray[i] instanceof CompositeRateSchedule) || (rateSchedule3 = this.getParentSchedule(rateScheduleArray[i], rateSchedule2)) == null) continue;
                return rateSchedule3;
            }
        }
        return null;
    }

    public void setSelectedRateSchedule(RateSchedule rateSchedule) {
        if (this.rateSchedules != null) {
            this.rateSchedules.setSelectedUserObject(rateSchedule);
        }
    }

    public void init(EasSession easSession) {
        this.session = easSession;
        this.layout.show(this, "hide");
        this.rateSchedules.init(easSession);
        this.rateSchedulesFilter = new AllRateSchedulesFilter(easSession, this.lex);
        this.rateSchedules.setModel(new FilterTreeModel(new RateFilterRootNode((Filter)this.rateSchedulesFilter, new Class[]{class$com$tridium$eas$cost$datatypes$RateSchedule == null ? (class$com$tridium$eas$cost$datatypes$RateSchedule = RateScheduleDetailPanel.class$("com.tridium.eas.cost.datatypes.RateSchedule")) : class$com$tridium$eas$cost$datatypes$RateSchedule})));
        this.rateSchedules.setEnabled(true);
    }

    protected EasSession getSession() {
        return this.session;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    private boolean canAddSchedule() {
        if (this.rateSchedules.getRowCount() <= 0) {
            return true;
        }
        RateSchedule rateSchedule = this.getSelectedRateSchedule();
        if (rateSchedule != null) {
            return rateSchedule instanceof CompositeRateSchedule;
        }
        return false;
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof JTextField && ((JTextField)component).isEditable()) {
            this.selectItLater(component);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private void selectItLater(Component component) {
        if (component instanceof JTextField) {
            final JTextField jTextField = (JTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTextField.selectAll();
                }
            });
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RateSchedulePopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem addItem = null;
        private boolean addItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem copyItem = null;
        private boolean copyItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem pasteItem = null;
        private boolean pasteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem insertItem = null;
        private boolean insertItemShowing = false;
        private Lexicon lex;

        public RateSchedulePopup(Lexicon lexicon) {
            this.lex = lexicon;
            this.addItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("addSchedule"), 0, null);
            this.copyItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("copy"), 1, null);
            this.pasteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Paste"), 2, null);
            this.insertItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("insertParentSchedule"), 3, null);
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("removeSchedule"), 4, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    RateScheduleDetailPanel.this.createRateSchedule();
                    break;
                }
                case 1: {
                    RateScheduleDetailPanel.this.copyRateSchedule();
                    break;
                }
                case 2: {
                    RateScheduleDetailPanel.this.pasteRateSchedule();
                    break;
                }
                case 3: {
                    RateScheduleDetailPanel.this.insertParentRateSchedule();
                    break;
                }
                case 4: {
                    RateScheduleDetailPanel.this.deleteRateSchedule();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            boolean bl2 = bl;
            boolean bl3 = RateScheduleDetailPanel.this.canAddSchedule();
            boolean bl4 = CreateARateApplication.clipboard != null && CreateARateApplication.clipboard instanceof RateSchedule && bl3;
            boolean bl5 = bl2;
            boolean bl6 = bl2;
            if (bl3 && !this.addItemShowing) {
                this.addItem.addActionListener(this);
                this.insert(this.addItem, 0);
                this.revalidate();
                this.addItemShowing = true;
            } else if (this.addItemShowing && !bl3) {
                this.remove(this.addItem);
                this.revalidate();
                this.addItemShowing = false;
            }
            if (bl5 && !this.copyItemShowing) {
                this.copyItem.addActionListener(this);
                if (this.addItemShowing) {
                    this.insert(this.copyItem, 1);
                } else {
                    this.insert(this.copyItem, 0);
                }
                this.revalidate();
                this.copyItemShowing = true;
            } else if (this.copyItemShowing && !bl5) {
                this.remove(this.copyItem);
                this.revalidate();
                this.copyItemShowing = false;
            }
            if (bl4 && !this.pasteItemShowing) {
                this.pasteItem.addActionListener(this);
                if (this.addItemShowing && this.copyItemShowing) {
                    this.insert(this.pasteItem, 2);
                } else if (this.addItemShowing || this.copyItemShowing) {
                    this.insert(this.pasteItem, 1);
                } else {
                    this.insert(this.pasteItem, 0);
                }
                this.revalidate();
                this.pasteItemShowing = true;
            } else if (this.pasteItemShowing && !bl4) {
                this.remove(this.pasteItem);
                this.revalidate();
                this.pasteItemShowing = false;
            }
            if (bl6 && !this.insertItemShowing) {
                this.insertItem.addActionListener(this);
                if (this.addItemShowing && this.copyItemShowing && this.pasteItemShowing) {
                    this.insert(this.insertItem, 3);
                } else if (this.addItemShowing && this.copyItemShowing || this.addItemShowing && this.pasteItemShowing || this.copyItemShowing && this.pasteItemShowing) {
                    this.insert(this.insertItem, 2);
                } else if (this.addItemShowing || this.copyItemShowing || this.pasteItemShowing) {
                    this.insert(this.insertItem, 1);
                } else {
                    this.insert(this.insertItem, 0);
                }
                this.revalidate();
                this.insertItemShowing = true;
            } else if (this.insertItemShowing && !bl6) {
                this.remove(this.insertItem);
                this.revalidate();
                this.insertItemShowing = false;
            }
            if (bl2 && !this.deleteItemShowing) {
                this.add(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl2) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            if (this.addItemShowing || this.deleteItemShowing || this.copyItemShowing || this.pasteItemShowing || this.insertItemShowing) {
                super.show(component, n, n2);
            }
        }
    }
}

