/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.cost.datatypes.CompositeRateSchedule;
import com.tridium.eas.cost.datatypes.IntersectionCompositeRateSchedule;
import com.tridium.eas.cost.datatypes.RateSchedule;
import com.tridium.eas.cost.datatypes.UnionCompositeRateSchedule;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.rate.components.ChoiceComponent;
import com.tridium.eas.cost.rate.components.ChoiceComponentChild;
import com.tridium.eas.cost.rate.components.CombinationPercentageFee;
import com.tridium.eas.cost.rate.components.DemandCharge;
import com.tridium.eas.cost.rate.components.FixedFee;
import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.HistoricalRatchet;
import com.tridium.eas.cost.rate.components.Ratchet;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.xml.XmlSupport;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class RateListCellRenderer
extends DefaultListCellRenderer {
    private Icon comboFeeIcon = null;
    private Icon demandChargeIcon = null;
    private Icon flatFeeIcon = null;
    private Icon flatFeePerUnitIcon = null;
    private Icon historicalRatchetIcon = null;
    private Icon ratchetIcon = null;
    private Icon choiceIcon = null;
    private Icon rateIcon = null;
    private Icon rateScheduleIcon = null;
    private Icon compositeRateScheduleIcon = null;
    private Icon intersectionRateScheduleIcon = null;
    private Icon unionRateScheduleIcon = null;

    public RateListCellRenderer(ResourceManager resourceManager) {
        this.comboFeeIcon = new ImageIcon(resourceManager.getIconImage(301));
        this.demandChargeIcon = new ImageIcon(resourceManager.getIconImage(302));
        this.flatFeeIcon = new ImageIcon(resourceManager.getIconImage(303));
        this.flatFeePerUnitIcon = new ImageIcon(resourceManager.getIconImage(304));
        this.historicalRatchetIcon = new ImageIcon(resourceManager.getIconImage(316));
        this.ratchetIcon = new ImageIcon(resourceManager.getIconImage(305));
        this.choiceIcon = new ImageIcon(resourceManager.getIconImage(19));
        this.rateIcon = new ImageIcon(resourceManager.getIconImage(306));
        this.rateScheduleIcon = new ImageIcon(resourceManager.getIconImage(307));
        this.compositeRateScheduleIcon = new ImageIcon(resourceManager.getIconImage(308));
        this.intersectionRateScheduleIcon = new ImageIcon(resourceManager.getIconImage(309));
        this.unionRateScheduleIcon = new ImageIcon(resourceManager.getIconImage(310));
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object instanceof XmlSupport) {
            jLabel.setText(((XmlSupport)object).getName());
        }
        if (object instanceof Rate || object instanceof RateLink) {
            jLabel.setIcon(this.rateIcon);
        } else if (object instanceof CombinationPercentageFee) {
            jLabel.setIcon(this.comboFeeIcon);
        } else if (object instanceof DemandCharge) {
            jLabel.setIcon(this.demandChargeIcon);
        } else if (object instanceof HistoricalRatchet) {
            jLabel.setIcon(this.historicalRatchetIcon);
        } else if (object instanceof Ratchet) {
            jLabel.setIcon(this.ratchetIcon);
        } else if (object instanceof FlatFeePerUnit) {
            jLabel.setIcon(this.flatFeePerUnitIcon);
        } else if (object instanceof FixedFee) {
            jLabel.setIcon(this.flatFeeIcon);
        } else if (object instanceof ChoiceComponent) {
            jLabel.setIcon(this.choiceIcon);
        } else if (object instanceof ChoiceComponentChild) {
            jLabel = (JLabel)this.getListCellRendererComponent(jList, (Object)((ChoiceComponentChild)object).getRateComponent(), n, bl, bl2);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 20 * (((ChoiceComponentChild)object).getIndent() + 1), 0, 0));
        } else if (object instanceof RateSchedule) {
            if (object instanceof IntersectionCompositeRateSchedule) {
                jLabel.setIcon(this.intersectionRateScheduleIcon);
            } else if (object instanceof UnionCompositeRateSchedule) {
                jLabel.setIcon(this.unionRateScheduleIcon);
            } else if (object instanceof CompositeRateSchedule) {
                jLabel.setIcon(this.compositeRateScheduleIcon);
            } else {
                jLabel.setIcon(this.rateScheduleIcon);
            }
        }
        return jLabel;
    }
}

