/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.components.ChoiceComponent;
import com.tridium.eas.cost.rate.components.ChoiceComponentChild;
import com.tridium.eas.cost.rate.components.CombinationPercentageFee;
import com.tridium.eas.cost.rate.components.CustomRateComponent;
import com.tridium.eas.cost.rate.components.DemandCharge;
import com.tridium.eas.cost.rate.components.FixedFee;
import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.HistoricalRatchet;
import com.tridium.eas.cost.rate.components.Ratchet;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.rate.components.ScheduledDemandCharge;
import com.tridium.eas.cost.rate.components.ScheduledFeePerUnit;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.RateDetailPanel;
import com.tridium.eas.cost.ui.RateScheduleDetailPanel;
import com.tridium.eas.cost.ui.RateScheduleParentPanel;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.CheckList;
import com.tridium.eas.ui.widgets.DateEditor;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.EasTimeEditor;
import com.tridium.eas.ui.widgets.NumberTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class RateComponentDetailPanel
extends JPanel
implements RateScheduleParentPanel,
FocusListener,
KeyListener {
    private RateScheduleDetailPanel rateScheduleDetails = null;
    private RateDetailPanel parentPanel = null;
    protected Lexicon lex;
    private CardLayout layout = null;
    private CardLayout rateComponentLayout;
    private JPanel rateComponentPanel;
    private Hashtable choicePercentageLabels = new Hashtable(10);
    private Hashtable choicePercentageTextFields = new Hashtable(10);
    private Hashtable nameTextFields = new Hashtable(10);
    private Hashtable categoryComboBoxes = new Hashtable(10);
    private ActionListener categoryListener = null;
    private Hashtable feeTextFields = new Hashtable(8);
    private Hashtable minContractPeakLevelTextFields = new Hashtable(3);
    private NumberTextField ratchetPercentageTextField;
    private NumberTextField ratchetLifeTextField;
    private EasComboBox ratchetLifeComboBox;
    private EasComboBox choiceComboBox;
    private EasComboBox comparisonComboBox;
    private NumberTextField combinationPercentageTextField;
    private CheckList includedComponentsEditor;
    private JLabel newFeeLabel;
    private CostTextField newFeeTextField;
    private DateEditor transitionDateEditor;
    private EasTimeEditor transitionTimeEditor;
    private EasComboBox transitionApproachComboBox;
    private JLabel demandNewFeeLabel;
    private CostTextField demandNewFeeTextField;
    private DateEditor demandTransitionDateEditor;
    private EasTimeEditor demandTransitionTimeEditor;
    private Hashtable feeLabels = new Hashtable(8);
    private Hashtable minContractPeakLevelLabels = new Hashtable(3);
    private Hashtable minApplicableDataLabels = new Hashtable(6);
    private Hashtable maxApplicableDataLabels = new Hashtable(6);
    private Hashtable perFeeLabels = new Hashtable(6);
    private Hashtable unitsInFeeTextFields = new Hashtable(6);
    private Hashtable minDataTextFields = new Hashtable(6);
    private Hashtable maxDataTextFields = new Hashtable(6);
    private Hashtable maxDataCheckBoxes = new Hashtable(6);
    private Hashtable dataRangeApproachComboBoxes = new Hashtable(6);
    private Hashtable applicableDataComboBoxes = new Hashtable(6);
    private static final String BLANK_CARD = "blank";
    private static final String SHOW_ADV = "showAdv";
    private static final String HIDE_ADV = "hideAdv";
    private String lastState = "hideAdv";
    private Hashtable advancedPropsLayouts = new Hashtable(7);
    private Hashtable advancedPropsPanels = new Hashtable(7);
    private Hashtable advancedPanels = new Hashtable(7);
    private Hashtable showAdvancedPropsPanels = new Hashtable(7);
    private boolean initializingRateComponentValues;
    private DocumentListener choiceDocumentListener = null;
    private DocumentListener nameDocumentListener = null;
    private DocumentListener feeDocumentListener = null;
    private DocumentListener minContractPeakLevelDocumentListener = null;
    private DocumentListener unitsInFeeDocumentListener = null;
    private DocumentListener minDataDocumentListener = null;
    private DocumentListener maxDataDocumentListener = null;
    private ActionListener maxDataActionListener = null;
    private ActionListener applicableDataListenerConsumption = null;
    private ActionListener applicableDataListenerDemand = null;
    private ActionListener dataRangeApproachListener = null;
    private RateComponent currentSelectedRateComponent = null;
    private Hashtable customComponents = null;

    protected RateComponentDetailPanel(RateDetailPanel rateDetailPanel, Lexicon lexicon) {
        this.lex = lexicon;
        this.parentPanel = rateDetailPanel;
        this.initializingRateComponentValues = true;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add("show", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        jPanel2.setBorder(BorderFactory.createTitledBorder(lexicon.getText("rateComponentDetails")));
        this.add("hide", jPanel2);
        this.rateComponentLayout = new CardLayout();
        this.rateComponentPanel = new JPanel(this.rateComponentLayout, false);
        this.rateComponentPanel.add((Component)new JPanel(), BLANK_CARD);
        this.rateComponentPanel.add((Component)this.buildRateComponentEditor(new FixedFee(lexicon.getText("fixedFee"))), FixedFee.TYPE);
        this.rateComponentPanel.add((Component)this.buildRateComponentEditor(new FlatFeePerUnit(lexicon.getText("flatFeePerUnit"))), FlatFeePerUnit.TYPE);
        this.rateComponentPanel.add((Component)this.buildRateComponentEditor(new ScheduledFeePerUnit(lexicon.getText("scheduledFeePerUnit"))), ScheduledFeePerUnit.TYPE);
        this.rateComponentPanel.add((Component)this.buildRateComponentEditor(new DemandCharge(lexicon.getText("demandCharge"))), DemandCharge.TYPE);
        this.rateComponentPanel.add((Component)this.buildRateComponentEditor(new ScheduledDemandCharge(lexicon.getText("scheduledDemandCharge"))), ScheduledDemandCharge.TYPE);
        this.rateComponentPanel.add((Component)this.buildRateComponentEditor(new Ratchet(lexicon.getText("ratchet"))), Ratchet.TYPE);
        this.rateComponentPanel.add((Component)this.buildRateComponentEditor(new HistoricalRatchet(lexicon.getText("historicalRatchet"))), HistoricalRatchet.TYPE);
        this.rateComponentPanel.add((Component)this.buildRateComponentEditor(new CombinationPercentageFee(lexicon.getText("combinationPercentageFee"))), CombinationPercentageFee.TYPE);
        this.rateComponentPanel.add((Component)this.buildRateComponentEditor(new ChoiceComponent(lexicon.getText("choiceComponent"))), ChoiceComponent.TYPE);
        Hashtable hashtable = EasCostClient.loadCustomRateComponents(this.getClass());
        this.customComponents = new Hashtable(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                RateComponent rateComponent = (RateComponent)Class.forName(string2).newInstance();
                rateComponent.setName(lexicon.getText(string));
                this.rateComponentPanel.add((Component)this.buildRateComponentEditor(rateComponent), rateComponent.getType());
                this.customComponents.put(rateComponent.getType(), rateComponent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.rateComponentLayout.show(this.rateComponentPanel, BLANK_CARD);
        jPanel.add((Component)this.rateComponentPanel, "North");
        jPanel.add((Component)this.buildRateSchedulesPanel(), "Center");
        this.setRateComponentEditorValue(null);
        this.initializingRateComponentValues = false;
    }

    protected JComponent buildRateComponentEditor(RateComponent rateComponent) {
        JComponent jComponent;
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("rateComponentDetails")));
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(this.lex.getText("choicePercentage"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.choicePercentageLabels.put(rateComponent.getType(), jLabel);
        jLabel.setVisible(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        CostTextField costTextField = new CostTextField(10, false);
        costTextField.setMaximumFractionDigits(5);
        costTextField.setAllowNegative(false);
        costTextField.setUseLabelAppearanceWhenDisabled(true);
        if (this.choiceDocumentListener == null) {
            this.choiceDocumentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    try {
                        ((ChoiceComponentChild)RateComponentDetailPanel.this.getSelectedRateComponent()).setPercentage(((NumberTextField)RateComponentDetailPanel.this.choicePercentageTextFields.get(((ChoiceComponentChild)RateComponentDetailPanel.this.getSelectedRateComponent()).getRateComponent().getType())).getDoubleValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            };
        }
        costTextField.getDocument().addDocumentListener(this.choiceDocumentListener);
        costTextField.addFocusListener(this);
        jPanel2.add((Component)costTextField, gridBagConstraints);
        this.choicePercentageTextFields.put(rateComponent.getType(), costTextField);
        costTextField.setVisible(false);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)new JLabel(this.lex.getText("type")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(rateComponent.getName()), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        EasTextField easTextField = new EasTextField(30, 50);
        easTextField.setUseLabelAppearanceWhenDisabled(true);
        if (this.nameDocumentListener == null) {
            this.nameDocumentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    String string = new String(RateComponentDetailPanel.this.getSelectedRateComponentBase().getName());
                    String string2 = ((EasTextField)RateComponentDetailPanel.this.nameTextFields.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getText();
                    if (string2 == null || string2.length() < 1) {
                        return;
                    }
                    RateComponent[] rateComponentArray = null;
                    rateComponentArray = RateComponentDetailPanel.this.getSelectedRateComponent() instanceof ChoiceComponentChild ? ((ChoiceComponent)((ChoiceComponentChild)RateComponentDetailPanel.this.getSelectedRateComponent()).getParentRateComponent()).getRateComponents() : RateComponentDetailPanel.this.getSelectedRateComponent().getParentRate().getRateComponents();
                    if (!RateComponentDetailPanel.this.componentNameAlreadyExists(rateComponentArray, string2)) {
                        RateComponentDetailPanel.this.getSelectedRateComponent().setName(string2);
                        RateComponentDetailPanel.this.handleRateComponentChange(true);
                        if (!(RateComponentDetailPanel.this.getSelectedRateComponent() instanceof ChoiceComponentChild)) {
                            RateComponentDetailPanel.this.parentPanel.updateCombinationPercentageFees(string2, string);
                        }
                    }
                }
            };
        }
        easTextField.getDocument().addDocumentListener(this.nameDocumentListener);
        easTextField.addFocusListener(this);
        jPanel2.add((Component)easTextField, gridBagConstraints);
        this.nameTextFields.put(rateComponent.getType(), easTextField);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(this.lex.getText("categoryLabel")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        EasComboBox easComboBox = new EasComboBox(new String[]{this.lex.getText("Consumption"), this.lex.getText("Demand"), this.lex.getText("Other"), this.lex.getText("userDefinedComponent1"), this.lex.getText("userDefinedComponent2"), this.lex.getText("userDefinedComponent3"), this.lex.getText("userDefinedComponent4")});
        if (this.categoryListener == null) {
            this.categoryListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    RateComponentDetailPanel.this.getSelectedRateComponent().setCategory(((EasComboBox)RateComponentDetailPanel.this.categoryComboBoxes.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getSelectedIndex());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            };
        }
        easComboBox.addActionListener(this.categoryListener);
        jPanel2.add((Component)easComboBox, gridBagConstraints);
        this.categoryComboBoxes.put(rateComponent.getType(), easComboBox);
        if (rateComponent instanceof FixedFee) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            object = this.lex.getText("fee");
            if (rateComponent instanceof ScheduledFeePerUnit || rateComponent instanceof ScheduledDemandCharge) {
                object = this.lex.getText("originalFee");
            }
            jComponent = new JLabel((String)object);
            jPanel2.add((Component)jComponent, gridBagConstraints);
            this.feeLabels.put(rateComponent.getType(), jComponent);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
            CostTextField costTextField2 = new CostTextField(10, false);
            costTextField2.setFormatter(decimalFormat);
            costTextField2.setMaximumFractionDigits(10);
            costTextField2.setUseLabelAppearanceWhenDisabled(true);
            if (this.feeDocumentListener == null) {
                this.feeDocumentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                            return;
                        }
                        try {
                            ((FixedFee)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setFee(((NumberTextField)RateComponentDetailPanel.this.feeTextFields.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getDoubleValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        RateComponentDetailPanel.this.handleRateComponentChange(false);
                    }
                };
            }
            costTextField2.getDocument().addDocumentListener(this.feeDocumentListener);
            costTextField2.addFocusListener(this);
            costTextField2.addKeyListener(this);
            costTextField2.setText(((FixedFee)rateComponent).getFee());
            jPanel2.add((Component)costTextField2, gridBagConstraints);
            this.feeTextFields.put(rateComponent.getType(), costTextField2);
        }
        if (rateComponent instanceof ScheduledFeePerUnit && !(rateComponent instanceof CustomRateComponent)) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.newFeeLabel = new JLabel(this.lex.getText("newFee"));
            jPanel2.add((Component)this.newFeeLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            object = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
            this.newFeeTextField = new CostTextField(10, false);
            this.newFeeTextField.setFormatter((DecimalFormat)object);
            this.newFeeTextField.setMaximumFractionDigits(10);
            this.newFeeTextField.setUseLabelAppearanceWhenDisabled(true);
            this.newFeeTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    try {
                        ((ScheduledFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setNewFee(RateComponentDetailPanel.this.newFeeTextField.getDoubleValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            this.newFeeTextField.addFocusListener(this);
            this.newFeeTextField.addKeyListener(this);
            this.newFeeTextField.setText(((ScheduledFeePerUnit)rateComponent).getNewFee());
            jPanel2.add((Component)this.newFeeTextField, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)new JLabel(this.lex.getText("transitionTime")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            jComponent = new JPanel(new GridBagLayout(), false);
            jPanel2.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            this.transitionDateEditor = new DateEditor(this.lex);
            this.transitionDateEditor.setValue(new EasLocalTime(((ScheduledFeePerUnit)rateComponent).getTransitionTime(), CostTimeUtil.DEFAULT_TZ));
            this.transitionDateEditor.setAllowFuture(true);
            this.transitionDateEditor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                    calendar.setTime(new Date(RateComponentDetailPanel.this.transitionDateEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                    calendar.set(11, RateComponentDetailPanel.this.transitionTimeEditor.getHour());
                    calendar.set(12, RateComponentDetailPanel.this.transitionTimeEditor.getMinute());
                    calendar.set(13, RateComponentDetailPanel.this.transitionTimeEditor.getSecond());
                    calendar.set(14, RateComponentDetailPanel.this.transitionTimeEditor.getMillisecond());
                    ((ScheduledFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setTransitionTime(calendar.getTime().getTime());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            jComponent.add((Component)this.transitionDateEditor, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.transitionTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.parentPanel.getResourceManager().getIconImage(312)), new ImageIcon(this.parentPanel.getResourceManager().getIconImage(313)));
            this.transitionTimeEditor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                    calendar.setTime(new Date(RateComponentDetailPanel.this.transitionDateEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                    calendar.set(11, RateComponentDetailPanel.this.transitionTimeEditor.getHour());
                    calendar.set(12, RateComponentDetailPanel.this.transitionTimeEditor.getMinute());
                    calendar.set(13, RateComponentDetailPanel.this.transitionTimeEditor.getSecond());
                    calendar.set(14, RateComponentDetailPanel.this.transitionTimeEditor.getMillisecond());
                    ((ScheduledFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setTransitionTime(calendar.getTime().getTime());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            jComponent.add((Component)this.transitionTimeEditor, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)new JLabel(this.lex.getText("transitionApproach")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            this.transitionApproachComboBox = new EasComboBox(new String[]{this.lex.getText("proRated"), this.lex.getText("absolute")});
            this.transitionApproachComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    ((ScheduledFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setTransitionMethod(RateComponentDetailPanel.this.transitionApproachComboBox.getSelectedIndex());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            jPanel2.add((Component)this.transitionApproachComboBox.getPanel(), gridBagConstraints);
        }
        if (rateComponent instanceof ScheduledDemandCharge && !(rateComponent instanceof CustomRateComponent)) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.demandNewFeeLabel = new JLabel(this.lex.getText("newFee"));
            jPanel2.add((Component)this.demandNewFeeLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            object = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
            this.demandNewFeeTextField = new CostTextField(10, false);
            this.demandNewFeeTextField.setFormatter((DecimalFormat)object);
            this.demandNewFeeTextField.setMaximumFractionDigits(10);
            this.demandNewFeeTextField.setUseLabelAppearanceWhenDisabled(true);
            this.demandNewFeeTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    try {
                        ((ScheduledDemandCharge)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setNewFee(RateComponentDetailPanel.this.demandNewFeeTextField.getDoubleValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            this.demandNewFeeTextField.addFocusListener(this);
            this.demandNewFeeTextField.addKeyListener(this);
            this.demandNewFeeTextField.setText(((ScheduledDemandCharge)rateComponent).getNewFee());
            jPanel2.add((Component)this.demandNewFeeTextField, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)new JLabel(this.lex.getText("transitionTime")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            jComponent = new JPanel(new GridBagLayout(), false);
            jPanel2.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            this.demandTransitionDateEditor = new DateEditor(this.lex);
            this.demandTransitionDateEditor.setValue(new EasLocalTime(((ScheduledDemandCharge)rateComponent).getTransitionTime(), CostTimeUtil.DEFAULT_TZ));
            this.demandTransitionDateEditor.setAllowFuture(true);
            this.demandTransitionDateEditor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                    calendar.setTime(new Date(RateComponentDetailPanel.this.demandTransitionDateEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                    calendar.set(11, RateComponentDetailPanel.this.demandTransitionTimeEditor.getHour());
                    calendar.set(12, RateComponentDetailPanel.this.demandTransitionTimeEditor.getMinute());
                    calendar.set(13, RateComponentDetailPanel.this.demandTransitionTimeEditor.getSecond());
                    calendar.set(14, RateComponentDetailPanel.this.demandTransitionTimeEditor.getMillisecond());
                    ((ScheduledDemandCharge)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setTransitionTime(calendar.getTime().getTime());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            jComponent.add((Component)this.demandTransitionDateEditor, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.demandTransitionTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.parentPanel.getResourceManager().getIconImage(312)), new ImageIcon(this.parentPanel.getResourceManager().getIconImage(313)));
            this.demandTransitionTimeEditor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                    calendar.setTime(new Date(RateComponentDetailPanel.this.demandTransitionDateEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                    calendar.set(11, RateComponentDetailPanel.this.demandTransitionTimeEditor.getHour());
                    calendar.set(12, RateComponentDetailPanel.this.demandTransitionTimeEditor.getMinute());
                    calendar.set(13, RateComponentDetailPanel.this.demandTransitionTimeEditor.getSecond());
                    calendar.set(14, RateComponentDetailPanel.this.demandTransitionTimeEditor.getMillisecond());
                    ((ScheduledDemandCharge)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setTransitionTime(calendar.getTime().getTime());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            jComponent.add((Component)this.demandTransitionTimeEditor, gridBagConstraints);
        }
        if (rateComponent instanceof Ratchet) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            object = new JLabel(this.lex.getText("minContractPeakLevel"));
            jPanel2.add((Component)object, gridBagConstraints);
            this.minContractPeakLevelLabels.put(rateComponent.getType(), object);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            jComponent = new CostTextField(10, false);
            ((NumberTextField)jComponent).setMaximumFractionDigits(5);
            ((NumberTextField)jComponent).setAllowNegative(false);
            ((EasTextField)jComponent).setUseLabelAppearanceWhenDisabled(true);
            if (this.minContractPeakLevelDocumentListener == null) {
                this.minContractPeakLevelDocumentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                            return;
                        }
                        try {
                            ((Ratchet)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setMinimumContractPeakLevel(((NumberTextField)RateComponentDetailPanel.this.minContractPeakLevelTextFields.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getDoubleValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        RateComponentDetailPanel.this.handleRateComponentChange(false);
                    }
                };
            }
            ((JTextComponent)jComponent).getDocument().addDocumentListener(this.minContractPeakLevelDocumentListener);
            jComponent.addFocusListener(this);
            jComponent.addKeyListener(this);
            ((NumberTextField)jComponent).setText(((Ratchet)rateComponent).getMinimumContractPeakLevel());
            jPanel2.add((Component)jComponent, gridBagConstraints);
            this.minContractPeakLevelTextFields.put(rateComponent.getType(), jComponent);
        }
        if (rateComponent instanceof HistoricalRatchet && !(rateComponent instanceof CustomRateComponent)) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)new JLabel(this.lex.getText("percentage")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.ratchetPercentageTextField = new CostTextField(10, false);
            this.ratchetPercentageTextField.setMaximumFractionDigits(5);
            this.ratchetPercentageTextField.setAllowNegative(false);
            this.ratchetPercentageTextField.setUseLabelAppearanceWhenDisabled(true);
            this.ratchetPercentageTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    try {
                        ((HistoricalRatchet)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setPercentage(RateComponentDetailPanel.this.ratchetPercentageTextField.getDoubleValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            this.ratchetPercentageTextField.addFocusListener(this);
            this.ratchetPercentageTextField.setText(((HistoricalRatchet)rateComponent).getPercentage());
            jPanel2.add((Component)this.ratchetPercentageTextField, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)new JLabel(this.lex.getText("ratchetValid")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.ratchetLifeTextField = new NumberTextField(3, true);
            this.ratchetLifeTextField.setAllowNegative(false);
            this.ratchetLifeTextField.setUseLabelAppearanceWhenDisabled(true);
            this.ratchetLifeTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    ((HistoricalRatchet)RateComponentDetailPanel.this.getSelectedRateComponentBase()).getPeriodsARatchetIsValid().setNumber(RateComponentDetailPanel.this.ratchetLifeTextField.getIntValue());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            this.ratchetLifeTextField.addFocusListener(this);
            this.ratchetLifeTextField.setText(((HistoricalRatchet)rateComponent).getPeriodsARatchetIsValid().getNumber());
            jPanel2.add((Component)this.ratchetLifeTextField, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.ratchetLifeComboBox = new EasComboBox(new String[]{this.lex.getText("numBillingCycles"), this.lex.getText("numMinutes"), this.lex.getText("numHours"), this.lex.getText("numDays"), this.lex.getText("numWeeks"), this.lex.getText("numMonths"), this.lex.getText("numYears")});
            this.ratchetLifeComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    ((HistoricalRatchet)RateComponentDetailPanel.this.getSelectedRateComponentBase()).getPeriodsARatchetIsValid().setTimeUnits(RateComponentDetailPanel.this.ratchetLifeComboBox.getSelectedIndex());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            jPanel2.add((Component)this.ratchetLifeComboBox.getPanel(), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        } else if (!(rateComponent instanceof CustomRateComponent)) {
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        }
        if (rateComponent instanceof CombinationPercentageFee && !(rateComponent instanceof CustomRateComponent)) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)new JLabel(this.lex.getText("percentage")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.combinationPercentageTextField = new CostTextField(10, false);
            this.combinationPercentageTextField.setMaximumFractionDigits(5);
            this.combinationPercentageTextField.setAllowNegative(false);
            this.combinationPercentageTextField.setUseLabelAppearanceWhenDisabled(true);
            this.combinationPercentageTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    try {
                        ((CombinationPercentageFee)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setPercentage(RateComponentDetailPanel.this.combinationPercentageTextField.getDoubleValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            this.combinationPercentageTextField.addFocusListener(this);
            this.combinationPercentageTextField.setText(((CombinationPercentageFee)rateComponent).getPercentage());
            jPanel2.add((Component)this.combinationPercentageTextField, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)new JLabel(this.lex.getText("includedComponents")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.includedComponentsEditor = new CheckList();
            this.includedComponentsEditor.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    Object[] objectArray = RateComponentDetailPanel.this.includedComponentsEditor.getSelectedValues();
                    int n = 0;
                    if (objectArray != null) {
                        n = objectArray.length;
                    }
                    String[] stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = (String)objectArray[i];
                    }
                    ((CombinationPercentageFee)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setRegisteredComponentIds(stringArray);
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            jPanel2.add((Component)this.includedComponentsEditor, gridBagConstraints);
        }
        if (rateComponent instanceof ChoiceComponent && !(rateComponent instanceof CustomRateComponent)) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)new JLabel(this.lex.getText("choice")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.choiceComboBox = new EasComboBox(new String[]{this.lex.getText("useHighest"), this.lex.getText("useLowest"), this.lex.getText("useSum"), this.lex.getText("useDifference")});
            this.choiceComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    ((ChoiceComponent)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setChoice(RateComponentDetailPanel.this.choiceComboBox.getSelectedIndex());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            jPanel2.add((Component)this.choiceComboBox.getPanel(), gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)new JLabel(this.lex.getText("choiceBasedOn")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            this.comparisonComboBox = new EasComboBox(new String[]{this.lex.getText("calculatedCost"), this.lex.getText("calculatedUnits")});
            this.comparisonComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                        return;
                    }
                    ((ChoiceComponent)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setComparison(RateComponentDetailPanel.this.comparisonComboBox.getSelectedIndex());
                    RateComponentDetailPanel.this.handleRateComponentChange(false);
                }
            });
            jPanel2.add((Component)this.comparisonComboBox.getPanel(), gridBagConstraints);
        }
        if (rateComponent instanceof CustomRateComponent) {
            object = new JPanel(new BorderLayout(), false);
            ((Container)object).add((Component)jPanel2, "North");
            ((Container)object).add((Component)((CustomRateComponent)((Object)rateComponent)).buildComponentEditor(this, this.lex), "South");
            jPanel.add((Component)object, "North");
        } else {
            jPanel.add((Component)jPanel2, "North");
        }
        if (rateComponent.getType().equals(FixedFee.TYPE) || rateComponent.getType().equals(ChoiceComponent.TYPE) || rateComponent.getType().equals(CombinationPercentageFee.TYPE) || rateComponent instanceof CustomRateComponent && !((CustomRateComponent)((Object)rateComponent)).supportsAdvancedProperties()) {
            return jPanel;
        }
        jPanel.add((Component)this.buildAdvRateComponentEditor(rateComponent), "Center");
        return jPanel;
    }

    protected JComponent buildAdvRateComponentEditor(RateComponent rateComponent) {
        JComponent jComponent;
        JComponent jComponent2;
        CardLayout cardLayout = new CardLayout();
        this.advancedPropsLayouts.put(rateComponent.getType(), cardLayout);
        JPanel jPanel = new JPanel(cardLayout, false);
        this.advancedPropsPanels.put(rateComponent.getType(), jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.showAdvancedPropsPanels.put(rateComponent.getType(), jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
        this.advancedPanels.put(rateComponent.getType(), jPanel4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        JButton jButton = new JButton(this.lex.getText("hideAdvanced"));
        jButton.addActionListener(new AdvancedButtonActionListener());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jButton, "West");
        jPanel2.add((Component)jPanel5, "North");
        JButton jButton2 = new JButton(this.lex.getText("showAdvanced"));
        jButton2.addActionListener(new AdvancedButtonActionListener());
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jButton2, "West");
        jPanel3.add((Component)jPanel6, "North");
        if (rateComponent instanceof DemandCharge || rateComponent instanceof Ratchet || rateComponent instanceof HistoricalRatchet) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jPanel4.add((Component)new JLabel(this.lex.getText("applicableData")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jComponent2 = new EasComboBox(new String[]{this.lex.getText("Demand"), this.lex.getText("ReactivePower"), this.lex.getText("ApparentPower")});
            if (this.applicableDataListenerDemand == null) {
                this.applicableDataListenerDemand = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                            return;
                        }
                        int n = ((EasComboBox)RateComponentDetailPanel.this.applicableDataComboBoxes.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getSelectedIndex() * 2 + 1;
                        RateComponentDetailPanel.this.getSelectedRateComponentBase().setApplicableData(n);
                        RateComponentDetailPanel.this.updateUnitLabels(n, RateComponentDetailPanel.this.getSelectedRateComponentBase());
                        RateComponentDetailPanel.this.handleRateComponentChange(false);
                    }
                };
            }
            ((JComboBox)jComponent2).addActionListener(this.applicableDataListenerDemand);
            jPanel4.add((Component)((EasComboBox)jComponent2).getPanel(), gridBagConstraints);
            this.applicableDataComboBoxes.put(rateComponent.getType(), jComponent2);
        } else if (rateComponent instanceof FlatFeePerUnit) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jComponent2 = new JLabel(this.lex.getText("applicableData"));
            jPanel4.add((Component)jComponent2, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jComponent = new EasComboBox(new String[]{this.lex.getText("Consumption"), this.lex.getText("ReactiveEnergy"), this.lex.getText("ApparentEnergy")});
            if (this.applicableDataListenerConsumption == null) {
                this.applicableDataListenerConsumption = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                            return;
                        }
                        int n = ((EasComboBox)RateComponentDetailPanel.this.applicableDataComboBoxes.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getSelectedIndex() * 2;
                        RateComponentDetailPanel.this.getSelectedRateComponentBase().setApplicableData(n);
                        RateComponentDetailPanel.this.updateUnitLabels(n, RateComponentDetailPanel.this.getSelectedRateComponentBase());
                        RateComponentDetailPanel.this.handleRateComponentChange(false);
                    }
                };
            }
            ((JComboBox)jComponent).addActionListener(this.applicableDataListenerConsumption);
            jPanel4.add((Component)((EasComboBox)jComponent).getPanel(), gridBagConstraints);
            this.applicableDataComboBoxes.put(rateComponent.getType(), jComponent);
        }
        if (rateComponent instanceof FlatFeePerUnit) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jComponent2 = new JLabel(this.lex.getText("minApplicableData"));
            jPanel4.add((Component)jComponent2, gridBagConstraints);
            this.minApplicableDataLabels.put(rateComponent.getType(), jComponent2);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jComponent = new CostTextField(10, false);
            ((NumberTextField)jComponent).setMaximumFractionDigits(5);
            ((NumberTextField)jComponent).setAllowNegative(false);
            ((EasTextField)jComponent).setUseLabelAppearanceWhenDisabled(true);
            if (this.minDataDocumentListener == null) {
                this.minDataDocumentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                            return;
                        }
                        ((FlatFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setMinDataValue(((NumberTextField)RateComponentDetailPanel.this.minDataTextFields.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getDoubleValue());
                        RateComponentDetailPanel.this.handleRateComponentChange(false);
                    }
                };
            }
            ((JTextComponent)jComponent).getDocument().addDocumentListener(this.minDataDocumentListener);
            jComponent.addFocusListener(this);
            jComponent.addKeyListener(this);
            ((NumberTextField)jComponent).setText(((FlatFeePerUnit)rateComponent).getMinDataValue());
            jPanel4.add((Component)jComponent, gridBagConstraints);
            this.minDataTextFields.put(rateComponent.getType(), jComponent);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            JLabel jLabel = new JLabel(this.lex.getText("maxApplicableData"));
            jPanel4.add((Component)jLabel, gridBagConstraints);
            this.maxApplicableDataLabels.put(rateComponent.getType(), jLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            JCheckBox jCheckBox = new JCheckBox(this.lex.getText("noUpperLimit"));
            if (this.maxDataActionListener == null) {
                this.maxDataActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                            return;
                        }
                        NumberTextField numberTextField = (NumberTextField)RateComponentDetailPanel.this.maxDataTextFields.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType());
                        if (((JCheckBox)RateComponentDetailPanel.this.maxDataCheckBoxes.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).isSelected()) {
                            ((FlatFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setMaxDataValue(Double.MAX_VALUE);
                            numberTextField.setEditable(false);
                            numberTextField.setVisible(false);
                        } else {
                            numberTextField.setEditable(true);
                            numberTextField.setVisible(true);
                            ((FlatFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setMaxDataValue(numberTextField.getDoubleValue());
                        }
                        RateComponentDetailPanel.this.rateComponentPanel.revalidate();
                        RateComponentDetailPanel.this.rateComponentPanel.repaint();
                        RateComponentDetailPanel.this.handleRateComponentChange(false);
                    }
                };
            }
            jCheckBox.addActionListener(this.maxDataActionListener);
            boolean bl = ((FlatFeePerUnit)rateComponent).getMaxDataValue() == Double.MAX_VALUE;
            jCheckBox.setSelected(bl);
            jPanel4.add((Component)jCheckBox, gridBagConstraints);
            this.maxDataCheckBoxes.put(rateComponent.getType(), jCheckBox);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            CostTextField costTextField = new CostTextField(10, false);
            costTextField.setMaximumFractionDigits(5);
            costTextField.setAllowNegative(false);
            costTextField.setUseLabelAppearanceWhenDisabled(true);
            if (this.maxDataDocumentListener == null) {
                this.maxDataDocumentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                            return;
                        }
                        ((FlatFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setMaxDataValue(((NumberTextField)RateComponentDetailPanel.this.maxDataTextFields.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getDoubleValue());
                        RateComponentDetailPanel.this.handleRateComponentChange(false);
                    }
                };
            }
            costTextField.getDocument().addDocumentListener(this.maxDataDocumentListener);
            costTextField.addFocusListener(this);
            costTextField.addKeyListener(this);
            costTextField.setText(((FlatFeePerUnit)rateComponent).getMaxDataValue());
            costTextField.setEditable(!bl);
            costTextField.setVisible(!bl);
            jPanel4.add((Component)costTextField, gridBagConstraints);
            this.maxDataTextFields.put(rateComponent.getType(), costTextField);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            JLabel jLabel2 = new JLabel(this.lex.getText("dataRangeApproach"));
            jPanel4.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 2;
            EasComboBox easComboBox = new EasComboBox(new String[]{this.lex.getText("cumulativeRangeApproach"), this.lex.getText("overallRangeApproach"), this.lex.getText("individualRangeApproach")});
            if (this.dataRangeApproachListener == null) {
                this.dataRangeApproachListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                            return;
                        }
                        int n = ((EasComboBox)RateComponentDetailPanel.this.dataRangeApproachComboBoxes.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getSelectedIndex();
                        ((FlatFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setDataRangeApproach(n);
                        RateComponentDetailPanel.this.handleRateComponentChange(false);
                    }
                };
            }
            easComboBox.addActionListener(this.dataRangeApproachListener);
            jPanel4.add((Component)easComboBox.getPanel(), gridBagConstraints);
            this.dataRangeApproachComboBoxes.put(rateComponent.getType(), easComboBox);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            JLabel jLabel3 = new JLabel(this.lex.getText("unitsInFee"));
            jPanel4.add((Component)jLabel3, gridBagConstraints);
            this.perFeeLabels.put(rateComponent.getType(), jLabel3);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            NumberTextField numberTextField = new NumberTextField(10, true);
            numberTextField.setAllowNegative(false);
            numberTextField.setUseLabelAppearanceWhenDisabled(true);
            if (this.unitsInFeeDocumentListener == null) {
                this.unitsInFeeDocumentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        if (RateComponentDetailPanel.this.initializingRateComponentValues) {
                            return;
                        }
                        ((FlatFeePerUnit)RateComponentDetailPanel.this.getSelectedRateComponentBase()).setUnitsInFee(((NumberTextField)RateComponentDetailPanel.this.unitsInFeeTextFields.get(RateComponentDetailPanel.this.getSelectedRateComponentBase().getType())).getIntValue());
                        RateComponentDetailPanel.this.handleRateComponentChange(false);
                    }
                };
            }
            numberTextField.getDocument().addDocumentListener(this.unitsInFeeDocumentListener);
            numberTextField.addFocusListener(this);
            numberTextField.setText(((FlatFeePerUnit)rateComponent).getUnitsInFee());
            jPanel4.add((Component)numberTextField, gridBagConstraints);
            this.unitsInFeeTextFields.put(rateComponent.getType(), numberTextField);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
        }
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel4.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel(""), gridBagConstraints);
        jPanel.add(HIDE_ADV, jPanel3);
        jPanel.add(SHOW_ADV, jPanel2);
        cardLayout.show(jPanel, HIDE_ADV);
        this.lastState = HIDE_ADV;
        return jPanel;
    }

    protected JComponent buildRateSchedulesPanel() {
        this.rateScheduleDetails = new RateScheduleDetailPanel(this.parentPanel.getResourceManager(), this, this.lex);
        this.rateScheduleDetails.setRateScheduleEditorValue(null);
        return this.rateScheduleDetails;
    }

    public void setRateComponentEditorValue(RateComponent rateComponent) {
        this.currentSelectedRateComponent = rateComponent;
        if (rateComponent == null) {
            this.layout.show(this, "hide");
        } else {
            this.layout.show(this, "show");
            this.initializingRateComponentValues = true;
            if (rateComponent instanceof ChoiceComponentChild) {
                this.rateComponentLayout.show(this.rateComponentPanel, ((ChoiceComponentChild)rateComponent).getRateComponent().getType());
                ((JLabel)this.choicePercentageLabels.get(((ChoiceComponentChild)rateComponent).getRateComponent().getType())).setVisible(true);
                ((NumberTextField)this.choicePercentageTextFields.get(((ChoiceComponentChild)rateComponent).getRateComponent().getType())).setVisible(true);
                ((NumberTextField)this.choicePercentageTextFields.get(((ChoiceComponentChild)rateComponent).getRateComponent().getType())).setText(((ChoiceComponentChild)rateComponent).getPercentage());
                rateComponent = ((ChoiceComponentChild)rateComponent).getRateComponent();
            } else {
                this.rateComponentLayout.show(this.rateComponentPanel, rateComponent.getType());
                ((JLabel)this.choicePercentageLabels.get(rateComponent.getType())).setVisible(false);
                ((NumberTextField)this.choicePercentageTextFields.get(rateComponent.getType())).setVisible(false);
            }
            ((EasTextField)this.nameTextFields.get(rateComponent.getType())).setText(rateComponent.getName());
            ((EasComboBox)this.categoryComboBoxes.get(rateComponent.getType())).setSelectedIndex(rateComponent.getCategory());
            if (rateComponent instanceof FixedFee) {
                String string = this.lex.getText("fee");
                if (rateComponent instanceof ScheduledFeePerUnit || rateComponent instanceof ScheduledDemandCharge) {
                    string = this.lex.getText("originalFee");
                }
                ((JLabel)this.feeLabels.get(rateComponent.getType())).setText(string + " (" + this.parentPanel.getCurrency() + ")");
                ((NumberTextField)this.feeTextFields.get(rateComponent.getType())).setText(((FixedFee)rateComponent).getFee());
            }
            if (rateComponent instanceof FlatFeePerUnit) {
                switch (rateComponent.getApplicableData()) {
                    case 0: {
                        ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getConsumptionUnits() + ")");
                        ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getConsumptionUnits() + ")");
                        ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getConsumptionUnits() + " " + this.lex.getText("perFee") + ")");
                        ((EasComboBox)this.applicableDataComboBoxes.get(rateComponent.getType())).setSelectedIndex(0);
                        break;
                    }
                    case 1: {
                        ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getDemandUnits() + ")");
                        ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getDemandUnits() + ")");
                        ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getDemandUnits() + " " + this.lex.getText("perFee") + ")");
                        ((EasComboBox)this.applicableDataComboBoxes.get(rateComponent.getType())).setSelectedIndex(0);
                        break;
                    }
                    case 2: {
                        ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getReactiveEnergyUnits() + ")");
                        ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getReactiveEnergyUnits() + ")");
                        ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getReactiveEnergyUnits() + " " + this.lex.getText("perFee") + ")");
                        ((EasComboBox)this.applicableDataComboBoxes.get(rateComponent.getType())).setSelectedIndex(1);
                        break;
                    }
                    case 4: {
                        ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getApparentEnergyUnits() + ")");
                        ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getApparentEnergyUnits() + ")");
                        ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getApparentEnergyUnits() + " " + this.lex.getText("perFee") + ")");
                        ((EasComboBox)this.applicableDataComboBoxes.get(rateComponent.getType())).setSelectedIndex(2);
                        break;
                    }
                    case 3: {
                        ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getReactivePowerUnits() + ")");
                        ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getReactivePowerUnits() + ")");
                        ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getReactivePowerUnits() + " " + this.lex.getText("perFee") + ")");
                        ((EasComboBox)this.applicableDataComboBoxes.get(rateComponent.getType())).setSelectedIndex(1);
                        break;
                    }
                    case 5: {
                        ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getApparentPowerUnits() + ")");
                        ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getApparentPowerUnits() + ")");
                        ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getApparentPowerUnits() + " " + this.lex.getText("perFee") + ")");
                        ((EasComboBox)this.applicableDataComboBoxes.get(rateComponent.getType())).setSelectedIndex(2);
                        break;
                    }
                    default: {
                        ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData"));
                        ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData"));
                        ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee"));
                        ((EasComboBox)this.applicableDataComboBoxes.get(rateComponent.getType())).setSelectedIndex(0);
                    }
                }
                ((EasComboBox)this.dataRangeApproachComboBoxes.get(rateComponent.getType())).setSelectedIndex(((FlatFeePerUnit)rateComponent).getDataRangeApproach());
                ((NumberTextField)this.minDataTextFields.get(rateComponent.getType())).setText(((FlatFeePerUnit)rateComponent).getMinDataValue());
                double d = ((FlatFeePerUnit)rateComponent).getMaxDataValue();
                boolean bl = d == Double.MAX_VALUE;
                ((JCheckBox)this.maxDataCheckBoxes.get(rateComponent.getType())).setSelected(bl);
                NumberTextField numberTextField = (NumberTextField)this.maxDataTextFields.get(rateComponent.getType());
                numberTextField.setText(d);
                numberTextField.setEditable(!bl);
                numberTextField.setVisible(!bl);
                ((NumberTextField)this.unitsInFeeTextFields.get(rateComponent.getType())).setText(((FlatFeePerUnit)rateComponent).getUnitsInFee());
            }
            if (rateComponent instanceof CustomRateComponent && this.customComponents != null) {
                CustomRateComponent customRateComponent = (CustomRateComponent)this.customComponents.get(rateComponent.getType());
                customRateComponent.loadComponentEditor((CustomRateComponent)((Object)rateComponent));
            }
            if (rateComponent instanceof ScheduledFeePerUnit && !(rateComponent instanceof CustomRateComponent)) {
                this.newFeeLabel.setText(this.lex.getText("newFee") + " (" + this.parentPanel.getCurrency() + ")");
                this.newFeeTextField.setText(((ScheduledFeePerUnit)rateComponent).getNewFee());
                this.transitionDateEditor.setValue(new EasLocalTime(((ScheduledFeePerUnit)rateComponent).getTransitionTime(), CostTimeUtil.DEFAULT_TZ));
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(((ScheduledFeePerUnit)rateComponent).getTransitionTime()));
                this.transitionTimeEditor.setValues(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
                this.transitionApproachComboBox.setSelectedIndex(((ScheduledFeePerUnit)rateComponent).getTransitionMethod());
            }
            if (rateComponent instanceof ScheduledDemandCharge && !(rateComponent instanceof CustomRateComponent)) {
                this.demandNewFeeLabel.setText(this.lex.getText("newFee") + " (" + this.parentPanel.getCurrency() + ")");
                this.demandNewFeeTextField.setText(((ScheduledDemandCharge)rateComponent).getNewFee());
                this.demandTransitionDateEditor.setValue(new EasLocalTime(((ScheduledDemandCharge)rateComponent).getTransitionTime(), CostTimeUtil.DEFAULT_TZ));
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(((ScheduledDemandCharge)rateComponent).getTransitionTime()));
                this.demandTransitionTimeEditor.setValues(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
            }
            if (rateComponent instanceof Ratchet) {
                switch (rateComponent.getApplicableData()) {
                    case 1: {
                        ((JLabel)this.minContractPeakLevelLabels.get(rateComponent.getType())).setText(this.lex.getText("minContractPeakLevel") + " (" + this.parentPanel.getDemandUnits() + ")");
                        break;
                    }
                    case 3: {
                        ((JLabel)this.minContractPeakLevelLabels.get(rateComponent.getType())).setText(this.lex.getText("minContractPeakLevel") + " (" + this.parentPanel.getReactivePowerUnits() + ")");
                        break;
                    }
                    case 5: {
                        ((JLabel)this.minContractPeakLevelLabels.get(rateComponent.getType())).setText(this.lex.getText("minContractPeakLevel") + " (" + this.parentPanel.getApparentPowerUnits() + ")");
                        break;
                    }
                    default: {
                        ((JLabel)this.minContractPeakLevelLabels.get(rateComponent.getType())).setText(this.lex.getText("minContractPeakLevel"));
                    }
                }
                ((NumberTextField)this.minContractPeakLevelTextFields.get(rateComponent.getType())).setText(((Ratchet)rateComponent).getMinimumContractPeakLevel());
            }
            if (rateComponent instanceof HistoricalRatchet && !(rateComponent instanceof CustomRateComponent)) {
                this.ratchetPercentageTextField.setText(((HistoricalRatchet)rateComponent).getPercentage());
                this.ratchetLifeTextField.setText(((HistoricalRatchet)rateComponent).getPeriodsARatchetIsValid().getNumber());
                this.ratchetLifeComboBox.setSelectedIndex(((HistoricalRatchet)rateComponent).getPeriodsARatchetIsValid().getTimeUnits());
            }
            if (rateComponent instanceof CombinationPercentageFee && !(rateComponent instanceof CustomRateComponent)) {
                this.combinationPercentageTextField.setText(((CombinationPercentageFee)rateComponent).getPercentage());
                RateComponent[] rateComponentArray = rateComponent.getParentRate().getRateComponents();
                int n = 0;
                if (rateComponentArray != null) {
                    n = rateComponentArray.length;
                }
                String[] stringArray = new String[n];
                int n2 = 0;
                int[] nArray = new int[n];
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    if (rateComponent == rateComponentArray[i]) continue;
                    stringArray[n2] = rateComponentArray[i].getName();
                    if (((CombinationPercentageFee)rateComponent).isRegistered(stringArray[n2])) {
                        nArray[n3] = n2;
                        ++n3;
                    }
                    ++n2;
                }
                Object[] objectArray = new String[n2];
                System.arraycopy(stringArray, 0, objectArray, 0, n2);
                int[] nArray2 = new int[n3];
                System.arraycopy(nArray, 0, nArray2, 0, n3);
                this.includedComponentsEditor.setListData(objectArray);
                this.includedComponentsEditor.setSelectedIndices(nArray2);
            }
            if (rateComponent instanceof ChoiceComponent && !(rateComponent instanceof CustomRateComponent)) {
                this.choiceComboBox.setSelectedIndex(((ChoiceComponent)rateComponent).getChoice());
                this.comparisonComboBox.setSelectedIndex(((ChoiceComponent)rateComponent).getComparison());
            }
            this.initializingRateComponentValues = false;
        }
        this.rateScheduleDetails.setRateComponentEditorValue(rateComponent);
    }

    public void handleRateComponentChange(boolean bl) {
        this.parentPanel.handleRateChange(bl);
    }

    private RateComponent getSelectedRateComponent() {
        return this.currentSelectedRateComponent;
    }

    public RateComponent getSelectedRateComponentBase() {
        if (this.currentSelectedRateComponent instanceof ChoiceComponentChild) {
            return ((ChoiceComponentChild)this.currentSelectedRateComponent).getRateComponent();
        }
        return this.currentSelectedRateComponent;
    }

    public boolean rateSchedulesEditable() {
        return true;
    }

    private boolean componentNameAlreadyExists(RateComponent[] rateComponentArray, String string) {
        if (rateComponentArray == null) {
            return false;
        }
        for (int i = 0; i < rateComponentArray.length; ++i) {
            if (!rateComponentArray[i].getName().equals(string) || rateComponentArray[i] == this.getSelectedRateComponent()) continue;
            return true;
        }
        return false;
    }

    protected void init(EasSession easSession) {
        this.rateScheduleDetails.init(easSession);
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof JTextField && ((JTextField)component).isEditable()) {
            this.selectItLater(component);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof CostTextField) {
            this.initializingRateComponentValues = true;
            ((CostTextField)component).setText(((CostTextField)component).getDoubleValue());
            this.initializingRateComponentValues = false;
        }
    }

    private void selectItLater(Component component) {
        if (component instanceof JTextField) {
            final JTextField jTextField = (JTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTextField.selectAll();
                }
            });
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Component component;
        if (keyEvent.getKeyCode() == 10 && (component = keyEvent.getComponent()) instanceof CostTextField) {
            this.initializingRateComponentValues = true;
            ((CostTextField)component).setText(((CostTextField)component).getDoubleValue());
            this.initializingRateComponentValues = false;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void updateUnitLabels(int n, RateComponent rateComponent) {
        switch (n) {
            case 0: {
                ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getConsumptionUnits() + ")");
                ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getConsumptionUnits() + ")");
                ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getConsumptionUnits() + " " + this.lex.getText("perFee") + ")");
                break;
            }
            case 1: {
                ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getDemandUnits() + ")");
                ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getDemandUnits() + ")");
                ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getDemandUnits() + " " + this.lex.getText("perFee") + ")");
                break;
            }
            case 2: {
                ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getReactiveEnergyUnits() + ")");
                ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getReactiveEnergyUnits() + ")");
                ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getReactiveEnergyUnits() + " " + this.lex.getText("perFee") + ")");
                break;
            }
            case 4: {
                ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getApparentEnergyUnits() + ")");
                ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getApparentEnergyUnits() + ")");
                ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getApparentEnergyUnits() + " " + this.lex.getText("perFee") + ")");
                break;
            }
            case 3: {
                ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getReactivePowerUnits() + ")");
                ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getReactivePowerUnits() + ")");
                ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getReactivePowerUnits() + " " + this.lex.getText("perFee") + ")");
                break;
            }
            case 5: {
                ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData") + " (" + this.parentPanel.getApparentPowerUnits() + ")");
                ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData") + " (" + this.parentPanel.getApparentPowerUnits() + ")");
                ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee") + " (" + this.parentPanel.getApparentPowerUnits() + " " + this.lex.getText("perFee") + ")");
                break;
            }
            default: {
                ((JLabel)this.minApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("minApplicableData"));
                ((JLabel)this.maxApplicableDataLabels.get(rateComponent.getType())).setText(this.lex.getText("maxApplicableData"));
                ((JLabel)this.perFeeLabels.get(rateComponent.getType())).setText(this.lex.getText("unitsInFee"));
            }
        }
        if (rateComponent instanceof Ratchet) {
            switch (n) {
                case 1: {
                    ((JLabel)this.minContractPeakLevelLabels.get(rateComponent.getType())).setText(this.lex.getText("minContractPeakLevel") + " (" + this.parentPanel.getDemandUnits() + ")");
                    break;
                }
                case 3: {
                    ((JLabel)this.minContractPeakLevelLabels.get(rateComponent.getType())).setText(this.lex.getText("minContractPeakLevel") + " (" + this.parentPanel.getReactivePowerUnits() + ")");
                    break;
                }
                case 5: {
                    ((JLabel)this.minContractPeakLevelLabels.get(rateComponent.getType())).setText(this.lex.getText("minContractPeakLevel") + " (" + this.parentPanel.getApparentPowerUnits() + ")");
                    break;
                }
                default: {
                    ((JLabel)this.minContractPeakLevelLabels.get(rateComponent.getType())).setText(this.lex.getText("minContractPeakLevel"));
                }
            }
        }
        this.revalidate();
    }

    public boolean getInitializingComponents() {
        return this.initializingRateComponentValues;
    }

    public ResourceManager getResourceManager() {
        return this.parentPanel.getResourceManager();
    }

    private class AdvancedButtonActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (RateComponentDetailPanel.this.lastState.equals(RateComponentDetailPanel.HIDE_ADV)) {
                RateComponentDetailPanel.this.lastState = RateComponentDetailPanel.SHOW_ADV;
            } else {
                RateComponentDetailPanel.this.lastState = RateComponentDetailPanel.HIDE_ADV;
            }
            Enumeration enumeration = RateComponentDetailPanel.this.advancedPropsLayouts.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ((CardLayout)RateComponentDetailPanel.this.advancedPropsLayouts.get(string)).show((JPanel)RateComponentDetailPanel.this.advancedPropsPanels.get(string), RateComponentDetailPanel.this.lastState);
                if (RateComponentDetailPanel.this.lastState.equals(RateComponentDetailPanel.HIDE_ADV)) {
                    ((JPanel)RateComponentDetailPanel.this.showAdvancedPropsPanels.get(string)).remove((JPanel)RateComponentDetailPanel.this.advancedPanels.get(string));
                    continue;
                }
                ((JPanel)RateComponentDetailPanel.this.showAdvancedPropsPanels.get(string)).add((Component)((JPanel)RateComponentDetailPanel.this.advancedPanels.get(string)), "Center");
            }
            RateComponentDetailPanel.this.parentPanel.revalidate();
        }
    }
}

