/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.datatypes.BillPeriodLengthRateSchedule;
import com.tridium.eas.cost.datatypes.DailyRateSchedule;
import com.tridium.eas.cost.datatypes.DayOfWeekRateSchedule;
import com.tridium.eas.cost.datatypes.IntersectionCompositeRateSchedule;
import com.tridium.eas.cost.datatypes.MonthOfYearRateSchedule;
import com.tridium.eas.cost.datatypes.RateSchedule;
import com.tridium.eas.cost.datatypes.TimeRangeRateSchedule;
import com.tridium.eas.cost.datatypes.UnionCompositeRateSchedule;
import com.tridium.eas.cost.ui.RateListCellRenderer;
import com.tridium.eas.cost.ui.RateScheduleDetailPanel;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class NewRateScheduleDialog
extends EasDialog
implements ActionListener {
    private JButton okButton = null;
    private JButton cancelButton = null;
    private EasComboBox scheduleTypeComboBox = null;
    private RateSchedule schedule = null;
    private EasSession session = null;
    private Lexicon lex;

    private NewRateScheduleDialog(EasSession easSession, Frame frame, Component component, boolean bl, Lexicon lexicon) {
        super(frame, component);
        this.lex = lexicon;
        this.setModal(true);
        this.session = easSession;
        this.setTitle(lexicon.getText("addSchedule"));
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1), false);
        this.okButton = new JButton(lexicon.getText("ok"));
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("ok");
        this.okButton.setEnabled(true);
        jPanel.add(this.okButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancel");
        jPanel.add(this.cancelButton);
        jComponent.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new FlowLayout(0), false);
        jPanel2.add(new JLabel(lexicon.getText("type")));
        this.scheduleTypeComboBox = bl ? new EasComboBox(new RateSchedule[]{new IntersectionCompositeRateSchedule(lexicon.getText("intersectionRateSchedule")), new UnionCompositeRateSchedule(lexicon.getText("unionRateSchedule"))}) : new EasComboBox(new RateSchedule[]{new DailyRateSchedule(lexicon.getText("dailyRateSchedule")), new DayOfWeekRateSchedule(lexicon.getText("dayOfWeekRateSchedule")), new MonthOfYearRateSchedule(lexicon.getText("monthOfYearRateSchedule")), new TimeRangeRateSchedule(lexicon.getText("timeRangeRateSchedule")), new BillPeriodLengthRateSchedule(lexicon.getText("billPeriodRateSchedule")), new IntersectionCompositeRateSchedule(lexicon.getText("intersectionRateSchedule")), new UnionCompositeRateSchedule(lexicon.getText("unionRateSchedule"))});
        this.scheduleTypeComboBox.setRenderer(new RateListCellRenderer(((RateScheduleDetailPanel)component).getResourceManager()));
        jPanel2.add(this.scheduleTypeComboBox);
        jComponent.add((Component)jPanel2, "Center");
        this.registerKeyboardActions(jComponent);
        this.registerKeyboardActions(this.scheduleTypeComboBox);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                NewRateScheduleDialog.this.scheduleTypeComboBox.requestFocus();
            }
        });
    }

    private void registerKeyboardActions(JComponent jComponent) {
        jComponent.registerKeyboardAction(this, "ok", KeyStroke.getKeyStroke(10, 0), 1);
        jComponent.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton || actionEvent.getActionCommand().equals("ok") && this.okButton.isEnabled()) {
            RateSchedule rateSchedule = (RateSchedule)this.scheduleTypeComboBox.getSelectedItem();
            this.schedule = (RateSchedule)rateSchedule.newCopy();
            this.hide();
        } else if (actionEvent.getSource() == this.cancelButton || actionEvent.getActionCommand().equals("cancel")) {
            this.schedule = null;
            this.hide();
        }
    }

    private RateSchedule getRateSchedule() {
        return this.schedule;
    }

    public static RateSchedule getNewRateSchedule(EasSession easSession, Component component, boolean bl, Lexicon lexicon) {
        NewRateScheduleDialog newRateScheduleDialog = new NewRateScheduleDialog(easSession, NewRateScheduleDialog.getParentFrame(component), component, bl, lexicon);
        newRateScheduleDialog.show();
        return newRateScheduleDialog.getRateSchedule();
    }
}

