/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.ui.widgets.EasDialog;
import com.tridium.eas.ui.widgets.EasTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewRateDialog
extends EasDialog
implements ActionListener,
DocumentListener {
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JTextField nameTextField = null;
    private String name = null;
    private EasSession session = null;
    private Lexicon lex;

    private NewRateDialog(EasSession easSession, Frame frame, Component component, Lexicon lexicon) {
        super(frame, component);
        this.lex = lexicon;
        this.setModal(true);
        this.session = easSession;
        this.setTitle(lexicon.getText("newRate"));
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1), false);
        this.okButton = new JButton(lexicon.getText("ok"));
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("ok");
        this.okButton.setEnabled(false);
        jPanel.add(this.okButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancel");
        jPanel.add(this.cancelButton);
        jComponent.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new FlowLayout(0), false);
        jPanel2.add(new JLabel(lexicon.getText("name")));
        this.nameTextField = new EasTextField(20, 50);
        this.nameTextField.getDocument().addDocumentListener(this);
        jPanel2.add(this.nameTextField);
        jComponent.add((Component)jPanel2, "Center");
        this.registerKeyboardActions(jComponent);
        this.registerKeyboardActions(this.nameTextField);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                NewRateDialog.this.nameTextField.requestFocus();
            }
        });
    }

    private void registerKeyboardActions(JComponent jComponent) {
        jComponent.registerKeyboardAction(this, "ok", KeyStroke.getKeyStroke(10, 0), 1);
        jComponent.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.nameTextField.getText().trim().length() > 0);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.nameTextField.getText().trim().length() > 0);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.nameTextField.getText().trim().length() > 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton || actionEvent.getActionCommand().equals("ok") && this.okButton.isEnabled()) {
            if (this.dataIsValid()) {
                this.name = this.nameTextField.getText();
                this.hide();
            }
        } else if (actionEvent.getSource() == this.cancelButton || actionEvent.getActionCommand().equals("cancel")) {
            this.hide();
        }
    }

    private boolean dataIsValid() {
        return true;
    }

    private Rate getRate() {
        if (this.name == null) {
            return null;
        }
        return new Rate(this.name);
    }

    public static Rate getNewRate(EasSession easSession, Component component, Lexicon lexicon) {
        NewRateDialog newRateDialog = new NewRateDialog(easSession, NewRateDialog.getParentFrame(component), component, lexicon);
        newRateDialog.show();
        return newRateDialog.getRate();
    }
}

