/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.ui.RateList;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasDialog;
import com.tridium.eas.ui.widgets.EasTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FilterRateDialog
extends EasDialog
implements ActionListener,
DocumentListener {
    private JPanel upperPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private EasComboBox filterTypeComboBox = null;
    private JLabel startsWithLabel = null;
    private EasTextField startsWithTextField = null;
    private JLabel rateFilterLabel = null;
    private RateList rateList = null;
    private Rate[] result = null;
    private EasSession session = null;
    private Lexicon lex;

    private FilterRateDialog(EasSession easSession, Frame frame, Component component, Lexicon lexicon, RateList rateList, JLabel jLabel) {
        super(frame, component);
        this.rateList = rateList;
        this.rateFilterLabel = jLabel;
        this.lex = lexicon;
        this.setModal(true);
        this.session = easSession;
        this.setTitle(lexicon.getText("filterRates"));
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1), false);
        this.okButton = new JButton(lexicon.getText("ok"));
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("ok");
        jPanel.add(this.okButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancel");
        jPanel.add(this.cancelButton);
        jComponent.add((Component)jPanel, "South");
        this.upperPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.filterTypeComboBox = new EasComboBox(new String[]{lexicon.getText("allRates"), lexicon.getText("byRateName"), lexicon.getText("byEnergyProvider"), lexicon.getText("byLocation")});
        this.filterTypeComboBox.addActionListener(this);
        this.upperPanel.add((Component)this.filterTypeComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.startsWithLabel = new JLabel(lexicon.getText("startingWith"));
        this.startsWithLabel.setEnabled(false);
        this.upperPanel.add((Component)this.startsWithLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.anchor = 17;
        this.startsWithTextField = new EasTextField(15, 50);
        this.startsWithTextField.setUseLabelAppearanceWhenDisabled(true);
        this.startsWithTextField.setEnabled(false);
        this.startsWithTextField.getDocument().addDocumentListener(this);
        this.upperPanel.add((Component)this.startsWithTextField, gridBagConstraints);
        jComponent.add((Component)this.upperPanel, "Center");
        this.registerKeyboardActions(jComponent);
        this.registerKeyboardActions(this.startsWithTextField);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                FilterRateDialog.this.filterTypeComboBox.requestFocus();
            }
        });
    }

    private void registerKeyboardActions(JComponent jComponent) {
        jComponent.registerKeyboardAction(this, "ok", KeyStroke.getKeyStroke(10, 0), 1);
        jComponent.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.startsWithTextField.getText().trim().length() > 0);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.startsWithTextField.getText().trim().length() > 0);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.startsWithTextField.getText().trim().length() > 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton || actionEvent.getActionCommand().equals("ok") && this.okButton.isEnabled()) {
            this.rateList.refreshData(true);
            switch (this.filterTypeComboBox.getSelectedIndex()) {
                case 0: {
                    this.result = this.rateList.getRates();
                    this.rateFilterLabel.setText(this.lex.getText("allRates"));
                    break;
                }
                case 1: {
                    Rate[] rateArray = this.rateList.getRates();
                    String string = this.startsWithTextField.getText();
                    Rate[] rateArray2 = null;
                    if (rateArray != null && string != null) {
                        Rate[] rateArray3 = new Rate[rateArray.length];
                        int n = 0;
                        for (int i = 0; i < rateArray.length; ++i) {
                            if (!rateArray[i].getName().toLowerCase().startsWith(string.toLowerCase())) continue;
                            rateArray3[n] = rateArray[i];
                            ++n;
                        }
                        rateArray2 = new Rate[n];
                        System.arraycopy(rateArray3, 0, rateArray2, 0, n);
                    }
                    this.result = rateArray2;
                    this.rateFilterLabel.setText(this.lex.getText("rates") + " " + this.lex.getText("byRateName") + " \"" + string + "\"");
                    break;
                }
                case 2: {
                    Rate[] rateArray = this.rateList.getRates();
                    String string = this.startsWithTextField.getText();
                    Rate[] rateArray4 = null;
                    if (rateArray != null && string != null) {
                        Rate[] rateArray5 = new Rate[rateArray.length];
                        int n = 0;
                        for (int i = 0; i < rateArray.length; ++i) {
                            Rate rate = this.rateList.getRate(rateArray[i].getName(), false);
                            if (!rate.getEnergyProvider().toLowerCase().startsWith(string.toLowerCase())) continue;
                            rateArray5[n] = rate;
                            ++n;
                        }
                        rateArray4 = new Rate[n];
                        System.arraycopy(rateArray5, 0, rateArray4, 0, n);
                    }
                    this.result = rateArray4;
                    this.rateFilterLabel.setText(this.lex.getText("rates") + " " + this.lex.getText("byEnergyProvider") + " \"" + string + "\"");
                    break;
                }
                case 3: {
                    Rate[] rateArray = this.rateList.getRates();
                    String string = this.startsWithTextField.getText();
                    Rate[] rateArray6 = null;
                    if (rateArray != null && string != null) {
                        Rate[] rateArray7 = new Rate[rateArray.length];
                        int n = 0;
                        for (int i = 0; i < rateArray.length; ++i) {
                            Rate rate = this.rateList.getRate(rateArray[i].getName(), false);
                            if (!rate.getLocation().toLowerCase().startsWith(string.toLowerCase())) continue;
                            rateArray7[n] = rate;
                            ++n;
                        }
                        rateArray6 = new Rate[n];
                        System.arraycopy(rateArray7, 0, rateArray6, 0, n);
                    }
                    this.result = rateArray6;
                    this.rateFilterLabel.setText(this.lex.getText("rates") + " " + this.lex.getText("byLocation") + " \"" + string + "\"");
                }
            }
            this.hide();
        } else if (actionEvent.getSource() == this.cancelButton || actionEvent.getActionCommand().equals("cancel")) {
            this.result = this.rateList.getRates();
            this.hide();
        } else if (actionEvent.getSource() == this.filterTypeComboBox) {
            this.startsWithLabel.setEnabled(this.filterTypeComboBox.getSelectedIndex() != 0);
            this.startsWithTextField.setEnabled(this.filterTypeComboBox.getSelectedIndex() != 0);
            this.upperPanel.revalidate();
            this.okButton.setEnabled(this.filterTypeComboBox.getSelectedIndex() == 0 || this.startsWithTextField.getText().trim().length() > 0);
        }
    }

    private Rate[] getRates() {
        return this.result;
    }

    public static Rate[] getFilteredRates(EasSession easSession, Component component, Lexicon lexicon, RateList rateList, JLabel jLabel) {
        FilterRateDialog filterRateDialog = new FilterRateDialog(easSession, FilterRateDialog.getParentFrame(component), component, lexicon, rateList, jLabel);
        filterRateDialog.show();
        return filterRateDialog.getRates();
    }
}

