/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.ui.theme.Theme;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class EasHotLink
extends JComponent
implements MouseListener,
MouseMotionListener {
    private String text;
    private Applet applet;
    private boolean emailText;
    private boolean isActive = false;
    private Color activeColor;
    private Color inactiveColor;
    private int displayLength;
    private long lastClick = 0L;
    private Rectangle textBounds = new Rectangle(0, 0, 0, 0);
    private FontMetrics fm;

    public EasHotLink(String string, Applet applet, boolean bl, int n) {
        this(string, applet, bl, n, null, null);
    }

    public EasHotLink(String string, Applet applet, boolean bl, int n, Color color) {
        this(string, applet, bl, n, color, color);
    }

    public EasHotLink(String string, Applet applet, boolean bl, int n, Color color, Color color2) {
        this.text = string;
        this.applet = applet;
        this.emailText = bl;
        this.displayLength = n;
        this.activeColor = color;
        this.inactiveColor = color2;
        if (color2 != null) {
            this.setForeground(color2);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        Font font = UIManager.getFont("Label.font");
        font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), font.getSize());
        this.setFont(font);
    }

    public Dimension getPreferredSize() {
        if (this.fm == null) {
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        String string = this.text;
        if (this.text.length() > this.displayLength) {
            string = this.text.substring(0, this.displayLength);
        }
        int n = this.fm.stringWidth(string);
        int n2 = this.fm.getHeight();
        int n3 = this.fm.stringWidth(" ");
        return new Dimension(n + 2 * n3, n2 + this.fm.getLeading());
    }

    public void setFont(Font font) {
        this.fm = null;
        super.setFont(font);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.repaint();
    }

    public void setActiveColor(Color color) {
        this.activeColor = color;
        this.repaint();
    }

    public void setInactiveColor(Color color) {
        this.inactiveColor = color;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
        }
        String string = this.text;
        if (this.text.length() > this.displayLength) {
            string = this.text.substring(0, this.displayLength);
        }
        int n = this.fm.stringWidth(string);
        int n2 = (dimension.width - n) / 2;
        int n3 = (dimension.height - this.fm.getHeight()) / 2 + this.fm.getAscent();
        graphics.drawString(string, n2, n3);
        this.textBounds.x = n2;
        this.textBounds.y = n3 - this.fm.getAscent();
        this.textBounds.width = n;
        this.textBounds.height = this.fm.getHeight();
    }

    private boolean inText(int n, int n2) {
        return n > this.textBounds.x && n < this.textBounds.x + this.textBounds.width && n2 > this.textBounds.y && n2 < this.textBounds.y + this.textBounds.height;
    }

    private void setActive(boolean bl) {
        if (bl == this.isActive) {
            return;
        }
        this.isActive = bl;
        if (this.isActive) {
            this.setForeground(this.activeColor);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setForeground(this.inactiveColor);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.repaint();
    }

    protected void leftPressed(MouseEvent mouseEvent) {
        String string = this.getText();
        if (this.emailText) {
            try {
                this.applet.getAppletContext().showDocument(new URL("mailto:" + string), "_blank");
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Bad email address: " + string);
                malformedURLException.printStackTrace();
            }
        } else {
            try {
                this.applet.getAppletContext().showDocument(new URL("http", string, ""), "_blank");
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Bad URL: " + string);
                malformedURLException.printStackTrace();
            }
        }
    }

    protected void leftReleased(MouseEvent mouseEvent) {
    }

    protected void rightPressed(MouseEvent mouseEvent) {
        this.leftPressed(mouseEvent);
    }

    protected void rightReleased(MouseEvent mouseEvent) {
    }

    protected void doubleClick(MouseEvent mouseEvent) {
        this.leftPressed(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.inText(mouseEvent.getX(), mouseEvent.getY())) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                this.lastClick = 0L;
                this.rightPressed(mouseEvent);
                return;
            }
            long l = System.currentTimeMillis();
            if (l - this.lastClick < 250L) {
                this.lastClick = 0L;
                this.doubleClick(mouseEvent);
                return;
            }
            this.lastClick = l;
            this.leftPressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.rightReleased(mouseEvent);
        } else {
            this.leftReleased(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.inText(mouseEvent.getX(), mouseEvent.getY())) {
            this.setActive(true);
        } else {
            this.setActive(false);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setActive(false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

