/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasClientSession;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.report.AnalyzerReport;
import com.tridium.eas.cost.report.Budget;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.xml.XmlDecoder;
import com.tridium.eas.xml.XmlEncoder;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.baja.units.BUnit;

public class EasCostClient {
    private static Hashtable unlockedCustomRateComponentMap = null;
    private static Hashtable customRateComponentMap = null;

    public static String[] retrieveRateNames(EasSession easSession) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/cost/ratelist"));
        int n = dataInputStream.readInt();
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        dataInputStream.close();
        return stringArray;
    }

    public static Rate retrieveRate(EasSession easSession, String string) throws Exception {
        if (string == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/cost/rate?name=" + XmlEncoder.encodeUrl(string)));
        int n = dataInputStream.readInt();
        if (n <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        Rate rate = (Rate)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return rate;
    }

    public static boolean storeRate(EasSession easSession, Rate rate) throws Exception {
        if (rate == null) {
            return false;
        }
        OutputStream outputStream = easSession.put("/eas/cost/saveRate");
        XmlEncoder xmlEncoder = new XmlEncoder(outputStream);
        xmlEncoder.encodeDocument(rate);
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static boolean renameRate(EasSession easSession, String string, String string2) throws Exception {
        OutputStream outputStream = easSession.put("/eas/cost/renameRate?oldName=" + XmlEncoder.encodeUrl(string) + "&newName=" + XmlEncoder.encodeUrl(string2));
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static boolean deleteRate(EasSession easSession, String string) throws Exception {
        OutputStream outputStream = easSession.put("/eas/cost/deleteRate?rateName=" + XmlEncoder.encodeUrl(string));
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static RateHistory retrieveRateHistory(EasSession easSession, int n) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/cost/rateHistory?meterId=" + String.valueOf(n)));
        int n2 = dataInputStream.readInt();
        if (n2 <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        RateHistory rateHistory = (RateHistory)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return rateHistory;
    }

    public static boolean storeRateHistory(EasSession easSession, int n, RateHistory rateHistory) throws Exception {
        if (rateHistory == null) {
            return false;
        }
        OutputStream outputStream = easSession.put("/eas/cost/saveRateHistory?meterId=" + String.valueOf(n));
        XmlEncoder xmlEncoder = new XmlEncoder(outputStream);
        xmlEncoder.encodeDocument(rateHistory);
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static String[] retrieveReconciliationReportNames(EasSession easSession, String string) throws Exception {
        if (string == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/cost/reconciliationList?directory=" + XmlEncoder.encodeUrl(string)));
        int n = dataInputStream.readInt();
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        dataInputStream.close();
        return stringArray;
    }

    public static ReconciliationReport retrieveReconciliationReport(EasSession easSession, String string, String string2, String string3, boolean bl, boolean bl2, String string4, boolean bl3, boolean bl4, BUnit bUnit, double d, boolean bl5, int n, double d2, boolean bl6, DataPoint dataPoint) throws Exception {
        if (string2 == null || string == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/cost/reconciliation?directory=" + XmlEncoder.encodeUrl(string) + "&name=" + XmlEncoder.encodeUrl(string2) + "&billPeriod=" + XmlEncoder.encodeUrl(string3) + "&run=" + String.valueOf(bl) + "&allowFuture=" + String.valueOf(bl2) + "&meter=" + XmlEncoder.encodeUrl(string4) + "&floorNorm=" + String.valueOf(bl3) + "&weatherNorm=" + String.valueOf(bl4) + "&normUnits=" + XmlEncoder.encodeUrl(bUnit.getUnitName()) + "&normTemp=" + String.valueOf(d) + "&dataCleanse=" + String.valueOf(bl5) + "&dataCleanseWindow=" + String.valueOf(n) + "&dataCleansePercentage=" + String.valueOf(d2) + "&dpNormalization=" + String.valueOf(bl6) + "&normalizer=" + String.valueOf(bl6 && dataPoint != null ? dataPoint.getId() : -1)));
        int n2 = dataInputStream.readInt();
        if (n2 <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        ReconciliationReport reconciliationReport = (ReconciliationReport)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return reconciliationReport;
    }

    public static boolean storeReconciliationReport(EasSession easSession, int n, String string, ReconciliationReport reconciliationReport) throws Exception {
        if (reconciliationReport == null || string == null) {
            return false;
        }
        OutputStream outputStream = easSession.put("/eas/cost/saveReconciliation?meterId=" + String.valueOf(n) + "&billCycle=" + XmlEncoder.encodeUrl(string));
        XmlEncoder xmlEncoder = new XmlEncoder(outputStream);
        xmlEncoder.encodeDocument(reconciliationReport);
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static boolean deleteReconciliationReport(EasSession easSession, int n, String string) throws Exception {
        OutputStream outputStream = easSession.put("/eas/cost/deleteReconciliation?meterId=" + String.valueOf(n) + "&billCycle=" + XmlEncoder.encodeUrl(string));
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static ReconciliationReport runReconciliationReport(EasSession easSession, String string, String string2, ReconciliationReport reconciliationReport, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) throws Exception {
        if (reconciliationReport == null || string == null) {
            return null;
        }
        URL uRL = ((EasClientSession)easSession).getURL("/eas/cost/runReconciliation?meter=" + XmlEncoder.encodeUrl(string) + "&billPeriod=" + XmlEncoder.encodeUrl(string2) + "&floorNorm=" + String.valueOf(bl) + "&weatherNorm=" + String.valueOf(bl2) + "&normUnits=" + XmlEncoder.encodeUrl(bUnit.getUnitName()) + "&normTemp=" + String.valueOf(d) + "&dataCleanse=" + String.valueOf(bl3) + "&dataCleanseWindow=" + String.valueOf(n) + "&dataCleansePercentage=" + String.valueOf(d2) + "&dpNormalization=" + String.valueOf(bl4) + "&normalizer=" + String.valueOf(bl4 && dataPoint != null ? dataPoint.getId() : -1));
        URLConnection uRLConnection = uRL.openConnection();
        ((EasClientSession)easSession).setAuthorization(uRLConnection);
        ((EasClientSession)easSession).setLanguage(uRLConnection);
        uRLConnection.setRequestProperty("content-type", "x-application/tridium-easdata");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlEncoder xmlEncoder = new XmlEncoder(byteArrayOutputStream);
        xmlEncoder.encodeDocument(reconciliationReport);
        uRLConnection.setRequestProperty("content-length", Integer.toString(byteArrayOutputStream.size()));
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
        byteArrayOutputStream.writeTo(dataOutputStream);
        dataOutputStream.flush();
        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
        int n2 = dataInputStream.readInt();
        if (n2 <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        ReconciliationReport reconciliationReport2 = (ReconciliationReport)xmlDecoder.decodeDocument();
        dataOutputStream.close();
        int n3 = uRLConnection.getContentLength();
        dataInputStream.close();
        return reconciliationReport2;
    }

    public static ReconciliationReport runAlternateReconciliationReport(EasSession easSession, String[] stringArray, String string, boolean bl, ReconciliationReport reconciliationReport, boolean bl2, boolean bl3, BUnit bUnit, double d, RateHistory rateHistory, boolean bl4, int n, double d2, boolean bl5, DataPoint dataPoint) throws Exception {
        if (reconciliationReport == null || stringArray == null || rateHistory == null) {
            return null;
        }
        int n2 = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(n2));
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(";" + XmlEncoder.encodeXmlString(stringArray[i]));
        }
        URL uRL = ((EasClientSession)easSession).getURL("/eas/cost/runAlternateReconciliation?meters=" + XmlEncoder.encodeUrl(stringBuffer.toString()) + "&billPeriod=" + XmlEncoder.encodeUrl(string) + "&aggregateTimestamps=" + String.valueOf(bl) + "&floorNorm=" + String.valueOf(bl2) + "&weatherNorm=" + String.valueOf(bl3) + "&normUnits=" + XmlEncoder.encodeUrl(bUnit.getUnitName()) + "&normTemp=" + String.valueOf(d) + "&dataCleanse=" + String.valueOf(bl4) + "&dataCleanseWindow=" + String.valueOf(n) + "&dataCleansePercentage=" + String.valueOf(d2) + "&dpNormalization=" + String.valueOf(bl5) + "&normalizer=" + String.valueOf(bl5 && dataPoint != null ? dataPoint.getId() : -1));
        URLConnection uRLConnection = uRL.openConnection();
        ((EasClientSession)easSession).setAuthorization(uRLConnection);
        ((EasClientSession)easSession).setLanguage(uRLConnection);
        uRLConnection.setRequestProperty("content-type", "x-application/tridium-easdata");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlEncoder xmlEncoder = new XmlEncoder(byteArrayOutputStream);
        xmlEncoder.encodeDocument(reconciliationReport);
        xmlEncoder.encodeDocument(rateHistory);
        uRLConnection.setRequestProperty("content-length", Integer.toString(byteArrayOutputStream.size()));
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
        byteArrayOutputStream.writeTo(dataOutputStream);
        dataOutputStream.flush();
        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
        int n3 = dataInputStream.readInt();
        if (n3 <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        ReconciliationReport reconciliationReport2 = (ReconciliationReport)xmlDecoder.decodeDocument();
        dataOutputStream.close();
        int n4 = uRLConnection.getContentLength();
        dataInputStream.close();
        return reconciliationReport2;
    }

    public static AnalyzerReport retrieveAnalyzerReport(EasSession easSession, String string, String string2) throws Exception {
        DataInputStream dataInputStream;
        int n;
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            string = "public";
        }
        if ((n = (dataInputStream = new DataInputStream(easSession.get("/eas/cost/analyzerReport?userName=" + XmlEncoder.encodeUrl(string) + "&reportName=" + XmlEncoder.encodeUrl(string2)))).readInt()) <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        AnalyzerReport analyzerReport = (AnalyzerReport)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return analyzerReport;
    }

    public static boolean storeAnalyzerReport(EasSession easSession, AnalyzerReport analyzerReport, String string) throws Exception {
        if (analyzerReport == null) {
            return false;
        }
        if (string == null) {
            string = "public";
        }
        OutputStream outputStream = easSession.put("/eas/cost/saveAnalyzerReport?userName=" + XmlEncoder.encodeUrl(string));
        XmlEncoder xmlEncoder = new XmlEncoder(outputStream);
        xmlEncoder.encodeDocument(analyzerReport);
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static Budget retrieveBudget(EasSession easSession, int n, String string) throws Exception {
        if (string == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/cost/budget?meterId=" + String.valueOf(n) + "&billCycle=" + XmlEncoder.encodeUrl(string)));
        int n2 = dataInputStream.readInt();
        if (n2 <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        Budget budget = (Budget)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return budget;
    }

    public static boolean storeBudget(EasSession easSession, int n, Budget budget) throws Exception {
        if (budget == null) {
            return false;
        }
        OutputStream outputStream = easSession.put("/eas/cost/saveBudget?meterId=" + String.valueOf(n));
        XmlEncoder xmlEncoder = new XmlEncoder(outputStream);
        xmlEncoder.encodeDocument(budget);
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static boolean deleteBudget(EasSession easSession, int n, String string) throws Exception {
        OutputStream outputStream = easSession.put("/eas/cost/deleteBudget?meterId=" + String.valueOf(n) + "&billCycle=" + XmlEncoder.encodeUrl(string));
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static String[] retrieveCostMeters(EasSession easSession, String string) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/cost/costMeterList?rateName=" + XmlEncoder.encodeUrl(string)));
        int n = dataInputStream.readInt();
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        dataInputStream.close();
        return stringArray;
    }

    public static Hashtable loadUnlockedCustomRateComponents(EasSession easSession) {
        if (unlockedCustomRateComponentMap == null) {
            Class<?> clazz = easSession.getClass();
            InputStream inputStream = clazz.getResourceAsStream("/com/tridium/eas/cost/rate/components/customRateComponents.properties");
            Properties properties = new Properties();
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            unlockedCustomRateComponentMap = new Hashtable();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!Meter.isCustomRateComponentUnlocked(easSession, string)) continue;
                unlockedCustomRateComponentMap.put(string, properties.getProperty(string));
            }
        }
        return unlockedCustomRateComponentMap;
    }

    public static Hashtable loadCustomRateComponents(Class clazz) {
        if (customRateComponentMap == null) {
            InputStream inputStream = clazz.getResourceAsStream("/com/tridium/eas/cost/rate/components/customRateComponents.properties");
            Properties properties = new Properties();
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            customRateComponentMap = new Hashtable();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                customRateComponentMap.put(string, properties.getProperty(string));
            }
        }
        return customRateComponentMap;
    }
}

