/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.components.ChoiceComponent;
import com.tridium.eas.cost.rate.components.ChoiceComponentChild;
import com.tridium.eas.cost.rate.components.CombinationPercentageFee;
import com.tridium.eas.cost.rate.components.DemandCharge;
import com.tridium.eas.cost.rate.components.FixedFee;
import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.HistoricalRatchet;
import com.tridium.eas.cost.rate.components.Ratchet;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.rate.components.ScheduledDemandCharge;
import com.tridium.eas.cost.rate.components.ScheduledFeePerUnit;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.FilterRateDialog;
import com.tridium.eas.cost.ui.NewRateDialog;
import com.tridium.eas.cost.ui.RateComponentList;
import com.tridium.eas.cost.ui.RateDetailPanel;
import com.tridium.eas.cost.ui.RateList;
import com.tridium.eas.cost.util.CopySupport;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasEditorListener;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.ListPopupHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class CreateARateApplication
extends JPanel
implements ResourceManager,
ActionListener {
    private RateList rates = null;
    private RateComponentList rateComponents = null;
    private RateDetailPanel rateDetails = null;
    private RatePopup ratePopup = null;
    private RateComponentPopup rateComponentPopup = null;
    private JSplitPane rateComponentsSplit = null;
    private JButton refreshButton;
    private JButton newButton;
    private JButton deleteButton;
    private JButton filterButton;
    private JLabel rateFilterLabel;
    private JPanel mainSplit;
    private Rate customRate = null;
    private JToolBar toolbar = null;
    private EasApplication easApplication;
    private boolean lastChange = true;
    private boolean firstCreation = true;
    public static CopySupport clipboard = null;
    public static final String CUSTOM_COMPONENTS_RATE = "CustomComponents";
    private static FixedFee defaultFixedFee = new FixedFee("Fixed Fee");
    private static FlatFeePerUnit defaultFlatFeePerUnit = new FlatFeePerUnit("Flat Fee Per Unit");
    private static ScheduledFeePerUnit defaultScheduledFeePerUnit = new ScheduledFeePerUnit("Scheduled Fee Per Unit");
    private static DemandCharge defaultDemandCharge = new DemandCharge("Demand Charge");
    private static ScheduledDemandCharge defaultScheduledDemandCharge = new ScheduledDemandCharge("Scheduled Demand Charge");
    private static Ratchet defaultRatchet = new Ratchet("Ratchet");
    private static HistoricalRatchet defaultHistoricalRatchet = new HistoricalRatchet("Historical Ratchet");
    private static ChoiceComponent defaultChoiceComponent = new ChoiceComponent("Choice Component");
    private static CombinationPercentageFee defaultCombinationPercentageFee = new CombinationPercentageFee("Combination Percentage Fee");
    private static RateComponent[] defaultRateComponents = new RateComponent[]{defaultFixedFee, defaultFlatFeePerUnit, defaultDemandCharge, defaultRatchet, defaultHistoricalRatchet, defaultCombinationPercentageFee, defaultChoiceComponent, defaultScheduledFeePerUnit, defaultScheduledDemandCharge};
    private static Rate defaultRate = new Rate(defaultRateComponents);

    public CreateARateApplication(EasApplication easApplication) {
        this.easApplication = easApplication;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getApplicationContent(), "Center");
    }

    public Image loadImage(String string) {
        return this.easApplication.loadImage(string);
    }

    public Image getIconImage(int n) {
        return this.easApplication.getIconImage(n);
    }

    public final void initApplication(boolean bl) {
        this.initApplication(bl, true);
    }

    public final void initApplication(boolean bl, boolean bl2) {
        if (bl) {
            Lexicon lexicon = BEasApplet.lex;
            this.rates.init(this.easApplication.getSession());
            this.rates.refreshData(bl2);
            this.rates.setEnabled(true);
            try {
                this.customRate = EasCostClient.retrieveRate(this.easApplication.getSession(), CUSTOM_COMPONENTS_RATE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.customRate == null) {
                this.customRate = new Rate(CUSTOM_COMPONENTS_RATE);
            }
            Hashtable hashtable = EasCostClient.loadUnlockedCustomRateComponents(this.easApplication.getSession());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)hashtable.get(string);
                    RateComponent rateComponent = (RateComponent)Class.forName(string2).newInstance();
                    RateComponent[] rateComponentArray = defaultRate.getRateComponents();
                    boolean bl3 = false;
                    if (rateComponentArray != null) {
                        for (int i = 0; i < rateComponentArray.length; ++i) {
                            if (!rateComponentArray[i].getType().equals(rateComponent.getType())) continue;
                            bl3 = true;
                            break;
                        }
                    }
                    if (bl3) continue;
                    rateComponent.setName(lexicon.getText(string));
                    defaultRate.addRateComponent(rateComponent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.rateComponents.setRate(defaultRate);
            this.rateComponents.setCustomRate(this.customRate);
            this.rateComponents.init(this.easApplication.getSession());
            defaultFixedFee.setName(lexicon.getText("fixedFee"));
            defaultFlatFeePerUnit.setName(lexicon.getText("flatFeePerUnit"));
            defaultScheduledFeePerUnit.setName(lexicon.getText("scheduledFeePerUnit"));
            defaultDemandCharge.setName(lexicon.getText("demandCharge"));
            defaultScheduledDemandCharge.setName(lexicon.getText("scheduledDemandCharge"));
            defaultRatchet.setName(lexicon.getText("ratchet"));
            defaultHistoricalRatchet.setName(lexicon.getText("historicalRatchet"));
            defaultCombinationPercentageFee.setName(lexicon.getText("combinationPercentageFee"));
            defaultChoiceComponent.setName(lexicon.getText("choiceComponent"));
            this.rateComponents.setEnabled(true);
            this.rateDetails.init(this.easApplication.getSession());
            if (this.rateComponentsSplit != null) {
                this.rateComponentsSplit.setDividerLocation(0.5);
            }
        }
    }

    public void startApplication() {
        if (this.rateComponentsSplit != null) {
            this.rateComponentsSplit.setDividerLocation(0.5);
        }
    }

    public JToolBar getToolBar() {
        return this.getApplicationToolBar(new int[]{17, 29, 16});
    }

    private JToolBar getApplicationToolBar(int[] nArray) {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        Lexicon lexicon = BEasApplet.lex;
        block5: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 29: {
                    this.newButton = new EasButton((ResourceManager)this, new int[]{306, 29}, lexicon.getText("newRate"));
                    this.newButton.addActionListener(this);
                    this.toolbar.add(this.newButton);
                    continue block5;
                }
                case 17: {
                    this.refreshButton = new EasButton((ResourceManager)this, 17, lexicon.getText("refresh"));
                    this.refreshButton.addActionListener(this);
                    this.toolbar.add(this.refreshButton);
                    this.toolbar.addSeparator();
                    continue block5;
                }
                case 16: {
                    this.deleteButton = new EasButton((ResourceManager)this, 16, lexicon.getText("deleteRate"));
                    this.deleteButton.addActionListener(this);
                    this.toolbar.add(this.deleteButton);
                }
            }
        }
        return this.toolbar;
    }

    private JComponent getApplicationContent() {
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/comboPerFee.png", 301);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/demandCharge.png", 302);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/flatFee.png", 303);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/flatFeePerUnit.png", 304);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/historicalRatchet.png", 316);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/ratchet.png", 305);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/rate.png", 306);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/schedule.png", 307);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/compositeSchedule.png", 308);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/intersectionSchedule.png", 309);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/unionSchedule.png", 310);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/filter.png", 311);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/startTime.png", 312);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/endTime.png", 313);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/arrowUp.png", 314);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/arrowDown.png", 315);
        if (this.mainSplit == null) {
            Lexicon lexicon = BEasApplet.lex;
            this.mainSplit = new JPanel(new BorderLayout(), false);
            this.rateComponentsSplit = new JSplitPane(0);
            this.rateComponentsSplit.setDividerSize(4);
            this.rateComponentsSplit.setTopComponent(this.buildAvailableRatesContents(lexicon));
            this.rateComponentsSplit.setBottomComponent(this.buildAvailableRateComponentsContents(lexicon));
            this.mainSplit.add((Component)this.rateComponentsSplit, "West");
            this.mainSplit.add((Component)this.buildRateEditorContent(), "Center");
        }
        return this.mainSplit;
    }

    private JComponent buildAvailableRatesContents(Lexicon lexicon) {
        this.rates = new RateList(this);
        this.rates.getSelectionModel().setSelectionMode(0);
        this.rates.setPopupHandler(new ListPopupHandler(){

            public void openPopup(Object object, int n, int n2, int n3) {
                if (CreateARateApplication.this.rates.isEnabled()) {
                    if (CreateARateApplication.this.ratePopup == null) {
                        Lexicon lexicon = BEasApplet.lex;
                        CreateARateApplication.this.ratePopup = new RatePopup(lexicon);
                    }
                    CreateARateApplication.this.ratePopup.show(CreateARateApplication.this.rates, n >= 0, n2, n3);
                }
            }
        });
        this.rates.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 155) {
                    CreateARateApplication.this.createRate();
                } else if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    CreateARateApplication.this.deleteRate();
                } else if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                    CreateARateApplication.this.copyRate();
                } else if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown() && clipboard != null && clipboard instanceof Rate) {
                    CreateARateApplication.this.pasteRate();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.filterButton = new EasButton((ResourceManager)this, 311, lexicon.getText("filterRates"));
        this.filterButton.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(0), false);
        jPanel2.add(this.filterButton);
        this.rateFilterLabel = new JLabel(lexicon.getText("allRates"));
        jPanel2.add(this.rateFilterLabel);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(this.rates), "Center");
        return jPanel;
    }

    private JComponent buildAvailableRateComponentsContents(Lexicon lexicon) {
        this.rateComponents = new RateComponentList(this);
        this.rateComponents.getSelectionModel().setSelectionMode(0);
        this.rateComponents.setPopupHandler(new ListPopupHandler(){

            public void openPopup(Object object, int n, int n2, int n3) {
                if (CreateARateApplication.this.rateComponents.isEnabled()) {
                    if (CreateARateApplication.this.rateComponentPopup == null) {
                        Lexicon lexicon = BEasApplet.lex;
                        CreateARateApplication.this.rateComponentPopup = new RateComponentPopup(lexicon);
                    }
                    CreateARateApplication.this.rateComponentPopup.show(CreateARateApplication.this.rateComponents, n >= 0, n2, n3);
                }
            }
        });
        this.rateComponents.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 155) {
                    CreateARateApplication.this.addRateComponent();
                } else if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    RateComponent rateComponent = (RateComponent)CreateARateApplication.this.rateComponents.getSelectedValue();
                    if (rateComponent != null) {
                        RateComponent[] rateComponentArray = defaultRate.getRateComponents();
                        for (int i = 0; i < rateComponentArray.length; ++i) {
                            if (rateComponent != rateComponentArray[i]) continue;
                            return;
                        }
                        CreateARateApplication.this.deleteRateComponent();
                    }
                } else if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                    CreateARateApplication.this.copyRateComponent();
                } else if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown() && clipboard != null && clipboard instanceof RateComponent) {
                    CreateARateApplication.this.pasteRateComponent();
                }
            }
        });
        this.rateComponents.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    CreateARateApplication.this.addRateComponent();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.add((Component)new JLabel("  " + lexicon.getText("availableComponents")), "North");
        jPanel.add((Component)new JScrollPane(this.rateComponents), "Center");
        return jPanel;
    }

    private JComponent buildRateEditorContent() {
        Lexicon lexicon = BEasApplet.lex;
        this.rateDetails = new RateDetailPanel(this, this, lexicon);
        this.rates.setRateEditor(this.rateDetails);
        return this.rateDetails;
    }

    public void setRateSelectionEnabled(boolean bl) {
        if (bl != this.lastChange) {
            EventObject eventObject = new EventObject(this);
            if (bl) {
                ((EasEditorListener)((Object)this.easApplication)).editingStopped(eventObject);
            } else {
                ((EasEditorListener)((Object)this.easApplication)).editingStarted(eventObject);
            }
        }
        this.lastChange = bl;
        this.rates.setEnabled(bl);
        this.newButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
        this.filterButton.setEnabled(bl);
        this.rateFilterLabel.setEnabled(bl);
    }

    public void saveRate(Rate rate) {
        this.rates.saveRate(rate);
    }

    public void renameRateAndSave(Rate rate, String string) {
        this.rates.renameRate(rate, string);
        rate.setName(string);
        this.saveRate(rate);
        this.rates.refreshData(false);
        this.rates.setSelectedValue(this.rates.getRateObject(string), true);
    }

    public void reloadRate() {
        this.rates.reloadRate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            this.buttonPressed((JButton)object);
        }
    }

    private void buttonPressed(JButton jButton) {
        if (jButton == this.refreshButton) {
            this.setRateSelectionEnabled(true);
            this.reloadRate();
            if (this.rateDetails != null) {
                this.rateDetails.doRefresh();
            }
            this.initApplication(true, false);
        } else if (jButton == this.newButton) {
            this.createRate();
        } else if (jButton == this.deleteButton) {
            this.deleteRate();
        } else if (jButton == this.filterButton) {
            this.filterRates();
        }
    }

    private void createRate() {
        Lexicon lexicon = BEasApplet.lex;
        Rate rate = NewRateDialog.getNewRate(this.easApplication.getSession(), this, lexicon);
        if (rate != null) {
            if (this.rateNameIllegal(rate.getName())) {
                JOptionPane.showMessageDialog(this, rate.getName() + " " + lexicon.getText("illegalRateName"), lexicon.getText("rateNameError"), 0);
                return;
            }
            if (this.rateNameAlreadyExists(rate, rate.getName())) {
                JOptionPane.showMessageDialog(this, rate.getName() + " " + lexicon.getText("rateAlreadyExists"), lexicon.getText("rateNameError"), 0);
                return;
            }
            this.saveRate(rate);
            this.rates.refreshData(false);
            this.rates.setSelectedValue(this.rates.getRateObject(rate.getName()), true);
            if (this.firstCreation) {
                this.rateDetails.adjustSplitPane();
                this.firstCreation = false;
            }
        }
    }

    private void deleteRate() {
        Rate rate = this.rates.getSelectedRate();
        if (rate != null) {
            Lexicon lexicon = BEasApplet.lex;
            String string = lexicon.getText("deleteWarning") + "\n\"" + rate.getName() + "\"?";
            int n = JOptionPane.showConfirmDialog(this, string, lexicon.getText("confirmDelete"), 0);
            if (n != 0) {
                return;
            }
            this.rates.deleteRate(rate);
            this.rates.refreshData(false);
        }
    }

    private void copyRate() {
        Rate rate = this.rates.getSelectedRate();
        if (rate != null) {
            clipboard = (Rate)rate.newCopy();
        }
    }

    private void pasteRate() {
        Rate rate = (Rate)clipboard.newCopy();
        if (rate != null) {
            String string = this.getNextAvailableRateName(rate, rate.getName());
            rate.setName(string);
            this.saveRate(rate);
            this.rates.refreshData(false);
            this.rates.setSelectedValue(this.rates.getRateObject(rate.getName()), true);
        }
    }

    private void filterRates() {
        Lexicon lexicon = BEasApplet.lex;
        Rate[] rateArray = FilterRateDialog.getFilteredRates(this.easApplication.getSession(), this, lexicon, this.rates, this.rateFilterLabel);
        this.rates.refreshData(rateArray);
    }

    private void saveRateComponent(RateComponent rateComponent) {
        this.rateComponents.saveRateComponent(rateComponent);
    }

    private void deleteRateComponent() {
        RateComponent rateComponent = (RateComponent)this.rateComponents.getSelectedValue();
        if (rateComponent != null) {
            Lexicon lexicon = BEasApplet.lex;
            String string = lexicon.getText("deleteWarning") + "\n\"" + rateComponent.getName() + "\"?";
            int n = JOptionPane.showConfirmDialog(this, string, lexicon.getText("confirmDelete"), 0);
            if (n != 0) {
                return;
            }
            if (rateComponent instanceof ChoiceComponentChild) {
                RateComponent rateComponent2 = ((ChoiceComponentChild)rateComponent).getParentRateComponent();
                ((ChoiceComponent)rateComponent2).removeRateComponent(rateComponent);
            } else {
                this.rateComponents.deleteRateComponent(rateComponent);
            }
            this.rateComponents.refreshData();
        }
    }

    private void copyRateComponent() {
        RateComponent rateComponent = (RateComponent)this.rateComponents.getSelectedValue();
        if (rateComponent != null) {
            if (rateComponent instanceof ChoiceComponentChild) {
                rateComponent = ((ChoiceComponentChild)rateComponent).getRateComponent();
            }
            clipboard = (RateComponent)rateComponent.newCopy();
        }
    }

    private void pasteRateComponent() {
        RateComponent rateComponent = (RateComponent)clipboard.newCopy();
        if (rateComponent instanceof ChoiceComponentChild) {
            rateComponent = ((ChoiceComponentChild)rateComponent).getRateComponent();
        }
        if (rateComponent != null) {
            boolean bl = !CreateARateApplication.componentNameAlreadyExists(defaultRate.getRateComponents(), rateComponent.getName());
            String string = CreateARateApplication.getNextAvailableComponentName(defaultRate, rateComponent.getName(), true);
            string = CreateARateApplication.getNextAvailableComponentName(this.customRate, string, bl);
            rateComponent.setName(string);
            this.saveRateComponent(rateComponent);
            this.rateComponents.refreshData();
        }
    }

    private void addRateComponent() {
        RateComponent rateComponent = (RateComponent)this.rateComponents.getSelectedValue();
        if (rateComponent instanceof ChoiceComponentChild) {
            rateComponent = ((ChoiceComponentChild)rateComponent).getRateComponent();
        }
        this.addRateComponent(rateComponent);
    }

    public void addRateComponent(RateComponent rateComponent) {
        Rate rate = this.rates.getSelectedRate();
        if (rate != null && rateComponent != null) {
            RateComponent rateComponent2 = (RateComponent)rateComponent.newCopy();
            String string = CreateARateApplication.getNextAvailableComponentName(rate, rateComponent2.getName(), true);
            rateComponent2.setName(string);
            rate.addRateComponent(rateComponent2);
            this.rateDetails.setRateEditorValue(rate);
            this.rateDetails.handleRateChange(false);
            this.rateDetails.setSelectedRateComponent(rateComponent2);
        }
    }

    public void addChoiceComponentChild(ChoiceComponent choiceComponent, RateComponent rateComponent) {
        Rate rate = this.rates.getSelectedRate();
        if (rate != null && choiceComponent != null && rateComponent != null && !(rateComponent instanceof CombinationPercentageFee)) {
            RateComponent rateComponent2 = (RateComponent)rateComponent.newCopy();
            String string = CreateARateApplication.getNextAvailableComponentName(choiceComponent, rateComponent2.getName(), true);
            rateComponent2.setName(string);
            ChoiceComponentChild choiceComponentChild = choiceComponent.addRateComponent(rateComponent2);
            this.rateDetails.setRateEditorValue(rate);
            this.rateDetails.handleRateChange(false);
            this.rateDetails.setSelectedRateComponent(choiceComponentChild);
        }
    }

    public void componentsReordered(RateComponent rateComponent, RateComponent[] rateComponentArray) {
        Rate rate = this.rates.getSelectedRate();
        if (rate != null && rateComponent != null) {
            rate.setRateComponents(rateComponentArray);
            this.rateDetails.setRateEditorValue(rate);
            this.rateDetails.handleRateChange(false);
            this.rateDetails.setSelectedRateComponent(rateComponent);
        }
    }

    public boolean rateNameIllegal(String string) {
        if (string == null) {
            return true;
        }
        if (string.length() <= 0) {
            return true;
        }
        return string.indexOf("\\") >= 0 || string.indexOf("|") >= 0 || string.indexOf(";") >= 0 || string.indexOf("/") >= 0 || string.indexOf("?") >= 0 || string.indexOf(":") >= 0 || string.indexOf("@") >= 0 || string.indexOf("&") >= 0 || string.indexOf("+") >= 0 || string.indexOf("$") >= 0 || string.indexOf(",") >= 0 || string.equalsIgnoreCase(CUSTOM_COMPONENTS_RATE);
    }

    public boolean rateNameAlreadyExists(Rate rate, String string) {
        Rate[] rateArray = this.rates.getRates();
        if (rateArray == null) {
            return false;
        }
        for (int i = 0; i < rateArray.length; ++i) {
            if (!rateArray[i].getName().equals(string) || rateArray[i] == rate) continue;
            return true;
        }
        return false;
    }

    private static boolean componentNameAlreadyExists(RateComponent[] rateComponentArray, String string) {
        if (rateComponentArray == null) {
            return false;
        }
        for (int i = 0; i < rateComponentArray.length; ++i) {
            if (!rateComponentArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String getNextAvailableComponentName(Rate rate, String string, boolean bl) {
        int n = 1;
        boolean bl2 = bl;
        while (CreateARateApplication.componentNameAlreadyExists(rate.getRateComponents(), string)) {
            if (bl2) {
                string = string + "_" + n;
                bl2 = false;
            } else {
                string = string.substring(0, string.lastIndexOf(95)) + "_" + n;
            }
            ++n;
        }
        return string;
    }

    private static String getNextAvailableComponentName(ChoiceComponent choiceComponent, String string, boolean bl) {
        int n = 1;
        boolean bl2 = bl;
        while (CreateARateApplication.componentNameAlreadyExists(choiceComponent.getRateComponents(), string)) {
            if (bl2) {
                string = string + "_" + n;
                bl2 = false;
            } else {
                string = string.substring(0, string.lastIndexOf(95)) + "_" + n;
            }
            ++n;
        }
        return string;
    }

    private String getNextAvailableRateName(Rate rate, String string) {
        int n = 1;
        boolean bl = true;
        while (this.rateNameAlreadyExists(rate, string)) {
            if (bl) {
                string = string + "_" + n;
                bl = false;
            } else {
                string = string.substring(0, string.lastIndexOf(95)) + "_" + n;
            }
            ++n;
        }
        return string;
    }

    public void stopApplication() {
        Lexicon lexicon;
        int n;
        if (this.rateDetails != null && this.rateDetails.unsavedChangesExist() && (n = JOptionPane.showConfirmDialog(null, (lexicon = BEasApplet.lex).getText("saveChangesTo") + " " + lexicon.getText("createArate") + "?", lexicon.getText("saveChanges") + "?", 1)) == 0) {
            this.rateDetails.applyChanges();
        }
    }

    private class RateComponentPopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem addItem = null;
        private EasPopupMenu.EasPopupMenuItem copyItem = null;
        private boolean addItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem pasteItem = null;
        private boolean pasteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;
        private Lexicon lex;

        public RateComponentPopup(Lexicon lexicon) {
            this.lex = lexicon;
            this.addItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("addRateComponent"), 0, null);
            this.copyItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("copy"), 1, null);
            this.pasteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Paste"), 2, null);
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("deleteRateComponent"), 3, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    CreateARateApplication.this.addRateComponent();
                    break;
                }
                case 1: {
                    CreateARateApplication.this.copyRateComponent();
                    break;
                }
                case 2: {
                    CreateARateApplication.this.pasteRateComponent();
                    break;
                }
                case 3: {
                    CreateARateApplication.this.deleteRateComponent();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            boolean bl2 = bl;
            boolean bl3 = clipboard != null && clipboard instanceof RateComponent;
            boolean bl4 = true;
            RateComponent rateComponent = (RateComponent)CreateARateApplication.this.rateComponents.getSelectedValue();
            if (rateComponent != null) {
                RateComponent[] rateComponentArray = defaultRate.getRateComponents();
                for (int i = 0; i < rateComponentArray.length; ++i) {
                    if (rateComponent != rateComponentArray[i]) continue;
                    bl4 = false;
                    break;
                }
            }
            if (bl2 && !this.addItemShowing) {
                this.addItem.addActionListener(this);
                this.copyItem.addActionListener(this);
                this.insert(this.addItem, 0);
                this.insert(this.copyItem, 1);
                this.revalidate();
                this.addItemShowing = true;
            } else if (this.addItemShowing && !bl2) {
                this.remove(this.addItem);
                this.remove(this.copyItem);
                this.revalidate();
                this.addItemShowing = false;
            }
            if (bl3 && !this.pasteItemShowing) {
                this.pasteItem.addActionListener(this);
                if (this.addItemShowing) {
                    this.insert(this.pasteItem, 2);
                } else {
                    this.insert(this.pasteItem, 0);
                }
                this.revalidate();
                this.pasteItemShowing = true;
            } else if (this.pasteItemShowing && !bl3) {
                this.remove(this.pasteItem);
                this.revalidate();
                this.pasteItemShowing = false;
            }
            if (bl4 && !this.deleteItemShowing) {
                this.add(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl4) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            if (this.addItemShowing || this.pasteItemShowing || this.deleteItemShowing) {
                super.show(component, n, n2);
            }
        }
    }

    private class RatePopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem addItem = null;
        private boolean addItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem copyItem = null;
        private boolean copyItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem pasteItem = null;
        private boolean pasteItemShowing = false;
        private Lexicon lex;

        public RatePopup(Lexicon lexicon) {
            this.lex = lexicon;
            this.addItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("newRate"), 0, null);
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("deleteRate"), 1, null);
            this.copyItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("copy"), 2, null);
            this.pasteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Paste"), 3, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    CreateARateApplication.this.createRate();
                    break;
                }
                case 1: {
                    CreateARateApplication.this.deleteRate();
                    break;
                }
                case 2: {
                    CreateARateApplication.this.copyRate();
                    break;
                }
                case 3: {
                    CreateARateApplication.this.pasteRate();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            boolean bl2 = bl;
            boolean bl3 = true;
            boolean bl4 = clipboard != null && clipboard instanceof Rate;
            boolean bl5 = bl2;
            if (bl3 && !this.addItemShowing) {
                this.addItem.addActionListener(this);
                this.insert(this.addItem, 0);
                this.revalidate();
                this.addItemShowing = true;
            } else if (this.addItemShowing && !bl3) {
                this.remove(this.addItem);
                this.revalidate();
                this.addItemShowing = false;
            }
            if (bl2 && !this.deleteItemShowing) {
                this.deleteItem.addActionListener(this);
                if (this.addItemShowing) {
                    this.insert(this.deleteItem, 1);
                } else {
                    this.insert(this.deleteItem, 0);
                }
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl2) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            if (bl5 && !this.copyItemShowing) {
                this.copyItem.addActionListener(this);
                if (this.deleteItemShowing && this.addItemShowing) {
                    this.insert(this.copyItem, 2);
                } else if (this.deleteItemShowing || this.addItemShowing) {
                    this.insert(this.copyItem, 1);
                } else {
                    this.insert(this.copyItem, 0);
                }
                this.revalidate();
                this.copyItemShowing = true;
            } else if (this.copyItemShowing && !bl5) {
                this.remove(this.copyItem);
                this.revalidate();
                this.copyItemShowing = false;
            }
            if (bl4 && !this.pasteItemShowing) {
                this.add(this.pasteItem);
                this.revalidate();
                this.pasteItemShowing = true;
            } else if (this.pasteItemShowing && !bl4) {
                this.remove(this.pasteItem);
                this.revalidate();
                this.pasteItemShowing = false;
            }
            if (this.addItemShowing || this.deleteItemShowing || this.copyItemShowing || this.pasteItemShowing) {
                super.show(component, n, n2);
            }
        }
    }
}

