/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import java.text.DecimalFormat;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class CostValueUnitPair
implements Comparable {
    private Number value;
    private BUnit unit;
    private boolean labelFirst;
    private Lexicon lex;

    public CostValueUnitPair(Number number, BUnit bUnit, boolean bl, Lexicon lexicon) {
        this.value = number;
        this.unit = bUnit;
        this.labelFirst = bl;
        this.lex = lexicon;
    }

    public Number getValue() {
        return this.value;
    }

    public BUnit getUnit() {
        return this.unit;
    }

    public byte byteValue() {
        return this.value.byteValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public short shortValue() {
        return this.value.shortValue();
    }

    public int compareTo(Object object) {
        return ((Comparable)((Object)this.value)).compareTo((Comparable)((Object)((CostValueUnitPair)object).getValue()));
    }

    public String toString() {
        BUnit bUnit = this.getUnit();
        String string = "";
        if (bUnit != null) {
            string = this.labelFirst ? " " + bUnit.toString() : bUnit.toString() + " ";
        }
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        if (this.labelFirst) {
            return decimalFormat.format(this.doubleValue()) + string;
        }
        return string + decimalFormat.format(this.doubleValue());
    }
}

