/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.report;

import com.tridium.eas.cost.rate.components.CombinationPercentageFee;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class ReconciliationRow
implements XmlSupport {
    private String name = "-";
    private boolean showCostColumns = false;
    private int namePrefixLength = 0;
    private RateComponent rateComponent = null;
    private double actualCost = 0.0;
    private boolean actualCostSet = false;
    private BUnit currency = null;
    private BUnit units = BUnit.getUnit((String)"kilowatt hour");
    private double projectedCost = 0.0;
    public static String TYPE = "ReconciliationRow";

    public ReconciliationRow() {
    }

    public ReconciliationRow(String string) {
        this.setName(string);
    }

    public ReconciliationRow(String string, int n, RateComponent rateComponent, double d, boolean bl, BUnit bUnit, BUnit bUnit2) {
        this.setName(string);
        this.setShowCostColumns(true);
        this.setNamePrefixLength(n);
        this.setRateComponent(rateComponent);
        this.setActualCost(d);
        this.setActualCostSet(bl);
        this.setCurrency(bUnit);
        this.setUnits(bUnit2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.equals("") ? "-" : string;
    }

    public boolean getShowCostColumns() {
        return this.showCostColumns;
    }

    public void setShowCostColumns(boolean bl) {
        this.showCostColumns = bl;
    }

    public int getNamePrefixLength() {
        return this.namePrefixLength;
    }

    public void setNamePrefixLength(int n) {
        this.namePrefixLength = n;
    }

    public RateComponent getRateComponent() {
        return this.rateComponent;
    }

    public void setRateComponent(RateComponent rateComponent) {
        this.rateComponent = rateComponent;
    }

    public double getActualCost(boolean bl, double d) {
        double d2 = this.actualCost;
        if (bl) {
            d2 /= d;
        }
        return d2;
    }

    public void setActualCost(double d) {
        this.actualCost = d;
    }

    public boolean getActualCostSet() {
        return this.actualCostSet;
    }

    public void setActualCostSet(boolean bl) {
        this.actualCostSet = bl;
    }

    public BUnit getCurrency() {
        if (this.currency == null) {
            try {
                this.currency = BUnit.getUnit((String)"dollar");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.currency == null) {
                this.currency = BUnit.make((String)"dollar", (String)"$", (BDimension)BDimension.make((int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)1));
            }
        }
        return this.currency;
    }

    public void setCurrency(BUnit bUnit) {
        this.currency = bUnit;
    }

    public BUnit getUnits() {
        return this.units;
    }

    public void setUnits(BUnit bUnit) {
        this.units = bUnit;
    }

    public String getDisplayName(Lexicon lexicon, boolean bl) {
        String string = "";
        String string2 = "";
        if (this.getShowCostColumns()) {
            string = "    ";
            string2 = bl ? "  (" + this.getCurrency().toString() + " " + lexicon.getText("/") + " " + this.getUnits().toString() + ")" : "  (" + this.getCurrency().toString() + ")";
        }
        return string + this.getName().substring(this.getNamePrefixLength()) + string2;
    }

    public String getDisplayName(Lexicon lexicon) {
        String string = "";
        String string2 = "";
        if (this.getShowCostColumns()) {
            string = "    ";
            string2 = "  (" + this.getCurrency().toString() + ")";
        }
        return string + this.getName().substring(this.getNamePrefixLength()) + string2;
    }

    public String getFullName() {
        if (this.getShowCostColumns()) {
            String string = this.getName().substring(0, this.getNamePrefixLength());
            String string2 = ", " + this.getName().substring(this.getNamePrefixLength());
            return string + string2;
        }
        return this.getName();
    }

    public String getRateName() {
        if (this.getShowCostColumns()) {
            return this.getName().substring(0, this.getNamePrefixLength());
        }
        return this.getName();
    }

    private String getRateNamePrefix() {
        if (this.getShowCostColumns()) {
            return this.getName().substring(0, this.getNamePrefixLength()) + ", ";
        }
        return "not a component";
    }

    public String getComponentName() {
        if (this.getShowCostColumns()) {
            return this.getName().substring(this.getNamePrefixLength());
        }
        return this.getName();
    }

    public double getCalculatedCost() {
        RateComponent rateComponent;
        if (this.getShowCostColumns() && (rateComponent = this.getRateComponent()) != null) {
            return rateComponent.getCalculatedCostForInterval();
        }
        return 0.0;
    }

    public double getDeltaCost(boolean bl, double d) {
        return this.getCalculatedCost() - (!this.getActualCostSet() ? this.getCalculatedCost() : this.getActualCost(bl, d));
    }

    public String toString() {
        return this.getFullName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n      name: " + this.getName());
        stringBuffer.append("\n      fullName: " + this.getFullName());
        stringBuffer.append("\n        showCostColumns: " + this.getShowCostColumns());
        stringBuffer.append("\n        namePrefixLength: " + this.getNamePrefixLength());
        stringBuffer.append("\n        calculatedCost: " + this.getCalculatedCost());
        stringBuffer.append("\n        actualCost: " + this.getActualCost(false, 1.0));
        stringBuffer.append("\n        actualCostSet: " + this.getActualCostSet());
        stringBuffer.append("\n        deltaCost: " + this.getDeltaCost(false, 1.0));
        stringBuffer.append("\n        currency: " + this.getCurrency());
        stringBuffer.append("\n        units: " + this.getUnits());
        stringBuffer.append("\n        rateComponent: " + (this.getRateComponent() != null ? this.getRateComponent().toDebugString() : "null"));
        return stringBuffer.toString();
    }

    public double computeProjectedCost(double d, ReconciliationReport reconciliationReport) {
        RateComponent rateComponent;
        this.projectedCost = 0.0;
        if (this.getShowCostColumns() && (rateComponent = this.getRateComponent()) != null) {
            if (rateComponent instanceof CombinationPercentageFee) {
                double d2 = 0.0;
                ReconciliationRow[] reconciliationRowArray = ReconciliationRow.getRegisteredRows(this, reconciliationReport);
                if (reconciliationRowArray != null && reconciliationRowArray.length > 0) {
                    for (int i = 0; i < reconciliationRowArray.length; ++i) {
                        d2 += reconciliationRowArray[i].computeProjectedCost(d, reconciliationReport);
                    }
                }
                this.projectedCost = d2 * (((CombinationPercentageFee)rateComponent).getPercentage() / 100.0);
                return this.projectedCost;
            }
            this.projectedCost = rateComponent.getProjectedCost(d);
            return this.projectedCost;
        }
        return this.projectedCost;
    }

    public double getProjectedCost() {
        return this.projectedCost;
    }

    private static ReconciliationRow[] getRegisteredRows(ReconciliationRow reconciliationRow, ReconciliationReport reconciliationReport) {
        if (reconciliationRow != null && reconciliationRow.getRateComponent() != null && reconciliationRow.getRateComponent() instanceof CombinationPercentageFee) {
            int n;
            String[] stringArray = ((CombinationPercentageFee)reconciliationRow.getRateComponent()).getRegisteredComponentIds();
            ReconciliationRow[] reconciliationRowArray = reconciliationReport.getReconciliationRows();
            if (stringArray == null || stringArray.length <= 0 || reconciliationRowArray == null || reconciliationRowArray.length <= 0) {
                return null;
            }
            ReconciliationRow[] reconciliationRowArray2 = new ReconciliationRow[stringArray.length];
            int n2 = 0;
            String string = reconciliationRow.getRateNamePrefix();
            block0: for (int i = 0; i < stringArray.length; ++i) {
                for (n = 0; n < reconciliationRowArray.length; ++n) {
                    if (!reconciliationRowArray[n].getFullName().equals(string + stringArray[i])) continue;
                    reconciliationRowArray2[n2] = reconciliationRowArray[n];
                    ++n2;
                    continue block0;
                }
            }
            ReconciliationRow[] reconciliationRowArray3 = new ReconciliationRow[n2];
            for (n = 0; n < n2; ++n) {
                reconciliationRowArray3[n] = reconciliationRowArray2[n];
            }
            return reconciliationRowArray3;
        }
        return null;
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("showCostColumns")) {
                this.setShowCostColumns(Boolean.valueOf(string2));
            } else if (string.equals("namePrefixLength")) {
                this.setNamePrefixLength(Integer.parseInt(string2));
            } else if (string.equals("actualCost")) {
                this.setActualCost(Double.valueOf(string2));
            } else if (string.equals("actualCostSet")) {
                this.setActualCostSet(Boolean.valueOf(string2));
            } else if (string.equals("rowUnits")) {
                try {
                    this.setUnits(BUnit.getUnit((String)XmlEncoder.decodeXmlString(string2)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.equals("rowCurrency")) {
                try {
                    this.setCurrency(BUnit.getUnit((String)XmlEncoder.decodeXmlString(string2)));
                }
                catch (Exception exception) {}
            }
        } else if (xmlSupport instanceof RateComponent) {
            this.setRateComponent((RateComponent)xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n = 6;
        if (this.getRateComponent() != null) {
            ++n;
        }
        XmlSupport[] xmlSupportArray = new XmlSupport[n];
        xmlSupportArray[0] = new XmlSimple("showCostColumns", String.valueOf(this.getShowCostColumns()));
        xmlSupportArray[1] = new XmlSimple("namePrefixLength", String.valueOf(this.getNamePrefixLength()));
        xmlSupportArray[2] = new XmlSimple("actualCost", String.valueOf(this.getActualCost(false, 1.0)));
        xmlSupportArray[3] = new XmlSimple("actualCostSet", String.valueOf(this.getActualCostSet()));
        xmlSupportArray[4] = new XmlSimple("rowUnits", XmlEncoder.encodeXmlString(this.getUnits() != null ? this.getUnits().getUnitName() : ""));
        xmlSupportArray[5] = new XmlSimple("rowCurrency", XmlEncoder.encodeXmlString(this.getCurrency() != null ? this.getCurrency().getUnitName() : ""));
        if (this.getRateComponent() != null) {
            xmlSupportArray[6] = this.getRateComponent();
        }
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

