/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.report;

import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public class ReconciliationNotePostInfo
implements XmlSupport {
    private String name = "-";
    private String user = "Unknown User";
    private long timestamp = -1L;
    private BTimeZone timeZone = CostTimeUtil.DEFAULT_TZ;
    private boolean originalPost = false;
    public static String TYPE = "ReconciliationNotePostInfo";

    public ReconciliationNotePostInfo(String string, long l, BTimeZone bTimeZone, boolean bl) {
        String string2 = "Unknown User";
        if (string != null) {
            string2 = string;
        }
        this.setName(string2 + l + bTimeZone.getId());
        this.setUser(string2);
        this.setTimestamp(l);
        this.setTimeZone(bTimeZone);
        this.setOriginalPost(bl);
    }

    public ReconciliationNotePostInfo() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.equals("") ? "-" : string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public BTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(BTimeZone bTimeZone) {
        this.timeZone = bTimeZone;
    }

    public boolean getOriginalPost() {
        return this.originalPost;
    }

    public void setOriginalPost(boolean bl) {
        this.originalPost = bl;
    }

    public String toDisplayString(Lexicon lexicon) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(lexicon.getText("noteTimeFormat"), new Locale(lexicon.language, ""));
        BTimeZone bTimeZone = BTimeZone.getLocal();
        simpleDateFormat.setTimeZone((TimeZone)bTimeZone.tzSupport());
        long l = CostTimeUtil.convertTime(this.getTimestamp(), this.getTimeZone(), bTimeZone);
        String string = this.getOriginalPost() ? lexicon.getText("posted") : lexicon.getText("edited");
        return "   " + simpleDateFormat.format(new Date(l)) + " " + this.getUser() + " " + string + "\n";
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nname: " + this.getName());
        stringBuffer.append("\n  user: " + this.getUser());
        stringBuffer.append("\n  timestamp: " + this.getTimestamp());
        stringBuffer.append("\n  timezone: " + this.getTimeZone());
        stringBuffer.append("\n  originalPost: " + this.getOriginalPost());
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("user")) {
                this.setUser(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("timestamp")) {
                this.setTimestamp(Long.parseLong(string2));
            } else if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("originalPost")) {
                this.setOriginalPost(Boolean.valueOf(string2));
            }
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = new XmlSupport[]{new XmlSimple("user", XmlEncoder.encodeXmlString(this.getUser())), new XmlSimple("timestamp", String.valueOf(this.getTimestamp())), new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId()))), new XmlSimple("originalPost", String.valueOf(this.getOriginalPost()))};
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

