/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.cost.rate.components.CustomRateComponent;
import com.tridium.eas.cost.rate.components.Ratchet;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.RateComponentDetailPanel;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.cost.util.DoubleRecord;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.cost.util.Record;
import com.tridium.eas.cost.util.Result;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasTimeEditor;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TwelveMonthRatchet
extends Ratchet
implements CustomRateComponent {
    private static final int FEE_APPLIES_PER_BILLING_CYCLE = 0;
    private static final int FEE_APPLIES_PER_DAY = 1;
    private int feeFrequency = 0;
    private double percentage = 100.0;
    private boolean neverReset = true;
    private int resetMonth = 0;
    private int resetDay = 1;
    private int resetHour = 0;
    private int resetMinute = 0;
    private int resetSecond = 0;
    private int resetMillisecond = 0;
    private double initialPeakValue = 0.0;
    private int initialPeakStartYear = EasLocalTime.getCurrentTime().getYear();
    private double currentCyclePeak = 0.0;
    private long currentCyclePeakTime = -1L;
    public static String TYPE = "TwelveMonthRatchet";
    private CostTextField percentageTextField;
    private CostTextField initialPeakTextField;
    private NumberTextField initialPeakStartYearTextField;
    private EasComboBox peakApproachComboBox;
    private EasComboBox feeAppliesComboBox;
    private JCheckBox neverResetCheckBox;
    private EasComboBox resetMonthComboBox;
    private EasComboBox resetDayComboBox;
    private EasTimeEditor resetTimeEditor;

    public TwelveMonthRatchet() {
    }

    public TwelveMonthRatchet(String string) {
        super(string);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((TwelveMonthRatchet)rateComponent).setFeeFrequency(this.getFeeFrequency());
        ((TwelveMonthRatchet)rateComponent).setPercentage(this.getPercentage());
        ((TwelveMonthRatchet)rateComponent).setNeverReset(this.getNeverReset());
        ((TwelveMonthRatchet)rateComponent).setResetMonth(this.getResetMonth());
        ((TwelveMonthRatchet)rateComponent).setResetDay(this.getResetDay());
        ((TwelveMonthRatchet)rateComponent).setResetHour(this.getResetHour());
        ((TwelveMonthRatchet)rateComponent).setResetMinute(this.getResetMinute());
        ((TwelveMonthRatchet)rateComponent).setResetSecond(this.getResetSecond());
        ((TwelveMonthRatchet)rateComponent).setResetMillisecond(this.getResetMillisecond());
        ((TwelveMonthRatchet)rateComponent).setInitialPeakValue(this.getInitialPeakValue());
        ((TwelveMonthRatchet)rateComponent).setInitialPeakStartYear(this.getInitialPeakStartYear());
        ((TwelveMonthRatchet)rateComponent).setCurrentCyclePeak(this.getCurrentCyclePeak());
        ((TwelveMonthRatchet)rateComponent).setCurrentCyclePeakTime(this.getCurrentCyclePeakTime());
        return super.copyParameters(rateComponent);
    }

    public Object newCopy() {
        return this.copyParameters(new TwelveMonthRatchet());
    }

    public int getFeeFrequency() {
        return this.feeFrequency;
    }

    public void setFeeFrequency(int n) {
        this.feeFrequency = n;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double d) {
        this.percentage = d;
        this.setComputeFromScratch(true);
    }

    public boolean getNeverReset() {
        return this.neverReset;
    }

    public void setNeverReset(boolean bl) {
        this.neverReset = bl;
    }

    public int getResetMonth() {
        return this.resetMonth;
    }

    public void setResetMonth(int n) {
        this.resetMonth = n;
    }

    public int getResetDay() {
        return this.resetDay;
    }

    public void setResetDay(int n) {
        this.resetDay = n;
    }

    public int getResetHour() {
        return this.resetHour;
    }

    public void setResetHour(int n) {
        this.resetHour = n;
    }

    public int getResetMinute() {
        return this.resetMinute;
    }

    public void setResetMinute(int n) {
        this.resetMinute = n;
    }

    public int getResetSecond() {
        return this.resetSecond;
    }

    public void setResetSecond(int n) {
        this.resetSecond = n;
    }

    public int getResetMillisecond() {
        return this.resetMillisecond;
    }

    public void setResetMillisecond(int n) {
        this.resetMillisecond = n;
    }

    public double getInitialPeakValue() {
        return this.initialPeakValue;
    }

    public void setInitialPeakValue(double d) {
        this.initialPeakValue = d;
    }

    public int getInitialPeakStartYear() {
        return this.initialPeakStartYear;
    }

    public void setInitialPeakStartYear(int n) {
        this.initialPeakStartYear = n;
    }

    public double getCurrentCyclePeak() {
        return this.currentCyclePeak;
    }

    public void setCurrentCyclePeak(double d) {
        this.currentCyclePeak = d;
    }

    public long getCurrentCyclePeakTime() {
        return this.currentCyclePeakTime;
    }

    public void setCurrentCyclePeakTime(long l) {
        this.currentCyclePeakTime = l;
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        this.setCostStatus("calculating");
        try {
            PeakTimePair peakTimePair;
            RawCostData rawCostData10 = null;
            RawCostData rawCostData11 = null;
            switch (this.getApplicableData()) {
                case 0: {
                    rawCostData10 = rawCostData;
                    break;
                }
                case 1: {
                    rawCostData10 = rawCostData2;
                    rawCostData11 = rawCostData3;
                    break;
                }
                case 2: {
                    rawCostData10 = rawCostData4;
                    break;
                }
                case 4: {
                    rawCostData10 = rawCostData5;
                    break;
                }
                case 3: {
                    rawCostData10 = rawCostData6;
                    rawCostData11 = rawCostData8;
                    break;
                }
                case 5: {
                    rawCostData10 = rawCostData7;
                    rawCostData11 = rawCostData9;
                }
            }
            double d2 = 0.0;
            long l3 = -1L;
            double d3 = 0.0;
            long l4 = -1L;
            double d4 = 0.0;
            long l5 = -1L;
            long l6 = this.getCurrentResetTimestamp(l);
            boolean bl2 = l6 >= 0L && l6 > l && l6 < l2;
            long l7 = this.getLastResetTimestamp(l);
            if (l7 <= l && (peakTimePair = this.findPeak(rawCostData11, l7, l, true, bl, d, l, l2)) != null) {
                d3 = peakTimePair.peak * (this.getPercentage() / 100.0);
                l4 = peakTimePair.timestamp;
            }
            peakTimePair = this.getMaxUnitsForPeriod(rawCostData10, l, l2, bl, d);
            d4 = peakTimePair.peak;
            l5 = peakTimePair.timestamp;
            this.setCurrentCyclePeak(d4);
            this.setCurrentCyclePeakTime(l5);
            if (l5 < 0L) {
                d2 = 0.0;
                l3 = -1L;
            } else if (d4 >= d3) {
                d2 = d4;
                l3 = l5;
            } else {
                if (bl2) {
                    this.setCalculatedUnits(d4);
                    this.setPeakTime(l5);
                    if (this.getDataRangeApproach() == 0) {
                        d3 = d3 < this.getMinDataValue() ? 0.0 : (d3 > this.getMaxDataValue() ? this.getMaxDataValue() - this.getMinDataValue() : (d3 -= this.getMinDataValue()));
                        d4 = d4 < this.getMinDataValue() ? 0.0 : (d4 > this.getMaxDataValue() ? this.getMaxDataValue() - this.getMinDataValue() : (d4 -= this.getMinDataValue()));
                    } else if (this.getDataRangeApproach() == 1) {
                        if (d3 < this.getMinDataValue() || d3 >= this.getMaxDataValue()) {
                            d3 = 0.0;
                        }
                        if (d4 < this.getMinDataValue() || d4 >= this.getMaxDataValue()) {
                            d4 = 0.0;
                        }
                    }
                    double d5 = ((double)l6 - (double)l) / ((double)l2 - (double)l);
                    double d6 = ((double)l2 - (double)l6) / ((double)l2 - (double)l);
                    double d7 = d3 / (double)this.getUnitsInFee();
                    double d8 = d4 / (double)this.getUnitsInFee();
                    double d9 = this.getFee() * d7 * d5 + this.getFee() * d8 * d6;
                    if (this.getFeeFrequency() == 1) {
                        long l8 = l2 - l;
                        if (l8 < 0L) {
                            l8 *= -1L;
                        }
                        double d10 = (double)l8 / 8.64E7;
                        d9 *= d10;
                    }
                    return d9;
                }
                d2 = d3;
                l3 = l4;
            }
            this.setCalculatedUnits(d2);
            this.setPeakTime(l3);
            if (this.getDataRangeApproach() == 0) {
                if (d2 < this.getMinDataValue()) {
                    return 0.0;
                }
                d2 = d2 > this.getMaxDataValue() ? this.getMaxDataValue() - this.getMinDataValue() : (d2 -= this.getMinDataValue());
            } else if (this.getDataRangeApproach() == 1 && (d2 < this.getMinDataValue() || d2 >= this.getMaxDataValue())) {
                return 0.0;
            }
            double d11 = d2 / (double)this.getUnitsInFee();
            double d12 = this.getFee() * d11;
            if (this.getFeeFrequency() == 1) {
                long l9 = l2 - l;
                if (l9 < 0L) {
                    l9 *= -1L;
                }
                double d13 = (double)l9 / 8.64E7;
                d12 *= d13;
            }
            return d12;
        }
        catch (Exception exception) {
            System.out.println("Caught exception in TwelveMonthRatchet.computeCostForRange(): ");
            exception.printStackTrace();
            return 0.0;
        }
    }

    private long getCurrentResetTimestamp(long l) {
        if (this.getNeverReset()) {
            return -1L;
        }
        Calendar calendar = Calendar.getInstance((TimeZone)this.getTimeZone().tzSupport());
        calendar.setTime(new Date(l));
        int n = calendar.get(1);
        Calendar calendar2 = Calendar.getInstance((TimeZone)this.getTimeZone().tzSupport());
        calendar2.set(1, n);
        calendar2.set(2, this.getResetMonth());
        calendar2.set(5, this.getResetDay());
        calendar2.set(11, this.getResetHour());
        calendar2.set(12, this.getResetMinute());
        calendar2.set(13, this.getResetSecond());
        calendar2.set(14, this.getResetMillisecond());
        return calendar2.getTime().getTime();
    }

    private long getLastResetTimestamp(long l) {
        Calendar calendar = Calendar.getInstance((TimeZone)this.getTimeZone().tzSupport());
        calendar.setTime(new Date(l));
        int n = calendar.get(1);
        if (this.getNeverReset()) {
            calendar.set(1, n - 1);
            long l2 = calendar.getTime().getTime();
            return Math.max(l2, CostTimeUtil.convertTime(this.getParentRate().getStartTime(), CostTimeUtil.DEFAULT_TZ, this.getTimeZone()));
        }
        Calendar calendar2 = Calendar.getInstance((TimeZone)this.getTimeZone().tzSupport());
        calendar2.set(1, n);
        calendar2.set(2, this.getResetMonth());
        calendar2.set(5, this.getResetDay());
        calendar2.set(11, this.getResetHour());
        calendar2.set(12, this.getResetMinute());
        calendar2.set(13, this.getResetSecond());
        calendar2.set(14, this.getResetMillisecond());
        long l3 = calendar2.getTime().getTime();
        if (l3 > l) {
            calendar2.set(1, n - 1);
            l3 = calendar2.getTime().getTime();
        }
        return l3;
    }

    protected PeakTimePair getMaxUnitsForPeriod(RawCostData rawCostData, long l, long l2, boolean bl, double d) throws Exception {
        Result result = rawCostData.get(l, l2);
        Record record = rawCostData.createRecord();
        long l3 = -1L;
        double d2 = this.getMinimumContractPeakLevel();
        if (bl) {
            d2 /= d;
        }
        boolean bl2 = false;
        record = result.next(record);
        while (record != null) {
            double d3;
            long l4;
            if (record instanceof DoubleRecord && this.isEffective(l4 = record.getTimestamp(), d3 = ((DoubleRecord)record).getDoubleValue(), bl, d, l, l2) && CostTimeUtil.includes(l4, l, l2) && this.getParentRate().includes(l4, this.getTimeZone()) && TwelveMonthRatchet.validStatus(record.getStatus())) {
                bl2 = true;
                if (d3 > d2) {
                    d2 = d3;
                    l3 = l4;
                }
            }
            record = result.next(record);
        }
        if (!bl2) {
            d2 = 0.0;
            l3 = -1L;
        }
        return new PeakTimePair(d2, l3);
    }

    private PeakTimePair findPeak(RawCostData rawCostData, long l, long l2, boolean bl, boolean bl2, double d, long l3, long l4) throws Exception {
        double d2 = 0.0;
        long l5 = -1L;
        Calendar calendar = Calendar.getInstance((TimeZone)this.getTimeZone().tzSupport());
        calendar.setTime(new Date(l));
        int n = calendar.get(1);
        if (n == this.getInitialPeakStartYear()) {
            d2 = this.getInitialPeakValue();
            if (bl2) {
                d2 /= d;
            }
            l5 = l;
        } else if (!this.getNeverReset()) {
            calendar.set(1, n - 1);
            long l6 = Math.max(calendar.getTime().getTime(), CostTimeUtil.convertTime(this.getParentRate().getStartTime(), CostTimeUtil.DEFAULT_TZ, this.getTimeZone()));
            Result result = rawCostData.get(l6, l);
            Record record = rawCostData.createRecord();
            record = result.next(record);
            while (record != null) {
                if (record instanceof DoubleRecord) {
                    long l7 = record.getTimestamp();
                    double d3 = ((DoubleRecord)record).getDoubleValue();
                    if (l7 == l && bl) {
                        record = result.next(record);
                        continue;
                    }
                    if (this.isEffective(l7, d3, bl2, d, l3, l4) && CostTimeUtil.includes(l7, l6, l) && this.getParentRate().includes(l7, this.getTimeZone()) && TwelveMonthRatchet.validStatus(record.getStatus()) && d3 > d2) {
                        d2 = d3;
                        l5 = l7;
                    }
                }
                record = result.next(record);
            }
        }
        if (l != l2) {
            Result result = rawCostData.get(l, l2);
            Record record = rawCostData.createRecord();
            record = result.next(record);
            while (record != null) {
                if (record instanceof DoubleRecord) {
                    long l8 = record.getTimestamp();
                    double d4 = ((DoubleRecord)record).getDoubleValue();
                    if (l8 == l && !bl) {
                        record = result.next(record);
                        continue;
                    }
                    if (this.isEffective(l8, d4, bl2, d, l3, l4) && CostTimeUtil.includes(l8, l, l2) && this.getParentRate().includes(l8, this.getTimeZone()) && TwelveMonthRatchet.validStatus(record.getStatus()) && d4 > d2) {
                        d2 = d4;
                        l5 = l8;
                    }
                }
                record = result.next(record);
            }
        }
        return new PeakTimePair(d2, l5);
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n      percentage: " + this.getPercentage());
        stringBuffer.append("\n      feeFrequency: " + this.getFeeFrequency());
        stringBuffer.append("\n      neverReset: " + this.getNeverReset());
        stringBuffer.append("\n      resetMonth: " + this.getResetMonth());
        stringBuffer.append("\n      resetDay: " + this.getResetDay());
        stringBuffer.append("\n      resetHour: " + this.getResetHour());
        stringBuffer.append("\n      resetMinute: " + this.getResetMinute());
        stringBuffer.append("\n      resetSecond: " + this.getResetSecond());
        stringBuffer.append("\n      resetMillisecond: " + this.getResetMillisecond());
        stringBuffer.append("\n      initialPeakValue: " + this.getInitialPeakValue());
        stringBuffer.append("\n      initialPeakStartYear: " + this.getInitialPeakStartYear());
        stringBuffer.append("\n      currentCyclePeak: " + this.getCurrentCyclePeak());
        stringBuffer.append("\n      currentCyclePeakTime: " + this.getCurrentCyclePeakTime());
        return stringBuffer.toString();
    }

    public double getProjectedCost(double d) {
        if (this.getFeeFrequency() == 0) {
            return this.getCalculatedCostForInterval();
        }
        return this.getCalculatedCostForInterval() * d;
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("fee")) {
                this.setFee(Double.valueOf(string2));
            } else if (string.equals("minDataValue")) {
                this.setMinDataValue(Double.valueOf(string2));
            } else if (string.equals("maxDataValue")) {
                this.setMaxDataValue(Double.valueOf(string2));
            } else if (string.equals("unitsInFee")) {
                this.setUnitsInFee(Integer.parseInt(string2));
            } else if (string.equals("peakTime")) {
                this.setPeakTime(Long.parseLong(string2));
            } else if (string.equals("minimumContractPeakLevel")) {
                this.setMinimumContractPeakLevel(Double.valueOf(string2));
            } else if (string.equals("feeFrequency")) {
                this.setFeeFrequency(Integer.parseInt(string2));
            } else if (string.equals("percentage")) {
                this.setPercentage(Double.valueOf(string2));
            } else if (string.equals("neverReset")) {
                this.setNeverReset(Boolean.valueOf(string2));
            } else if (string.equals("resetMonth")) {
                this.setResetMonth(Integer.parseInt(string2));
            } else if (string.equals("resetDay")) {
                this.setResetDay(Integer.parseInt(string2));
            } else if (string.equals("resetHour")) {
                this.setResetHour(Integer.parseInt(string2));
            } else if (string.equals("resetMinute")) {
                this.setResetMinute(Integer.parseInt(string2));
            } else if (string.equals("resetSecond")) {
                this.setResetSecond(Integer.parseInt(string2));
            } else if (string.equals("resetMillisecond")) {
                this.setResetMillisecond(Integer.parseInt(string2));
            } else if (string.equals("initialPeakValue")) {
                this.setInitialPeakValue(Double.valueOf(string2));
            } else if (string.equals("initialPeakStartYear")) {
                this.setInitialPeakStartYear(Integer.parseInt(string2));
            } else if (string.equals("currentCyclePeak")) {
                this.setCurrentCyclePeak(Double.valueOf(string2));
            } else if (string.equals("currentCyclePeakTime")) {
                this.setCurrentCyclePeakTime(Long.parseLong(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else if (string.equals("calculatedUnits")) {
                this.setCalculatedUnits(Double.valueOf(string2));
            } else if (string.equals("dataRangeApproach")) {
                this.setDataRangeApproach(Integer.parseInt(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n = 25;
        if (this.getRateSchedule() != null) {
            ++n;
        }
        XmlSupport[] xmlSupportArray = new XmlSupport[n];
        xmlSupportArray[0] = new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId())));
        xmlSupportArray[1] = new XmlSimple("applicableData", String.valueOf(this.getApplicableData()));
        xmlSupportArray[2] = new XmlSimple("category", String.valueOf(this.getCategory()));
        xmlSupportArray[3] = new XmlSimple("fee", String.valueOf(this.getFee()));
        xmlSupportArray[4] = new XmlSimple("minDataValue", String.valueOf(this.getMinDataValue()));
        xmlSupportArray[5] = new XmlSimple("maxDataValue", String.valueOf(this.getMaxDataValue()));
        xmlSupportArray[6] = new XmlSimple("unitsInFee", String.valueOf(this.getUnitsInFee()));
        xmlSupportArray[7] = new XmlSimple("peakTime", String.valueOf(this.getPeakTime()));
        xmlSupportArray[8] = new XmlSimple("minimumContractPeakLevel", String.valueOf(this.getMinimumContractPeakLevel()));
        xmlSupportArray[9] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        xmlSupportArray[10] = new XmlSimple("calculatedUnits", String.valueOf(this.getCalculatedUnits()));
        xmlSupportArray[11] = new XmlSimple("dataRangeApproach", String.valueOf(this.getDataRangeApproach()));
        xmlSupportArray[12] = new XmlSimple("feeFrequency", String.valueOf(this.getFeeFrequency()));
        xmlSupportArray[13] = new XmlSimple("percentage", String.valueOf(this.getPercentage()));
        xmlSupportArray[14] = new XmlSimple("neverReset", String.valueOf(this.getNeverReset()));
        xmlSupportArray[15] = new XmlSimple("resetMonth", String.valueOf(this.getResetMonth()));
        xmlSupportArray[16] = new XmlSimple("resetDay", String.valueOf(this.getResetDay()));
        xmlSupportArray[17] = new XmlSimple("resetHour", String.valueOf(this.getResetHour()));
        xmlSupportArray[18] = new XmlSimple("resetMinute", String.valueOf(this.getResetMinute()));
        xmlSupportArray[19] = new XmlSimple("resetSecond", String.valueOf(this.getResetSecond()));
        xmlSupportArray[20] = new XmlSimple("resetMillisecond", String.valueOf(this.getResetMillisecond()));
        xmlSupportArray[21] = new XmlSimple("initialPeakValue", String.valueOf(this.getInitialPeakValue()));
        xmlSupportArray[22] = new XmlSimple("initialPeakStartYear", String.valueOf(this.getInitialPeakStartYear()));
        xmlSupportArray[23] = new XmlSimple("currentCyclePeak", String.valueOf(this.getCurrentCyclePeak()));
        xmlSupportArray[24] = new XmlSimple("currentCyclePeakTime", String.valueOf(this.getCurrentCyclePeakTime()));
        if (this.getRateSchedule() != null) {
            xmlSupportArray[25] = this.getRateSchedule();
        }
        return xmlSupportArray;
    }

    public boolean supportsRateSchedule() {
        return true;
    }

    public boolean supportsAdvancedProperties() {
        return true;
    }

    public JComponent buildComponentEditor(RateComponentDetailPanel rateComponentDetailPanel, Lexicon lexicon) {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("percentage")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.percentageTextField = new CostTextField(10, false);
        this.percentageTextField.setMaximumFractionDigits(5);
        this.percentageTextField.setAllowNegative(false);
        this.percentageTextField.setUseLabelAppearanceWhenDisabled(true);
        this.percentageTextField.getDocument().addDocumentListener(new MyDocumentListener(rateComponentDetailPanel));
        this.percentageTextField.addFocusListener(rateComponentDetailPanel);
        this.percentageTextField.setText(this.getPercentage());
        jPanel.add((Component)this.percentageTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("feeApplies")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.feeAppliesComboBox = new EasComboBox(new String[]{lexicon.getText("perBillingCycle"), lexicon.getText("perDay")});
        this.feeAppliesComboBox.addActionListener(new FeeAppliesActionListener(rateComponentDetailPanel));
        jPanel.add((Component)this.feeAppliesComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("resetDate")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.neverResetCheckBox = new JCheckBox(lexicon.getText("never12MonthRolling"));
        this.neverResetCheckBox.addActionListener(new NeverResetCheckBoxListener(rateComponentDetailPanel));
        jPanel.add((Component)this.neverResetCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.resetMonthComboBox = new EasComboBox(new String[]{lexicon.getText("january.short"), lexicon.getText("february.short"), lexicon.getText("march.short"), lexicon.getText("april.short"), lexicon.getText("may.short"), lexicon.getText("june.short"), lexicon.getText("july.short"), lexicon.getText("august.short"), lexicon.getText("september.short"), lexicon.getText("october.short"), lexicon.getText("november.short"), lexicon.getText("december.short")});
        this.resetMonthComboBox.addActionListener(new ResetMonthActionListener(rateComponentDetailPanel));
        jPanel.add((Component)this.resetMonthComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.resetDayComboBox = new EasComboBox(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"});
        this.resetDayComboBox.addActionListener(new ResetDayActionListener(rateComponentDetailPanel));
        jPanel.add((Component)this.resetDayComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.resetTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(rateComponentDetailPanel.getResourceManager().getIconImage(312)), new ImageIcon(rateComponentDetailPanel.getResourceManager().getIconImage(313)));
        this.resetTimeEditor.addActionListener(new ResetTimeActionListener(rateComponentDetailPanel));
        jPanel.add((Component)this.resetTimeEditor, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("initialPeakValue")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.initialPeakTextField = new CostTextField(10, false);
        this.initialPeakTextField.setMaximumFractionDigits(5);
        this.initialPeakTextField.setUseLabelAppearanceWhenDisabled(true);
        this.initialPeakTextField.getDocument().addDocumentListener(new InitialPeakDocumentListener(rateComponentDetailPanel));
        this.initialPeakTextField.addFocusListener(rateComponentDetailPanel);
        this.initialPeakTextField.setText(this.getInitialPeakValue());
        jPanel.add((Component)this.initialPeakTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("initialPeakStartYear")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.initialPeakStartYearTextField = new NumberTextField(6, true);
        this.initialPeakStartYearTextField.setAllowNegative(false);
        this.initialPeakStartYearTextField.setUseLabelAppearanceWhenDisabled(true);
        this.initialPeakStartYearTextField.setText(this.getInitialPeakStartYear());
        this.initialPeakStartYearTextField.getDocument().addDocumentListener(new InitialPeakStartYearDocumentListener(rateComponentDetailPanel));
        this.initialPeakStartYearTextField.addFocusListener(rateComponentDetailPanel);
        jPanel.add((Component)this.initialPeakStartYearTextField, gridBagConstraints);
        return jPanel;
    }

    public void loadComponentEditor(CustomRateComponent customRateComponent) {
        this.percentageTextField.setText(((TwelveMonthRatchet)customRateComponent).getPercentage());
        this.initialPeakTextField.setText(((TwelveMonthRatchet)customRateComponent).getInitialPeakValue());
        this.initialPeakStartYearTextField.setText(((TwelveMonthRatchet)customRateComponent).getInitialPeakStartYear());
        this.feeAppliesComboBox.setSelectedIndex(((TwelveMonthRatchet)customRateComponent).getFeeFrequency());
        this.neverResetCheckBox.setSelected(((TwelveMonthRatchet)customRateComponent).getNeverReset());
        this.resetMonthComboBox.setSelectedIndex(((TwelveMonthRatchet)customRateComponent).getResetMonth());
        this.resetDayComboBox.setSelectedIndex(((TwelveMonthRatchet)customRateComponent).getResetDay() - 1);
        this.resetTimeEditor.setValues(((TwelveMonthRatchet)customRateComponent).getResetHour(), ((TwelveMonthRatchet)customRateComponent).getResetMinute(), ((TwelveMonthRatchet)customRateComponent).getResetSecond(), ((TwelveMonthRatchet)customRateComponent).getResetMillisecond());
        if (this.neverResetCheckBox.isSelected()) {
            this.resetMonthComboBox.setVisible(false);
            this.resetDayComboBox.setVisible(false);
            this.resetTimeEditor.setVisible(false);
        } else {
            this.resetMonthComboBox.setVisible(true);
            this.resetDayComboBox.setVisible(true);
            this.resetTimeEditor.setVisible(true);
        }
    }

    public void buildReconciliationDetails(ReconciliationRow reconciliationRow, JPanel jPanel, GridBagConstraints gridBagConstraints, Lexicon lexicon) {
        int n = gridBagConstraints.gridy;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("currentCyclePeak")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        DecimalFormat decimalFormat = new DecimalFormat(lexicon.getText("costValueFormat"));
        if (this.getCurrentCyclePeak() > 0.0 && this.getCurrentCyclePeak() < 0.01) {
            decimalFormat = new DecimalFormat(lexicon.getText("extendedCostValueFormat"));
        }
        String string = decimalFormat.format(this.getCurrentCyclePeak());
        String string2 = reconciliationRow.getUnits().toString();
        jPanel.add((Component)new JLabel(string + " " + string2, 4), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("currentCyclePeakTime")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(lexicon.getText("peakTimeFormat"), new Locale(lexicon.language, ""));
        simpleDateFormat.setTimeZone((TimeZone)this.getTimeZone().tzSupport());
        jPanel.add((Component)new JLabel(simpleDateFormat.format(new Date(this.getCurrentCyclePeakTime())), 4), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("percentage")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(String.valueOf(this.getPercentage()), 4), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("feeApplies")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        String string3 = lexicon.getText("perBillingCycle");
        if (this.getFeeFrequency() == 1) {
            string3 = lexicon.getText("perDay");
        }
        jPanel.add((Component)new JLabel(string3, 4), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("resetDate")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        String string4 = lexicon.getText("never12MonthRolling");
        if (!this.getNeverReset()) {
            switch (this.getResetMonth()) {
                case 0: {
                    string4 = lexicon.getText("january.short");
                    break;
                }
                case 1: {
                    string4 = lexicon.getText("february.short");
                    break;
                }
                case 2: {
                    string4 = lexicon.getText("march.short");
                    break;
                }
                case 3: {
                    string4 = lexicon.getText("april.short");
                    break;
                }
                case 4: {
                    string4 = lexicon.getText("may.short");
                    break;
                }
                case 5: {
                    string4 = lexicon.getText("june.short");
                    break;
                }
                case 6: {
                    string4 = lexicon.getText("july.short");
                    break;
                }
                case 7: {
                    string4 = lexicon.getText("august.short");
                    break;
                }
                case 8: {
                    string4 = lexicon.getText("september.short");
                    break;
                }
                case 9: {
                    string4 = lexicon.getText("october.short");
                    break;
                }
                case 10: {
                    string4 = lexicon.getText("november.short");
                    break;
                }
                case 11: {
                    string4 = lexicon.getText("december.short");
                    break;
                }
                default: {
                    string4 = "";
                }
            }
            String string5 = null;
            string5 = this.getResetHour() < 10 ? "0" + this.getResetHour() : "" + this.getResetHour();
            String string6 = null;
            string6 = this.getResetMinute() < 10 ? "0" + this.getResetMinute() : "" + this.getResetMinute();
            string4 = string4 + " " + this.getResetDay() + ", " + string5 + ":" + string6;
        }
        jPanel.add((Component)new JLabel(string4, 4), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("initialPeakValue")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(String.valueOf(this.getInitialPeakValue()), 4), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("initialPeakStartYear")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(String.valueOf(this.getInitialPeakStartYear()), 4), gridBagConstraints);
    }

    private class ResetTimeActionListener
    implements ActionListener {
        private RateComponentDetailPanel parentPanel;

        public ResetTimeActionListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            TwelveMonthRatchet twelveMonthRatchet = (TwelveMonthRatchet)this.parentPanel.getSelectedRateComponentBase();
            twelveMonthRatchet.setResetHour(TwelveMonthRatchet.this.resetTimeEditor.getHour());
            twelveMonthRatchet.setResetMinute(TwelveMonthRatchet.this.resetTimeEditor.getMinute());
            twelveMonthRatchet.setResetSecond(TwelveMonthRatchet.this.resetTimeEditor.getSecond());
            twelveMonthRatchet.setResetMillisecond(TwelveMonthRatchet.this.resetTimeEditor.getMillisecond());
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class ResetDayActionListener
    implements ActionListener {
        private RateComponentDetailPanel parentPanel;

        public ResetDayActionListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            ((TwelveMonthRatchet)this.parentPanel.getSelectedRateComponentBase()).setResetDay(TwelveMonthRatchet.this.resetDayComboBox.getSelectedIndex() + 1);
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class ResetMonthActionListener
    implements ActionListener {
        private RateComponentDetailPanel parentPanel;

        public ResetMonthActionListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            ((TwelveMonthRatchet)this.parentPanel.getSelectedRateComponentBase()).setResetMonth(TwelveMonthRatchet.this.resetMonthComboBox.getSelectedIndex());
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class NeverResetCheckBoxListener
    implements ActionListener {
        private RateComponentDetailPanel parentPanel;

        public NeverResetCheckBoxListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            ((TwelveMonthRatchet)this.parentPanel.getSelectedRateComponentBase()).setNeverReset(TwelveMonthRatchet.this.neverResetCheckBox.isSelected());
            if (TwelveMonthRatchet.this.neverResetCheckBox.isSelected()) {
                TwelveMonthRatchet.this.resetMonthComboBox.setVisible(false);
                TwelveMonthRatchet.this.resetDayComboBox.setVisible(false);
                TwelveMonthRatchet.this.resetTimeEditor.setVisible(false);
            } else {
                TwelveMonthRatchet.this.resetMonthComboBox.setVisible(true);
                TwelveMonthRatchet.this.resetDayComboBox.setVisible(true);
                TwelveMonthRatchet.this.resetTimeEditor.setVisible(true);
            }
            this.parentPanel.revalidate();
            this.parentPanel.repaint();
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class FeeAppliesActionListener
    implements ActionListener {
        private RateComponentDetailPanel parentPanel;

        public FeeAppliesActionListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            ((TwelveMonthRatchet)this.parentPanel.getSelectedRateComponentBase()).setFeeFrequency(TwelveMonthRatchet.this.feeAppliesComboBox.getSelectedIndex());
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class InitialPeakStartYearDocumentListener
    implements DocumentListener {
        private RateComponentDetailPanel parentPanel;

        public InitialPeakStartYearDocumentListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            try {
                ((TwelveMonthRatchet)this.parentPanel.getSelectedRateComponentBase()).setInitialPeakStartYear(TwelveMonthRatchet.this.initialPeakStartYearTextField.getIntValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class InitialPeakDocumentListener
    implements DocumentListener {
        private RateComponentDetailPanel parentPanel;

        public InitialPeakDocumentListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            try {
                ((TwelveMonthRatchet)this.parentPanel.getSelectedRateComponentBase()).setInitialPeakValue(TwelveMonthRatchet.this.initialPeakTextField.getDoubleValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private RateComponentDetailPanel parentPanel;

        public MyDocumentListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            try {
                ((TwelveMonthRatchet)this.parentPanel.getSelectedRateComponentBase()).setPercentage(TwelveMonthRatchet.this.percentageTextField.getDoubleValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class PeakTimePair {
        public double peak = 0.0;
        public long timestamp = -1L;

        public PeakTimePair(double d, long l) {
            this.peak = d;
            this.timestamp = l;
        }
    }
}

