/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.cost.datatypes.RateSchedule;
import com.tridium.eas.cost.rate.components.CustomRateComponent;
import com.tridium.eas.cost.rate.components.FixedFee;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.RateComponentDetailPanel;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.ui.widgets.CheckList;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScheduledFixedFee
extends FixedFee
implements CustomRateComponent {
    private static final int FEE_APPLIES_PER_BILLING_CYCLE = 0;
    private static final int FEE_APPLIES_PER_DAY = 1;
    private int feeFrequency = 0;
    private boolean january = true;
    private boolean february = true;
    private boolean march = true;
    private boolean april = true;
    private boolean may = true;
    private boolean june = true;
    private boolean july = true;
    private boolean august = true;
    private boolean september = true;
    private boolean october = true;
    private boolean november = true;
    private boolean december = true;
    private int startYear = -1;
    private int endYear = -1;
    public static String TYPE = "ScheduledFixedFee";
    private EasComboBox feeAppliesComboBox;
    private CheckList includedMonthsEditor;
    private JCheckBox noStartYearCheckBox;
    private NumberTextField startYearEditor;
    private JCheckBox noEndYearCheckBox;
    private NumberTextField endYearEditor;

    public ScheduledFixedFee() {
    }

    public ScheduledFixedFee(String string) {
        super(string);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((ScheduledFixedFee)rateComponent).setFeeFrequency(this.getFeeFrequency());
        ((ScheduledFixedFee)rateComponent).setJanuary(this.getJanuary());
        ((ScheduledFixedFee)rateComponent).setFebruary(this.getFebruary());
        ((ScheduledFixedFee)rateComponent).setMarch(this.getMarch());
        ((ScheduledFixedFee)rateComponent).setApril(this.getApril());
        ((ScheduledFixedFee)rateComponent).setMay(this.getMay());
        ((ScheduledFixedFee)rateComponent).setJune(this.getJune());
        ((ScheduledFixedFee)rateComponent).setJuly(this.getJuly());
        ((ScheduledFixedFee)rateComponent).setAugust(this.getAugust());
        ((ScheduledFixedFee)rateComponent).setSeptember(this.getSeptember());
        ((ScheduledFixedFee)rateComponent).setOctober(this.getOctober());
        ((ScheduledFixedFee)rateComponent).setNovember(this.getNovember());
        ((ScheduledFixedFee)rateComponent).setDecember(this.getDecember());
        ((ScheduledFixedFee)rateComponent).setStartYear(this.getStartYear());
        ((ScheduledFixedFee)rateComponent).setEndYear(this.getEndYear());
        return super.copyParameters(rateComponent);
    }

    public Object newCopy() {
        return this.copyParameters(new ScheduledFixedFee());
    }

    public int getFeeFrequency() {
        return this.feeFrequency;
    }

    public void setFeeFrequency(int n) {
        this.feeFrequency = n;
    }

    public boolean getJanuary() {
        return this.january;
    }

    public void setJanuary(boolean bl) {
        this.january = bl;
    }

    public boolean getFebruary() {
        return this.february;
    }

    public void setFebruary(boolean bl) {
        this.february = bl;
    }

    public boolean getMarch() {
        return this.march;
    }

    public void setMarch(boolean bl) {
        this.march = bl;
    }

    public boolean getApril() {
        return this.april;
    }

    public void setApril(boolean bl) {
        this.april = bl;
    }

    public boolean getMay() {
        return this.may;
    }

    public void setMay(boolean bl) {
        this.may = bl;
    }

    public boolean getJune() {
        return this.june;
    }

    public void setJune(boolean bl) {
        this.june = bl;
    }

    public boolean getJuly() {
        return this.july;
    }

    public void setJuly(boolean bl) {
        this.july = bl;
    }

    public boolean getAugust() {
        return this.august;
    }

    public void setAugust(boolean bl) {
        this.august = bl;
    }

    public boolean getSeptember() {
        return this.september;
    }

    public void setSeptember(boolean bl) {
        this.september = bl;
    }

    public boolean getOctober() {
        return this.october;
    }

    public void setOctober(boolean bl) {
        this.october = bl;
    }

    public boolean getNovember() {
        return this.november;
    }

    public void setNovember(boolean bl) {
        this.november = bl;
    }

    public boolean getDecember() {
        return this.december;
    }

    public void setDecember(boolean bl) {
        this.december = bl;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int n) {
        this.startYear = n;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int n) {
        this.endYear = n;
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        double d2 = 0.0;
        boolean bl2 = true;
        String string2 = string.substring(0, 3);
        try {
            int n = Integer.parseInt(string.substring(3));
            if (this.getStartYear() >= 0) {
                boolean bl3 = bl2 = n >= this.getStartYear();
            }
            if (bl2 && this.getEndYear() >= 0) {
                bl2 = n <= this.getEndYear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl2) {
            return d2;
        }
        if (string2.equals("Jan")) {
            bl2 = this.getJanuary();
        } else if (string2.equals("Feb")) {
            bl2 = this.getFebruary();
        } else if (string2.equals("Mar")) {
            bl2 = this.getMarch();
        } else if (string2.equals("Apr")) {
            bl2 = this.getApril();
        } else if (string2.equals("May")) {
            bl2 = this.getMay();
        } else if (string2.equals("Jun")) {
            bl2 = this.getJune();
        } else if (string2.equals("Jul")) {
            bl2 = this.getJuly();
        } else if (string2.equals("Aug")) {
            bl2 = this.getAugust();
        } else if (string2.equals("Sep")) {
            bl2 = this.getSeptember();
        } else if (string2.equals("Oct")) {
            bl2 = this.getOctober();
        } else if (string2.equals("Nov")) {
            bl2 = this.getNovember();
        } else if (string2.equals("Dec")) {
            bl2 = this.getDecember();
        }
        if (!bl2) {
            return d2;
        }
        if (this.getFeeFrequency() == 0) {
            d2 = this.getFee();
        } else {
            long l3 = l2 - l;
            if (l3 < 0L) {
                l3 *= -1L;
            }
            double d3 = (double)l3 / 8.64E7;
            d2 = this.getFee() * d3;
        }
        if (bl) {
            d2 /= d;
        }
        return d2;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n      feeFrequency: " + this.getFeeFrequency());
        stringBuffer.append("\n      Jan: " + this.getJanuary());
        stringBuffer.append("\n      Feb: " + this.getFebruary());
        stringBuffer.append("\n      Mar: " + this.getMarch());
        stringBuffer.append("\n      Apr: " + this.getApril());
        stringBuffer.append("\n      May: " + this.getMay());
        stringBuffer.append("\n      Jun: " + this.getJune());
        stringBuffer.append("\n      Jul: " + this.getJuly());
        stringBuffer.append("\n      Aug: " + this.getAugust());
        stringBuffer.append("\n      Sep: " + this.getSeptember());
        stringBuffer.append("\n      Oct: " + this.getOctober());
        stringBuffer.append("\n      Nov: " + this.getNovember());
        stringBuffer.append("\n      Dec: " + this.getDecember());
        stringBuffer.append("\n      startYear: " + this.getStartYear());
        stringBuffer.append("\n      endYear: " + this.getEndYear());
        return stringBuffer.toString();
    }

    public double getProjectedCost(double d) {
        if (this.getFeeFrequency() == 0) {
            return this.getCalculatedCostForInterval();
        }
        return this.getCalculatedCostForInterval() * d;
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("fee")) {
                this.setFee(Double.valueOf(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else if (string.equals("feeFrequency")) {
                this.setFeeFrequency(Integer.parseInt(string2));
            } else if (string.equals("january")) {
                this.setJanuary(Boolean.valueOf(string2));
            } else if (string.equals("february")) {
                this.setFebruary(Boolean.valueOf(string2));
            } else if (string.equals("march")) {
                this.setMarch(Boolean.valueOf(string2));
            } else if (string.equals("april")) {
                this.setApril(Boolean.valueOf(string2));
            } else if (string.equals("may")) {
                this.setMay(Boolean.valueOf(string2));
            } else if (string.equals("june")) {
                this.setJune(Boolean.valueOf(string2));
            } else if (string.equals("july")) {
                this.setJuly(Boolean.valueOf(string2));
            } else if (string.equals("august")) {
                this.setAugust(Boolean.valueOf(string2));
            } else if (string.equals("september")) {
                this.setSeptember(Boolean.valueOf(string2));
            } else if (string.equals("october")) {
                this.setOctober(Boolean.valueOf(string2));
            } else if (string.equals("november")) {
                this.setNovember(Boolean.valueOf(string2));
            } else if (string.equals("december")) {
                this.setDecember(Boolean.valueOf(string2));
            } else if (string.equals("startYear")) {
                this.setStartYear(Integer.parseInt(string2));
            } else if (string.equals("endYear")) {
                this.setEndYear(Integer.parseInt(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = new XmlSupport[]{new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId()))), new XmlSimple("applicableData", String.valueOf(this.getApplicableData())), new XmlSimple("category", String.valueOf(this.getCategory())), new XmlSimple("fee", String.valueOf(this.getFee())), new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval())), new XmlSimple("feeFrequency", String.valueOf(this.getFeeFrequency())), new XmlSimple("january", String.valueOf(this.getJanuary())), new XmlSimple("february", String.valueOf(this.getFebruary())), new XmlSimple("march", String.valueOf(this.getMarch())), new XmlSimple("april", String.valueOf(this.getApril())), new XmlSimple("may", String.valueOf(this.getMay())), new XmlSimple("june", String.valueOf(this.getJune())), new XmlSimple("july", String.valueOf(this.getJuly())), new XmlSimple("august", String.valueOf(this.getAugust())), new XmlSimple("september", String.valueOf(this.getSeptember())), new XmlSimple("october", String.valueOf(this.getOctober())), new XmlSimple("november", String.valueOf(this.getNovember())), new XmlSimple("december", String.valueOf(this.getDecember())), new XmlSimple("startYear", String.valueOf(this.getStartYear())), new XmlSimple("endYear", String.valueOf(this.getEndYear()))};
        return xmlSupportArray;
    }

    public boolean supportsRateSchedule() {
        return false;
    }

    public RateSchedule getRateSchedule() {
        return null;
    }

    public void setRateSchedule(RateSchedule rateSchedule) {
    }

    public boolean supportsAdvancedProperties() {
        return false;
    }

    public JComponent buildComponentEditor(RateComponentDetailPanel rateComponentDetailPanel, Lexicon lexicon) {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("feeApplies")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.feeAppliesComboBox = new EasComboBox(new String[]{lexicon.getText("perBillingCycle"), lexicon.getText("perDay")});
        this.feeAppliesComboBox.addActionListener(new MyActionListener(rateComponentDetailPanel));
        jPanel.add((Component)this.feeAppliesComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("includedMonths")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.includedMonthsEditor = new CheckList(new String[]{lexicon.getText("january"), lexicon.getText("february"), lexicon.getText("march"), lexicon.getText("april"), lexicon.getText("may.short"), lexicon.getText("june"), lexicon.getText("july"), lexicon.getText("august"), lexicon.getText("september"), lexicon.getText("october"), lexicon.getText("november"), lexicon.getText("december")});
        this.includedMonthsEditor.addListSelectionListener(new MyListSelectionListener(rateComponentDetailPanel));
        jPanel.add((Component)this.includedMonthsEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("startYear")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.noStartYearCheckBox = new JCheckBox(lexicon.getText("noStartLimit"));
        this.noStartYearCheckBox.addActionListener(new MyCheckBoxListener(rateComponentDetailPanel, true));
        jPanel.add((Component)this.noStartYearCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        this.startYearEditor = new NumberTextField(10, true);
        this.startYearEditor.setAllowNegative(false);
        this.startYearEditor.setUseLabelAppearanceWhenDisabled(true);
        this.startYearEditor.setText(calendar.get(1));
        this.startYearEditor.getDocument().addDocumentListener(new MyDocumentListener(rateComponentDetailPanel, true));
        this.startYearEditor.addFocusListener(rateComponentDetailPanel);
        jPanel.add((Component)this.startYearEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("endYear")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.noEndYearCheckBox = new JCheckBox(lexicon.getText("noEndLimit"));
        this.noEndYearCheckBox.addActionListener(new MyCheckBoxListener(rateComponentDetailPanel, false));
        jPanel.add((Component)this.noEndYearCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.endYearEditor = new NumberTextField(10, true);
        this.endYearEditor.setAllowNegative(false);
        this.endYearEditor.setUseLabelAppearanceWhenDisabled(true);
        this.endYearEditor.setText(calendar.get(1));
        this.endYearEditor.getDocument().addDocumentListener(new MyDocumentListener(rateComponentDetailPanel, false));
        this.endYearEditor.addFocusListener(rateComponentDetailPanel);
        jPanel.add((Component)this.endYearEditor, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        return jPanel;
    }

    public void loadComponentEditor(CustomRateComponent customRateComponent) {
        this.feeAppliesComboBox.setSelectedIndex(((ScheduledFixedFee)customRateComponent).getFeeFrequency());
        int[] nArray = new int[12];
        int n = 0;
        block14: for (int i = 0; i < 12; ++i) {
            switch (i) {
                case 0: {
                    if (!((ScheduledFixedFee)customRateComponent).getJanuary()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 1: {
                    if (!((ScheduledFixedFee)customRateComponent).getFebruary()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 2: {
                    if (!((ScheduledFixedFee)customRateComponent).getMarch()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 3: {
                    if (!((ScheduledFixedFee)customRateComponent).getApril()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 4: {
                    if (!((ScheduledFixedFee)customRateComponent).getMay()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 5: {
                    if (!((ScheduledFixedFee)customRateComponent).getJune()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 6: {
                    if (!((ScheduledFixedFee)customRateComponent).getJuly()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 7: {
                    if (!((ScheduledFixedFee)customRateComponent).getAugust()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 8: {
                    if (!((ScheduledFixedFee)customRateComponent).getSeptember()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 9: {
                    if (!((ScheduledFixedFee)customRateComponent).getOctober()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 10: {
                    if (!((ScheduledFixedFee)customRateComponent).getNovember()) continue block14;
                    nArray[n] = i;
                    ++n;
                    continue block14;
                }
                case 11: {
                    if (!((ScheduledFixedFee)customRateComponent).getDecember()) continue block14;
                    nArray[n] = i;
                    ++n;
                }
            }
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        this.includedMonthsEditor.setSelectedIndices(nArray2);
        int n2 = ((ScheduledFixedFee)customRateComponent).getStartYear();
        int n3 = ((ScheduledFixedFee)customRateComponent).getEndYear();
        if (n2 >= 0) {
            this.noStartYearCheckBox.setSelected(false);
            this.startYearEditor.setVisible(true);
            this.startYearEditor.setText(n2);
        } else {
            this.noStartYearCheckBox.setSelected(true);
            this.startYearEditor.setVisible(false);
        }
        if (n3 >= 0) {
            this.noEndYearCheckBox.setSelected(false);
            this.endYearEditor.setVisible(true);
            this.endYearEditor.setText(n3);
        } else {
            this.noEndYearCheckBox.setSelected(true);
            this.endYearEditor.setVisible(false);
        }
    }

    public void buildReconciliationDetails(ReconciliationRow reconciliationRow, JPanel jPanel, GridBagConstraints gridBagConstraints, Lexicon lexicon) {
        int n = gridBagConstraints.gridy;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("feeApplies")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        String string = lexicon.getText("perBillingCycle");
        if (this.getFeeFrequency() == 1) {
            string = lexicon.getText("perDay");
        }
        jPanel.add((Component)new JLabel(string, 4), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("includedMonths")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        CheckList checkList = new CheckList(new String[]{lexicon.getText("january"), lexicon.getText("february"), lexicon.getText("march"), lexicon.getText("april"), lexicon.getText("may.short"), lexicon.getText("june"), lexicon.getText("july"), lexicon.getText("august"), lexicon.getText("september"), lexicon.getText("october"), lexicon.getText("november"), lexicon.getText("december")});
        checkList.setEnabled(false);
        int[] nArray = new int[12];
        int n2 = 0;
        block14: for (int i = 0; i < 12; ++i) {
            switch (i) {
                case 0: {
                    if (!this.getJanuary()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 1: {
                    if (!this.getFebruary()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 2: {
                    if (!this.getMarch()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 3: {
                    if (!this.getApril()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 4: {
                    if (!this.getMay()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 5: {
                    if (!this.getJune()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 6: {
                    if (!this.getJuly()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 7: {
                    if (!this.getAugust()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 8: {
                    if (!this.getSeptember()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 9: {
                    if (!this.getOctober()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 10: {
                    if (!this.getNovember()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                    continue block14;
                }
                case 11: {
                    if (!this.getDecember()) continue block14;
                    nArray[n2] = i;
                    ++n2;
                }
            }
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        checkList.setSelectedIndices(nArray2);
        jPanel.add((Component)checkList, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("startYear")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        String string2 = lexicon.getText("noStartLimit");
        if (this.getStartYear() >= 0) {
            string2 = String.valueOf(this.getStartYear());
        }
        jPanel.add((Component)new JLabel(string2, 4), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("endYear")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        String string3 = lexicon.getText("noEndLimit");
        if (this.getEndYear() >= 0) {
            string3 = String.valueOf(this.getEndYear());
        }
        jPanel.add((Component)new JLabel(string3, 4), gridBagConstraints);
    }

    private class MyCheckBoxListener
    implements ActionListener {
        private RateComponentDetailPanel parentPanel;
        private boolean isStart;

        public MyCheckBoxListener(RateComponentDetailPanel rateComponentDetailPanel, boolean bl) {
            this.parentPanel = rateComponentDetailPanel;
            this.isStart = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            ScheduledFixedFee scheduledFixedFee = (ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase();
            if (this.isStart) {
                if (ScheduledFixedFee.this.noStartYearCheckBox.isSelected()) {
                    scheduledFixedFee.setStartYear(-1);
                    ScheduledFixedFee.this.startYearEditor.setVisible(false);
                } else {
                    ScheduledFixedFee.this.startYearEditor.setVisible(true);
                    scheduledFixedFee.setStartYear(ScheduledFixedFee.this.startYearEditor.getIntValue());
                }
            } else if (ScheduledFixedFee.this.noEndYearCheckBox.isSelected()) {
                scheduledFixedFee.setEndYear(-1);
                ScheduledFixedFee.this.endYearEditor.setVisible(false);
            } else {
                ScheduledFixedFee.this.endYearEditor.setVisible(true);
                scheduledFixedFee.setEndYear(ScheduledFixedFee.this.endYearEditor.getIntValue());
            }
            this.parentPanel.revalidate();
            this.parentPanel.repaint();
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private RateComponentDetailPanel parentPanel;
        private boolean isStart;

        public MyDocumentListener(RateComponentDetailPanel rateComponentDetailPanel, boolean bl) {
            this.parentPanel = rateComponentDetailPanel;
            this.isStart = bl;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            try {
                ScheduledFixedFee scheduledFixedFee = (ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase();
                if (this.isStart) {
                    if (ScheduledFixedFee.this.noStartYearCheckBox.isSelected()) {
                        scheduledFixedFee.setStartYear(-1);
                    } else {
                        scheduledFixedFee.setStartYear(ScheduledFixedFee.this.startYearEditor.getIntValue());
                    }
                } else if (ScheduledFixedFee.this.noEndYearCheckBox.isSelected()) {
                    scheduledFixedFee.setEndYear(-1);
                } else {
                    scheduledFixedFee.setEndYear(ScheduledFixedFee.this.endYearEditor.getIntValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private RateComponentDetailPanel parentPanel;

        public MyListSelectionListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            int[] nArray = ScheduledFixedFee.this.includedMonthsEditor.getSelectedIndices();
            if (nArray != null) {
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setJanuary(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setFebruary(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setMarch(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setApril(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setMay(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setJune(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setJuly(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setAugust(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setSeptember(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setOctober(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setNovember(false);
                ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setDecember(false);
                block14: for (int i = 0; i < nArray.length; ++i) {
                    switch (nArray[i]) {
                        case 0: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setJanuary(true);
                            continue block14;
                        }
                        case 1: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setFebruary(true);
                            continue block14;
                        }
                        case 2: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setMarch(true);
                            continue block14;
                        }
                        case 3: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setApril(true);
                            continue block14;
                        }
                        case 4: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setMay(true);
                            continue block14;
                        }
                        case 5: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setJune(true);
                            continue block14;
                        }
                        case 6: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setJuly(true);
                            continue block14;
                        }
                        case 7: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setAugust(true);
                            continue block14;
                        }
                        case 8: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setSeptember(true);
                            continue block14;
                        }
                        case 9: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setOctober(true);
                            continue block14;
                        }
                        case 10: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setNovember(true);
                            continue block14;
                        }
                        case 11: {
                            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setDecember(true);
                        }
                    }
                }
            }
            this.parentPanel.handleRateComponentChange(false);
        }
    }

    private class MyActionListener
    implements ActionListener {
        private RateComponentDetailPanel parentPanel;

        public MyActionListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            ((ScheduledFixedFee)this.parentPanel.getSelectedRateComponentBase()).setFeeFrequency(ScheduledFixedFee.this.feeAppliesComboBox.getSelectedIndex());
            this.parentPanel.handleRateComponentChange(false);
        }
    }
}

