/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.cost.util.DoubleRecord;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.cost.util.Record;
import com.tridium.eas.cost.util.Result;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;

public class ScheduledFeePerUnit
extends FlatFeePerUnit {
    public static final int PRORATED_METHOD = 0;
    public static final int ABSOLUTE_METHOD = 1;
    private double newFee = 0.0;
    private long transitionTime = System.currentTimeMillis();
    private int transitionMethod = 0;
    private double preTransitionUnits = 0.0;
    private double postTransitionUnits = 0.0;
    public static String TYPE = "ScheduledFeePerUnit";

    public ScheduledFeePerUnit() {
        this.initTransitionTime();
    }

    public ScheduledFeePerUnit(String string) {
        super(string);
        this.initTransitionTime();
    }

    private void initTransitionTime() {
        Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
        calendar.setTime(new Date(EasLocalTime.getCurrentTime().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        this.setTransitionTime(l);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((ScheduledFeePerUnit)rateComponent).setNewFee(this.getNewFee());
        ((ScheduledFeePerUnit)rateComponent).setTransitionTime(this.getTransitionTime());
        ((ScheduledFeePerUnit)rateComponent).setTransitionMethod(this.getTransitionMethod());
        ((ScheduledFeePerUnit)rateComponent).setPreTransitionUnits(this.getPreTransitionUnits());
        ((ScheduledFeePerUnit)rateComponent).setPostTransitionUnits(this.getPostTransitionUnits());
        return super.copyParameters(rateComponent);
    }

    public Object newCopy() {
        return this.copyParameters(new ScheduledFeePerUnit());
    }

    public double getNewFee() {
        return this.newFee;
    }

    public void setNewFee(double d) {
        this.setComputeFromScratch(true);
        this.newFee = d;
    }

    public long getTransitionTime() {
        return this.transitionTime;
    }

    public void setTransitionTime(long l) {
        this.transitionTime = l;
    }

    public int getTransitionMethod() {
        return this.transitionMethod;
    }

    public void setTransitionMethod(int n) {
        this.transitionMethod = n;
        this.setComputeFromScratch(true);
    }

    public double getPreTransitionUnits() {
        return this.preTransitionUnits;
    }

    public void setPreTransitionUnits(double d) {
        this.preTransitionUnits = d;
    }

    public double getPostTransitionUnits() {
        return this.postTransitionUnits;
    }

    public void setPostTransitionUnits(double d) {
        this.postTransitionUnits = d;
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        long l3 = CostTimeUtil.convertTime(this.getTransitionTime(), CostTimeUtil.DEFAULT_TZ, this.getTimeZone());
        if (l3 >= l2) {
            double d2 = super.computeCostForRange(string, l, l2, rawCostData, rawCostData2, rawCostData3, bl, d, rawCostData4, rawCostData5, rawCostData6, rawCostData7, rawCostData8, rawCostData9);
            this.setPreTransitionUnits(this.getCalculatedUnits());
            this.setPostTransitionUnits(0.0);
            return d2;
        }
        try {
            RawCostData rawCostData10 = null;
            long l4 = 0L;
            switch (this.getApplicableData()) {
                case 0: {
                    rawCostData10 = rawCostData;
                    l4 = 450000L;
                    l += l4;
                    l2 += l4;
                    l3 += l4;
                    break;
                }
                case 1: {
                    rawCostData10 = rawCostData2;
                    break;
                }
                case 2: {
                    rawCostData10 = rawCostData4;
                    l4 = 450000L;
                    l += l4;
                    l2 += l4;
                    l3 += l4;
                    break;
                }
                case 4: {
                    rawCostData10 = rawCostData5;
                    l4 = 450000L;
                    l += l4;
                    l2 += l4;
                    l3 += l4;
                    break;
                }
                case 3: {
                    rawCostData10 = rawCostData6;
                    break;
                }
                case 5: {
                    rawCostData10 = rawCostData7;
                }
            }
            Result result = rawCostData10.get(l, l2);
            Record record = rawCostData10.createRecord();
            double d3 = 0.0;
            record = result.next(record);
            if (this.getTransitionMethod() == 1 && l3 > l) {
                double d4;
                double d5 = 0.0;
                double d6 = 0.0;
                while (record != null) {
                    long l5;
                    if (record instanceof DoubleRecord && this.isEffective((l5 = record.getTimestamp()) - l4, ((DoubleRecord)record).getDoubleValue(), bl, d, l, l2) && CostTimeUtil.includes(l5, l, l2) && this.getParentRate().includes(l5 - l4, this.getTimeZone()) && ScheduledFeePerUnit.validStatus(record.getStatus())) {
                        d4 = ((DoubleRecord)record).getDoubleValue();
                        d3 += d4;
                        if (l5 < l3) {
                            d5 += d4;
                        } else {
                            d6 += d4;
                        }
                    }
                    record = result.next(record);
                }
                this.setCalculatedUnits(d3);
                this.setPreTransitionUnits(d5);
                this.setPostTransitionUnits(d6);
                if (this.getDataRangeApproach() == 0) {
                    if (d3 < this.getMinDataValue()) {
                        return 0.0;
                    }
                    if (d3 > this.getMaxDataValue()) {
                        d3 = this.getMaxDataValue() - this.getMinDataValue();
                        if (d5 >= this.getMaxDataValue()) {
                            d5 = this.getMaxDataValue() - this.getMinDataValue();
                            d6 = 0.0;
                        } else if (d5 <= this.getMinDataValue()) {
                            d6 = this.getMaxDataValue() - this.getMinDataValue();
                            d5 = 0.0;
                        } else {
                            d6 = this.getMaxDataValue() - d5;
                            d5 -= this.getMinDataValue();
                        }
                    } else {
                        if (d5 >= this.getMaxDataValue()) {
                            d5 = this.getMaxDataValue() - this.getMinDataValue();
                            d6 = 0.0;
                        } else if (d5 <= this.getMinDataValue()) {
                            d6 = d3 - this.getMinDataValue();
                            d5 = 0.0;
                        } else {
                            d6 = d3 - d5;
                            d5 -= this.getMinDataValue();
                        }
                        d3 -= this.getMinDataValue();
                    }
                } else if (this.getDataRangeApproach() == 1 && (d3 < this.getMinDataValue() || d3 >= this.getMaxDataValue())) {
                    return 0.0;
                }
                double d7 = d5 / (double)this.getUnitsInFee();
                d4 = d6 / (double)this.getUnitsInFee();
                return this.getFee() * d7 + this.getNewFee() * d4;
            }
            double d8 = 0.0;
            double d9 = 1.0;
            double d10 = 0.0;
            double d11 = 0.0;
            if (l3 > l) {
                d8 = ((double)l3 - (double)l) / ((double)l2 - (double)l);
                d9 = ((double)l2 - (double)l3) / ((double)l2 - (double)l);
            }
            while (record != null) {
                long l6;
                if (record instanceof DoubleRecord && this.isEffective((l6 = record.getTimestamp()) - l4, ((DoubleRecord)record).getDoubleValue(), bl, d, l, l2) && CostTimeUtil.includes(l6, l, l2) && this.getParentRate().includes(l6 - l4, this.getTimeZone()) && ScheduledFeePerUnit.validStatus(record.getStatus())) {
                    double d12 = ((DoubleRecord)record).getDoubleValue();
                    d3 += d12;
                    if (l6 < l3) {
                        d10 += d12;
                    } else {
                        d11 += d12;
                    }
                }
                record = result.next(record);
            }
            this.setCalculatedUnits(d3);
            this.setPreTransitionUnits(d10);
            this.setPostTransitionUnits(d11);
            if (this.getDataRangeApproach() == 0) {
                if (d3 < this.getMinDataValue()) {
                    return 0.0;
                }
                d3 = d3 > this.getMaxDataValue() ? this.getMaxDataValue() - this.getMinDataValue() : (d3 -= this.getMinDataValue());
            } else if (this.getDataRangeApproach() == 1 && (d3 < this.getMinDataValue() || d3 >= this.getMaxDataValue())) {
                return 0.0;
            }
            double d13 = d3 / (double)this.getUnitsInFee();
            return this.getFee() * d13 * d8 + this.getNewFee() * d13 * d9;
        }
        catch (Exception exception) {
            System.out.println("Caught exception in ScheduledFeePerUnit.computeCostForRange(): ");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n      newFee: " + this.getNewFee());
        stringBuffer.append("\n      transitionTime: " + this.getTransitionTime());
        stringBuffer.append("\n      transitionMethod: " + this.getTransitionMethod());
        stringBuffer.append("\n      preTransitionUnits: " + this.getPreTransitionUnits());
        stringBuffer.append("\n      postTransitionUnits: " + this.getPostTransitionUnits());
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("fee")) {
                this.setFee(Double.valueOf(string2));
            } else if (string.equals("minDataValue")) {
                this.setMinDataValue(Double.valueOf(string2));
            } else if (string.equals("maxDataValue")) {
                this.setMaxDataValue(Double.valueOf(string2));
            } else if (string.equals("unitsInFee")) {
                this.setUnitsInFee(Integer.parseInt(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else if (string.equals("calculatedUnits")) {
                this.setCalculatedUnits(Double.valueOf(string2));
            } else if (string.equals("dataRangeApproach")) {
                this.setDataRangeApproach(Integer.parseInt(string2));
            } else if (string.equals("newFee")) {
                this.setNewFee(Double.valueOf(string2));
            } else if (string.equals("transitionTime")) {
                this.setTransitionTime(Long.parseLong(string2));
            } else if (string.equals("transitionMethod")) {
                this.setTransitionMethod(Integer.parseInt(string2));
            } else if (string.equals("preTransitionUnits")) {
                this.setPreTransitionUnits(Double.valueOf(string2));
            } else if (string.equals("postTransitionUnits")) {
                this.setPostTransitionUnits(Double.valueOf(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n = 15;
        if (this.getRateSchedule() != null) {
            ++n;
        }
        XmlSupport[] xmlSupportArray = new XmlSupport[n];
        xmlSupportArray[0] = new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId())));
        xmlSupportArray[1] = new XmlSimple("applicableData", String.valueOf(this.getApplicableData()));
        xmlSupportArray[2] = new XmlSimple("category", String.valueOf(this.getCategory()));
        xmlSupportArray[3] = new XmlSimple("fee", String.valueOf(this.getFee()));
        xmlSupportArray[4] = new XmlSimple("minDataValue", String.valueOf(this.getMinDataValue()));
        xmlSupportArray[5] = new XmlSimple("maxDataValue", String.valueOf(this.getMaxDataValue()));
        xmlSupportArray[6] = new XmlSimple("unitsInFee", String.valueOf(this.getUnitsInFee()));
        xmlSupportArray[7] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        xmlSupportArray[8] = new XmlSimple("calculatedUnits", String.valueOf(this.getCalculatedUnits()));
        xmlSupportArray[9] = new XmlSimple("dataRangeApproach", String.valueOf(this.getDataRangeApproach()));
        xmlSupportArray[10] = new XmlSimple("newFee", String.valueOf(this.getNewFee()));
        xmlSupportArray[11] = new XmlSimple("transitionTime", String.valueOf(this.getTransitionTime()));
        xmlSupportArray[12] = new XmlSimple("transitionMethod", String.valueOf(this.getTransitionMethod()));
        xmlSupportArray[13] = new XmlSimple("preTransitionUnits", String.valueOf(this.getPreTransitionUnits()));
        xmlSupportArray[14] = new XmlSimple("postTransitionUnits", String.valueOf(this.getPostTransitionUnits()));
        if (this.getRateSchedule() != null) {
            xmlSupportArray[15] = this.getRateSchedule();
        }
        return xmlSupportArray;
    }
}

