/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.util.CopySupport;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import javax.baja.timezone.BTimeZone;

public abstract class RateComponent
implements CopySupport,
XmlSupport {
    public static final String STALE = "stale";
    public static final String CALCULATING = "calculating";
    public static final String CURRENT = "current";
    public static final int CONSUMPTION = 0;
    public static final int DEMAND = 1;
    public static final int REACTIVE_ENERGY = 2;
    public static final int REACTIVE_POWER = 3;
    public static final int APPARENT_ENERGY = 4;
    public static final int APPARENT_POWER = 5;
    public static final int OTHER_COMPONENT = 2;
    public static final int USER_DEFINED_1 = 3;
    public static final int USER_DEFINED_2 = 4;
    public static final int USER_DEFINED_3 = 5;
    public static final int USER_DEFINED_4 = 6;
    private String name = "-";
    private int applicableData = 0;
    private int category = 2;
    private Rate parentRate = null;
    private BTimeZone timeZone = CostTimeUtil.DEFAULT_TZ;
    private String costStatus = "stale";
    private double calculatedCostForInterval = 0.0;
    private boolean computeFromScratch = true;
    private Object synchronizer = new Object();

    public RateComponent() {
    }

    public RateComponent(String string) {
        this.setName(string);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        rateComponent.setName(new String(this.getName()));
        rateComponent.setApplicableData(this.getApplicableData());
        rateComponent.setCategory(this.getCategory());
        rateComponent.setParentRate(this.getParentRate());
        rateComponent.setTimeZone(this.getTimeZone());
        rateComponent.setCostStatus(this.getCostStatus());
        rateComponent.setCalculatedCostForInterval(this.getCalculatedCostForInterval());
        return rateComponent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.equals("") ? "-" : string;
    }

    public int getApplicableData() {
        return this.applicableData;
    }

    public void setApplicableData(int n) {
        this.applicableData = n;
        this.setComputeFromScratch(true);
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int n) {
        this.category = n;
    }

    public Rate getParentRate() {
        return this.parentRate;
    }

    public void setParentRate(Rate rate) {
        this.parentRate = rate;
        this.setComputeFromScratch(true);
    }

    public BTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(BTimeZone bTimeZone) {
        this.timeZone = bTimeZone;
        this.setComputeFromScratch(true);
    }

    public String getCostStatus() {
        return this.costStatus;
    }

    public void setCostStatus(String string) {
        this.costStatus = string;
    }

    public double getCalculatedCostForInterval() {
        return this.calculatedCostForInterval;
    }

    public void setCalculatedCostForInterval(double d) {
        this.calculatedCostForInterval = d;
    }

    public double computeCostForInterval(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        double d2 = this.computeCostForRange(string, l, l2, rawCostData, rawCostData2, rawCostData3, bl, d, rawCostData4, rawCostData5, rawCostData6, rawCostData7, rawCostData8, rawCostData9);
        this.setCalculatedCostForInterval(d2);
        return d2;
    }

    protected abstract double computeCostForRange(String var1, long var2, long var4, RawCostData var6, RawCostData var7, RawCostData var8, boolean var9, double var10, RawCostData var12, RawCostData var13, RawCostData var14, RawCostData var15, RawCostData var16, RawCostData var17);

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n      type: " + this.getType());
        stringBuffer.append("\n      name: " + this.getName());
        String string = "unknown";
        if (this.getApplicableData() == 0) {
            string = "consumption";
        } else if (this.getApplicableData() == 1) {
            string = "demand";
        } else if (this.getApplicableData() == 2) {
            string = "reactive energy";
        } else if (this.getApplicableData() == 4) {
            string = "apparent energy";
        } else if (this.getApplicableData() == 3) {
            string = "reactive power";
        } else if (this.getApplicableData() == 5) {
            string = "apparent power";
        }
        stringBuffer.append("\n      applicableData: " + string);
        if (this.getCategory() == 0) {
            string = "consumption";
        } else if (this.getCategory() == 1) {
            string = "demand";
        } else if (this.getCategory() == 2) {
            string = "other";
        } else if (this.getCategory() == 3) {
            string = "user_defined_1";
        } else if (this.getCategory() == 4) {
            string = "user_defined_2";
        } else if (this.getCategory() == 5) {
            string = "user_defined_3";
        } else if (this.getCategory() == 6) {
            string = "user_defined_4";
        }
        stringBuffer.append("\n      category: " + string);
        stringBuffer.append("\n      timeZone: " + this.getTimeZone().getId());
        stringBuffer.append("\n      costStatus: " + this.getCostStatus());
        stringBuffer.append("\n      calculatedCostForInterval: " + this.getCalculatedCostForInterval());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getComputeFromScratch() {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.computeFromScratch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComputeFromScratch(boolean bl) {
        Object object = this.synchronizer;
        synchronized (object) {
            this.computeFromScratch = bl;
            if (this.computeFromScratch) {
                this.setCostStatus(STALE);
            } else {
                this.setCostStatus(CURRENT);
            }
        }
    }

    public double getProjectedCost(double d) {
        return this.getCalculatedCostForInterval() * d;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            }
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = new XmlSupport[]{new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId()))), new XmlSimple("applicableData", String.valueOf(this.getApplicableData())), new XmlSimple("category", String.valueOf(this.getCategory())), new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()))};
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

