/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.cost.datatypes.RateSchedule;
import com.tridium.eas.cost.rate.components.FixedFee;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.cost.util.DoubleRecord;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.cost.util.Record;
import com.tridium.eas.cost.util.Result;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import javax.baja.timezone.BTimeZone;

public class FlatFeePerUnit
extends FixedFee {
    public static final int CUMULATIVE_RANGE_APPROACH = 0;
    public static final int OVERALL_RANGE_APPROACH = 1;
    public static final int INDIVIDUAL_RANGE_APPROACH = 2;
    private double calculatedUnits = 0.0;
    private double minDataValue = 0.0;
    private double maxDataValue = Double.MAX_VALUE;
    private int unitsInFee = 1;
    private RateSchedule rateSchedule = null;
    private int dataRangeApproach = 0;
    public static String TYPE = "FlatFeePerUnit";
    private static final int BAD_STATUS = 23;

    public FlatFeePerUnit() {
        this.setCategory(0);
    }

    public FlatFeePerUnit(String string) {
        super(string);
        this.setCategory(0);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((FlatFeePerUnit)rateComponent).setCalculatedUnits(this.getCalculatedUnits());
        ((FlatFeePerUnit)rateComponent).setMinDataValue(this.getMinDataValue());
        ((FlatFeePerUnit)rateComponent).setMaxDataValue(this.getMaxDataValue());
        ((FlatFeePerUnit)rateComponent).setUnitsInFee(this.getUnitsInFee());
        ((FlatFeePerUnit)rateComponent).setDataRangeApproach(this.getDataRangeApproach());
        RateSchedule rateSchedule = null;
        if (this.getRateSchedule() != null) {
            rateSchedule = (RateSchedule)this.getRateSchedule().newCopy();
        }
        ((FlatFeePerUnit)rateComponent).setRateSchedule(rateSchedule);
        return super.copyParameters(rateComponent);
    }

    public Object newCopy() {
        return this.copyParameters(new FlatFeePerUnit());
    }

    public double getCalculatedUnits() {
        return this.calculatedUnits;
    }

    public void setCalculatedUnits(double d) {
        this.calculatedUnits = d;
    }

    public double getMinDataValue() {
        return this.minDataValue;
    }

    public void setMinDataValue(double d) {
        this.minDataValue = d;
        this.setComputeFromScratch(true);
    }

    public double getMaxDataValue() {
        return this.maxDataValue;
    }

    public void setMaxDataValue(double d) {
        this.maxDataValue = d;
        this.setComputeFromScratch(true);
    }

    public int getUnitsInFee() {
        return this.unitsInFee;
    }

    public void setUnitsInFee(int n) {
        this.unitsInFee = n;
        this.setComputeFromScratch(true);
    }

    public RateSchedule getRateSchedule() {
        return this.rateSchedule;
    }

    public void setRateSchedule(RateSchedule rateSchedule) {
        this.rateSchedule = rateSchedule;
        this.setComputeFromScratch(true);
    }

    public int getDataRangeApproach() {
        return this.dataRangeApproach;
    }

    public void setDataRangeApproach(int n) {
        this.dataRangeApproach = n;
        this.setComputeFromScratch(true);
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        try {
            RawCostData rawCostData10 = null;
            long l3 = 0L;
            switch (this.getApplicableData()) {
                case 0: {
                    rawCostData10 = rawCostData;
                    l3 = 450000L;
                    l += l3;
                    l2 += l3;
                    break;
                }
                case 1: {
                    rawCostData10 = rawCostData2;
                    break;
                }
                case 2: {
                    rawCostData10 = rawCostData4;
                    l3 = 450000L;
                    l += l3;
                    l2 += l3;
                    break;
                }
                case 4: {
                    rawCostData10 = rawCostData5;
                    l3 = 450000L;
                    l += l3;
                    l2 += l3;
                    break;
                }
                case 3: {
                    rawCostData10 = rawCostData6;
                    break;
                }
                case 5: {
                    rawCostData10 = rawCostData7;
                }
            }
            Result result = rawCostData10.get(l, l2);
            Record record = rawCostData10.createRecord();
            double d2 = 0.0;
            record = result.next(record);
            while (record != null) {
                long l4;
                if (record instanceof DoubleRecord && this.isEffective((l4 = record.getTimestamp()) - l3, ((DoubleRecord)record).getDoubleValue(), bl, d, l, l2) && CostTimeUtil.includes(l4, l, l2) && this.getParentRate().includes(l4 - l3, this.getTimeZone()) && FlatFeePerUnit.validStatus(record.getStatus())) {
                    d2 += ((DoubleRecord)record).getDoubleValue();
                }
                record = result.next(record);
            }
            this.setCalculatedUnits(d2);
            if (this.getDataRangeApproach() == 0) {
                if (d2 < this.getMinDataValue()) {
                    return 0.0;
                }
                d2 = d2 > this.getMaxDataValue() ? this.getMaxDataValue() - this.getMinDataValue() : (d2 -= this.getMinDataValue());
            } else if (this.getDataRangeApproach() == 1 && (d2 < this.getMinDataValue() || d2 >= this.getMaxDataValue())) {
                return 0.0;
            }
            double d3 = d2 / (double)this.getUnitsInFee();
            return this.getFee() * d3;
        }
        catch (Exception exception) {
            System.out.println("Caught exception in FlatFeePerUnit.computeCostForRange(): ");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n      calculatedUnits: " + this.getCalculatedUnits());
        stringBuffer.append("\n      minDataValue: " + this.getMinDataValue());
        stringBuffer.append("\n      maxDataValue: " + this.getMaxDataValue());
        stringBuffer.append("\n      dataRangeApproach: " + this.getDataRangeApproach());
        stringBuffer.append("\n      unitsInFee: " + this.getUnitsInFee());
        if (this.getRateSchedule() != null) {
            stringBuffer.append("\n        rateSchedule: " + this.getRateSchedule().toDebugString());
        }
        return stringBuffer.toString();
    }

    public boolean isEffective(long l, double d, boolean bl, double d2, long l2, long l3) {
        double d3 = d;
        if (bl) {
            d3 *= d2;
        }
        if (this.getDataRangeApproach() == 2 && (d3 < this.getMinDataValue() || d3 >= this.getMaxDataValue())) {
            return false;
        }
        if (this.getRateSchedule() == null) {
            return true;
        }
        return this.getRateSchedule().isScheduleEffective(l, this.getTimeZone(), l2, l3);
    }

    public double getProjectedCost(double d) {
        return this.getCalculatedCostForInterval() * d;
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("fee")) {
                this.setFee(Double.valueOf(string2));
            } else if (string.equals("minDataValue")) {
                this.setMinDataValue(Double.valueOf(string2));
            } else if (string.equals("maxDataValue")) {
                this.setMaxDataValue(Double.valueOf(string2));
            } else if (string.equals("unitsInFee")) {
                this.setUnitsInFee(Integer.parseInt(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else if (string.equals("calculatedUnits")) {
                this.setCalculatedUnits(Double.valueOf(string2));
            } else if (string.equals("dataRangeApproach")) {
                this.setDataRangeApproach(Integer.parseInt(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else if (xmlSupport instanceof RateSchedule) {
            this.setRateSchedule((RateSchedule)xmlSupport);
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n = 10;
        if (this.getRateSchedule() != null) {
            ++n;
        }
        XmlSupport[] xmlSupportArray = new XmlSupport[n];
        xmlSupportArray[0] = new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId())));
        xmlSupportArray[1] = new XmlSimple("applicableData", String.valueOf(this.getApplicableData()));
        xmlSupportArray[2] = new XmlSimple("category", String.valueOf(this.getCategory()));
        xmlSupportArray[3] = new XmlSimple("fee", String.valueOf(this.getFee()));
        xmlSupportArray[4] = new XmlSimple("minDataValue", String.valueOf(this.getMinDataValue()));
        xmlSupportArray[5] = new XmlSimple("maxDataValue", String.valueOf(this.getMaxDataValue()));
        xmlSupportArray[6] = new XmlSimple("unitsInFee", String.valueOf(this.getUnitsInFee()));
        xmlSupportArray[7] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        xmlSupportArray[8] = new XmlSimple("calculatedUnits", String.valueOf(this.getCalculatedUnits()));
        xmlSupportArray[9] = new XmlSimple("dataRangeApproach", String.valueOf(this.getDataRangeApproach()));
        if (this.getRateSchedule() != null) {
            xmlSupportArray[10] = this.getRateSchedule();
        }
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }

    protected static boolean validStatus(int n) {
        return (n & 0x17) == 0;
    }
}

