/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.components.ChoiceComponentChild;
import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import javax.baja.timezone.BTimeZone;

public class ChoiceComponent
extends RateComponent {
    public static final int CHOICE_HIGHEST = 0;
    public static final int CHOICE_LOWEST = 1;
    public static final int CHOICE_SUMMATION = 2;
    public static final int CHOICE_DIFFERENCE = 3;
    public static final int COMPARE_COSTS = 0;
    public static final int COMPARE_UNITS = 1;
    private int choice = 0;
    private int comparison = 0;
    private ChoiceComponentChild nestedChoice = null;
    private ChoiceComponentChild[] rateComponents = null;
    public static String TYPE = "ChoiceComponent";

    public ChoiceComponent() {
        this.setCategory(2);
    }

    public ChoiceComponent(String string) {
        super(string);
        this.setCategory(2);
    }

    public void setParentRate(Rate rate) {
        super.setParentRate(rate);
        if (this.rateComponents == null) {
            return;
        }
        for (int i = 0; i < this.rateComponents.length; ++i) {
            this.rateComponents[i].setParentRate(rate);
        }
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((ChoiceComponent)rateComponent).setChoice(this.getChoice());
        ((ChoiceComponent)rateComponent).setComparison(this.getComparison());
        RateComponent rateComponent2 = super.copyParameters(rateComponent);
        ChoiceComponentChild[] choiceComponentChildArray = null;
        if (this.rateComponents != null) {
            choiceComponentChildArray = new ChoiceComponentChild[this.rateComponents.length];
            for (int i = 0; i < this.rateComponents.length; ++i) {
                choiceComponentChildArray[i] = (ChoiceComponentChild)this.rateComponents[i].newCopy();
            }
        }
        ((ChoiceComponent)rateComponent2).setRateComponents(choiceComponentChildArray);
        return rateComponent2;
    }

    public Object newCopy() {
        return this.copyParameters(new ChoiceComponent());
    }

    public int getChoice() {
        return this.choice;
    }

    public void setChoice(int n) {
        this.setComputeFromScratch(true);
        this.choice = n;
    }

    public int getComparison() {
        return this.comparison;
    }

    public void setComparison(int n) {
        this.setComputeFromScratch(true);
        this.comparison = n;
    }

    public ChoiceComponentChild getNestedChoice() {
        return this.nestedChoice;
    }

    public void setNestedChoice(ChoiceComponentChild choiceComponentChild) {
        this.nestedChoice = choiceComponentChild;
    }

    public ChoiceComponentChild[] getRateComponents() {
        return this.rateComponents;
    }

    public void setRateComponents(ChoiceComponentChild[] choiceComponentChildArray) {
        this.setComputeFromScratch(true);
        this.rateComponents = choiceComponentChildArray;
        if (this.rateComponents == null) {
            return;
        }
        for (int i = 0; i < this.rateComponents.length; ++i) {
            this.rateComponents[i].setParentRate(this.getParentRate());
            this.rateComponents[i].setParentRateComponent(this);
            RateComponent rateComponent = this.rateComponents[i].getRateComponent();
            if (rateComponent == null || !(rateComponent instanceof ChoiceComponent)) continue;
            ((ChoiceComponent)rateComponent).setNestedChoice(this.rateComponents[i]);
        }
    }

    public ChoiceComponentChild addRateComponent(RateComponent rateComponent) {
        this.setComputeFromScratch(true);
        rateComponent.setParentRate(this.getParentRate());
        ChoiceComponentChild choiceComponentChild = null;
        choiceComponentChild = !(rateComponent instanceof ChoiceComponentChild) ? new ChoiceComponentChild(rateComponent) : (ChoiceComponentChild)rateComponent;
        choiceComponentChild.setParentRate(this.getParentRate());
        choiceComponentChild.setParentRateComponent(this);
        RateComponent rateComponent2 = choiceComponentChild.getRateComponent();
        if (rateComponent2 != null && rateComponent2 instanceof ChoiceComponent) {
            ((ChoiceComponent)rateComponent2).setNestedChoice(choiceComponentChild);
        }
        if (this.rateComponents == null) {
            this.rateComponents = new ChoiceComponentChild[1];
            this.rateComponents[0] = choiceComponentChild;
            return choiceComponentChild;
        }
        ChoiceComponentChild[] choiceComponentChildArray = new ChoiceComponentChild[this.rateComponents.length + 1];
        for (int i = 0; i < this.rateComponents.length; ++i) {
            choiceComponentChildArray[i] = this.rateComponents[i];
        }
        choiceComponentChildArray[this.rateComponents.length] = choiceComponentChild;
        this.rateComponents = choiceComponentChildArray;
        return choiceComponentChild;
    }

    public void removeRateComponent(RateComponent rateComponent) {
        if (this.rateComponents != null && this.rateComponents.length > 0) {
            int n = -1;
            for (int i = 0; i < this.rateComponents.length; ++i) {
                if (this.rateComponents[i].equals(rateComponent)) {
                    n = i;
                    this.rateComponents[i].setParentRate(null);
                    this.rateComponents[i].setParentRateComponent(null);
                    break;
                }
                if (!(this.rateComponents[i].getRateComponent() instanceof ChoiceComponent)) continue;
                ((ChoiceComponent)this.rateComponents[i].getRateComponent()).removeRateComponent(rateComponent);
            }
            if (n >= 0) {
                ChoiceComponentChild[] choiceComponentChildArray = new ChoiceComponentChild[this.rateComponents.length - 1];
                int n2 = 0;
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (i == n) continue;
                    choiceComponentChildArray[n2] = this.rateComponents[i];
                    ++n2;
                }
                this.rateComponents = choiceComponentChildArray;
            }
        }
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        this.setCostStatus("calculating");
        double d2 = 0.0;
        ChoiceComponentChild[] choiceComponentChildArray = this.getRateComponents();
        if (choiceComponentChildArray == null || choiceComponentChildArray.length <= 0) {
            return d2;
        }
        double d3 = 0.0;
        boolean bl2 = false;
        for (int i = 0; i < choiceComponentChildArray.length; ++i) {
            double d4 = choiceComponentChildArray[i].computeCostForRange(string, l, l2, rawCostData, rawCostData2, rawCostData3, bl, d, rawCostData4, rawCostData5, rawCostData6, rawCostData7, rawCostData8, rawCostData9);
            choiceComponentChildArray[i].setCalculatedCostForInterval(d4 *= choiceComponentChildArray[i].getPercentage() / 100.0);
            double d5 = 0.0;
            if (this.getChoice() == 2) {
                d2 += d4;
                continue;
            }
            if (this.getChoice() == 3) {
                if (!bl2) {
                    d2 = d4;
                    bl2 = true;
                    continue;
                }
                d2 -= d4;
            } else if (this.getComparison() == 1) {
                if (!(choiceComponentChildArray[i].getRateComponent() instanceof FlatFeePerUnit)) continue;
                d5 = ((FlatFeePerUnit)choiceComponentChildArray[i].getRateComponent()).getCalculatedUnits();
                d5 *= choiceComponentChildArray[i].getPercentage() / 100.0;
                if (!bl2) {
                    d3 = d5;
                    d2 = d4;
                    bl2 = true;
                    continue;
                }
            } else {
                d5 = d4;
                if (!bl2) {
                    d3 = d5;
                    d2 = d4;
                    bl2 = true;
                    continue;
                }
            }
            if (this.getChoice() == 1) {
                if (!(d5 < d3)) continue;
                d3 = d5;
                d2 = d4;
                continue;
            }
            if (this.getChoice() != 0 || !(d5 > d2)) continue;
            d3 = d5;
            d2 = d4;
        }
        return d2;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        String string = "unknown";
        switch (this.getChoice()) {
            case 0: {
                string = "highest";
                break;
            }
            case 1: {
                string = "lowest";
                break;
            }
            case 2: {
                string = "summation";
                break;
            }
            case 3: {
                string = "difference";
            }
        }
        stringBuffer.append("\n     choice: " + string);
        String string2 = "unknown";
        switch (this.getComparison()) {
            case 0: {
                string2 = "compare costs";
                break;
            }
            case 1: {
                string2 = "compare units";
            }
        }
        stringBuffer.append("\n     comparison: " + string2);
        ChoiceComponentChild[] choiceComponentChildArray = this.getRateComponents();
        if (choiceComponentChildArray != null) {
            for (int i = 0; i < choiceComponentChildArray.length; ++i) {
                stringBuffer.append("\n      component[" + i + "]:" + ((RateComponent)choiceComponentChildArray[i]).toDebugString());
            }
        }
        return stringBuffer.toString();
    }

    public double getProjectedCost(double d) {
        double d2 = 0.0;
        ChoiceComponentChild[] choiceComponentChildArray = this.getRateComponents();
        if (choiceComponentChildArray == null || choiceComponentChildArray.length <= 0) {
            return d2;
        }
        double d3 = 0.0;
        boolean bl = false;
        for (int i = 0; i < choiceComponentChildArray.length; ++i) {
            double d4 = choiceComponentChildArray[i].getProjectedCost(d);
            d4 *= choiceComponentChildArray[i].getPercentage() / 100.0;
            double d5 = 0.0;
            if (this.getChoice() == 2) {
                d2 += d4;
                continue;
            }
            if (this.getChoice() == 3) {
                if (!bl) {
                    d2 = d4;
                    bl = true;
                    continue;
                }
                d2 -= d4;
            } else if (this.getComparison() == 1) {
                if (!(choiceComponentChildArray[i].getRateComponent() instanceof FlatFeePerUnit)) continue;
                d5 = ((FlatFeePerUnit)choiceComponentChildArray[i].getRateComponent()).getCalculatedUnits();
                d5 *= choiceComponentChildArray[i].getPercentage() / 100.0;
                if (!bl) {
                    d3 = d5;
                    d2 = d4;
                    bl = true;
                    continue;
                }
            } else {
                d5 = d4;
                if (!bl) {
                    d3 = d5;
                    d2 = d4;
                    bl = true;
                    continue;
                }
            }
            if (this.getChoice() == 1) {
                if (!(d5 < d3)) continue;
                d3 = d5;
                d2 = d4;
                continue;
            }
            if (this.getChoice() != 0 || !(d5 > d2)) continue;
            d3 = d5;
            d2 = d4;
        }
        return d2;
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("choice")) {
                this.setChoice(Integer.parseInt(string2));
            } else if (string.equals("comparison")) {
                this.setComparison(Integer.parseInt(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else if (xmlSupport instanceof RateComponent) {
            this.addRateComponent((RateComponent)xmlSupport);
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = this.getRateComponents();
        int n = 6;
        if (xmlSupportArray != null) {
            n = xmlSupportArray.length + 6;
        }
        XmlSupport[] xmlSupportArray2 = new XmlSupport[n];
        xmlSupportArray2[0] = new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId())));
        xmlSupportArray2[1] = new XmlSimple("applicableData", String.valueOf(this.getApplicableData()));
        xmlSupportArray2[2] = new XmlSimple("category", String.valueOf(this.getCategory()));
        xmlSupportArray2[3] = new XmlSimple("choice", String.valueOf(this.getChoice()));
        xmlSupportArray2[4] = new XmlSimple("comparison", String.valueOf(this.getComparison()));
        xmlSupportArray2[5] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        if (xmlSupportArray != null) {
            for (int i = 0; i < xmlSupportArray.length; ++i) {
                xmlSupportArray2[i + 6] = xmlSupportArray[i];
            }
        }
        return xmlSupportArray2;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

