/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.cost.datatypes.TimePeriods;
import com.tridium.eas.cost.util.CopySupport;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class RateLink
implements CopySupport,
XmlSupport {
    private String name = "-";
    private long startTime = System.currentTimeMillis();
    private long endTime = -1L;
    private long billingCycleStart = System.currentTimeMillis();
    private TimePeriods billingCycle = new TimePeriods(1, 5);
    private String account = "";
    private String custServRep = "";
    private String custServRepPhone = "";
    private String custServRepEmail = "";
    private String salesRep = "";
    private String salesRepPhone = "";
    private String salesRepEmail = "";
    public static String TYPE = "RateLink";

    public RateLink() {
        Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
        calendar.setTime(new Date(EasLocalTime.getCurrentTime().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(1, calendar.get(1) - 1);
        long l = calendar.getTime().getTime();
        this.setStartTime(l);
        this.setBillingCycleStart(l);
    }

    public RateLink(String string) {
        this();
        this.setName(string);
    }

    private RateLink copyParameters(RateLink rateLink) {
        rateLink.setName(new String(this.getName()));
        rateLink.setStartTime(this.getStartTime());
        rateLink.setEndTime(this.getEndTime());
        rateLink.setBillingCycleStart(this.getBillingCycleStart());
        rateLink.setBillingCycle((TimePeriods)this.getBillingCycle().newCopy());
        rateLink.setAccount(new String(this.getAccount()));
        rateLink.setCustServRep(new String(this.getCustServRep()));
        rateLink.setCustServRepPhone(new String(this.getCustServRepPhone()));
        rateLink.setCustServRepEmail(new String(this.getCustServRepEmail()));
        rateLink.setSalesRep(new String(this.getSalesRep()));
        rateLink.setSalesRepPhone(new String(this.getSalesRepPhone()));
        rateLink.setSalesRepEmail(new String(this.getSalesRepEmail()));
        return rateLink;
    }

    public Object newCopy() {
        return this.copyParameters(new RateLink());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.equals("") ? "-" : string;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public long getBillingCycleStart() {
        return this.billingCycleStart;
    }

    public void setBillingCycleStart(long l) {
        this.billingCycleStart = l;
    }

    public TimePeriods getBillingCycle() {
        return this.billingCycle;
    }

    public void setBillingCycle(TimePeriods timePeriods) {
        this.billingCycle = timePeriods;
        if (this.billingCycle.getTimeUnits() == 0) {
            this.billingCycle.setTimeUnits(5);
        }
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String string) {
        this.account = string;
    }

    public String getCustServRep() {
        return this.custServRep;
    }

    public void setCustServRep(String string) {
        this.custServRep = string;
    }

    public String getCustServRepPhone() {
        return this.custServRepPhone;
    }

    public void setCustServRepPhone(String string) {
        this.custServRepPhone = string;
    }

    public String getCustServRepEmail() {
        return this.custServRepEmail;
    }

    public void setCustServRepEmail(String string) {
        this.custServRepEmail = string;
    }

    public String getSalesRep() {
        return this.salesRep;
    }

    public void setSalesRep(String string) {
        this.salesRep = string;
    }

    public String getSalesRepPhone() {
        return this.salesRepPhone;
    }

    public void setSalesRepPhone(String string) {
        this.salesRepPhone = string;
    }

    public String getSalesRepEmail() {
        return this.salesRepEmail;
    }

    public void setSalesRepEmail(String string) {
        this.salesRepEmail = string;
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n  name: " + this.getName());
        stringBuffer.append("\n  startTime: " + this.getStartTime());
        stringBuffer.append("\n  endTime: " + this.getEndTime());
        stringBuffer.append("\n  billingCycleStart: " + this.getBillingCycleStart());
        stringBuffer.append("\n  billingCycle: " + this.getBillingCycle());
        stringBuffer.append("\n  account: " + this.getAccount());
        stringBuffer.append("\n  custServRep: " + this.getCustServRep());
        stringBuffer.append("\n  custServRepPhone: " + this.getCustServRepPhone());
        stringBuffer.append("\n  custServRepEmail: " + this.getCustServRepEmail());
        stringBuffer.append("\n  salesRep: " + this.getSalesRep());
        stringBuffer.append("\n  salesRepPhone: " + this.getSalesRepPhone());
        stringBuffer.append("\n  salesRepEmail: " + this.getSalesRepEmail());
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("startTime")) {
                this.setStartTime(Long.parseLong(string2));
            } else if (string.equals("endTime")) {
                this.setEndTime(Long.parseLong(string2));
            } else if (string.equals("billingCycleStart")) {
                this.setBillingCycleStart(Long.parseLong(string2));
            } else if (string.equals("account")) {
                this.setAccount(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("custServRep")) {
                this.setCustServRep(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("custServRepPhone")) {
                this.setCustServRepPhone(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("custServRepEmail")) {
                this.setCustServRepEmail(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("salesRep")) {
                this.setSalesRep(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("salesRepPhone")) {
                this.setSalesRepPhone(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("salesRepEmail")) {
                this.setSalesRepEmail(XmlEncoder.decodeXmlString(string2));
            }
        } else if (xmlSupport instanceof TimePeriods) {
            this.setBillingCycle((TimePeriods)xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = new XmlSupport[]{new XmlSimple("startTime", String.valueOf(this.getStartTime())), new XmlSimple("endTime", String.valueOf(this.getEndTime())), new XmlSimple("billingCycleStart", String.valueOf(this.getBillingCycleStart())), new XmlSimple("account", XmlEncoder.encodeXmlString(this.getAccount())), new XmlSimple("custServRep", XmlEncoder.encodeXmlString(this.getCustServRep())), new XmlSimple("custServRepPhone", XmlEncoder.encodeXmlString(this.getCustServRepPhone())), new XmlSimple("custServRepEmail", XmlEncoder.encodeXmlString(this.getCustServRepEmail())), new XmlSimple("salesRep", XmlEncoder.encodeXmlString(this.getSalesRep())), new XmlSimple("salesRepPhone", XmlEncoder.encodeXmlString(this.getSalesRepPhone())), new XmlSimple("salesRepEmail", XmlEncoder.encodeXmlString(this.getSalesRepEmail())), this.getBillingCycle()};
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
        if (string == null) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            this.setStartTime(Long.parseLong(stringTokenizer.nextToken()));
            this.setEndTime(Long.parseLong(stringTokenizer.nextToken()));
            this.setBillingCycleStart(Long.parseLong(stringTokenizer.nextToken()));
            this.setAccount(XmlEncoder.decodeXmlString(stringTokenizer.nextToken()));
            this.setCustServRep(XmlEncoder.decodeXmlString(stringTokenizer.nextToken()));
            this.setCustServRepPhone(XmlEncoder.decodeXmlString(stringTokenizer.nextToken()));
            this.setCustServRepEmail(XmlEncoder.decodeXmlString(stringTokenizer.nextToken()));
            this.setSalesRep(XmlEncoder.decodeXmlString(stringTokenizer.nextToken()));
            this.setSalesRepPhone(XmlEncoder.decodeXmlString(stringTokenizer.nextToken()));
            this.setSalesRepEmail(XmlEncoder.decodeXmlString(stringTokenizer.nextToken()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

