/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.datatypes;

import com.tridium.eas.cost.datatypes.RateSchedule;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.util.StringTokenizer;
import javax.baja.timezone.BTimeZone;

public class TimeRangeRateSchedule
extends RateSchedule {
    private long startTime = System.currentTimeMillis();
    private long endTime = System.currentTimeMillis();
    public static String TYPE = "TimeRangeRateSchedule";

    public TimeRangeRateSchedule() {
    }

    public TimeRangeRateSchedule(String string) {
        super(string);
    }

    public TimeRangeRateSchedule(long l, long l2) {
        this.setStartTime(l);
        this.setEndTime(l2);
    }

    protected RateSchedule copyParameters(RateSchedule rateSchedule) {
        ((TimeRangeRateSchedule)rateSchedule).setStartTime(this.getStartTime());
        ((TimeRangeRateSchedule)rateSchedule).setEndTime(this.getEndTime());
        return super.copyParameters(rateSchedule);
    }

    public Object newCopy() {
        return this.copyParameters(new TimeRangeRateSchedule());
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public String toString() {
        return "Time Range: " + this.getStartTime() + " - " + this.getEndTime();
    }

    protected boolean isEffective(long l, BTimeZone bTimeZone, long l2, long l3) {
        long l4 = CostTimeUtil.convertTime(this.getStartTime(), CostTimeUtil.DEFAULT_TZ, bTimeZone);
        long l5 = CostTimeUtil.convertTime(this.getEndTime(), CostTimeUtil.DEFAULT_TZ, bTimeZone);
        return l4 <= l && l5 > l;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n          startTime: " + this.getStartTime());
        stringBuffer.append("\n          endTime: " + this.getEndTime());
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("exclusive")) {
                this.setExclusive(Boolean.valueOf(string2));
            } else if (string.equals("startTime")) {
                this.setStartTime(Long.parseLong(string2));
            } else if (string.equals("endTime")) {
                this.setEndTime(Long.parseLong(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = new XmlSupport[]{new XmlSimple("exclusive", String.valueOf(this.getExclusive())), new XmlSimple("startTime", String.valueOf(this.getStartTime())), new XmlSimple("endTime", String.valueOf(this.getEndTime()))};
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
        if (string == null) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            this.setExclusive(Boolean.valueOf(stringTokenizer.nextToken()));
            this.setStartTime(Long.parseLong(stringTokenizer.nextToken()));
            this.setEndTime(Long.parseLong(stringTokenizer.nextToken()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

