/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.datatypes;

import com.tridium.eas.cost.datatypes.RateSchedule;
import com.tridium.eas.cost.datatypes.TimePeriods;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import javax.baja.timezone.BTimeZone;

public class BillPeriodLengthRateSchedule
extends RateSchedule {
    private TimePeriods minLength = new TimePeriods(30, 3);
    private TimePeriods maxLength = new TimePeriods(30, 3);
    private boolean noUpperLimit = true;
    public static String TYPE = "BillPeriodLengthRateSchedule";

    public BillPeriodLengthRateSchedule() {
    }

    public BillPeriodLengthRateSchedule(String string) {
        super(string);
    }

    protected RateSchedule copyParameters(RateSchedule rateSchedule) {
        ((BillPeriodLengthRateSchedule)rateSchedule).setMinLength((TimePeriods)this.getMinLength().newCopy());
        ((BillPeriodLengthRateSchedule)rateSchedule).setMaxLength((TimePeriods)this.getMaxLength().newCopy());
        ((BillPeriodLengthRateSchedule)rateSchedule).setNoUpperLimit(this.getNoUpperLimit());
        return super.copyParameters(rateSchedule);
    }

    public Object newCopy() {
        return this.copyParameters(new BillPeriodLengthRateSchedule());
    }

    public TimePeriods getMinLength() {
        return this.minLength;
    }

    public long getMinLengthMillis() {
        switch (this.minLength.getTimeUnits()) {
            case 1: {
                return (long)this.minLength.getNumber() * 60000L;
            }
            case 2: {
                return (long)this.minLength.getNumber() * 3600000L;
            }
            case 3: {
                return (long)this.minLength.getNumber() * 86400000L;
            }
            case 4: {
                return (long)this.minLength.getNumber() * 86400000L * 7L;
            }
        }
        return -1L;
    }

    public void setMinLength(TimePeriods timePeriods) {
        this.minLength = timePeriods;
        if (this.minLength.getTimeUnits() == 0 || this.minLength.getTimeUnits() == 5 || this.minLength.getTimeUnits() == 6) {
            this.minLength.setTimeUnits(3);
        }
    }

    public TimePeriods getMaxLength() {
        return this.maxLength;
    }

    public long getMaxLengthMillis() {
        switch (this.maxLength.getTimeUnits()) {
            case 1: {
                return (long)this.maxLength.getNumber() * 60000L;
            }
            case 2: {
                return (long)this.maxLength.getNumber() * 3600000L;
            }
            case 3: {
                return (long)this.maxLength.getNumber() * 86400000L;
            }
            case 4: {
                return (long)this.maxLength.getNumber() * 86400000L * 7L;
            }
        }
        return 0L;
    }

    public void setMaxLength(TimePeriods timePeriods) {
        this.maxLength = timePeriods;
        if (this.maxLength.getTimeUnits() == 0 || this.maxLength.getTimeUnits() == 5 || this.maxLength.getTimeUnits() == 6) {
            this.maxLength.setTimeUnits(3);
        }
    }

    public boolean getNoUpperLimit() {
        return this.noUpperLimit;
    }

    public void setNoUpperLimit(boolean bl) {
        this.noUpperLimit = bl;
    }

    public String toString() {
        return "Bill Period Length: " + this.getMinLength() + " - " + (this.getNoUpperLimit() ? "No Upper Limit" : this.getMaxLength().toString());
    }

    protected boolean isEffective(long l, BTimeZone bTimeZone, long l2, long l3) {
        long l4 = l3 - l2;
        long l5 = this.getMinLengthMillis();
        if (this.getNoUpperLimit()) {
            return l4 >= l5;
        }
        long l6 = this.getMaxLengthMillis();
        if (l5 == l6) {
            return l4 == l5;
        }
        return l4 >= l5 && l4 < l6;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n          minLength: " + this.getMinLength());
        stringBuffer.append("\n          noUpperLimit: " + this.getNoUpperLimit());
        stringBuffer.append("\n          maxLength: " + this.getMaxLength());
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("noUpperLimit")) {
                this.setNoUpperLimit(Boolean.valueOf(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else if (xmlSupport instanceof TimePeriods) {
            String string = ((TimePeriods)xmlSupport).getName();
            if (string.equals("minLength")) {
                this.setMinLength((TimePeriods)xmlSupport);
            } else if (string.equals("maxLength")) {
                this.setMaxLength((TimePeriods)xmlSupport);
            } else {
                super.addChildObject(xmlSupport);
            }
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = new XmlSupport[3];
        this.minLength.setName("minLength");
        this.maxLength.setName("maxLength");
        xmlSupportArray[0] = this.minLength;
        xmlSupportArray[1] = new XmlSimple("noUpperLimit", String.valueOf(this.getNoUpperLimit()));
        xmlSupportArray[2] = this.maxLength;
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

