/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataSummaryElement;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.TSDataRegular;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.function.Population;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;

public class TSDataSummary
extends TSDataRegular {
    private DataSummaryElement[] summaries;
    private BUnit valueUnit;

    public TSDataSummary(RegularTimeParameters regularTimeParameters, BUnit bUnit, DataSummaryElement[] dataSummaryElementArray) {
        super(regularTimeParameters);
        this.summaries = dataSummaryElementArray == null ? new DataSummaryElement[]{} : dataSummaryElementArray;
        this.valueUnit = bUnit;
    }

    public TSDataSummary(EasLocalTime easLocalTime, BTimeZone bTimeZone, TimeInterval timeInterval, BUnit bUnit, DataSummaryElement[] dataSummaryElementArray) {
        super(new RegularTimeParameters(easLocalTime, timeInterval, dataSummaryElementArray == null ? 0 : dataSummaryElementArray.length, bTimeZone));
        this.summaries = dataSummaryElementArray == null ? new DataSummaryElement[]{} : dataSummaryElementArray;
        this.valueUnit = bUnit;
    }

    public DataSummaryElement getDataSummary(int n) {
        return this.summaries[n];
    }

    public int getSize() {
        return this.summaries == null ? 0 : this.summaries.length;
    }

    public int getType() {
        return 6;
    }

    public boolean isValid(int n) {
        return this.summaries[n].isValid();
    }

    public DataSummaryElement rollup() {
        DataSummaryElement dataSummaryElement = this.getSize() > 0 ? new DataSummaryElement(this.getDataSummary(0)) : new DataSummaryElement();
        for (int i = 1; i < this.getSize(); ++i) {
            dataSummaryElement.add(this.getDataSummary(i));
        }
        return dataSummaryElement;
    }

    public TSDataSummary applyCycle(int n) {
        int n2;
        int n3 = Math.min(n, this.getSize());
        DataSummaryElement[] dataSummaryElementArray = new DataSummaryElement[n3];
        for (n2 = 0; n2 < this.getSize(); ++n2) {
            if (dataSummaryElementArray[n2 % n] == null) {
                dataSummaryElementArray[n2 % n] = new DataSummaryElement(this.getDataSummary(n2));
                continue;
            }
            dataSummaryElementArray[n2 % n].add(this.getDataSummary(n2));
        }
        n2 = this.getSize() / n;
        if (n2 == 0) {
            n2 = 1;
        }
        for (int i = 0; i < n3; ++i) {
            dataSummaryElementArray[i].setNumberOfCycles(n2);
        }
        return new TSDataSummary(this.getStart(), this.getTimeZone(), this.getTimeParameters().getInterval(), this.getValueUnit(), dataSummaryElementArray);
    }

    public void dump() {
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            System.out.println(i + ": " + this.getDataSummary(i).getTotalConsumption());
        }
    }

    protected void convertUnit(int n, BUnit bUnit) {
        this.summaries[n].convertUnit(this.getValueUnit(), bUnit);
    }

    public Population getMeanPopulation() {
        return new Population(){

            public BUnit getUnit() {
                return TSDataSummary.this.getValueUnit();
            }

            public int getSize() {
                return TSDataSummary.this.getSize();
            }

            public double getSample(int n) {
                return TSDataSummary.this.summaries[n].getAvgDemand();
            }

            public boolean isValid(int n) {
                return TSDataSummary.this.isValid(n);
            }
        };
    }

    public Population getDemandPopulation() {
        return new Population(){

            public BUnit getUnit() {
                return TSDataSummary.this.getValueUnit();
            }

            public int getSize() {
                return TSDataSummary.this.getSize();
            }

            public double getSample(int n) {
                return TSDataSummary.this.summaries[n].getPeakDemand();
            }

            public boolean isValid(int n) {
                return TSDataSummary.this.isValid(n);
            }
        };
    }

    public Population getConsumptionPopulation() {
        return new Population(){

            public BUnit getUnit() {
                return TSDataSummary.this.getValueUnit();
            }

            public int getSize() {
                return TSDataSummary.this.getSize();
            }

            public double getSample(int n) {
                return TSDataSummary.this.summaries[n].getTotalConsumption();
            }

            public boolean isValid(int n) {
                return TSDataSummary.this.isValid(n);
            }
        };
    }

    public BUnit getValueUnit() {
        return this.valueUnit;
    }

    public DataSummaryElement[] getSummaries() {
        return this.summaries;
    }
}

