/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DayOfWeek;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.TSData;
import com.tridium.eas.api.TSDataFloat;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;

public abstract class TSDataRegular
implements TSData {
    private RegularTimeParameters timeParameters;
    private boolean[] dow_incl;
    private boolean[] time_of_day_incl;
    private int day_length;

    public TSDataRegular(RegularTimeParameters regularTimeParameters) {
        this.timeParameters = regularTimeParameters;
    }

    public TSDataFloat rollup(TimeInterval timeInterval, int n, int n2) {
        return null;
    }

    public TSDataSummary rollup(TimeInterval timeInterval, int n) {
        return null;
    }

    public void setDaysOfWeek(int n) {
        this.dow_incl = new boolean[7];
        this.day_length = (int)((long)TimeInterval.MILLIS_IN_DAY / this.timeParameters.getInterval().getMilliseconds());
        if (n == -1) {
            int n2 = 0;
            while (n2 < 7) {
                this.dow_incl[n2++] = true;
            }
        } else {
            Calendar calendar = Calendar.getInstance((TimeZone)this.timeParameters.getDefaultTimeZone().tzSupport());
            calendar.setTime(new Date(this.getDefaultTime(0)));
            DayOfWeek dayOfWeek = new DayOfWeek(n);
            for (int i = 0; i < 7; ++i) {
                this.dow_incl[i] = dayOfWeek.included(calendar);
                calendar.add(14, TimeInterval.MILLIS_IN_DAY);
            }
        }
    }

    public boolean isDayIncluded(int n) {
        return this.dow_incl == null || this.day_length == 0 ? true : this.dow_incl[n / this.day_length % 7];
    }

    public void setTimeOfDay(int n, int n2, int n3, int n4, boolean bl) {
        long l = this.timeParameters.getInterval().getMilliseconds();
        this.day_length = (int)((long)TimeInterval.MILLIS_IN_DAY / l);
        this.time_of_day_incl = new boolean[this.day_length];
        Calendar calendar = Calendar.getInstance((TimeZone)this.timeParameters.getDefaultTimeZone().tzSupport());
        calendar.setTime(new Date(this.getDefaultTime(0)));
        for (int i = 0; i < this.day_length; ++i) {
            int n5 = calendar.get(11);
            int n6 = calendar.get(12);
            if (n5 < n || n5 > n3) {
                this.time_of_day_incl[i] = bl;
            } else if (n5 > n && n5 < n3) {
                this.time_of_day_incl[i] = !bl;
            } else if (n5 == n && n5 == n3) {
                this.time_of_day_incl[i] = n6 < n2 || n6 > n4 ? bl : !bl;
            } else if (n5 == n) {
                this.time_of_day_incl[i] = n6 >= n2 ? !bl : bl;
            } else if (n5 == n3) {
                this.time_of_day_incl[i] = n6 <= n4 ? !bl : bl;
            } else {
                this.time_of_day_incl[i] = true;
                System.out.println("Shouldn't ever get here in TSDataRegular!");
            }
            calendar.add(14, (int)l);
        }
    }

    public boolean isTimeOfDayIncluded(int n) {
        return this.time_of_day_incl == null || this.day_length == 0 ? true : this.time_of_day_incl[n % this.day_length];
    }

    public int getIndexByOffset(long l) {
        return this.timeParameters.getIndexByOffset(l);
    }

    public long getOffsetMillis(int n) {
        return this.timeParameters.getOffsetMillis(n);
    }

    public BTimeZone getTimeZone() {
        return this.timeParameters.getDefaultTimeZone();
    }

    public long getDefaultTime(int n) {
        return this.timeParameters.getDefaultTime(n);
    }

    public long getZonelessTime(int n) {
        return this.timeParameters.getZonelessTime(n);
    }

    public long getLocalTime(int n) {
        return this.timeParameters.getLocalTime(n);
    }

    public int getIndex(EasLocalTime easLocalTime) {
        return this.timeParameters.getIndex(easLocalTime);
    }

    public RegularTimeParameters getTimeParameters() {
        return this.timeParameters;
    }

    public EasLocalTime getStart() {
        return this.timeParameters.getStartTime();
    }
}

