/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataSample;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.TSDataIrregular;
import javax.baja.timezone.BTimeZone;

public class TSDataIrregularRepeating
extends TSDataIrregular {
    private int size = 0;
    private RegularTimeParameters timeParams = null;
    private EasLocalTime baselineStart = null;
    private EasLocalTime baselineEnd = null;
    private long adjustedDefaultStart;

    public TSDataIrregularRepeating(DataSample[] dataSampleArray, BTimeZone bTimeZone, int n, RegularTimeParameters regularTimeParameters, EasLocalTime easLocalTime, EasLocalTime easLocalTime2) {
        super(dataSampleArray, bTimeZone);
        if (this.getData() != null && this.getData().length > 0) {
            this.adjustedDefaultStart = regularTimeParameters.getStartTime().getTimestamp(bTimeZone) + (dataSampleArray[0].getTime() - easLocalTime.getTimestamp(bTimeZone));
            this.setEasStartTime(new EasLocalTime(this.adjustedDefaultStart, bTimeZone));
            this.setZonelessStart(this.getStart().getTimestamp(GMT));
            this.setLocalStart(this.getStart().getTimestamp(BTimeZone.getLocal()));
        }
        this.size = n;
        this.timeParams = regularTimeParameters;
        this.baselineStart = easLocalTime;
        this.baselineEnd = easLocalTime2;
    }

    public int getSize() {
        if (this.getDataSize() == 0) {
            return 0;
        }
        return this.size;
    }

    public int getDataSize() {
        return this.getData() == null ? 0 : this.getData().length;
    }

    public double getDouble(int n) {
        return this.getData()[n % this.getDataSize()].getDouble();
    }

    public boolean getBool(int n) {
        return this.getData()[n % this.getDataSize()].getBool();
    }

    public int getStatus(int n) {
        return this.getData()[n % this.getDataSize()].getStatus();
    }

    private long getDefaultStart(int n) {
        int n2 = n / this.getDataSize();
        long l = this.timeParams.getStartTime().getTimestamp(this.getTimeZone()) + (long)n2 * (this.baselineEnd.getTimestamp(this.getTimeZone()) - this.baselineStart.getTimestamp(this.getTimeZone()));
        return l + (this.getDefaultStart() - this.baselineStart.getTimestamp(this.getTimeZone()));
    }

    private long getDataTime(int n) {
        long l = this.getData()[n % this.getDataSize()].getTime() - this.getDefaultStart();
        return this.getDefaultStart(n) + l;
    }

    public long getOffsetMillis(int n) {
        return this.getDataTime(n) - this.adjustedDefaultStart;
    }

    public long getDefaultTime(int n) {
        return this.getDataTime(n);
    }

    public boolean isValid(int n) {
        return this.getData()[n % this.getDataSize()].isValid();
    }

    public int getIndex(EasLocalTime easLocalTime) {
        return this.getIndexByOffset(easLocalTime.getTimestamp(this.getTimeZone()) - this.adjustedDefaultStart);
    }
}

