/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataSummaryElement;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.TSDataRegular;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.function.BooleanPopulation;
import com.tridium.eas.function.CompactBooleanPopulation;
import com.tridium.eas.function.MutablePopulation;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.SimpleBooleanPopulation;
import com.tridium.eas.function.SimpleFloatPopulation;
import com.tridium.eas.util.BoolArray;
import java.util.Calendar;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;

public class TSDataFloat
extends TSDataRegular {
    private Population dataPopulation;
    private BooleanPopulation statusPopulation = null;

    public TSDataFloat(EasLocalTime easLocalTime, BTimeZone bTimeZone, TimeInterval timeInterval, BUnit bUnit, double[] dArray, BoolArray boolArray) {
        this(new RegularTimeParameters(easLocalTime, timeInterval, dArray.length, bTimeZone), bUnit, dArray, boolArray);
    }

    public TSDataFloat(EasLocalTime easLocalTime, BTimeZone bTimeZone, TimeInterval timeInterval, Population population) {
        super(new RegularTimeParameters(easLocalTime, timeInterval, population.getSize(), bTimeZone));
        this.dataPopulation = population;
    }

    public TSDataFloat(EasLocalTime easLocalTime, BTimeZone bTimeZone, TimeInterval timeInterval, Population population, BooleanPopulation booleanPopulation) {
        this(new RegularTimeParameters(easLocalTime, timeInterval, population.getSize(), bTimeZone), population, booleanPopulation);
    }

    public TSDataFloat(RegularTimeParameters regularTimeParameters, BUnit bUnit, double[] dArray, BoolArray boolArray) {
        super(regularTimeParameters);
        this.dataPopulation = new SimpleFloatPopulation(bUnit, dArray);
        this.statusPopulation = boolArray == null ? null : new CompactBooleanPopulation(boolArray);
    }

    public TSDataFloat(EasLocalTime easLocalTime, BTimeZone bTimeZone, TimeInterval timeInterval, BUnit bUnit, double[] dArray) {
        super(new RegularTimeParameters(easLocalTime, timeInterval, dArray.length, bTimeZone));
        this.dataPopulation = new SimpleFloatPopulation(bUnit, dArray);
    }

    public TSDataFloat(RegularTimeParameters regularTimeParameters, Population population) {
        super(regularTimeParameters);
        this.dataPopulation = population instanceof MutablePopulation ? new SimpleFloatPopulation(population) : population;
        this.statusPopulation = null;
    }

    public TSDataFloat(RegularTimeParameters regularTimeParameters, Population population, BooleanPopulation booleanPopulation) {
        super(regularTimeParameters);
        this.dataPopulation = population instanceof MutablePopulation ? new SimpleFloatPopulation(population) : population;
        this.statusPopulation = booleanPopulation instanceof MutablePopulation ? new CompactBooleanPopulation(booleanPopulation) : booleanPopulation;
    }

    public boolean getBool(int n) {
        return false;
    }

    public double getDouble(int n) {
        return this.dataPopulation.getSample(n);
    }

    public int getSize() {
        return this.dataPopulation.getSize();
    }

    public int getInt(int n) {
        return (int)this.dataPopulation.getSample(n);
    }

    public int getType() {
        return 2;
    }

    public String getString(int n) {
        return null;
    }

    public boolean isValid(int n) {
        return this.statusPopulation == null ? this.dataPopulation.isValid(n) : this.statusPopulation.getBoolean(n);
    }

    public BUnit getValueUnit() {
        return this.getPopulation().getUnit();
    }

    public Population getPopulation() {
        return new Population(){

            public double getSample(int n) {
                return TSDataFloat.this.dataPopulation.getSample(n);
            }

            public boolean isValid(int n) {
                return TSDataFloat.this.statusPopulation == null ? true : TSDataFloat.this.statusPopulation.getBoolean(n);
            }

            public BUnit getUnit() {
                return TSDataFloat.this.dataPopulation.getUnit();
            }

            public int getSize() {
                return TSDataFloat.this.dataPopulation.getSize();
            }
        };
    }

    public Population getDataPopulation() {
        if (this.dataPopulation instanceof SimpleFloatPopulation) {
            return this.dataPopulation;
        }
        return new Population(){

            public double getSample(int n) {
                return TSDataFloat.this.dataPopulation.getSample(n);
            }

            public boolean isValid(int n) {
                return true;
            }

            public BUnit getUnit() {
                return TSDataFloat.this.dataPopulation.getUnit();
            }

            public int getSize() {
                return TSDataFloat.this.dataPopulation.getSize();
            }
        };
    }

    public BooleanPopulation getStatusPopulation() {
        if (this.statusPopulation == null) {
            this.statusPopulation = new SimpleBooleanPopulation(this.dataPopulation, true);
        }
        return this.statusPopulation;
    }

    public TSDataSummary rollup(TimeInterval timeInterval, int n, int n2, int n3, int n4, int n5, boolean bl) {
        DataSummaryElement[] dataSummaryElementArray;
        Calendar calendar = null;
        this.setDaysOfWeek(n);
        this.setTimeOfDay(n2, n3, n4, n5, bl);
        long l = this.getTimeParameters().getInterval().getMilliseconds();
        int n6 = 0;
        int n7 = 0;
        if (timeInterval.getUnit() == 7) {
            dataSummaryElementArray = new RegularTimeParameters(this.getStart(), timeInterval, 0, this.getTimeZone());
            n6 = dataSummaryElementArray.getIndex(new EasLocalTime(this.getDefaultTime(this.getSize() - 1), this.getTimeZone())) + 1;
            calendar = this.getStart().getCalendar(this.getTimeZone());
        } else {
            long l2 = timeInterval.getMilliseconds();
            n7 = (int)(l2 / this.getTimeParameters().getInterval().getMilliseconds());
            n6 = (this.getSize() - 1) / n7 + 1;
        }
        dataSummaryElementArray = new DataSummaryElement[n6];
        int n8 = 0;
        int n9 = 0;
        long l3 = this.getDefaultTime(0);
        for (int i = 0; i < n6; ++i) {
            dataSummaryElementArray[i] = new DataSummaryElement();
            n9 += n7;
            if (timeInterval.getUnit() == 7) {
                calendar.add(2, 1);
                n9 = this.getIndex(new EasLocalTime(calendar.get(1), calendar.get(2), 1));
            }
            if (n9 > this.getSize()) {
                n9 = this.getSize();
            }
            try {
                while (n8 < n9) {
                    dataSummaryElementArray[i].add(this.getDouble(n8), l3, this.isDayIncluded(n8) && this.isTimeOfDayIncluded(n8) && this.isValid(n8));
                    ++n8;
                    l3 += l;
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return new TSDataSummary(this.getStart(), this.getTimeZone(), timeInterval, this.getValueUnit(), dataSummaryElementArray);
    }

    public TSDataFloat rollup(TimeInterval timeInterval, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Calendar calendar = null;
        this.setDaysOfWeek(n);
        this.setTimeOfDay(n3, n4, n5, n6, bl);
        int n7 = 0;
        int n8 = 0;
        RegularTimeParameters regularTimeParameters = new RegularTimeParameters(this.getStart(), timeInterval, 0, this.getTimeZone());
        if (timeInterval.getUnit() == 7) {
            n7 = regularTimeParameters.getIndex(new EasLocalTime(this.getDefaultTime(this.getSize() - 1), this.getTimeZone())) + 1;
            calendar = this.getStart().getCalendar(this.getTimeZone());
        } else {
            long l = timeInterval.getMilliseconds();
            n8 = (int)(l / this.getTimeParameters().getInterval().getMilliseconds());
            n7 = (this.getSize() - 1) / n8 + 1;
        }
        double[] dArray = new double[n7];
        BoolArray boolArray = new BoolArray(n7);
        boolArray.setAll(false);
        int n9 = 0;
        int n10 = 0;
        int n11 = -1;
        for (int i = 0; i < n7; ++i) {
            n10 += n8;
            if (timeInterval.getUnit() == 7) {
                calendar.add(2, 1);
                n10 = this.getIndex(new EasLocalTime(calendar.get(1), calendar.get(2), 1));
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            int n12 = 0;
            switch (n2) {
                case 2: {
                    d = -1.7976931348623157E308;
                    break;
                }
                case 3: {
                    d = Double.MAX_VALUE;
                }
            }
            if (n10 > this.getSize()) {
                n10 = this.getSize();
            }
            try {
                while (n9 < n10) {
                    double d5 = this.getDouble(n9);
                    if (this.isDayIncluded(n9) && this.isTimeOfDayIncluded(n9) && this.isValid(n9)) {
                        ++n12;
                        switch (n2) {
                            case 1: {
                                d += d5;
                                break;
                            }
                            case 5: {
                                d2 += d5 * d5;
                            }
                            case 4: 
                            case 8: {
                                d += d5;
                            }
                            case 7: {
                                break;
                            }
                            case 2: {
                                if (!(d5 > d)) break;
                                d = d5;
                                break;
                            }
                            case 3: {
                                if (!(d5 < d)) break;
                                d = d5;
                                break;
                            }
                            case 0: {
                                if (d5 > d4) {
                                    d4 = d5;
                                }
                                if (!(d5 < d3)) break;
                                d3 = d5;
                            }
                        }
                    }
                    ++n9;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (n12 > 0) {
                boolArray.sett(i);
                switch (n2) {
                    case 2: 
                    case 3: {
                        dArray[i] = d;
                        break;
                    }
                    case 1: {
                        dArray[i] = d * (double)n8 / (double)n12;
                        break;
                    }
                    case 4: 
                    case 8: {
                        dArray[i] = d / (double)n12;
                        break;
                    }
                    case 7: {
                        dArray[i] = n12;
                        break;
                    }
                    case 5: {
                        dArray[i] = n12 > 1 ? Math.sqrt((d2 - d * d / (double)n12) / (double)(n12 - 1)) : 0.0;
                        break;
                    }
                    case 0: {
                        if (d4 == -1.7976931348623157E308) {
                            d4 = d3;
                        } else if (d3 == Double.MAX_VALUE) {
                            d3 = d4;
                        }
                        dArray[i] = (d4 + d3) / 2.0;
                    }
                }
                if (n11 < 0) continue;
                for (int j = 0; j <= n11; ++j) {
                    dArray[j] = dArray[i];
                }
                n11 = -1;
                continue;
            }
            if (i > 0) {
                dArray[i] = dArray[i - 1];
                continue;
            }
            n11 = i;
        }
        TSDataFloat tSDataFloat = new TSDataFloat(this.getStart(), this.getTimeZone(), timeInterval, this.getValueUnit(), dArray, boolArray);
        return tSDataFloat;
    }
}

