/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasProtected;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Manager;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.PStatus;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Site
extends Group
implements EasProtected {
    private Hashtable meters = new Hashtable();
    private boolean metersLoaded = false;
    private int metersCount = 0;
    private Hashtable ownedDataPoints = new Hashtable();
    private boolean ownedDataPointsLoaded = false;
    private int ownedDataPointCount = 0;
    private PStatus status = new PStatus();

    public int getProtectedType() {
        return 0;
    }

    public String getProtectedIdentifier() {
        return String.valueOf(this.getId());
    }

    public Group[] getGroups() {
        return Site.getGroups('P', this.session);
    }

    public static Group[] getGroups(EasSession easSession) {
        return Site.getGroups('P', easSession);
    }

    public static Group createSite(String string, EasSession easSession) throws EasException {
        return Site.create(string, "", 'P', easSession);
    }

    public static Group createSite(String string, String string2, EasSession easSession) throws EasException {
        return Site.create(string, string2, 'P', easSession);
    }

    public static Site getSite(int n, EasSession easSession) throws EasException {
        if (easSession == null) {
            easSession = Manager.get();
        }
        return (Site)easSession.get(new Site(n, easSession));
    }

    public int getType() {
        return 80;
    }

    public void remove() throws EasException {
        PStatus pStatus;
        this.loadMeters(false);
        Enumeration enumeration = this.meters.elements();
        while (enumeration.hasMoreElements()) {
            pStatus = (MeterStatus)enumeration.nextElement();
            pStatus.meter.remove();
            this.remMeter(pStatus.meter);
        }
        enumeration = this.ownedDataPoints.elements();
        while (enumeration.hasMoreElements()) {
            pStatus = (DpStatus)enumeration.nextElement();
            ((DpStatus)pStatus).dp.erase();
            this.remOwnedDataPoint(((DpStatus)pStatus).dp);
        }
        super.remove();
    }

    public void save() throws EasException {
        super.save();
        this.do_save(-1, true);
    }

    public void loadMeters(boolean bl) throws EasException {
        if (!bl && this.metersLoaded) {
            return;
        }
        if (this.isInitialized()) {
            Vector vector = this.session.getMeterExec().getSiteMeters(this);
            this.metersCount = vector.size();
            this.meters.clear();
            for (int i = 0; i < this.metersCount; ++i) {
                Meter meter = (Meter)vector.elementAt(i);
                meter.load(bl);
                this.meters.put(meter, new MeterStatus(meter));
            }
        } else {
            throw new EasException("can't load uninitialized site");
        }
        this.metersLoaded = true;
    }

    public void addMeter(Meter meter) throws EasException {
        Site site = meter.getSite();
        if (site != null && site.getId() != this.getId()) {
            site.remMeter(meter);
        }
        this.loadMeters(false);
        boolean bl = false;
        MeterStatus meterStatus = (MeterStatus)this.meters.get(meter);
        if (meterStatus == null) {
            meterStatus = new MeterStatus(meter);
            meterStatus.setInserted(true);
            this.meters.put(meter, meterStatus);
            ++this.metersCount;
            bl = true;
        } else if (meterStatus.isRemoved()) {
            meterStatus.setRemoved(false);
            ++this.metersCount;
            bl = true;
        }
        if (bl) {
            meter.setSite(this);
        }
    }

    public void remMeter(Meter meter) throws EasException {
        this.loadMeters(false);
        boolean bl = false;
        MeterStatus meterStatus = (MeterStatus)this.meters.get(meter);
        if (meterStatus != null) {
            if (meterStatus.isInserted()) {
                this.meters.remove(meter);
                --this.metersCount;
                bl = true;
            } else if (!meterStatus.isRemoved()) {
                meterStatus.setRemoved(true);
                --this.metersCount;
                bl = true;
            }
        }
        if (bl) {
            meter.setSite(null);
        }
    }

    public Meter[] getMeters() throws EasException {
        this.loadMeters(false);
        Meter[] meterArray = new Meter[this.metersCount];
        int n = 0;
        Enumeration enumeration = this.meters.elements();
        while (enumeration.hasMoreElements()) {
            MeterStatus meterStatus = (MeterStatus)enumeration.nextElement();
            if (meterStatus.isRemoved()) continue;
            meterArray[n++] = meterStatus.meter;
        }
        return meterArray;
    }

    public int getMetersCount() throws EasException {
        this.loadMeters(false);
        return this.metersCount;
    }

    public void save(int n, boolean bl) throws EasException {
        super.save(n |= 1, bl);
        this.do_save(n, bl);
    }

    private void do_save(int n, boolean bl) throws EasException {
        PStatus pStatus;
        Enumeration enumeration;
        if ((n & 8) != 0) {
            enumeration = this.meters.elements();
            while (enumeration.hasMoreElements()) {
                pStatus = (MeterStatus)enumeration.nextElement();
                if (pStatus.isRemoved()) {
                    ((MeterStatus)pStatus).meter.save();
                    this.meters.remove(((MeterStatus)pStatus).meter);
                    continue;
                }
                if (!pStatus.isInserted()) continue;
                ((MeterStatus)pStatus).meter.save();
                pStatus.setCurrent();
            }
        }
        if ((n & 4) != 0) {
            enumeration = this.ownedDataPoints.elements();
            while (enumeration.hasMoreElements()) {
                pStatus = (DpStatus)enumeration.nextElement();
                if (pStatus.isRemoved()) {
                    ((DpStatus)pStatus).dp.save();
                    this.ownedDataPoints.remove(((DpStatus)pStatus).dp);
                    continue;
                }
                if (!pStatus.isInserted()) continue;
                ((DpStatus)pStatus).dp.save();
                pStatus.setCurrent();
            }
        }
    }

    protected Site(int n, EasSession easSession) {
        super(n, easSession);
    }

    Site(int n, String string, String string2, char c, boolean bl, boolean bl2, EasSession easSession) {
        super(n, string, string2, c, bl, bl2, easSession);
    }

    public void addOwnedDataPoint(DataPoint dataPoint) throws EasException {
        Site site = dataPoint.getSite();
        if (site != null && site.getId() != this.getId()) {
            site.remOwnedDataPoint(dataPoint);
        }
        this.loadOwnedDataPoints(false);
        boolean bl = false;
        DpStatus dpStatus = (DpStatus)this.ownedDataPoints.get(dataPoint);
        if (dpStatus == null) {
            dpStatus = new DpStatus(dataPoint);
            dpStatus.setInserted(true);
            this.ownedDataPoints.put(dataPoint, dpStatus);
            ++this.ownedDataPointCount;
            bl = true;
        } else if (dpStatus.isRemoved()) {
            dpStatus.setRemoved(false);
            ++this.ownedDataPointCount;
            bl = true;
        }
        if (bl) {
            dataPoint.setSite(this);
        }
    }

    public void remOwnedDataPoint(DataPoint dataPoint) throws EasException {
        this.loadOwnedDataPoints(false);
        DpStatus dpStatus = (DpStatus)this.ownedDataPoints.get(dataPoint);
        boolean bl = false;
        if (dpStatus != null) {
            if (dpStatus.isInserted()) {
                this.ownedDataPoints.remove(dataPoint);
                --this.ownedDataPointCount;
                bl = true;
            } else if (!dpStatus.isRemoved()) {
                dpStatus.setRemoved(true);
                --this.ownedDataPointCount;
                bl = true;
            }
        }
        if (bl) {
            dataPoint.setSite(null);
            dataPoint.erase();
        }
    }

    public DataPoint createOwnedDataPoint(String string, String string2, String string3, int n, int n2, int n3, boolean bl, String string4, String string5) throws EasException {
        return this.createOwnedDataPoint(string, string2, string3, n, n2, n3, bl, string4, string5, "square foot", 0.0);
    }

    public DataPoint createOwnedDataPoint(String string, String string2, String string3, int n, int n2, int n3, boolean bl, String string4, String string5, String string6, double d) throws EasException {
        return this.createOwnedDataPoint(string, string2, string3, n, n2, n3, bl, string4, string5, null, string6, d, null);
    }

    public DataPoint createOwnedDataPoint(String string, String string2, String string3, int n, int n2, int n3, boolean bl, String string4, String string5, Meter meter, String string6, double d, String string7) throws EasException {
        DataPoint dataPoint = DataPoint.create(string, string2, string3, n, n2, n3, bl, string4, string5, this, meter, string6, d, string7);
        this.addOwnedDataPoint(dataPoint);
        return dataPoint;
    }

    public DataPoint[] getOwnedDataPoints() throws EasException {
        this.loadOwnedDataPoints(false);
        DataPoint[] dataPointArray = new DataPoint[this.ownedDataPointCount];
        int n = 0;
        Enumeration enumeration = this.ownedDataPoints.elements();
        while (enumeration.hasMoreElements()) {
            DpStatus dpStatus = (DpStatus)enumeration.nextElement();
            if (dpStatus.isRemoved()) continue;
            dataPointArray[n++] = dpStatus.dp;
        }
        return dataPointArray;
    }

    public void loadOwnedDataPoints(boolean bl) throws EasException {
        if (!bl && this.ownedDataPointsLoaded) {
            return;
        }
        if (this.isInitialized()) {
            Vector vector = this.session.getDataPointExec().getDataPoints(this);
            this.ownedDataPointCount = vector.size();
            this.ownedDataPoints.clear();
            for (int i = 0; i < this.ownedDataPointCount; ++i) {
                DataPoint dataPoint = (DataPoint)vector.elementAt(i);
                dataPoint.load(bl);
                this.ownedDataPoints.put(dataPoint, new DpStatus(dataPoint));
            }
        } else {
            throw new EasException("can't load uninitialized site");
        }
        this.ownedDataPointsLoaded = true;
    }

    private class DpStatus
    extends PStatus {
        public DataPoint dp;

        public DpStatus(DataPoint dataPoint) {
            this.dp = dataPoint;
        }
    }

    private class MeterStatus
    extends PStatus {
        public Meter meter;

        public MeterStatus(Meter meter) {
            this.meter = meter;
        }
    }
}

