/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.Period;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public class ReportPeriod
extends Period {
    public static final int FIXED_RANGE = 0;
    public static final int YESTERDAY = 1;
    public static final int LAST_WEEK = 2;
    public static final int LAST_7_DAYS = 3;
    public static final int LAST_MONTH = 4;
    public static final int LAST_YEAR = 5;
    public static final int MONTH_TO_DATE = 6;
    public static final int YEAR_TO_DATE = 7;
    public static final int LAST_10_DAYS = 8;
    public static final int LAST_48_HOURS = 9;
    public static final int LAST_24_HOURS = 10;
    public static final int LAST_PERIOD_ID = 10;
    private int customPeriod;
    private static DateFormatSymbols dateSymbols;

    public ReportPeriod() {
    }

    public ReportPeriod(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public ReportPeriod(int n, int n2, Lexicon lexicon) {
        this(n, null, null, n2, lexicon);
    }

    public ReportPeriod(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n, Lexicon lexicon) {
        this(0, easLocalTime, easLocalTime2, n, lexicon);
    }

    public ReportPeriod(int n, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n2, Lexicon lexicon) {
        super(easLocalTime, easLocalTime2, n2, lexicon);
        this.customPeriod = n;
        this.lex = lexicon;
    }

    public boolean isCustomPeriod() {
        return this.customPeriod != 0;
    }

    public int getCustomPeriod() {
        return this.customPeriod;
    }

    public static String getCustomPeriodName(int n, Lexicon lexicon) {
        switch (n) {
            case 0: {
                return lexicon.getText("dateRange");
            }
            case 1: {
                return lexicon.getText("yesterday");
            }
            case 2: {
                return lexicon.getText("lastWeek");
            }
            case 3: {
                return lexicon.getText("last7Days");
            }
            case 4: {
                return lexicon.getText("lastMonth");
            }
            case 5: {
                return lexicon.getText("lastYear");
            }
            case 6: {
                return lexicon.getText("monthToDate");
            }
            case 7: {
                return lexicon.getText("yearToDate");
            }
            case 8: {
                return lexicon.getText("last10Days");
            }
            case 9: {
                return lexicon.getText("last48Hours");
            }
            case 10: {
                return lexicon.getText("last24Hours");
            }
        }
        return lexicon.getText("error");
    }

    public void applyCustomPeriod(long l) {
        if (this.customPeriod == 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        calendar.setTime(new Date(l));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (this.customPeriod) {
            case 1: {
                calendar.add(5, -1);
                this.setEndTime(new EasLocalTime(calendar, calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13), calendar.getMaximum(14)));
                this.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 2: {
                while (calendar.get(7) != 1) {
                    calendar.add(5, -1);
                }
                calendar.add(5, -1);
                this.setEndTime(new EasLocalTime(calendar, calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13), calendar.getMaximum(14)));
                while (calendar.get(7) != 1) {
                    calendar.add(5, -1);
                }
                this.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 3: {
                calendar.add(5, -1);
                this.setEndTime(new EasLocalTime(calendar, calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13), calendar.getMaximum(14)));
                calendar.add(5, -6);
                this.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 4: {
                calendar.add(2, -1);
                calendar.set(5, 1);
                this.setStartTime(new EasLocalTime(calendar));
                int n = calendar.get(2);
                int n2 = calendar.get(1);
                calendar.set(5, ReportPeriod.getDaysInMonth(n, n2));
                this.setEndTime(new EasLocalTime(calendar, calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13), calendar.getMaximum(14)));
                break;
            }
            case 5: {
                calendar.add(1, -1);
                calendar.set(2, 0);
                calendar.set(5, 1);
                this.setStartTime(new EasLocalTime(calendar));
                calendar.set(2, 11);
                calendar.set(5, 31);
                this.setEndTime(new EasLocalTime(calendar, calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13), calendar.getMaximum(14)));
                break;
            }
            case 6: {
                this.setEndTime(new EasLocalTime(calendar, calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13), calendar.getMaximum(14)));
                calendar.set(5, 1);
                this.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 7: {
                this.setEndTime(new EasLocalTime(calendar, calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13), calendar.getMaximum(14)));
                calendar.set(2, 0);
                calendar.set(5, 1);
                this.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 8: {
                calendar.add(5, -1);
                this.setEndTime(new EasLocalTime(calendar, calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13), calendar.getMaximum(14)));
                calendar.add(5, -9);
                this.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 9: {
                Calendar calendar2 = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
                calendar2.setTime(new Date(l));
                this.setEndTime(new EasLocalTime(calendar2, calendar2.get(11), calendar2.get(12), calendar2.get(13), calendar2.get(14)));
                calendar2.add(5, -2);
                this.setStartTime(new EasLocalTime(calendar2));
                break;
            }
            case 10: {
                Calendar calendar3 = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
                calendar3.setTime(new Date(l));
                this.setEndTime(new EasLocalTime(calendar3, calendar3.get(11), calendar3.get(12), calendar3.get(13), calendar3.get(14)));
                calendar3.add(5, -1);
                this.setStartTime(new EasLocalTime(calendar3));
            }
        }
    }

    public void save(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.customPeriod);
        super.save(dataOutput);
    }

    public void load(DataInput dataInput) throws IOException, EasException {
        this.customPeriod = dataInput.readInt();
        super.load(dataInput);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(ReportPeriod.getCustomPeriodName(this.customPeriod, this.lex));
        stringBuffer.append(": ");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static final int getDaysInMonth(int n, int n2) {
        if (n != 1) {
            return MONTH_DAYS[n];
        }
        if (ReportPeriod.isLeapYear(n2)) {
            return 29;
        }
        return MONTH_DAYS[n];
    }

    public static final int getDaysInYear(int n) {
        if (ReportPeriod.isLeapYear(n)) {
            return 366;
        }
        return 365;
    }

    public static void main(String[] stringArray) {
        ReportPeriod reportPeriod = new ReportPeriod(0, 65, null);
        System.out.println(reportPeriod);
    }
}

